# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.private_zones_operations import PrivateZonesOperations
from .operations.virtual_network_links_operations import VirtualNetworkLinksOperations
from .operations.record_sets_operations import RecordSetsOperations
from . import models


class PrivateDnsManagementClientConfiguration(AzureConfiguration):
    """Configuration for PrivateDnsManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Gets subscription credentials which uniquely
     identify Microsoft Azure subscription. The subscription ID forms part of
     the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(PrivateDnsManagementClientConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-mgmt-privatedns/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class PrivateDnsManagementClient(SDKClient):
    """The Private DNS Management Client.

    :ivar config: Configuration for client.
    :vartype config: PrivateDnsManagementClientConfiguration

    :ivar private_zones: PrivateZones operations
    :vartype private_zones: azure.mgmt.privatedns.operations.PrivateZonesOperations
    :ivar virtual_network_links: VirtualNetworkLinks operations
    :vartype virtual_network_links: azure.mgmt.privatedns.operations.VirtualNetworkLinksOperations
    :ivar record_sets: RecordSets operations
    :vartype record_sets: azure.mgmt.privatedns.operations.RecordSetsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Gets subscription credentials which uniquely
     identify Microsoft Azure subscription. The subscription ID forms part of
     the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = PrivateDnsManagementClientConfiguration(credentials, subscription_id, base_url)
        super(PrivateDnsManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2018-09-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.private_zones = PrivateZonesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.virtual_network_links = VirtualNetworkLinksOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.record_sets = RecordSetsOperations(
            self._client, self.config, self._serialize, self._deserialize)
