# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RequestHistoryProperties(Model):
    """The request history.

    :param start_time: The time the request started.
    :type start_time: datetime
    :param end_time: The time the request ended.
    :type end_time: datetime
    :param request: The request.
    :type request: ~azure.mgmt.logic.models.Request
    :param response: The response.
    :type response: ~azure.mgmt.logic.models.Response
    """

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'request': {'key': 'request', 'type': 'Request'},
        'response': {'key': 'response', 'type': 'Response'},
    }

    def __init__(self, **kwargs):
        super(RequestHistoryProperties, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.request = kwargs.get('request', None)
        self.response = kwargs.get('response', None)
