# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .artifact_content_properties_definition import ArtifactContentPropertiesDefinition


class AssemblyProperties(ArtifactContentPropertiesDefinition):
    """The assembly properties definition.

    All required parameters must be populated in order to send to Azure.

    :param created_time: The artifact creation time.
    :type created_time: datetime
    :param changed_time: The artifact changed time.
    :type changed_time: datetime
    :param metadata:
    :type metadata: object
    :param content:
    :type content: object
    :param content_type: The content type.
    :type content_type: str
    :param content_link: The content link.
    :type content_link: ~azure.mgmt.logic.models.ContentLink
    :param assembly_name: Required. The assembly name.
    :type assembly_name: str
    :param assembly_version: The assembly version.
    :type assembly_version: str
    :param assembly_culture: The assembly culture.
    :type assembly_culture: str
    :param assembly_public_key_token: The assembly public key token.
    :type assembly_public_key_token: str
    """

    _validation = {
        'assembly_name': {'required': True},
    }

    _attribute_map = {
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'content': {'key': 'content', 'type': 'object'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'content_link': {'key': 'contentLink', 'type': 'ContentLink'},
        'assembly_name': {'key': 'assemblyName', 'type': 'str'},
        'assembly_version': {'key': 'assemblyVersion', 'type': 'str'},
        'assembly_culture': {'key': 'assemblyCulture', 'type': 'str'},
        'assembly_public_key_token': {'key': 'assemblyPublicKeyToken', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AssemblyProperties, self).__init__(**kwargs)
        self.assembly_name = kwargs.get('assembly_name', None)
        self.assembly_version = kwargs.get('assembly_version', None)
        self.assembly_culture = kwargs.get('assembly_culture', None)
        self.assembly_public_key_token = kwargs.get('assembly_public_key_token', None)
