# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class Lab(Resource):
    """Represents a lab.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The identifier of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource.
    :type location: str
    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param max_users_in_lab: Maximum number of users allowed in the lab.
    :type max_users_in_lab: int
    :ivar user_quota: Maximum value MaxUsersInLab can be set to, as specified
     by the service
    :vartype user_quota: int
    :ivar invitation_code: Invitation code that users can use to join a lab.
    :vartype invitation_code: str
    :ivar created_by_object_id: Object id of the user that created the lab.
    :vartype created_by_object_id: str
    :param usage_quota: Maximum duration a user can use an environment for in
     the lab.
    :type usage_quota: timedelta
    :param user_access_mode: Lab user access mode (open to all vs. restricted
     to those listed on the lab). Possible values include: 'Restricted', 'Open'
    :type user_access_mode: str or
     ~azure.mgmt.labservices.models.LabUserAccessMode
    :ivar created_by_user_principal_name: Lab creator name
    :vartype created_by_user_principal_name: str
    :ivar created_date: Creation date for the lab
    :vartype created_date: datetime
    :param provisioning_state: The provisioning status of the resource.
    :type provisioning_state: str
    :param unique_identifier: The unique immutable identifier of a resource
     (Guid).
    :type unique_identifier: str
    :ivar latest_operation_result: The details of the latest operation. ex:
     status, error
    :vartype latest_operation_result:
     ~azure.mgmt.labservices.models.LatestOperationResult
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'user_quota': {'readonly': True},
        'invitation_code': {'readonly': True},
        'created_by_object_id': {'readonly': True},
        'created_by_user_principal_name': {'readonly': True},
        'created_date': {'readonly': True},
        'latest_operation_result': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'max_users_in_lab': {'key': 'properties.maxUsersInLab', 'type': 'int'},
        'user_quota': {'key': 'properties.userQuota', 'type': 'int'},
        'invitation_code': {'key': 'properties.invitationCode', 'type': 'str'},
        'created_by_object_id': {'key': 'properties.createdByObjectId', 'type': 'str'},
        'usage_quota': {'key': 'properties.usageQuota', 'type': 'duration'},
        'user_access_mode': {'key': 'properties.userAccessMode', 'type': 'str'},
        'created_by_user_principal_name': {'key': 'properties.createdByUserPrincipalName', 'type': 'str'},
        'created_date': {'key': 'properties.createdDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'unique_identifier': {'key': 'properties.uniqueIdentifier', 'type': 'str'},
        'latest_operation_result': {'key': 'properties.latestOperationResult', 'type': 'LatestOperationResult'},
    }

    def __init__(self, **kwargs):
        super(Lab, self).__init__(**kwargs)
        self.max_users_in_lab = kwargs.get('max_users_in_lab', None)
        self.user_quota = None
        self.invitation_code = None
        self.created_by_object_id = None
        self.usage_quota = kwargs.get('usage_quota', None)
        self.user_access_mode = kwargs.get('user_access_mode', None)
        self.created_by_user_principal_name = None
        self.created_date = None
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.unique_identifier = kwargs.get('unique_identifier', None)
        self.latest_operation_result = None
