# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EnvironmentDetails(Model):
    """This represents the details about a User's environment and its state.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Name of the Environment
    :vartype name: str
    :ivar description: Description of the Environment
    :vartype description: str
    :ivar id: Resource Id of the environment
    :vartype id: str
    :ivar provisioning_state: The provisioning state of the environment. This
     also includes LabIsFull and NotYetProvisioned status.
    :vartype provisioning_state: str
    :ivar virtual_machine_details: Details of backing DTL virtual machine with
     compute and network details.
    :vartype virtual_machine_details:
     ~azure.mgmt.labservices.models.VirtualMachineDetails
    :ivar latest_operation_result: The details of the latest operation. ex:
     status, error
    :vartype latest_operation_result:
     ~azure.mgmt.labservices.models.LatestOperationResult
    :ivar environment_state: Publishing state of the environment setting
     Possible values are Creating, Created, Failed
    :vartype environment_state: str
    :ivar total_usage: How long the environment has been used by a lab user
    :vartype total_usage: timedelta
    :ivar password_last_reset: When the password was last reset on the
     environment.
    :vartype password_last_reset: datetime
    """

    _validation = {
        'name': {'readonly': True},
        'description': {'readonly': True},
        'id': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'virtual_machine_details': {'readonly': True},
        'latest_operation_result': {'readonly': True},
        'environment_state': {'readonly': True},
        'total_usage': {'readonly': True},
        'password_last_reset': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'virtual_machine_details': {'key': 'virtualMachineDetails', 'type': 'VirtualMachineDetails'},
        'latest_operation_result': {'key': 'latestOperationResult', 'type': 'LatestOperationResult'},
        'environment_state': {'key': 'environmentState', 'type': 'str'},
        'total_usage': {'key': 'totalUsage', 'type': 'duration'},
        'password_last_reset': {'key': 'passwordLastReset', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(EnvironmentDetails, self).__init__(**kwargs)
        self.name = None
        self.description = None
        self.id = None
        self.provisioning_state = None
        self.virtual_machine_details = None
        self.latest_operation_result = None
        self.environment_state = None
        self.total_usage = None
        self.password_last_reset = None
