# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServiceBusDeadletterMessagesAvailableWithNoListenersEventData(Model):
    """Schema of the Data property of an EventGridEvent for a
    Microsoft.ServiceBus.DeadletterMessagesAvailableWithNoListenersEvent event.

    :param namespace_name: The namespace name of the Microsoft.ServiceBus
     resource.
    :type namespace_name: str
    :param request_uri: The endpoint of the Microsoft.ServiceBus resource.
    :type request_uri: str
    :param entity_type: The entity type of the Microsoft.ServiceBus resource.
     Could be one of 'queue' or 'subscriber'.
    :type entity_type: str
    :param queue_name: The name of the Microsoft.ServiceBus queue. If the
     entity type is of type 'subscriber', then this value will be null.
    :type queue_name: str
    :param topic_name: The name of the Microsoft.ServiceBus topic. If the
     entity type is of type 'queue', then this value will be null.
    :type topic_name: str
    :param subscription_name: The name of the Microsoft.ServiceBus topic's
     subscription. If the entity type is of type 'queue', then this value will
     be null.
    :type subscription_name: str
    """

    _attribute_map = {
        'namespace_name': {'key': 'namespaceName', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'entity_type': {'key': 'entityType', 'type': 'str'},
        'queue_name': {'key': 'queueName', 'type': 'str'},
        'topic_name': {'key': 'topicName', 'type': 'str'},
        'subscription_name': {'key': 'subscriptionName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceBusDeadletterMessagesAvailableWithNoListenersEventData, self).__init__(**kwargs)
        self.namespace_name = kwargs.get('namespace_name', None)
        self.request_uri = kwargs.get('request_uri', None)
        self.entity_type = kwargs.get('entity_type', None)
        self.queue_name = kwargs.get('queue_name', None)
        self.topic_name = kwargs.get('topic_name', None)
        self.subscription_name = kwargs.get('subscription_name', None)
