# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MediaJobError(Model):
    """Details of JobOutput errors.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: Error code describing the error. Possible values include:
     'ServiceError', 'ServiceTransientError', 'DownloadNotAccessible',
     'DownloadTransientError', 'UploadNotAccessible', 'UploadTransientError',
     'ConfigurationUnsupported', 'ContentMalformed', 'ContentUnsupported'
    :vartype code: str or ~azure.eventgrid.models.MediaJobErrorCode
    :ivar message: A human-readable language-dependent representation of the
     error.
    :vartype message: str
    :ivar category: Helps with categorization of errors. Possible values
     include: 'Service', 'Download', 'Upload', 'Configuration', 'Content'
    :vartype category: str or ~azure.eventgrid.models.MediaJobErrorCategory
    :ivar retry: Indicates that it may be possible to retry the Job. If retry
     is unsuccessful, please contact Azure support via Azure Portal. Possible
     values include: 'DoNotRetry', 'MayRetry'
    :vartype retry: str or ~azure.eventgrid.models.MediaJobRetry
    :ivar details: An array of details about specific errors that led to this
     reported error.
    :vartype details: list[~azure.eventgrid.models.MediaJobErrorDetail]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'category': {'readonly': True},
        'retry': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'MediaJobErrorCode'},
        'message': {'key': 'message', 'type': 'str'},
        'category': {'key': 'category', 'type': 'MediaJobErrorCategory'},
        'retry': {'key': 'retry', 'type': 'MediaJobRetry'},
        'details': {'key': 'details', 'type': '[MediaJobErrorDetail]'},
    }

    def __init__(self, **kwargs):
        super(MediaJobError, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.category = None
        self.retry = None
        self.details = None
