# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SkypeChannelProperties(Model):
    """The parameters to provide for the Microsoft Teams channel.

    All required parameters must be populated in order to send to Azure.

    :param enable_messaging: Enable messaging for Skype channel
    :type enable_messaging: bool
    :param enable_media_cards: Enable media cards for Skype channel
    :type enable_media_cards: bool
    :param enable_video: Enable video for Skype channel
    :type enable_video: bool
    :param enable_calling: Enable calling for Skype channel
    :type enable_calling: bool
    :param enable_screen_sharing: Enable screen sharing for Skype channel
    :type enable_screen_sharing: bool
    :param enable_groups: Enable groups for Skype channel
    :type enable_groups: bool
    :param groups_mode: Group mode for Skype channel
    :type groups_mode: str
    :param calling_web_hook: Calling web hook for Skype channel
    :type calling_web_hook: str
    :param is_enabled: Required. Whether this channel is enabled for the bot
    :type is_enabled: bool
    """

    _validation = {
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'enable_messaging': {'key': 'enableMessaging', 'type': 'bool'},
        'enable_media_cards': {'key': 'enableMediaCards', 'type': 'bool'},
        'enable_video': {'key': 'enableVideo', 'type': 'bool'},
        'enable_calling': {'key': 'enableCalling', 'type': 'bool'},
        'enable_screen_sharing': {'key': 'enableScreenSharing', 'type': 'bool'},
        'enable_groups': {'key': 'enableGroups', 'type': 'bool'},
        'groups_mode': {'key': 'groupsMode', 'type': 'str'},
        'calling_web_hook': {'key': 'callingWebHook', 'type': 'str'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(self, *, is_enabled: bool, enable_messaging: bool=None, enable_media_cards: bool=None, enable_video: bool=None, enable_calling: bool=None, enable_screen_sharing: bool=None, enable_groups: bool=None, groups_mode: str=None, calling_web_hook: str=None, **kwargs) -> None:
        super(SkypeChannelProperties, self).__init__(**kwargs)
        self.enable_messaging = enable_messaging
        self.enable_media_cards = enable_media_cards
        self.enable_video = enable_video
        self.enable_calling = enable_calling
        self.enable_screen_sharing = enable_screen_sharing
        self.enable_groups = enable_groups
        self.groups_mode = groups_mode
        self.calling_web_hook = calling_web_hook
        self.is_enabled = is_enabled
