# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Sku(Model):
    """The account SKU.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Gets or sets the SKU name of the account. Possible
     values include: 'Free', 'Basic'
    :type name: str or ~azure.mgmt.automation.models.SkuNameEnum
    :param family: Gets or sets the SKU family.
    :type family: str
    :param capacity: Gets or sets the SKU capacity.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.family = kwargs.get('family', None)
        self.capacity = kwargs.get('capacity', None)
