# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OpenidConnectProviderUpdateContract(Model):
    """Parameters supplied to the Update OpenID Connect Provider operation.

    :param display_name: User-friendly OpenID Connect Provider name.
    :type display_name: str
    :param description: User-friendly description of OpenID Connect Provider.
    :type description: str
    :param metadata_endpoint: Metadata endpoint URI.
    :type metadata_endpoint: str
    :param client_id: Client ID of developer console which is the client
     application.
    :type client_id: str
    :param client_secret: Client Secret of developer console which is the
     client application.
    :type client_secret: str
    """

    _validation = {
        'display_name': {'max_length': 50},
    }

    _attribute_map = {
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'metadata_endpoint': {'key': 'properties.metadataEndpoint', 'type': 'str'},
        'client_id': {'key': 'properties.clientId', 'type': 'str'},
        'client_secret': {'key': 'properties.clientSecret', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OpenidConnectProviderUpdateContract, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)
        self.metadata_endpoint = kwargs.get('metadata_endpoint', None)
        self.client_id = kwargs.get('client_id', None)
        self.client_secret = kwargs.get('client_secret', None)
