# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApiRevisionContract(Model):
    """Summary of revision metadata.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar api_id: Identifier of the API Revision.
    :vartype api_id: str
    :ivar api_revision: Revision number of API.
    :vartype api_revision: str
    :ivar created_date_time: The time the API Revision was created. The date
     conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the
     ISO 8601 standard.
    :vartype created_date_time: datetime
    :ivar updated_date_time: The time the API Revision were updated. The date
     conforms to the following format: yyyy-MM-ddTHH:mm:ssZ as specified by the
     ISO 8601 standard.
    :vartype updated_date_time: datetime
    :ivar description: Description of the API Revision.
    :vartype description: str
    :ivar private_url: Gateway URL for accessing the non-current API Revision.
    :vartype private_url: str
    :ivar is_online: Indicates if API revision is the current api revision.
    :vartype is_online: bool
    :ivar is_current: Indicates if API revision is accessible via the gateway.
    :vartype is_current: bool
    """

    _validation = {
        'api_id': {'readonly': True},
        'api_revision': {'readonly': True, 'max_length': 100, 'min_length': 1},
        'created_date_time': {'readonly': True},
        'updated_date_time': {'readonly': True},
        'description': {'readonly': True, 'max_length': 256},
        'private_url': {'readonly': True},
        'is_online': {'readonly': True},
        'is_current': {'readonly': True},
    }

    _attribute_map = {
        'api_id': {'key': 'apiId', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'iso-8601'},
        'updated_date_time': {'key': 'updatedDateTime', 'type': 'iso-8601'},
        'description': {'key': 'description', 'type': 'str'},
        'private_url': {'key': 'privateUrl', 'type': 'str'},
        'is_online': {'key': 'isOnline', 'type': 'bool'},
        'is_current': {'key': 'isCurrent', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(ApiRevisionContract, self).__init__(**kwargs)
        self.api_id = None
        self.api_revision = None
        self.created_date_time = None
        self.updated_date_time = None
        self.description = None
        self.private_url = None
        self.is_online = None
        self.is_current = None
