# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource import ProxyResource


class TrafficManagerGeographicHierarchy(ProxyResource):
    """Class representing the Geographic hierarchy used with the Geographic
    traffic routing method.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Network/trafficmanagerProfiles.
    :vartype type: str
    :param geographic_hierarchy: The region at the root of the hierarchy from
     all the regions in the hierarchy can be retrieved.
    :type geographic_hierarchy: :class:`Region
     <azure.mgmt.trafficmanager.models.Region>`
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'geographic_hierarchy': {'key': 'properties.geographicHierarchy', 'type': 'Region'},
    }

    def __init__(self, geographic_hierarchy=None):
        super(TrafficManagerGeographicHierarchy, self).__init__()
        self.geographic_hierarchy = geographic_hierarchy
