# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from .version import VERSION
from .operations.gateway_operations import GatewayOperations
from .operations.node_operations import NodeOperations
from .operations.session_operations import SessionOperations
from .operations.power_shell_operations import PowerShellOperations
from . import models


class ServerManagementConfiguration(AzureConfiguration):
    """Configuration for ServerManagement
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Gets subscription credentials which uniquely
     identify Microsoft Azure subscription. The subscription ID forms part of
     the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not isinstance(subscription_id, str):
            raise TypeError("Parameter 'subscription_id' must be str.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(ServerManagementConfiguration, self).__init__(base_url)

        self.add_user_agent('servermanagement/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class ServerManagement(object):
    """REST API for Azure Server Management Service.

    :ivar config: Configuration for client.
    :vartype config: ServerManagementConfiguration

    :ivar gateway: Gateway operations
    :vartype gateway: azure.mgmt.servermanager.operations.GatewayOperations
    :ivar node: Node operations
    :vartype node: azure.mgmt.servermanager.operations.NodeOperations
    :ivar session: Session operations
    :vartype session: azure.mgmt.servermanager.operations.SessionOperations
    :ivar power_shell: PowerShell operations
    :vartype power_shell: azure.mgmt.servermanager.operations.PowerShellOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Gets subscription credentials which uniquely
     identify Microsoft Azure subscription. The subscription ID forms part of
     the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = ServerManagementConfiguration(credentials, subscription_id, base_url)
        self._client = ServiceClient(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2016-07-01-preview'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.gateway = GatewayOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.node = NodeOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.session = SessionOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.power_shell = PowerShellOperations(
            self._client, self.config, self._serialize, self._deserialize)
