# Pympress package

This page contains the inline documentation, generated from the code using sphinx.

The code is documented in the source using the [Google style](https://google.github.io/styleguide/pyguide.html) for docstrings. Sphinx has gathered a [set of examples](http://www.sphinx-doc.org/en/latest/ext/example_google.html) which serves as a better crash course than the full style reference.

Retructured text (rst) can be used inside the comments and docstrings.

## Modules

```eval_rst
.. automodule:: pympress.__main__
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.app
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.ui
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.document
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.builder
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.surfacecache
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.scribble
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.pointer
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.editable_label
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.talk_time
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.config
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.extras
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.util
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.media_overlays.base
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.media_overlays.gif_backend
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.media_overlays.gst_backend
    :members:
    :undoc-members:
    :show-inheritance:

.. automodule:: pympress.media_overlays.vlc_backend
    :members:
    :undoc-members:
    :show-inheritance:
```

