#A* -------------------------------------------------------------------
#B* This file contains source code for the PyMOL computer program
#C* Copyright (c) Schrodinger, LLC. 
#D* -------------------------------------------------------------------
#E* It is unlawful to modify or remove this copyright notice.
#F* -------------------------------------------------------------------
#G* Please see the accompanying LICENSE file for further information. 
#H* -------------------------------------------------------------------
#I* Additional authors of this source file include:
#-* 
#-* 
#-*
#Z* -------------------------------------------------------------------

import traceback
import string
import sys

try:
    from cmd import QuietException, \
          _feedback,fb_module,fb_mask 

    # xray.py 
    # This section contains python code for supporting
    # x-ray crystallography functions

    
    def old_sg_sym_to_mat_list(sgsymbol):
        import sglite
        sgsymbol = hex_to_rhom_xHM.get(sgsymbol,sgsymbol)
        try:
            Symbols_Inp = sglite.SgSymbolLookup(sgsymbol)
            if(Symbols_Inp):
                HallSymbol = Symbols_Inp['Hall']
                SgOps = sglite.SgOps(HallSymbol)
                nLTr = SgOps.get_nLTr()
                fInv = SgOps.get_fInv()
                nSMx = SgOps.get_nSMx()
                result = []
                rb = float(sglite.SRBF)
                tb = float(sglite.STBF)
                for iLTr in xrange(nLTr):
                    for iInv in xrange(fInv):
                        for iSMx in xrange(nSMx):
                            Mx = SgOps.getLISMx(iLTr, iInv, iSMx, +1)
                            result.append([[ Mx[0]/rb, Mx[1]/rb, Mx[2]/rb, Mx[9 ]/tb],
                                           [ Mx[3]/rb, Mx[4]/rb, Mx[5]/rb, Mx[10]/tb],
                                           [ Mx[6]/rb, Mx[7]/rb, Mx[8]/rb, Mx[11]/tb],
                                           [      0.0,      0.0,      0.0,       1.0]] )
        except:
            if(_feedback(fb_module.symmetry,fb_mask.errors)):
                print "Symmetry-Error: Urecognized space group symbol '"+sgsymbol+"'."
            result = None
        return result

    def sg_sym_to_mat_list(sgsymbol): # TODO _self
        result = None
        key = string.strip(string.upper(sgsymbol))
        sym_op = sym_dict.get(key,None)
        if sym_op != None:
            result = []
            for op in sym_op:
                mat = []
                try:
                    # WORKAROUND: Not sure why the string op can have difficulty
                    # being split, but calling this inside a try/except block before
                    # it gets called in the below for loop seems to fix it
                    # TODO : NEED TO FIGURE OUT : it could have something to do with
                    # how sym_dict/sym_base is instantiated, and how PyMOL in P.c
                    # imports this module directly
                    # the error that is thrown is "IndexError: list index out of range"
                    string.split(op,',')
                except:
#                    traceback.print_exc()
                    pass
                for expr in string.split(op,','):
                    mat.append( expr_to_vect[expr] )
                mat.append([0.0,0.0,0.0,1.0])
                result.append(mat)
        else:
            if(_feedback(fb_module.symmetry,fb_mask.errors)):
                print "Symmetry-Error: Urecognized space group symbol '"+sgsymbol+"'."
        return result

except:
    traceback.print_exc()
    print "Error: unable to import xray module (no symmetry support)."
    def sg_sym_to_mat_list(sgsymbol):
        return None

hex_to_rhom_xHM = {
    #  extended Hermann Mauguin symbol translation
    #  from CCP4's syminfo.lib
    
    'H 3'      : 'R 3 :H',
    'H -3'     : 'R -3 :H',
    'H 3 2'    : 'R 3 2 :H',
    
    'H 3 m'    : 'R 3 m :H',
    'H 3 c'    : 'R 3 c :H',
    'H -3 2/m' : 'R -3 m :H',
    'H -3 m'   : 'R -3 m :H',
    'H -3 2/c' : 'R -3 c :H',
    'H -3 c'   : 'R -3 c :H',
    
    'H 3 M'    : 'R 3 m :H',
    'H 3 C'    : 'R 3 c :H',
    'H -3 2/M' : 'R -3 m :H',
    'H -3 M'   : 'R -3 m :H',
    'H -3 2/C' : 'R -3 c :H',
    'H -3 C'   : 'R -3 c :H',
    }

expr_to_vect = {    
    'x-y': [1.0,-1.0,0.0,0.0],
    'x-y+1/3': [1.0,-1.0,0.0,1.0/3.0],
    'x-y+2/3': [1.0,-1.0,0.0,2.0/3.0],
    'x': [1.0,0.0,0.0,0.0],
    'x+1/4': [1.0,0.0,0.0,1.0/4.0],
    'x+1/3': [1.0,0.0,0.0,1.0/3.0],
    'x+1/2': [1.0,0.0,0.0,1.0/2.0],
    'x+2/3': [1.0,0.0,0.0,2.0/3.0],
    'x+3/4': [1.0,0.0,0.0,3.0/4.0],
    '-x+y': [-1.0,1.0,0.0,0.0],
    '-x+y+1/3': [-1.0,1.0,0.0,1.0/3.0],
    '-x+y+2/3': [-1.0,1.0,0.0,2.0/3.0],
    '-x': [-1.0,0.0,0.0,0.0],
    '-x+1/4': [-1.0,0.0,0.0,1.0/4.0],
    '-x+1/3': [-1.0,0.0,0.0,1.0/3.0],
    '-x+1/2': [-1.0,0.0,0.0,1.0/2.0],
    '-x+2/3': [-1.0,0.0,0.0,2.0/3.0],
    '-x+3/4': [-1.0,0.0,0.0,3.0/4.0],
    'y': [0.0,1.0,0.0,0.0],
    'y+1/4': [0.0,1.0,0.0,1.0/4.0],
    'y+1/3': [0.0,1.0,0.0,1.0/3.0],
    'y+1/2': [0.0,1.0,0.0,1.0/2.0],
    'y+2/3': [0.0,1.0,0.0,2.0/3.0],
    'y+3/4': [0.0,1.0,0.0,3.0/4.0],
    '-y': [0.0,-1.0,0.0,0.0],
    '-y+1/4': [0.0,-1.0,0.0,1.0/4.0],
    '-y+1/3': [0.0,-1.0,0.0,1.0/3.0],
    '-y+1/2': [0.0,-1.0,0.0,1.0/2.0],
    '-y+2/3': [0.0,-1.0,0.0,2.0/3.0],
    '-y+3/4': [0.0,-1.0,0.0,3.0/4.0],
    'z': [0.0,0.0,1.0,0.0],
    'z+1/6': [0.0,0.0,1.0,1.0/6.0],
    'z+1/4': [0.0,0.0,1.0,1.0/4.0],
    'z+1/3': [0.0,0.0,1.0,1.0/3.0],
    'z+1/2': [0.0,0.0,1.0,1.0/2.0],
    'z+2/3': [0.0,0.0,1.0,2.0/3.0],
    'z+3/4': [0.0,0.0,1.0,3.0/4.0],
    'z+5/6': [0.0,0.0,1.0,5.0/6.0],
    '-z': [0.0,0.0,-1.0,0.0],
    '-z+1/6': [0.0,0.0,-1.0,1.0/6.0],
    '-z+1/4': [0.0,0.0,-1.0,1.0/4.0],
    '-z+1/3': [0.0,0.0,-1.0,1.0/3.0],
    '-z+1/2': [0.0,0.0,-1.0,1.0/2.0],
    '-z+2/3': [0.0,0.0,-1.0,2.0/3.0],
    '-z+3/4': [0.0,0.0,-1.0,3.0/4.0],
    '-z+5/6': [0.0,0.0,-1.0,5.0/6.0],
    }

sym_base = {
    (
    'x,y,z',
    ) : ['P 1', 'P1', ''] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    ) : ['P 1 1 2/N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    'x+1/2,y,z+1/2',
    '-x,-y+1/2,z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x,y+1/2,-z+1/2',
    ) : ['B 1 1 2/N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    'x,y+1/2,z+1/2',
    '-x+1/2,-y,z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x+1/2,y,-z+1/2',
    ) : ['A 1 1 2/N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    'x,-y,z',
    ) : ['P B M N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    'x,-y,z',
    'x,y+1/2,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['A B M A'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z+1/2',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z+1/2',
    'x,-y,z+1/2',
    ) : ['P N C N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y,-z',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y,z',
    'x,-y+1/2,z',
    ) : ['P M M N :2', 'P M M N:2'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['P C C N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    'x,-y+1/2,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    '-x,y+1/2,z',
    'x+1/2,-y,z',
    ) : ['P B A N :2', 'P B A N:2'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    'x,-y+1/2,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    '-x,y+1/2,z',
    'x+1/2,-y,z',
    'x+1/2,y,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x,y,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x,-y,z+1/2',
    ) : ['B B C B :2', 'B B C B:2'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    'x,-y+1/2,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    '-x,y+1/2,z',
    'x+1/2,-y,z',
    'x,y+1/2,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x,-y,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x,y,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['A C A A :2', 'A C A A:2'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    'x,-y+1/2,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    '-x,y+1/2,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['P N N N :2', 'P N N N:2'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    'x,-y+1/2,-z+1/2',
    '-x+1/2,y,-z+1/2',
    'z,x,y',
    '-z+1/2,-x+1/2,y',
    'z,-x+1/2,-y+1/2',
    '-z+1/2,x,-y+1/2',
    'y,z,x',
    'y,-z+1/2,-x+1/2',
    '-y+1/2,z,-x+1/2',
    '-y+1/2,-z+1/2,x',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    '-x,y+1/2,z+1/2',
    'x+1/2,-y,z+1/2',
    '-z,-x,-y',
    'z+1/2,x+1/2,-y',
    '-z,x+1/2,y+1/2',
    'z+1/2,-x,y+1/2',
    '-y,-z,-x',
    '-y,z+1/2,x+1/2',
    'y+1/2,-z,x+1/2',
    'y+1/2,z+1/2,-x',
    ) : ['P N -3 :2', 'P N -3:2'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    'x,-y,-z',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    '-x,y,z',
    'x+1/2,-y+1/2,z',
    ) : ['P M A N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    'x,-y,-z',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    '-x,y,z',
    'x+1/2,-y+1/2,z',
    'x+1/2,y,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['B M A B'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z',
    'x,-y,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z',
    '-x,y,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P C N N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z+1/2',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z+1/2',
    ) : ['P 1 1 21/N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z',
    'x,-y,z+1/2',
    ) : ['P B C N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x,y,-z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x,-y,z',
    ) : ['P N M N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y,-z',
    '-x,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y,z',
    'x,-y+1/2,z+1/2',
    ) : ['P M C N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x,-y+1/2,z',
    ) : ['P C M N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z+1/2',
    'x,-y+1/2,-z',
    '-x+1/2,y,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-x,y+1/2,z',
    'x+1/2,-y,z+1/2',
    ) : ['P B N N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x+1/2,-y,z',
    ) : ['P N A N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z+1/2',
    'x,-y,-z',
    '-x+1/2,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-x,y,z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P M N N'] ,
    (
    'x,y,z',
    '-x+1/2,-y+1/2,z+1/2',
    'x,-y,-z+1/2',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-x,y,z+1/2',
    'x+1/2,-y+1/2,z',
    ) : ['P C A N'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    ) : ['P 1 1 2/A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    'x+1/2,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    ) : ['I 1 1 2/A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    'x,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    ) : ['A 1 1 2/A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x+1/2,-y+1/2,-z',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x+1/2,y+1/2,z',
    'x,-y+1/2,z',
    ) : ['P B M A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x+1/2,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x+1/2,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['P N C A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x+1/2,-y,-z',
    '-x,y,-z',
    ) : ['P 21 2 2'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x+1/2,-y,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x+1/2,y,z',
    'x,-y,z',
    ) : ['P M M A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x+1/2,-y,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x+1/2,y,z',
    'x,-y,z',
    'x+1/2,y+1/2,z',
    '-x,-y+1/2,z',
    'x,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-x+1/2,-y+1/2,-z',
    'x,y+1/2,-z',
    '-x,y+1/2,z',
    'x+1/2,-y+1/2,z',
    ) : ['C M M B'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x+1/2,-y,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x+1/2,y,z',
    'x,-y,z',
    'x+1/2,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['I M M B'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x+1/2,-y,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x+1/2,y,z',
    'x,-y,z',
    'x,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['A M M A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x+1/2,-y,-z',
    '-x,y,-z',
    'x,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    ) : ['A 21 2 2'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x+1/2,-y,-z+1/2',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x+1/2,y,z+1/2',
    'x,-y,z+1/2',
    ) : ['P C C A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x+1/2,-y,-z+1/2',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x+1/2,y,z+1/2',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x,-y+1/2,z',
    'x,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z',
    'x,y+1/2,-z',
    '-x,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['C C C A :2', 'C C C A:2'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x,y+1/2,z',
    'x+1/2,-y+1/2,z',
    ) : ['P B A A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x,y+1/2,z',
    'x+1/2,-y+1/2,z',
    'x+1/2,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x,y,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x,-y,z+1/2',
    ) : ['I C A B'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x,y+1/2,z',
    'x+1/2,-y+1/2,z',
    'x,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x,y,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['A B A A :2', 'A B A A:2'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P N N A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x,-y,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x,y,z',
    'x+1/2,-y,z',
    ) : ['P M A A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x,-y,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x,y,z',
    'x+1/2,-y,z',
    'x+1/2,y+1/2,z',
    '-x,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x,y+1/2,-z',
    '-x+1/2,-y+1/2,-z',
    'x,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    'x,-y+1/2,z',
    ) : ['C M M A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x,-y,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x,y,z',
    'x+1/2,-y,z',
    'x+1/2,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['I M C B'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x,-y,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x,y,z',
    'x+1/2,-y,z',
    'x+1/2,y,z+1/2',
    '-x,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x,y,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x,-y,z+1/2',
    ) : ['B M A M'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x,-y,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x,y,z',
    'x+1/2,-y,z',
    'x,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['A M A A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x,y,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['P C N A :2', 'P C N A:2'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z',
    'x,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y,-z',
    '-x,y,z+1/2',
    'x+1/2,-y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x,-y+1/2,z',
    'x+1/2,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z',
    'x,y+1/2,-z',
    '-x+1/2,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['C C C B :2', 'C C C B:2'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    '-x,-y,-z',
    'x+1/2,y,-z+1/2',
    ) : ['P 1 1 21/A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    '-x,y,z',
    'x+1/2,-y,z+1/2',
    ) : ['P M N 21'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x,y+1/2,-z+1/2',
    ) : ['P 21 21 21'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y+1/2,z',
    'x,-y+1/2,z+1/2',
    ) : ['P B C A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x,y+1/2,-z+1/2',
    'z,x,y',
    '-z+1/2,-x,y+1/2',
    'z+1/2,-x+1/2,-y',
    '-z,x+1/2,-y+1/2',
    'y,z,x',
    'y+1/2,-z+1/2,-x',
    '-y,z+1/2,-x+1/2',
    '-y+1/2,-z,x+1/2',
    ) : ['P 21 3'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x,y+1/2,-z+1/2',
    'z,x,y',
    '-z+1/2,-x,y+1/2',
    'z+1/2,-x+1/2,-y',
    '-z,x+1/2,-y+1/2',
    'y,z,x',
    'y+1/2,-z+1/2,-x',
    '-y,z+1/2,-x+1/2',
    '-y+1/2,-z,x+1/2',
    '-x,-y,-z',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y+1/2,z',
    'x,-y+1/2,z+1/2',
    '-z,-x,-y',
    'z+1/2,x,-y+1/2',
    '-z+1/2,x+1/2,y',
    'z,-x+1/2,y+1/2',
    '-y,-z,-x',
    '-y+1/2,z+1/2,x',
    'y,-z+1/2,x+1/2',
    'y+1/2,z,-x+1/2',
    ) : ['P A -3'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x,-y+1/2,z',
    ) : ['P N M A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z',
    'x,-y,z+1/2',
    ) : ['P M C A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x,y,-z',
    ) : ['P 21 2 21'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x,y,-z',
    '-x+1/2,-y,-z+1/2',
    'x,y,-z',
    '-x,y,z',
    'x+1/2,-y,z+1/2',
    ) : ['P M N M :1', 'P M N M:1'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x,y,-z',
    '-x,-y,-z',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x,-y,z',
    ) : ['P C M A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x,y,-z',
    '-x,-y,-z',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x,-y,z',
    'x+1/2,y+1/2,z',
    '-x,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z',
    '-x+1/2,-y+1/2,-z',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z',
    ) : ['C C M B'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x,-y+1/2,-z',
    '-x+1/2,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y,-z+1/2',
    '-x,y+1/2,z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P B N A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x+1/2,y,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z',
    ) : ['P N A A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x,-y,-z',
    '-x+1/2,y,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y,-z+1/2',
    '-x,y,z',
    'x+1/2,-y,z+1/2',
    ) : ['P M N A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x,-y,-z',
    '-x+1/2,y,-z+1/2',
    '-x,-y,-z',
    'x+1/2,y,-z+1/2',
    '-x,y,z',
    'x+1/2,-y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z',
    'x,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z',
    'x,-y+1/2,z+1/2',
    ) : ['C M C A'] ,
    (
    'x,y,z',
    '-x+1/2,-y,z+1/2',
    'x,-y,-z+1/2',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x+1/2,y,-z+1/2',
    '-x,y,z+1/2',
    'x+1/2,-y,z',
    ) : ['P C A A'] ,
    (
    'x,y,z',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x+1/2,-y+1/2,z',
    ) : ['P 1 21/A 1'] ,
    (
    'x,y,z',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x+1/2,-y+1/2,z',
    'x,y+1/2,z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['A 1 2/N 1'] ,
    (
    'x,y,z',
    '-x+1/2,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P 1 21/N 1'] ,
    (
    'x,y,z',
    '-x+1/2,y+1/2,z',
    'x+1/2,y,z+1/2',
    '-x,y+1/2,z+1/2',
    ) : ['B N 1 1'] ,
    (
    'x,y,z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x+1/2,-y,z',
    ) : ['P 1 2/A 1'] ,
    (
    'x,y,z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x+1/2,-y,z',
    'x+1/2,y+1/2,z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['I 1 2/A 1'] ,
    (
    'x,y,z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x+1/2,-y,z',
    'x,y+1/2,z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['A 1 2/A 1'] ,
    (
    'x,y,z',
    '-x+1/2,y,-z+1/2',
    '-x,-y,-z',
    'x+1/2,-y,z+1/2',
    ) : ['P 1 2/N 1'] ,
    (
    'x,y,z',
    '-x+1/2,y,-z+1/2',
    '-x,-y,-z',
    'x+1/2,-y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z',
    'x,-y+1/2,z+1/2',
    ) : ['C 1 2/N 1'] ,
    (
    'x,y,z',
    '-x+1/2,y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x,y+1/2,z+1/2',
    ) : ['C N 1 1'] ,
    (
    'x,y,z',
    '-x+1/4,-y+1/4,z',
    'x,-y+1/4,-z+1/4',
    '-x+1/4,y,-z+1/4',
    '-x,-y,-z',
    'x+3/4,y+3/4,-z',
    '-x,y+3/4,z+3/4',
    'x+3/4,-y,z+3/4',
    'x,y+1/2,z+1/2',
    '-x+1/4,-y+3/4,z+1/2',
    'x,-y+3/4,-z+3/4',
    '-x+1/4,y+1/2,-z+3/4',
    '-x,-y+1/2,-z+1/2',
    'x+3/4,y+1/4,-z+1/2',
    '-x,y+1/4,z+1/4',
    'x+3/4,-y+1/2,z+1/4',
    'x+1/2,y,z+1/2',
    '-x+3/4,-y+1/4,z+1/2',
    'x+1/2,-y+1/4,-z+3/4',
    '-x+3/4,y,-z+3/4',
    '-x+1/2,-y,-z+1/2',
    'x+1/4,y+3/4,-z+1/2',
    '-x+1/2,y+3/4,z+1/4',
    'x+1/4,-y,z+1/4',
    'x+1/2,y+1/2,z',
    '-x+3/4,-y+3/4,z',
    'x+1/2,-y+3/4,-z+1/4',
    '-x+3/4,y+1/2,-z+1/4',
    '-x+1/2,-y+1/2,-z',
    'x+1/4,y+1/4,-z',
    '-x+1/2,y+1/4,z+3/4',
    'x+1/4,-y+1/2,z+3/4',
    ) : ['F D D D :2', 'F D D D:2'] ,
    (
    'x,y,z',
    '-x+1/4,-y+1/4,z',
    'x,-y+1/4,-z+1/4',
    '-x+1/4,y,-z+1/4',
    'z,x,y',
    '-z+1/4,-x+1/4,y',
    'z,-x+1/4,-y+1/4',
    '-z+1/4,x,-y+1/4',
    'y,z,x',
    'y,-z+1/4,-x+1/4',
    '-y+1/4,z,-x+1/4',
    '-y+1/4,-z+1/4,x',
    '-x,-y,-z',
    'x+3/4,y+3/4,-z',
    '-x,y+3/4,z+3/4',
    'x+3/4,-y,z+3/4',
    '-z,-x,-y',
    'z+3/4,x+3/4,-y',
    '-z,x+3/4,y+3/4',
    'z+3/4,-x,y+3/4',
    '-y,-z,-x',
    '-y,z+3/4,x+3/4',
    'y+3/4,-z,x+3/4',
    'y+3/4,z+3/4,-x',
    'x,y+1/2,z+1/2',
    '-x+1/4,-y+3/4,z+1/2',
    'x,-y+3/4,-z+3/4',
    '-x+1/4,y+1/2,-z+3/4',
    'z,x+1/2,y+1/2',
    '-z+1/4,-x+3/4,y+1/2',
    'z,-x+3/4,-y+3/4',
    '-z+1/4,x+1/2,-y+3/4',
    'y,z+1/2,x+1/2',
    'y,-z+3/4,-x+3/4',
    '-y+1/4,z+1/2,-x+3/4',
    '-y+1/4,-z+3/4,x+1/2',
    '-x,-y+1/2,-z+1/2',
    'x+3/4,y+1/4,-z+1/2',
    '-x,y+1/4,z+1/4',
    'x+3/4,-y+1/2,z+1/4',
    '-z,-x+1/2,-y+1/2',
    'z+3/4,x+1/4,-y+1/2',
    '-z,x+1/4,y+1/4',
    'z+3/4,-x+1/2,y+1/4',
    '-y,-z+1/2,-x+1/2',
    '-y,z+1/4,x+1/4',
    'y+3/4,-z+1/2,x+1/4',
    'y+3/4,z+1/4,-x+1/2',
    'x+1/2,y,z+1/2',
    '-x+3/4,-y+1/4,z+1/2',
    'x+1/2,-y+1/4,-z+3/4',
    '-x+3/4,y,-z+3/4',
    'z+1/2,x,y+1/2',
    '-z+3/4,-x+1/4,y+1/2',
    'z+1/2,-x+1/4,-y+3/4',
    '-z+3/4,x,-y+3/4',
    'y+1/2,z,x+1/2',
    'y+1/2,-z+1/4,-x+3/4',
    '-y+3/4,z,-x+3/4',
    '-y+3/4,-z+1/4,x+1/2',
    '-x+1/2,-y,-z+1/2',
    'x+1/4,y+3/4,-z+1/2',
    '-x+1/2,y+3/4,z+1/4',
    'x+1/4,-y,z+1/4',
    '-z+1/2,-x,-y+1/2',
    'z+1/4,x+3/4,-y+1/2',
    '-z+1/2,x+3/4,y+1/4',
    'z+1/4,-x,y+1/4',
    '-y+1/2,-z,-x+1/2',
    '-y+1/2,z+3/4,x+1/4',
    'y+1/4,-z,x+1/4',
    'y+1/4,z+3/4,-x+1/2',
    'x+1/2,y+1/2,z',
    '-x+3/4,-y+3/4,z',
    'x+1/2,-y+3/4,-z+1/4',
    '-x+3/4,y+1/2,-z+1/4',
    'z+1/2,x+1/2,y',
    '-z+3/4,-x+3/4,y',
    'z+1/2,-x+3/4,-y+1/4',
    '-z+3/4,x+1/2,-y+1/4',
    'y+1/2,z+1/2,x',
    'y+1/2,-z+3/4,-x+1/4',
    '-y+3/4,z+1/2,-x+1/4',
    '-y+3/4,-z+3/4,x',
    '-x+1/2,-y+1/2,-z',
    'x+1/4,y+1/4,-z',
    '-x+1/2,y+1/4,z+3/4',
    'x+1/4,-y+1/2,z+3/4',
    '-z+1/2,-x+1/2,-y',
    'z+1/4,x+1/4,-y',
    '-z+1/2,x+1/4,y+3/4',
    'z+1/4,-x+1/2,y+3/4',
    '-y+1/2,-z+1/2,-x',
    '-y+1/2,z+1/4,x+3/4',
    'y+1/4,-z+1/2,x+3/4',
    'y+1/4,z+1/4,-x',
    ) : ['F D -3 :2', 'F D -3:2'] ,
    (
    'x,y,z',
    '-x+y,-x,-z',
    '-y,x-y,z',
    'x,y,-z',
    '-x+y,-x,z',
    '-y,x-y,-z',
    ) : ['P -6'] ,
    (
    'x,y,z',
    '-x+y,-x,-z',
    '-y,x-y,z',
    'x,y,-z',
    '-x+y,-x,z',
    '-y,x-y,-z',
    '-y,-x,-z',
    '-x+y,y,z',
    'x,x-y,-z',
    '-y,-x,z',
    '-x+y,y,-z',
    'x,x-y,z',
    ) : ['P -6 M 2'] ,
    (
    'x,y,z',
    '-x+y,-x,-z',
    '-y,x-y,z',
    'x,y,-z',
    '-x+y,-x,z',
    '-y,x-y,-z',
    'y,x,z',
    'x-y,-y,-z',
    '-x,-x+y,z',
    'y,x,-z',
    'x-y,-y,z',
    '-x,-x+y,-z',
    ) : ['P -6 2 M'] ,
    (
    'x,y,z',
    '-x+y,-x,-z+1/2',
    '-y,x-y,z',
    'x,y,-z+1/2',
    '-x+y,-x,z',
    '-y,x-y,-z+1/2',
    '-y,-x,-z',
    '-x+y,y,z+1/2',
    'x,x-y,-z',
    '-y,-x,z+1/2',
    '-x+y,y,-z',
    'x,x-y,z+1/2',
    ) : ['P -6 C 2'] ,
    (
    'x,y,z',
    '-x+y,-x,-z+1/2',
    '-y,x-y,z',
    'x,y,-z+1/2',
    '-x+y,-x,z',
    '-y,x-y,-z+1/2',
    'y,x,z+1/2',
    'x-y,-y,-z',
    '-x,-x+y,z+1/2',
    'y,x,-z',
    'x-y,-y,z+1/2',
    '-x,-x+y,-z',
    ) : ['P -6 2 C'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    '-x,-y,-z',
    'x,y+1/2,-z',
    ) : ['P 1 1 2/B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    '-x,-y,-z',
    'x,y+1/2,-z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y,z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y,-z+1/2',
    ) : ['I 1 1 2/B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    '-x,-y,-z',
    'x,y+1/2,-z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    ) : ['B 1 1 2/B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y,z',
    ) : ['P B A B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y,z+1/2',
    ) : ['B B A B :2', 'B B A B:2'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['P N N B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x+1/2,-y,-z',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x+1/2,y,z',
    'x+1/2,-y+1/2,z',
    ) : ['P M A B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P C N B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x,-y+1/2,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x,y+1/2,z',
    'x,-y,z',
    ) : ['P B M B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x,-y+1/2,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x,y+1/2,z',
    'x,-y,z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['I C M A'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x,-y+1/2,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x,y+1/2,z',
    'x,-y,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['B B M B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x,-y+1/2,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x,y+1/2,z',
    'x,-y,z',
    'x,y+1/2,z+1/2',
    '-x,-y,z+1/2',
    'x,-y,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x,y,-z+1/2',
    '-x,y,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['A B M M'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x,-y+1/2,-z+1/2',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x,y+1/2,z+1/2',
    'x,-y,z+1/2',
    ) : ['P N C B :2', 'P N C B:2'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x,-y,-z',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x,y,z',
    'x,-y+1/2,z',
    ) : ['P M M B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x,-y,-z',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x,y,z',
    'x,-y+1/2,z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['I M M A'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x,-y,-z',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x,y,z',
    'x,-y+1/2,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['B M M B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x,-y,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x,y,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['P C C B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x,-y,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x,y,z+1/2',
    'x,-y+1/2,z+1/2',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y,-z',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y,z',
    ) : ['I B C A'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x,-y,-z+1/2',
    '-x,y+1/2,-z+1/2',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y,-z',
    ) : ['I 21 21 21'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x,-y,-z+1/2',
    '-x,y+1/2,-z+1/2',
    'z,x,y',
    '-z,-x+1/2,y',
    'z,-x,-y+1/2',
    '-z,x+1/2,-y+1/2',
    'y,z,x',
    'y,-z,-x+1/2',
    '-y,z+1/2,-x+1/2',
    '-y+1/2,-z,x+1/2',
    '-x,-y,-z',
    'x,y+1/2,-z',
    '-x,y,z+1/2',
    'x,-y+1/2,z+1/2',
    '-z,-x,-y',
    'z,x+1/2,-y',
    '-z,x,y+1/2',
    'z,-x+1/2,y+1/2',
    '-y,-z,-x',
    '-y,z,x+1/2',
    'y,-z+1/2,x+1/2',
    'y+1/2,z,-x+1/2',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y,-z',
    'z+1/2,x+1/2,y+1/2',
    '-z+1/2,-x,y+1/2',
    'z+1/2,-x+1/2,-y',
    '-z+1/2,x,-y',
    'y+1/2,z+1/2,x+1/2',
    'y+1/2,-z+1/2,-x',
    '-y+1/2,z,-x',
    '-y,-z+1/2,x',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y,z',
    '-z+1/2,-x+1/2,-y+1/2',
    'z+1/2,x,-y+1/2',
    '-z+1/2,x+1/2,y',
    'z+1/2,-x,y',
    '-y+1/2,-z+1/2,-x+1/2',
    '-y+1/2,z+1/2,x',
    'y+1/2,-z,x',
    'y,z+1/2,-x',
    ) : ['I A -3'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z',
    'x,-y,-z+1/2',
    '-x,y+1/2,-z+1/2',
    'z,x,y',
    '-z,-x+1/2,y',
    'z,-x,-y+1/2',
    '-z,x+1/2,-y+1/2',
    'y,z,x',
    'y,-z,-x+1/2',
    '-y,z+1/2,-x+1/2',
    '-y+1/2,-z,x+1/2',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y,-z',
    'z+1/2,x+1/2,y+1/2',
    '-z+1/2,-x,y+1/2',
    'z+1/2,-x+1/2,-y',
    '-z+1/2,x,-y',
    'y+1/2,z+1/2,x+1/2',
    'y+1/2,-z+1/2,-x',
    '-y+1/2,z,-x',
    '-y,-z+1/2,x',
    ) : ['I 21 3'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z+1/2',
    '-x,-y,-z',
    'x,y+1/2,-z+1/2',
    ) : ['P 1 1 21/B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y,z',
    ) : ['P N M 21'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y,-z+1/2',
    '-x,-y,-z',
    'x,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y,z+1/2',
    ) : ['P B N B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y,z',
    ) : ['P N A B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z+1/2',
    'x+1/2,-y,-z',
    '-x+1/2,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x,y+1/2,-z+1/2',
    '-x+1/2,y,z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P M N B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x,y+1/2,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y+1/2,z',
    ) : ['P C A B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z+1/2',
    'x,-y+1/2,-z',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z',
    'x,-y,z+1/2',
    ) : ['P B C B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y,z',
    ) : ['P N M B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z+1/2',
    'x,-y,-z',
    '-x,y+1/2,-z+1/2',
    ) : ['P 2 21 21'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z+1/2',
    'x,-y,-z',
    '-x,y+1/2,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x,y,-z',
    '-x,y+1/2,z+1/2',
    'x,-y,z',
    ) : ['P N M M :1', 'P N M M:1'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z+1/2',
    'x,-y,-z',
    '-x,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x,y+1/2,-z+1/2',
    '-x,y,z',
    'x,-y+1/2,z+1/2',
    ) : ['P M C B'] ,
    (
    'x,y,z',
    '-x,-y+1/2,z+1/2',
    'x,-y,-z+1/2',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x,y+1/2,-z+1/2',
    '-x,y,z+1/2',
    'x,-y+1/2,z',
    ) : ['P C M B'] ,
    (
    'x,y,z',
    '-x,-y,-z',
    ) : ['P -1', 'P 1-'] ,
    (
    'x,y,z',
    '-x,-y,z',
    ) : ['P 1 1 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    ) : ['P B A 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['B B A 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['A B A 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P N N 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x+1/2,y,z',
    'x+1/2,-y,z',
    ) : ['P M A 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x+1/2,y,z',
    'x+1/2,-y,z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['I M A 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x+1/2,y,z',
    'x+1/2,-y,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    '-x,y,z+1/2',
    'x,-y,z+1/2',
    ) : ['B M A 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x+1/2,y,z',
    'x+1/2,-y,z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['A M A 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['P C N 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x+1/4,y+1/4,z+1/4',
    'x+3/4,-y+3/4,z+1/4',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    '-x+1/4,y+3/4,z+3/4',
    'x+3/4,-y+1/4,z+3/4',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    '-x+3/4,y+1/4,z+3/4',
    'x+1/4,-y+3/4,z+3/4',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    '-x+3/4,y+3/4,z+1/4',
    'x+1/4,-y+1/4,z+1/4',
    ) : ['F D D 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,-y,-z',
    'x,y,-z',
    ) : ['P 1 1 2/M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,-y,-z',
    'x,y,-z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    ) : ['I 1 1 2/M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,-y,-z',
    'x,y,-z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y,-z+1/2',
    ) : ['B 1 1 2/M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,-y,-z',
    'x,y,-z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    ) : ['A 1 1 2/M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y+1/2,z',
    'x,-y+1/2,z',
    ) : ['P B M 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y+1/2,z',
    'x,-y+1/2,z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['I B M 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y+1/2,z',
    'x,-y+1/2,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['B B M 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y+1/2,z',
    'x,-y+1/2,z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    '-x,y,z+1/2',
    'x,-y,z+1/2',
    ) : ['A B M 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['P N C 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y,z',
    'x,-y,z',
    ) : ['P M M 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y,z',
    'x,-y,z',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    ) : ['C M M 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y,z',
    'x,-y,z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['I M M 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y,z',
    'x,-y,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['B M M 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y,z',
    'x,-y,z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['A M M 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y,z',
    'x,-y,z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    ) : ['F M M 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y,z+1/2',
    'x,-y,z+1/2',
    ) : ['P C C 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y,z+1/2',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['C C C 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    '-x,y,z+1/2',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    ) : ['I B A 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    ) : ['P 21 21 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-x+1/2,-y+1/2,-z',
    'x+1/2,y+1/2,-z',
    '-x,y,z',
    'x,-y,z',
    ) : ['P M M N :1', 'P M M N:1'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    ) : ['P B A M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['B B C M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['A C A M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x,y,-z',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P N N M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x+1/2,-y,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x+1/2,y,z',
    'x+1/2,-y,z',
    ) : ['P M A M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x+1/2,-y,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x+1/2,y,z',
    'x+1/2,-y,z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['I M C M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x+1/2,-y,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x+1/2,y,z',
    'x+1/2,-y,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x,-y,-z+1/2',
    '-x,y,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x,y,z+1/2',
    'x,-y,z+1/2',
    ) : ['B M C M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x+1/2,-y,-z',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x+1/2,y,z',
    'x+1/2,-y,z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['A M A M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x,-y,-z',
    'x,y,-z',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['P C N M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    ) : ['I 1 1 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    ) : ['B 1 1 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y+1/2,-z',
    '-x,y+1/2,-z',
    ) : ['P 2 21 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y+1/2,-z',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y+1/2,z',
    'x,-y+1/2,z',
    ) : ['P B M M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y+1/2,-z',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y+1/2,z',
    'x,-y+1/2,z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['I C M M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y+1/2,-z',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y+1/2,z',
    'x,-y+1/2,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['B B M M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y+1/2,-z',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y+1/2,z',
    'x,-y+1/2,z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x,-y,-z+1/2',
    '-x,y,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x,y,z+1/2',
    'x,-y,z+1/2',
    ) : ['A C M M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y+1/2,-z',
    '-x,y+1/2,-z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    ) : ['B 2 21 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['P N C M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    ) : ['P 2 2 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x+1/2,-y+1/2,-z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    ) : ['P B A N :1', 'P B A N:1'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x+1/2,-y+1/2,-z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['B B A B :1', 'B B A B:1', 'B B C B :1', 'B B C B:1'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x+1/2,-y+1/2,-z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['A B A A :1', 'A B A A:1', 'A C A A :1', 'A C A A:1'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P N N N :1', 'P N N N:1'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['P C N A :1', 'P C N A:1'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-x,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['C C C A :1', 'C C C A:1', 'C C C B :1', 'C C C B:1'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x+1/4,-y+1/4,-z+1/4',
    'x+1/4,y+1/4,-z+1/4',
    '-x+1/4,y+1/4,z+1/4',
    'x+1/4,-y+1/4,z+1/4',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x+1/4,-y+3/4,-z+3/4',
    'x+1/4,y+3/4,-z+3/4',
    '-x+1/4,y+3/4,z+3/4',
    'x+1/4,-y+3/4,z+3/4',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x+3/4,-y+1/4,-z+3/4',
    'x+3/4,y+1/4,-z+3/4',
    '-x+3/4,y+1/4,z+3/4',
    'x+3/4,-y+1/4,z+3/4',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-x+3/4,-y+3/4,-z+1/4',
    'x+3/4,y+3/4,-z+1/4',
    '-x+3/4,y+3/4,z+1/4',
    'x+3/4,-y+3/4,z+1/4',
    ) : ['F D D D :1', 'F D D D:1'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['P N C B :1', 'P N C B:1'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y,z',
    'x,-y,z',
    ) : ['P M M M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y,z',
    'x,-y,z',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-x+1/2,-y+1/2,-z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    ) : ['C M M M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y,z',
    'x,-y,z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['I M M M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y,z',
    'x,-y,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['B M M M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y,z',
    'x,-y,z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['A M M M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y,z',
    'x,-y,z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-x+1/2,-y+1/2,-z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    ) : ['F M M M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    ) : ['C 2 2 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    ) : ['I 2 2 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    ) : ['B 2 2 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    ) : ['A 2 2 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    ) : ['F 2 2 2'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    'z,x,y',
    '-z,-x,y',
    'z,-x,-y',
    '-z,x,-y',
    'y,z,x',
    'y,-z,-x',
    '-y,z,-x',
    '-y,-z,x',
    ) : ['P 2 3'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    'z,x,y',
    '-z,-x,y',
    'z,-x,-y',
    '-z,x,-y',
    'y,z,x',
    'y,-z,-x',
    '-y,z,-x',
    '-y,-z,x',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    '-z+1/2,-x+1/2,-y+1/2',
    'z+1/2,x+1/2,-y+1/2',
    '-z+1/2,x+1/2,y+1/2',
    'z+1/2,-x+1/2,y+1/2',
    '-y+1/2,-z+1/2,-x+1/2',
    '-y+1/2,z+1/2,x+1/2',
    'y+1/2,-z+1/2,x+1/2',
    'y+1/2,z+1/2,-x+1/2',
    ) : ['P N -3 :1', 'P N -3:1'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    'z,x,y',
    '-z,-x,y',
    'z,-x,-y',
    '-z,x,-y',
    'y,z,x',
    'y,-z,-x',
    '-y,z,-x',
    '-y,-z,x',
    '-x+1/4,-y+1/4,-z+1/4',
    'x+1/4,y+1/4,-z+1/4',
    '-x+1/4,y+1/4,z+1/4',
    'x+1/4,-y+1/4,z+1/4',
    '-z+1/4,-x+1/4,-y+1/4',
    'z+1/4,x+1/4,-y+1/4',
    '-z+1/4,x+1/4,y+1/4',
    'z+1/4,-x+1/4,y+1/4',
    '-y+1/4,-z+1/4,-x+1/4',
    '-y+1/4,z+1/4,x+1/4',
    'y+1/4,-z+1/4,x+1/4',
    'y+1/4,z+1/4,-x+1/4',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    'z,x+1/2,y+1/2',
    '-z,-x+1/2,y+1/2',
    'z,-x+1/2,-y+1/2',
    '-z,x+1/2,-y+1/2',
    'y,z+1/2,x+1/2',
    'y,-z+1/2,-x+1/2',
    '-y,z+1/2,-x+1/2',
    '-y,-z+1/2,x+1/2',
    '-x+1/4,-y+3/4,-z+3/4',
    'x+1/4,y+3/4,-z+3/4',
    '-x+1/4,y+3/4,z+3/4',
    'x+1/4,-y+3/4,z+3/4',
    '-z+1/4,-x+3/4,-y+3/4',
    'z+1/4,x+3/4,-y+3/4',
    '-z+1/4,x+3/4,y+3/4',
    'z+1/4,-x+3/4,y+3/4',
    '-y+1/4,-z+3/4,-x+3/4',
    '-y+1/4,z+3/4,x+3/4',
    'y+1/4,-z+3/4,x+3/4',
    'y+1/4,z+3/4,-x+3/4',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    'z+1/2,x,y+1/2',
    '-z+1/2,-x,y+1/2',
    'z+1/2,-x,-y+1/2',
    '-z+1/2,x,-y+1/2',
    'y+1/2,z,x+1/2',
    'y+1/2,-z,-x+1/2',
    '-y+1/2,z,-x+1/2',
    '-y+1/2,-z,x+1/2',
    '-x+3/4,-y+1/4,-z+3/4',
    'x+3/4,y+1/4,-z+3/4',
    '-x+3/4,y+1/4,z+3/4',
    'x+3/4,-y+1/4,z+3/4',
    '-z+3/4,-x+1/4,-y+3/4',
    'z+3/4,x+1/4,-y+3/4',
    '-z+3/4,x+1/4,y+3/4',
    'z+3/4,-x+1/4,y+3/4',
    '-y+3/4,-z+1/4,-x+3/4',
    '-y+3/4,z+1/4,x+3/4',
    'y+3/4,-z+1/4,x+3/4',
    'y+3/4,z+1/4,-x+3/4',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    'z+1/2,x+1/2,y',
    '-z+1/2,-x+1/2,y',
    'z+1/2,-x+1/2,-y',
    '-z+1/2,x+1/2,-y',
    'y+1/2,z+1/2,x',
    'y+1/2,-z+1/2,-x',
    '-y+1/2,z+1/2,-x',
    '-y+1/2,-z+1/2,x',
    '-x+3/4,-y+3/4,-z+1/4',
    'x+3/4,y+3/4,-z+1/4',
    '-x+3/4,y+3/4,z+1/4',
    'x+3/4,-y+3/4,z+1/4',
    '-z+3/4,-x+3/4,-y+1/4',
    'z+3/4,x+3/4,-y+1/4',
    '-z+3/4,x+3/4,y+1/4',
    'z+3/4,-x+3/4,y+1/4',
    '-y+3/4,-z+3/4,-x+1/4',
    '-y+3/4,z+3/4,x+1/4',
    'y+3/4,-z+3/4,x+1/4',
    'y+3/4,z+3/4,-x+1/4',
    ) : ['F D -3 :1', 'F D -3:1'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    'z,x,y',
    '-z,-x,y',
    'z,-x,-y',
    '-z,x,-y',
    'y,z,x',
    'y,-z,-x',
    '-y,z,-x',
    '-y,-z,x',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y,z',
    'x,-y,z',
    '-z,-x,-y',
    'z,x,-y',
    '-z,x,y',
    'z,-x,y',
    '-y,-z,-x',
    '-y,z,x',
    'y,-z,x',
    'y,z,-x',
    ) : ['P M -3'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    'z,x,y',
    '-z,-x,y',
    'z,-x,-y',
    '-z,x,-y',
    'y,z,x',
    'y,-z,-x',
    '-y,z,-x',
    '-y,-z,x',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y,z',
    'x,-y,z',
    '-z,-x,-y',
    'z,x,-y',
    '-z,x,y',
    'z,-x,y',
    '-y,-z,-x',
    '-y,z,x',
    'y,-z,x',
    'y,z,-x',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    'z+1/2,x+1/2,y+1/2',
    '-z+1/2,-x+1/2,y+1/2',
    'z+1/2,-x+1/2,-y+1/2',
    '-z+1/2,x+1/2,-y+1/2',
    'y+1/2,z+1/2,x+1/2',
    'y+1/2,-z+1/2,-x+1/2',
    '-y+1/2,z+1/2,-x+1/2',
    '-y+1/2,-z+1/2,x+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    '-z+1/2,-x+1/2,-y+1/2',
    'z+1/2,x+1/2,-y+1/2',
    '-z+1/2,x+1/2,y+1/2',
    'z+1/2,-x+1/2,y+1/2',
    '-y+1/2,-z+1/2,-x+1/2',
    '-y+1/2,z+1/2,x+1/2',
    'y+1/2,-z+1/2,x+1/2',
    'y+1/2,z+1/2,-x+1/2',
    ) : ['I M -3'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    'z,x,y',
    '-z,-x,y',
    'z,-x,-y',
    '-z,x,-y',
    'y,z,x',
    'y,-z,-x',
    '-y,z,-x',
    '-y,-z,x',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y,z',
    'x,-y,z',
    '-z,-x,-y',
    'z,x,-y',
    '-z,x,y',
    'z,-x,y',
    '-y,-z,-x',
    '-y,z,x',
    'y,-z,x',
    'y,z,-x',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    'z,x+1/2,y+1/2',
    '-z,-x+1/2,y+1/2',
    'z,-x+1/2,-y+1/2',
    '-z,x+1/2,-y+1/2',
    'y,z+1/2,x+1/2',
    'y,-z+1/2,-x+1/2',
    '-y,z+1/2,-x+1/2',
    '-y,-z+1/2,x+1/2',
    '-x,-y+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    '-z,-x+1/2,-y+1/2',
    'z,x+1/2,-y+1/2',
    '-z,x+1/2,y+1/2',
    'z,-x+1/2,y+1/2',
    '-y,-z+1/2,-x+1/2',
    '-y,z+1/2,x+1/2',
    'y,-z+1/2,x+1/2',
    'y,z+1/2,-x+1/2',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    'z+1/2,x,y+1/2',
    '-z+1/2,-x,y+1/2',
    'z+1/2,-x,-y+1/2',
    '-z+1/2,x,-y+1/2',
    'y+1/2,z,x+1/2',
    'y+1/2,-z,-x+1/2',
    '-y+1/2,z,-x+1/2',
    '-y+1/2,-z,x+1/2',
    '-x+1/2,-y,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z+1/2',
    '-z+1/2,-x,-y+1/2',
    'z+1/2,x,-y+1/2',
    '-z+1/2,x,y+1/2',
    'z+1/2,-x,y+1/2',
    '-y+1/2,-z,-x+1/2',
    '-y+1/2,z,x+1/2',
    'y+1/2,-z,x+1/2',
    'y+1/2,z,-x+1/2',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    'z+1/2,x+1/2,y',
    '-z+1/2,-x+1/2,y',
    'z+1/2,-x+1/2,-y',
    '-z+1/2,x+1/2,-y',
    'y+1/2,z+1/2,x',
    'y+1/2,-z+1/2,-x',
    '-y+1/2,z+1/2,-x',
    '-y+1/2,-z+1/2,x',
    '-x+1/2,-y+1/2,-z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    '-z+1/2,-x+1/2,-y',
    'z+1/2,x+1/2,-y',
    '-z+1/2,x+1/2,y',
    'z+1/2,-x+1/2,y',
    '-y+1/2,-z+1/2,-x',
    '-y+1/2,z+1/2,x',
    'y+1/2,-z+1/2,x',
    'y+1/2,z+1/2,-x',
    ) : ['F M -3'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    'z,x,y',
    '-z,-x,y',
    'z,-x,-y',
    '-z,x,-y',
    'y,z,x',
    'y,-z,-x',
    '-y,z,-x',
    '-y,-z,x',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    'z+1/2,x+1/2,y+1/2',
    '-z+1/2,-x+1/2,y+1/2',
    'z+1/2,-x+1/2,-y+1/2',
    '-z+1/2,x+1/2,-y+1/2',
    'y+1/2,z+1/2,x+1/2',
    'y+1/2,-z+1/2,-x+1/2',
    '-y+1/2,z+1/2,-x+1/2',
    '-y+1/2,-z+1/2,x+1/2',
    ) : ['I 2 3', 'I 23'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z',
    '-x,y,-z',
    'z,x,y',
    '-z,-x,y',
    'z,-x,-y',
    '-z,x,-y',
    'y,z,x',
    'y,-z,-x',
    '-y,z,-x',
    '-y,-z,x',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    'z,x+1/2,y+1/2',
    '-z,-x+1/2,y+1/2',
    'z,-x+1/2,-y+1/2',
    '-z,x+1/2,-y+1/2',
    'y,z+1/2,x+1/2',
    'y,-z+1/2,-x+1/2',
    '-y,z+1/2,-x+1/2',
    '-y,-z+1/2,x+1/2',
    'x+1/2,y,z+1/2',
    '-x+1/2,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y,-z+1/2',
    'z+1/2,x,y+1/2',
    '-z+1/2,-x,y+1/2',
    'z+1/2,-x,-y+1/2',
    '-z+1/2,x,-y+1/2',
    'y+1/2,z,x+1/2',
    'y+1/2,-z,-x+1/2',
    '-y+1/2,z,-x+1/2',
    '-y+1/2,-z,x+1/2',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    'z+1/2,x+1/2,y',
    '-z+1/2,-x+1/2,y',
    'z+1/2,-x+1/2,-y',
    '-z+1/2,x+1/2,-y',
    'y+1/2,z+1/2,x',
    'y+1/2,-z+1/2,-x',
    '-y+1/2,z+1/2,-x',
    '-y+1/2,-z+1/2,x',
    ) : ['F 2 3'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z+1/2',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y,z+1/2',
    'x,-y,z+1/2',
    ) : ['P C C M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z+1/2',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y,z+1/2',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['C C C M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,-y,-z+1/2',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x,y,-z',
    '-x,y,z+1/2',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    ) : ['I B A M'] ,
    (
    'x,y,z',
    '-x,-y,z',
    'x,y+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    ) : ['A 1 1 2'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    ) : ['P 1 1 21'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P B N 21'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z',
    ) : ['P N A 21'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z',
    ) : ['P C A 21'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    '-x,-y,-z',
    'x,y,-z+1/2',
    ) : ['P 1 1 21/M'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    '-x,y+1/2,z',
    'x,-y+1/2,z+1/2',
    ) : ['P B C 21'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    '-x,y,z',
    'x,-y,z+1/2',
    ) : ['P M C 21'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    '-x,y,z',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z+1/2',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['C M C 21'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    '-x,y,z+1/2',
    'x,-y,z',
    ) : ['P C M 21'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    '-x,y,z+1/2',
    'x,-y,z',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z',
    ) : ['C C M 21'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x,y,-z+1/2',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P B N M'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z',
    '-x,-y,-z',
    'x,y,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z',
    ) : ['P N A M'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x+1/2,-y,-z',
    '-x+1/2,y,-z+1/2',
    '-x,-y,-z',
    'x,y,-z+1/2',
    '-x+1/2,y,z',
    'x+1/2,-y,z+1/2',
    ) : ['P M N M :2', 'P M N M:2'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,y,-z',
    '-x,-y,-z',
    'x,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    'x+1/2,-y,z',
    ) : ['P C A M'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x,-y+1/2,-z',
    '-x,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x,y,-z+1/2',
    '-x,y+1/2,z',
    'x,-y+1/2,z+1/2',
    ) : ['P B C M'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x,y,-z+1/2',
    '-x,y+1/2,z+1/2',
    'x,-y+1/2,z',
    ) : ['P N M M :2', 'P N M M:2'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x,-y,-z',
    '-x,y,-z+1/2',
    ) : ['P 2 2 21'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x,-y,-z',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x,y,-z+1/2',
    '-x,y,z',
    'x,-y,z+1/2',
    ) : ['P M C M'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x,-y,-z',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x,y,-z+1/2',
    '-x,y,z',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['C M C M'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x,-y,-z',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x,y,-z+1/2',
    '-x,y,z',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z',
    ) : ['I M A M'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x,-y,-z',
    '-x,y,-z+1/2',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z+1/2',
    ) : ['C 2 2 21'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x,-y,-z+1/2',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y,-z+1/2',
    '-x,y,z+1/2',
    'x,-y,z',
    ) : ['P C M M'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x,-y,-z+1/2',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y,-z+1/2',
    '-x,y,z+1/2',
    'x,-y,z',
    'x+1/2,y+1/2,z',
    '-x+1/2,-y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z',
    '-x+1/2,-y+1/2,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z',
    ) : ['C C M M'] ,
    (
    'x,y,z',
    '-x,-y,z+1/2',
    'x,-y,-z+1/2',
    '-x,y,-z',
    '-x,-y,-z',
    'x,y,-z+1/2',
    '-x,y,z+1/2',
    'x,-y,z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,-y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['I B M M'] ,
    (
    'x,y,z',
    '-x,y+1/2,-z',
    ) : ['P 1 21 1', 'P 21'] ,
    (
    'x,y,z',
    '-x,y+1/2,-z',
    '-x,-y,-z',
    'x,-y+1/2,z',
    ) : ['P 1 21/M 1'] ,
    (
    'x,y,z',
    '-x,y+1/2,-z+1/2',
    '-x,-y,-z',
    'x,-y+1/2,z+1/2',
    ) : ['P 1 21/C 1'] ,
    (
    'x,y,z',
    '-x,y+1/2,z',
    ) : ['P B 1 1'] ,
    (
    'x,y,z',
    '-x,y+1/2,z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,y,z+1/2',
    ) : ['I B 1 1'] ,
    (
    'x,y,z',
    '-x,y+1/2,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    ) : ['B B 1 1'] ,
    (
    'x,y,z',
    '-x,y+1/2,z+1/2',
    ) : ['P N 1 1'] ,
    (
    'x,y,z',
    '-x,y,-z',
    ) : ['P 1 2 1', 'P 2'] ,
    (
    'x,y,z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,-y,z',
    ) : ['P 1 2/M 1'] ,
    (
    'x,y,z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,-y,z',
    'x+1/2,y+1/2,z',
    '-x+1/2,y+1/2,-z',
    '-x+1/2,-y+1/2,-z',
    'x+1/2,-y+1/2,z',
    ) : ['C 1 2/M 1'] ,
    (
    'x,y,z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,-y,z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['I 1 2/M 1'] ,
    (
    'x,y,z',
    '-x,y,-z',
    '-x,-y,-z',
    'x,-y,z',
    'x,y+1/2,z+1/2',
    '-x,y+1/2,-z+1/2',
    '-x,-y+1/2,-z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['A 1 2/M 1'] ,
    (
    'x,y,z',
    '-x,y,-z',
    'x+1/2,y+1/2,z',
    '-x+1/2,y+1/2,-z',
    ) : ['C 1 2 1', 'C 2'] ,
    (
    'x,y,z',
    '-x,y,-z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    ) : ['I 1 2 1'] ,
    (
    'x,y,z',
    '-x,y,-z',
    'x,y+1/2,z+1/2',
    '-x,y+1/2,-z+1/2',
    ) : ['A 1 2 1'] ,
    (
    'x,y,z',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x,-y,z+1/2',
    ) : ['P 1 2/C 1'] ,
    (
    'x,y,z',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x+1/2,y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['C 1 2/C 1'] ,
    (
    'x,y,z',
    '-x,y,-z+1/2',
    '-x,-y,-z',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,y+1/2,-z',
    '-x+1/2,-y+1/2,-z+1/2',
    'x+1/2,-y+1/2,z',
    ) : ['I 1 2/C 1'] ,
    (
    'x,y,z',
    '-x,y,z',
    ) : ['P M 1 1'] ,
    (
    'x,y,z',
    '-x,y,z',
    'x+1/2,y+1/2,z',
    '-x+1/2,y+1/2,z',
    ) : ['C M 1 1'] ,
    (
    'x,y,z',
    '-x,y,z',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    ) : ['I M 1 1'] ,
    (
    'x,y,z',
    '-x,y,z',
    'x+1/2,y,z+1/2',
    '-x+1/2,y,z+1/2',
    ) : ['B M 1 1'] ,
    (
    'x,y,z',
    '-x,y,z+1/2',
    ) : ['P C 1 1'] ,
    (
    'x,y,z',
    '-x,y,z+1/2',
    'x+1/2,y+1/2,z',
    '-x+1/2,y+1/2,z+1/2',
    ) : ['C C 1 1'] ,
    (
    'x,y,z',
    '-x,y,z+1/2',
    'x+1/2,y+1/2,z+1/2',
    '-x+1/2,y+1/2,z',
    ) : ['I C 1 1'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z',
    '-x,-y,z',
    'y+1/2,-x+1/2,z',
    '-x+1/2,-y+1/2,-z',
    'y,-x,-z',
    'x+1/2,y+1/2,-z',
    '-y,x,-z',
    ) : ['P 4/N :1', 'P 4/N:1'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z',
    '-x,-y,z',
    'y+1/2,-x+1/2,z',
    'x+1/2,-y+1/2,-z',
    'y,x,-z',
    '-x+1/2,y+1/2,-z',
    '-y,-x,-z',
    ) : ['P 4 21 2'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z',
    '-x,-y,z',
    'y+1/2,-x+1/2,z',
    'x+1/2,-y+1/2,-z',
    'y,x,-z',
    '-x+1/2,y+1/2,-z',
    '-y,-x,-z',
    '-x+1/2,-y+1/2,-z',
    'y,-x,-z',
    'x+1/2,y+1/2,-z',
    '-y,x,-z',
    '-x,y,z',
    '-y+1/2,-x+1/2,z',
    'x,-y,z',
    'y+1/2,x+1/2,z',
    ) : ['P 4/N M M :1', 'P 4/N M M:1'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z',
    '-x,-y,z',
    'y+1/2,-x+1/2,z',
    'x+1/2,-y+1/2,-z+1/2',
    'y,x,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-y,-x,-z+1/2',
    '-x+1/2,-y+1/2,-z',
    'y,-x,-z',
    'x+1/2,y+1/2,-z',
    '-y,x,-z',
    '-x,y,z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    'x,-y,z+1/2',
    'y+1/2,x+1/2,z+1/2',
    ) : ['P 4/N C C :1', 'P 4/N C C:1'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z+1/2',
    '-x,-y,z',
    'y+1/2,-x+1/2,z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'y,-x,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-y,x,-z',
    ) : ['P 42/N :1', 'P 42/N:1'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z+1/2',
    '-x,-y,z',
    'y+1/2,-x+1/2,z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-y,-x,z',
    'x+1/2,-y+1/2,z+1/2',
    'y,x,z',
    ) : ['P 42 N M'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z+1/2',
    '-x,-y,z',
    'y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,-z',
    'y,x,-z+1/2',
    '-x+1/2,y+1/2,-z',
    '-y,-x,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'y,-x,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-y,x,-z',
    '-x,y,z+1/2',
    '-y+1/2,-x+1/2,z',
    'x,-y,z+1/2',
    'y+1/2,x+1/2,z',
    ) : ['P 42/N C M :1', 'P 42/N C M:1'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z+1/2',
    '-x,-y,z',
    'y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    'y,x,-z',
    '-x+1/2,y+1/2,-z+1/2',
    '-y,-x,-z',
    ) : ['P 42 21 2'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z+1/2',
    '-x,-y,z',
    'y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    'y,x,-z',
    '-x+1/2,y+1/2,-z+1/2',
    '-y,-x,-z',
    '-x+1/2,-y+1/2,-z+1/2',
    'y,-x,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-y,x,-z',
    '-x,y,z',
    '-y+1/2,-x+1/2,z+1/2',
    'x,-y,z',
    'y+1/2,x+1/2,z+1/2',
    ) : ['P 42/N M C :1', 'P 42/N M C:1'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z+1/2',
    '-x,-y,z',
    'y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    'y,x,-z',
    '-x+1/2,y+1/2,-z+1/2',
    '-y,-x,-z',
    '-x,-y,-z',
    'y+1/2,-x+1/2,-z+1/2',
    'x,y,-z',
    '-y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-y,-x,z',
    'x+1/2,-y+1/2,z+1/2',
    'y,x,z',
    ) : ['P 42/M N M'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z+1/2',
    '-x,-y,z',
    'y+1/2,-x+1/2,z+1/2',
    'x,-y,-z',
    'y+1/2,x+1/2,-z+1/2',
    '-x,y,-z',
    '-y+1/2,-x+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'y,-x,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-y,x,-z',
    '-x+1/2,y+1/2,z+1/2',
    '-y,-x,z',
    'x+1/2,-y+1/2,z+1/2',
    'y,x,z',
    ) : ['P 42/N N M :1', 'P 42/N N M:1'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z+1/2',
    '-x,-y,z',
    'y+1/2,-x+1/2,z+1/2',
    'x,-y,-z',
    'y+1/2,x+1/2,-z+1/2',
    '-x,y,-z',
    '-y+1/2,-x+1/2,-z+1/2',
    'z,x,y',
    '-x+1/2,z+1/2,y+1/2',
    '-z,-x,y',
    'x+1/2,-z+1/2,y+1/2',
    'z,-x,-y',
    'x+1/2,z+1/2,-y+1/2',
    '-z,x,-y',
    '-x+1/2,-z+1/2,-y+1/2',
    'y,z,x',
    'y,-z,-x',
    'z+1/2,y+1/2,-x+1/2',
    '-y,z,-x',
    '-z+1/2,-y+1/2,-x+1/2',
    '-y,-z,x',
    'z+1/2,-y+1/2,x+1/2',
    '-z+1/2,y+1/2,x+1/2',
    ) : ['P 42 3 2'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z+1/2',
    '-x,-y,z',
    'y+1/2,-x+1/2,z+1/2',
    'x,-y,-z',
    'y+1/2,x+1/2,-z+1/2',
    '-x,y,-z',
    '-y+1/2,-x+1/2,-z+1/2',
    'z,x,y',
    '-x+1/2,z+1/2,y+1/2',
    '-z,-x,y',
    'x+1/2,-z+1/2,y+1/2',
    'z,-x,-y',
    'x+1/2,z+1/2,-y+1/2',
    '-z,x,-y',
    '-x+1/2,-z+1/2,-y+1/2',
    'y,z,x',
    'y,-z,-x',
    'z+1/2,y+1/2,-x+1/2',
    '-y,z,-x',
    '-z+1/2,-y+1/2,-x+1/2',
    '-y,-z,x',
    'z+1/2,-y+1/2,x+1/2',
    '-z+1/2,y+1/2,x+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'y,-x,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-y,x,-z',
    '-x+1/2,y+1/2,z+1/2',
    '-y,-x,z',
    'x+1/2,-y+1/2,z+1/2',
    'y,x,z',
    '-z+1/2,-x+1/2,-y+1/2',
    'x,-z,-y',
    'z+1/2,x+1/2,-y+1/2',
    '-x,z,-y',
    '-z+1/2,x+1/2,y+1/2',
    '-x,-z,y',
    'z+1/2,-x+1/2,y+1/2',
    'x,z,y',
    '-y+1/2,-z+1/2,-x+1/2',
    '-y+1/2,z+1/2,x+1/2',
    '-z,-y,x',
    'y+1/2,-z+1/2,x+1/2',
    'z,y,x',
    'y+1/2,z+1/2,-x+1/2',
    '-z,y,-x',
    'z,-y,-x',
    ) : ['P N -3 M :1', 'P N -3 M:1'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z+1/2',
    '-x,-y,z',
    'y+1/2,-x+1/2,z+1/2',
    'x,-y,-z',
    'y+1/2,x+1/2,-z+1/2',
    '-x,y,-z',
    '-y+1/2,-x+1/2,-z+1/2',
    'z,x,y',
    '-x+1/2,z+1/2,y+1/2',
    '-z,-x,y',
    'x+1/2,-z+1/2,y+1/2',
    'z,-x,-y',
    'x+1/2,z+1/2,-y+1/2',
    '-z,x,-y',
    '-x+1/2,-z+1/2,-y+1/2',
    'y,z,x',
    'y,-z,-x',
    'z+1/2,y+1/2,-x+1/2',
    '-y,z,-x',
    '-z+1/2,-y+1/2,-x+1/2',
    '-y,-z,x',
    'z+1/2,-y+1/2,x+1/2',
    '-z+1/2,y+1/2,x+1/2',
    '-x,-y,-z',
    'y+1/2,-x+1/2,-z+1/2',
    'x,y,-z',
    '-y+1/2,x+1/2,-z+1/2',
    '-x,y,z',
    '-y+1/2,-x+1/2,z+1/2',
    'x,-y,z',
    'y+1/2,x+1/2,z+1/2',
    '-z,-x,-y',
    'x+1/2,-z+1/2,-y+1/2',
    'z,x,-y',
    '-x+1/2,z+1/2,-y+1/2',
    '-z,x,y',
    '-x+1/2,-z+1/2,y+1/2',
    'z,-x,y',
    'x+1/2,z+1/2,y+1/2',
    '-y,-z,-x',
    '-y,z,x',
    '-z+1/2,-y+1/2,x+1/2',
    'y,-z,x',
    'z+1/2,y+1/2,x+1/2',
    'y,z,-x',
    '-z+1/2,y+1/2,-x+1/2',
    'z+1/2,-y+1/2,-x+1/2',
    ) : ['P M -3 N'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z+1/2',
    '-x,-y,z',
    'y+1/2,-x+1/2,z+1/2',
    'x,-y,-z+1/2',
    'y+1/2,x+1/2,-z',
    '-x,y,-z+1/2',
    '-y+1/2,-x+1/2,-z',
    '-x+1/2,-y+1/2,-z+1/2',
    'y,-x,-z',
    'x+1/2,y+1/2,-z+1/2',
    '-y,x,-z',
    '-x+1/2,y+1/2,z',
    '-y,-x,z+1/2',
    'x+1/2,-y+1/2,z',
    'y,x,z+1/2',
    ) : ['P 42/N B C :1', 'P 42/N B C:1'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z+1/4',
    '-x,-y,z+1/2',
    'y+1/2,-x+1/2,z+3/4',
    'x+1/2,-y+1/2,-z+3/4',
    'y,x,-z',
    '-x+1/2,y+1/2,-z+1/4',
    '-y,-x,-z+1/2',
    ) : ['P 41 21 2'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/2,z+3/4',
    '-x,-y,z+1/2',
    'y+1/2,-x+1/2,z+1/4',
    'x+1/2,-y+1/2,-z+1/4',
    'y,x,-z',
    '-x+1/2,y+1/2,-z+3/4',
    '-y,-x,-z+1/2',
    ) : ['P 43 21 2'] ,
    (
    'x,y,z',
    '-y+1/2,x+1/4,z+1/4',
    '-x+1/4,-y+3/4,z+1/2',
    'y+3/4,-x+1/2,z+3/4',
    'x,-y+1/4,-z+1/4',
    'y+1/4,x+1/4,-z+1/2',
    '-x+1/4,y+1/2,-z+3/4',
    '-y,-x+1/2,-z',
    'z,x,y',
    '-x+1/2,z+1/4,y+1/4',
    '-z+1/4,-x+3/4,y+1/2',
    'x+3/4,-z+1/2,y+3/4',
    'z,-x+1/4,-y+1/4',
    'x+1/4,z+1/4,-y+1/2',
    '-z+1/4,x+1/2,-y+3/4',
    '-x,-z+1/2,-y',
    'y,z,x',
    'y+1/2,-z+1/4,-x+3/4',
    'z+1/4,y+3/4,-x',
    '-y+3/4,z+1/2,-x+1/4',
    '-z+1/2,-y+1/2,-x+1/2',
    '-y+1/4,-z+1/4,x',
    'z+1/4,-y,x+3/4',
    '-z,y+3/4,x+1/4',
    '-x,-y,-z',
    'y+1/2,-x+3/4,-z+3/4',
    'x+3/4,y+1/4,-z+1/2',
    '-y+1/4,x+1/2,-z+1/4',
    '-x,y+3/4,z+3/4',
    '-y+3/4,-x+3/4,z+1/2',
    'x+3/4,-y+1/2,z+1/4',
    'y,x+1/2,z',
    '-z,-x,-y',
    'x+1/2,-z+3/4,-y+3/4',
    'z+3/4,x+1/4,-y+1/2',
    '-x+1/4,z+1/2,-y+1/4',
    '-z,x+3/4,y+3/4',
    '-x+3/4,-z+3/4,y+1/2',
    'z+3/4,-x+1/2,y+1/4',
    'x,z+1/2,y',
    '-y,-z,-x',
    '-y+1/2,z+3/4,x+1/4',
    '-z+3/4,-y+1/4,x',
    'y+1/4,-z+1/2,x+3/4',
    'z+1/2,y+1/2,x+1/2',
    'y+3/4,z+3/4,-x',
    '-z+3/4,y,-x+1/4',
    'z,-y+1/4,-x+3/4',
    'x,y+1/2,z+1/2',
    '-y+1/2,x+3/4,z+3/4',
    '-x+1/4,-y+1/4,z',
    'y+3/4,-x,z+1/4',
    'x,-y+3/4,-z+3/4',
    'y+1/4,x+3/4,-z',
    '-x+1/4,y,-z+1/4',
    '-y,-x,-z+1/2',
    'z,x+1/2,y+1/2',
    '-x+1/2,z+3/4,y+3/4',
    '-z+1/4,-x+1/4,y',
    'x+3/4,-z,y+1/4',
    'z,-x+3/4,-y+3/4',
    'x+1/4,z+3/4,-y',
    '-z+1/4,x,-y+1/4',
    '-x,-z,-y+1/2',
    'y,z+1/2,x+1/2',
    'y+1/2,-z+3/4,-x+1/4',
    'z+1/4,y+1/4,-x+1/2',
    '-y+3/4,z,-x+3/4',
    '-z+1/2,-y,-x',
    '-y+1/4,-z+3/4,x+1/2',
    'z+1/4,-y+1/2,x+1/4',
    '-z,y+1/4,x+3/4',
    '-x,-y+1/2,-z+1/2',
    'y+1/2,-x+1/4,-z+1/4',
    'x+3/4,y+3/4,-z',
    '-y+1/4,x,-z+3/4',
    '-x,y+1/4,z+1/4',
    '-y+3/4,-x+1/4,z',
    'x+3/4,-y,z+3/4',
    'y,x,z+1/2',
    '-z,-x+1/2,-y+1/2',
    'x+1/2,-z+1/4,-y+1/4',
    'z+3/4,x+3/4,-y',
    '-x+1/4,z,-y+3/4',
    '-z,x+1/4,y+1/4',
    '-x+3/4,-z+1/4,y',
    'z+3/4,-x,y+3/4',
    'x,z,y+1/2',
    '-y,-z+1/2,-x+1/2',
    '-y+1/2,z+1/4,x+3/4',
    '-z+3/4,-y+3/4,x+1/2',
    'y+1/4,-z,x+1/4',
    'z+1/2,y,x',
    'y+3/4,z+1/4,-x+1/2',
    '-z+3/4,y+1/2,-x+3/4',
    'z,-y+3/4,-x+1/4',
    'x+1/2,y,z+1/2',
    '-y,x+1/4,z+3/4',
    '-x+3/4,-y+3/4,z',
    'y+1/4,-x+1/2,z+1/4',
    'x+1/2,-y+1/4,-z+3/4',
    'y+3/4,x+1/4,-z',
    '-x+3/4,y+1/2,-z+1/4',
    '-y+1/2,-x+1/2,-z+1/2',
    'z+1/2,x,y+1/2',
    '-x,z+1/4,y+3/4',
    '-z+3/4,-x+3/4,y',
    'x+1/4,-z+1/2,y+1/4',
    'z+1/2,-x+1/4,-y+3/4',
    'x+3/4,z+1/4,-y',
    '-z+3/4,x+1/2,-y+1/4',
    '-x+1/2,-z+1/2,-y+1/2',
    'y+1/2,z,x+1/2',
    'y,-z+1/4,-x+1/4',
    'z+3/4,y+3/4,-x+1/2',
    '-y+1/4,z+1/2,-x+3/4',
    '-z,-y+1/2,-x',
    '-y+3/4,-z+1/4,x+1/2',
    'z+3/4,-y,x+1/4',
    '-z+1/2,y+3/4,x+3/4',
    '-x+1/2,-y,-z+1/2',
    'y,-x+3/4,-z+1/4',
    'x+1/4,y+1/4,-z',
    '-y+3/4,x+1/2,-z+3/4',
    '-x+1/2,y+3/4,z+1/4',
    '-y+1/4,-x+3/4,z',
    'x+1/4,-y+1/2,z+3/4',
    'y+1/2,x+1/2,z+1/2',
    '-z+1/2,-x,-y+1/2',
    'x,-z+3/4,-y+1/4',
    'z+1/4,x+1/4,-y',
    '-x+3/4,z+1/2,-y+3/4',
    '-z+1/2,x+3/4,y+1/4',
    '-x+1/4,-z+3/4,y',
    'z+1/4,-x+1/2,y+3/4',
    'x+1/2,z+1/2,y+1/2',
    '-y+1/2,-z,-x+1/2',
    '-y,z+3/4,x+3/4',
    '-z+1/4,-y+1/4,x+1/2',
    'y+3/4,-z+1/2,x+1/4',
    'z,y+1/2,x',
    'y+1/4,z+3/4,-x+1/2',
    '-z+1/4,y,-x+3/4',
    'z+1/2,-y+1/4,-x+1/4',
    'x+1/2,y+1/2,z',
    '-y,x+3/4,z+1/4',
    '-x+3/4,-y+1/4,z+1/2',
    'y+1/4,-x,z+3/4',
    'x+1/2,-y+3/4,-z+1/4',
    'y+3/4,x+3/4,-z+1/2',
    '-x+3/4,y,-z+3/4',
    '-y+1/2,-x,-z',
    'z+1/2,x+1/2,y',
    '-x,z+3/4,y+1/4',
    '-z+3/4,-x+1/4,y+1/2',
    'x+1/4,-z,y+3/4',
    'z+1/2,-x+3/4,-y+1/4',
    'x+3/4,z+3/4,-y+1/2',
    '-z+3/4,x,-y+3/4',
    '-x+1/2,-z,-y',
    'y+1/2,z+1/2,x',
    'y,-z+3/4,-x+3/4',
    'z+3/4,y+1/4,-x',
    '-y+1/4,z,-x+1/4',
    '-z,-y,-x+1/2',
    '-y+3/4,-z+3/4,x',
    'z+3/4,-y+1/2,x+3/4',
    '-z+1/2,y+1/4,x+1/4',
    '-x+1/2,-y+1/2,-z',
    'y,-x+1/4,-z+3/4',
    'x+1/4,y+3/4,-z+1/2',
    '-y+3/4,x,-z+1/4',
    '-x+1/2,y+1/4,z+3/4',
    '-y+1/4,-x+1/4,z+1/2',
    'x+1/4,-y,z+1/4',
    'y+1/2,x,z',
    '-z+1/2,-x+1/2,-y',
    'x,-z+1/4,-y+3/4',
    'z+1/4,x+3/4,-y+1/2',
    '-x+3/4,z,-y+1/4',
    '-z+1/2,x+1/4,y+3/4',
    '-x+1/4,-z+1/4,y+1/2',
    'z+1/4,-x,y+1/4',
    'x+1/2,z,y',
    '-y+1/2,-z+1/2,-x',
    '-y,z+1/4,x+1/4',
    '-z+1/4,-y+3/4,x',
    'y+3/4,-z,x+3/4',
    'z,y,x+1/2',
    'y+1/4,z+1/4,-x',
    '-z+1/4,y+1/2,-x+1/4',
    'z+1/2,-y+3/4,-x+3/4',
    ) : ['F D -3 C :2', 'F D -3 C:2'] ,
    (
    'x,y,z',
    '-y+1/2,x,z',
    '-x+1/2,-y+1/2,z',
    'y,-x+1/2,z',
    '-x,-y,-z',
    'y+1/2,-x,-z',
    'x+1/2,y+1/2,-z',
    '-y,x+1/2,-z',
    ) : ['P 4/N :2', 'P 4/N:2'] ,
    (
    'x,y,z',
    '-y+1/2,x,z',
    '-x+1/2,-y+1/2,z',
    'y,-x+1/2,z',
    'x+1/2,-y,-z',
    'y+1/2,x+1/2,-z',
    '-x,y+1/2,-z',
    '-y,-x,-z',
    '-x,-y,-z',
    'y+1/2,-x,-z',
    'x+1/2,y+1/2,-z',
    '-y,x+1/2,-z',
    '-x+1/2,y,z',
    '-y+1/2,-x+1/2,z',
    'x,-y+1/2,z',
    'y,x,z',
    ) : ['P 4/N M M :2', 'P 4/N M M:2'] ,
    (
    'x,y,z',
    '-y+1/2,x,z',
    '-x+1/2,-y+1/2,z',
    'y,-x+1/2,z',
    'x+1/2,-y,-z+1/2',
    'y+1/2,x+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-y,-x,-z+1/2',
    '-x,-y,-z',
    'y+1/2,-x,-z',
    'x+1/2,y+1/2,-z',
    '-y,x+1/2,-z',
    '-x+1/2,y,z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    'y,x,z+1/2',
    ) : ['P 4/N C C :2', 'P 4/N C C:2'] ,
    (
    'x,y,z',
    '-y+1/2,x,z',
    '-x+1/2,-y+1/2,z',
    'y,-x+1/2,z',
    'x,-y+1/2,-z',
    'y,x,-z',
    '-x+1/2,y,-z',
    '-y+1/2,-x+1/2,-z',
    '-x,-y,-z',
    'y+1/2,-x,-z',
    'x+1/2,y+1/2,-z',
    '-y,x+1/2,-z',
    '-x,y+1/2,z',
    '-y,-x,z',
    'x+1/2,-y,z',
    'y+1/2,x+1/2,z',
    ) : ['P 4/N B M :2', 'P 4/N B M:2'] ,
    (
    'x,y,z',
    '-y+1/2,x,z',
    '-x+1/2,-y+1/2,z',
    'y,-x+1/2,z',
    'x,-y+1/2,-z+1/2',
    'y,x,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-y+1/2,-x+1/2,-z+1/2',
    '-x,-y,-z',
    'y+1/2,-x,-z',
    'x+1/2,y+1/2,-z',
    '-y,x+1/2,-z',
    '-x,y+1/2,z+1/2',
    '-y,-x,z+1/2',
    'x+1/2,-y,z+1/2',
    'y+1/2,x+1/2,z+1/2',
    ) : ['P 4/N N C :2', 'P 4/N N C:2'] ,
    (
    'x,y,z',
    '-y+1/2,x,z',
    '-x+1/2,-y+1/2,z',
    'y,-x+1/2,z',
    'x,-y+1/2,-z+1/2',
    'y,x,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-y+1/2,-x+1/2,-z+1/2',
    'z,x,y',
    '-x+1/2,z,y',
    '-z+1/2,-x+1/2,y',
    'x,-z+1/2,y',
    'z,-x+1/2,-y+1/2',
    'x,z,-y+1/2',
    '-z+1/2,x,-y+1/2',
    '-x+1/2,-z+1/2,-y+1/2',
    'y,z,x',
    'y,-z+1/2,-x+1/2',
    'z,y,-x+1/2',
    '-y+1/2,z,-x+1/2',
    '-z+1/2,-y+1/2,-x+1/2',
    '-y+1/2,-z+1/2,x',
    'z,-y+1/2,x',
    '-z+1/2,y,x',
    '-x,-y,-z',
    'y+1/2,-x,-z',
    'x+1/2,y+1/2,-z',
    '-y,x+1/2,-z',
    '-x,y+1/2,z+1/2',
    '-y,-x,z+1/2',
    'x+1/2,-y,z+1/2',
    'y+1/2,x+1/2,z+1/2',
    '-z,-x,-y',
    'x+1/2,-z,-y',
    'z+1/2,x+1/2,-y',
    '-x,z+1/2,-y',
    '-z,x+1/2,y+1/2',
    '-x,-z,y+1/2',
    'z+1/2,-x,y+1/2',
    'x+1/2,z+1/2,y+1/2',
    '-y,-z,-x',
    '-y,z+1/2,x+1/2',
    '-z,-y,x+1/2',
    'y+1/2,-z,x+1/2',
    'z+1/2,y+1/2,x+1/2',
    'y+1/2,z+1/2,-x',
    '-z,y+1/2,-x',
    'z+1/2,-y,-x',
    ) : ['P N -3 N :2', 'P N -3 N:2'] ,
    (
    'x,y,z',
    '-y+1/2,x,z',
    '-x+1/2,-y+1/2,z',
    'y,-x+1/2,z',
    'x,-y,-z',
    'y+1/2,x,-z',
    '-x+1/2,y+1/2,-z',
    '-y,-x+1/2,-z',
    'z,x,y',
    '-x+1/2,z,y',
    '-z+1/2,-x+1/2,y',
    'x,-z+1/2,y',
    'z,-x,-y',
    'x+1/2,z,-y',
    '-z+1/2,x+1/2,-y',
    '-x,-z+1/2,-y',
    'y,z,x',
    'y,-z+1/2,-x+1/2',
    'z,y,-x+1/2',
    '-y+1/2,z,-x+1/2',
    '-z+1/2,-y,-x',
    '-y,-z,x',
    'z,-y,x+1/2',
    '-z+1/2,y+1/2,x+1/2',
    '-x,-y,-z',
    'y+1/2,-x,-z',
    'x+1/2,y+1/2,-z',
    '-y,x+1/2,-z',
    '-x,y,z',
    '-y+1/2,-x,z',
    'x+1/2,-y+1/2,z',
    'y,x+1/2,z',
    '-z,-x,-y',
    'x+1/2,-z,-y',
    'z+1/2,x+1/2,-y',
    '-x,z+1/2,-y',
    '-z,x,y',
    '-x+1/2,-z,y',
    'z+1/2,-x+1/2,y',
    'x,z+1/2,y',
    '-y,-z,-x',
    '-y,z+1/2,x+1/2',
    '-z,-y,x+1/2',
    'y+1/2,-z,x+1/2',
    'z+1/2,y,x',
    'y,z,-x',
    '-z,y,-x+1/2',
    'z+1/2,-y+1/2,-x+1/2',
    'x,y+1/2,z+1/2',
    '-y+1/2,x+1/2,z+1/2',
    '-x+1/2,-y,z+1/2',
    'y,-x,z+1/2',
    'x,-y+1/2,-z+1/2',
    'y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-y,-x,-z+1/2',
    'z,x+1/2,y+1/2',
    '-x+1/2,z+1/2,y+1/2',
    '-z+1/2,-x,y+1/2',
    'x,-z,y+1/2',
    'z,-x+1/2,-y+1/2',
    'x+1/2,z+1/2,-y+1/2',
    '-z+1/2,x,-y+1/2',
    '-x,-z,-y+1/2',
    'y,z+1/2,x+1/2',
    'y,-z,-x',
    'z,y+1/2,-x',
    '-y+1/2,z+1/2,-x',
    '-z+1/2,-y+1/2,-x+1/2',
    '-y,-z+1/2,x+1/2',
    'z,-y+1/2,x',
    '-z+1/2,y,x',
    '-x,-y+1/2,-z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-y,x,-z+1/2',
    '-x,y+1/2,z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y,z+1/2',
    'y,x,z+1/2',
    '-z,-x+1/2,-y+1/2',
    'x+1/2,-z+1/2,-y+1/2',
    'z+1/2,x,-y+1/2',
    '-x,z,-y+1/2',
    '-z,x+1/2,y+1/2',
    '-x+1/2,-z+1/2,y+1/2',
    'z+1/2,-x,y+1/2',
    'x,z,y+1/2',
    '-y,-z+1/2,-x+1/2',
    '-y,z,x',
    '-z,-y+1/2,x',
    'y+1/2,-z+1/2,x',
    'z+1/2,y+1/2,x+1/2',
    'y,z+1/2,-x+1/2',
    '-z,y+1/2,-x',
    'z+1/2,-y,-x',
    'x+1/2,y,z+1/2',
    '-y,x,z+1/2',
    '-x,-y+1/2,z+1/2',
    'y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y,-z+1/2',
    'y,x,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-y+1/2,-x+1/2,-z+1/2',
    'z+1/2,x,y+1/2',
    '-x,z,y+1/2',
    '-z,-x+1/2,y+1/2',
    'x+1/2,-z+1/2,y+1/2',
    'z+1/2,-x,-y+1/2',
    'x,z,-y+1/2',
    '-z,x+1/2,-y+1/2',
    '-x+1/2,-z+1/2,-y+1/2',
    'y+1/2,z,x+1/2',
    'y+1/2,-z+1/2,-x',
    'z+1/2,y,-x',
    '-y,z,-x',
    '-z,-y,-x+1/2',
    '-y+1/2,-z,x+1/2',
    'z+1/2,-y,x',
    '-z,y+1/2,x',
    '-x+1/2,-y,-z+1/2',
    'y,-x,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y,z+1/2',
    '-y,-x,z+1/2',
    'x,-y+1/2,z+1/2',
    'y+1/2,x+1/2,z+1/2',
    '-z+1/2,-x,-y+1/2',
    'x,-z,-y+1/2',
    'z,x+1/2,-y+1/2',
    '-x+1/2,z+1/2,-y+1/2',
    '-z+1/2,x,y+1/2',
    '-x,-z,y+1/2',
    'z,-x+1/2,y+1/2',
    'x+1/2,z+1/2,y+1/2',
    '-y+1/2,-z,-x+1/2',
    '-y+1/2,z+1/2,x',
    '-z+1/2,-y,x',
    'y,-z,x',
    'z,y,x+1/2',
    'y+1/2,z,-x+1/2',
    '-z+1/2,y,-x',
    'z,-y+1/2,-x',
    'x+1/2,y+1/2,z',
    '-y,x+1/2,z',
    '-x,-y,z',
    'y+1/2,-x,z',
    'x+1/2,-y+1/2,-z',
    'y,x+1/2,-z',
    '-x,y,-z',
    '-y+1/2,-x,-z',
    'z+1/2,x+1/2,y',
    '-x,z+1/2,y',
    '-z,-x,y',
    'x+1/2,-z,y',
    'z+1/2,-x+1/2,-y',
    'x,z+1/2,-y',
    '-z,x,-y',
    '-x+1/2,-z,-y',
    'y+1/2,z+1/2,x',
    'y+1/2,-z,-x+1/2',
    'z+1/2,y+1/2,-x+1/2',
    '-y,z+1/2,-x+1/2',
    '-z,-y+1/2,-x',
    '-y+1/2,-z+1/2,x',
    'z+1/2,-y+1/2,x+1/2',
    '-z,y,x+1/2',
    '-x+1/2,-y+1/2,-z',
    'y,-x+1/2,-z',
    'x,y,-z',
    '-y+1/2,x,-z',
    '-x+1/2,y+1/2,z',
    '-y,-x+1/2,z',
    'x,-y,z',
    'y+1/2,x,z',
    '-z+1/2,-x+1/2,-y',
    'x,-z+1/2,-y',
    'z,x,-y',
    '-x+1/2,z,-y',
    '-z+1/2,x+1/2,y',
    '-x,-z+1/2,y',
    'z,-x,y',
    'x+1/2,z,y',
    '-y+1/2,-z+1/2,-x',
    '-y+1/2,z,x+1/2',
    '-z+1/2,-y+1/2,x+1/2',
    'y,-z+1/2,x+1/2',
    'z,y+1/2,x',
    'y+1/2,z+1/2,-x',
    '-z+1/2,y+1/2,-x+1/2',
    'z,-y,-x+1/2',
    ) : ['F M -3 C'] ,
    (
    'x,y,z',
    '-y+1/2,x,z+1/2',
    '-x+1/2,-y+1/2,z',
    'y,-x+1/2,z+1/2',
    'x+1/2,-y,-z',
    'y+1/2,x+1/2,-z+1/2',
    '-x,y+1/2,-z',
    '-y,-x,-z+1/2',
    '-x,-y,-z',
    'y+1/2,-x,-z+1/2',
    'x+1/2,y+1/2,-z',
    '-y,x+1/2,-z+1/2',
    '-x+1/2,y,z',
    '-y+1/2,-x+1/2,z+1/2',
    'x,-y+1/2,z',
    'y,x,z+1/2',
    ) : ['P 42/N M C :2', 'P 42/N M C:2'] ,
    (
    'x,y,z',
    '-y+1/2,x,z+1/2',
    '-x+1/2,-y+1/2,z',
    'y,-x+1/2,z+1/2',
    'x+1/2,-y,-z+1/2',
    'y+1/2,x+1/2,-z',
    '-x,y+1/2,-z+1/2',
    '-y,-x,-z',
    '-x,-y,-z',
    'y+1/2,-x,-z+1/2',
    'x+1/2,y+1/2,-z',
    '-y,x+1/2,-z+1/2',
    '-x+1/2,y,z+1/2',
    '-y+1/2,-x+1/2,z',
    'x,-y+1/2,z+1/2',
    'y,x,z',
    ) : ['P 42/N C M :2', 'P 42/N C M:2'] ,
    (
    'x,y,z',
    '-y+1/2,x,z+1/2',
    '-x+1/2,-y+1/2,z',
    'y,-x+1/2,z+1/2',
    'x,-y+1/2,-z',
    'y,x,-z+1/2',
    '-x+1/2,y,-z',
    '-y+1/2,-x+1/2,-z+1/2',
    '-x,-y,-z',
    'y+1/2,-x,-z+1/2',
    'x+1/2,y+1/2,-z',
    '-y,x+1/2,-z+1/2',
    '-x,y+1/2,z',
    '-y,-x,z+1/2',
    'x+1/2,-y,z',
    'y+1/2,x+1/2,z+1/2',
    ) : ['P 42/N B C :2', 'P 42/N B C:2'] ,
    (
    'x,y,z',
    '-y+1/2,x,z+1/2',
    '-x+1/2,-y+1/2,z',
    'y,-x+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    'y,x,-z',
    '-x+1/2,y,-z+1/2',
    '-y+1/2,-x+1/2,-z',
    '-x,-y,-z',
    'y+1/2,-x,-z+1/2',
    'x+1/2,y+1/2,-z',
    '-y,x+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    '-y,-x,z',
    'x+1/2,-y,z+1/2',
    'y+1/2,x+1/2,z',
    ) : ['P 42/N N M :2', 'P 42/N N M:2'] ,
    (
    'x,y,z',
    '-y+1/4,x+1/4,z+1/4',
    '-x,-y+1/2,z+1/2',
    'y+3/4,-x+1/4,z+3/4',
    'x,-y,-z',
    'y+1/4,x+1/4,-z+1/4',
    '-x,y+1/2,-z+1/2',
    '-y+3/4,-x+1/4,-z+3/4',
    'z,x,y',
    '-x+1/4,z+1/4,y+1/4',
    '-z,-x+1/2,y+1/2',
    'x+3/4,-z+1/4,y+3/4',
    'z,-x,-y',
    'x+1/4,z+1/4,-y+1/4',
    '-z,x+1/2,-y+1/2',
    '-x+3/4,-z+1/4,-y+3/4',
    'y,z,x',
    'y+1/2,-z,-x+1/2',
    'z+1/4,y+3/4,-x+3/4',
    '-y+1/2,z+1/2,-x',
    '-z+1/4,-y+1/4,-x+1/4',
    '-y,-z,x',
    'z+1/4,-y+3/4,x+3/4',
    '-z+3/4,y+3/4,x+1/4',
    '-x+1/4,-y+1/4,-z+1/4',
    'y,-x,-z',
    'x+1/4,y+3/4,-z+3/4',
    '-y+1/2,x,-z+1/2',
    '-x+1/4,y+1/4,z+1/4',
    '-y,-x,z',
    'x+1/4,-y+3/4,z+3/4',
    'y+1/2,x,z+1/2',
    '-z+1/4,-x+1/4,-y+1/4',
    'x,-z,-y',
    'z+1/4,x+3/4,-y+3/4',
    '-x+1/2,z,-y+1/2',
    '-z+1/4,x+1/4,y+1/4',
    '-x,-z,y',
    'z+1/4,-x+3/4,y+3/4',
    'x+1/2,z,y+1/2',
    '-y+1/4,-z+1/4,-x+1/4',
    '-y+3/4,z+1/4,x+3/4',
    '-z,-y+1/2,x+1/2',
    'y+3/4,-z+3/4,x+1/4',
    'z,y,x',
    'y+1/4,z+1/4,-x+1/4',
    '-z,y+1/2,-x+1/2',
    'z+1/2,-y+1/2,-x',
    'x,y+1/2,z+1/2',
    '-y+1/4,x+3/4,z+3/4',
    '-x,-y,z',
    'y+3/4,-x+3/4,z+1/4',
    'x,-y+1/2,-z+1/2',
    'y+1/4,x+3/4,-z+3/4',
    '-x,y,-z',
    '-y+3/4,-x+3/4,-z+1/4',
    'z,x+1/2,y+1/2',
    '-x+1/4,z+3/4,y+3/4',
    '-z,-x,y',
    'x+3/4,-z+3/4,y+1/4',
    'z,-x+1/2,-y+1/2',
    'x+1/4,z+3/4,-y+3/4',
    '-z,x,-y',
    '-x+3/4,-z+3/4,-y+1/4',
    'y,z+1/2,x+1/2',
    'y+1/2,-z+1/2,-x',
    'z+1/4,y+1/4,-x+1/4',
    '-y+1/2,z,-x+1/2',
    '-z+1/4,-y+3/4,-x+3/4',
    '-y,-z+1/2,x+1/2',
    'z+1/4,-y+1/4,x+1/4',
    '-z+3/4,y+1/4,x+3/4',
    '-x+1/4,-y+3/4,-z+3/4',
    'y,-x+1/2,-z+1/2',
    'x+1/4,y+1/4,-z+1/4',
    '-y+1/2,x+1/2,-z',
    '-x+1/4,y+3/4,z+3/4',
    '-y,-x+1/2,z+1/2',
    'x+1/4,-y+1/4,z+1/4',
    'y+1/2,x+1/2,z',
    '-z+1/4,-x+3/4,-y+3/4',
    'x,-z+1/2,-y+1/2',
    'z+1/4,x+1/4,-y+1/4',
    '-x+1/2,z+1/2,-y',
    '-z+1/4,x+3/4,y+3/4',
    '-x,-z+1/2,y+1/2',
    'z+1/4,-x+1/4,y+1/4',
    'x+1/2,z+1/2,y',
    '-y+1/4,-z+3/4,-x+3/4',
    '-y+3/4,z+3/4,x+1/4',
    '-z,-y,x',
    'y+3/4,-z+1/4,x+3/4',
    'z,y+1/2,x+1/2',
    'y+1/4,z+3/4,-x+3/4',
    '-z,y,-x',
    'z+1/2,-y,-x+1/2',
    'x+1/2,y,z+1/2',
    '-y+3/4,x+1/4,z+3/4',
    '-x+1/2,-y+1/2,z',
    'y+1/4,-x+1/4,z+1/4',
    'x+1/2,-y,-z+1/2',
    'y+3/4,x+1/4,-z+3/4',
    '-x+1/2,y+1/2,-z',
    '-y+1/4,-x+1/4,-z+1/4',
    'z+1/2,x,y+1/2',
    '-x+3/4,z+1/4,y+3/4',
    '-z+1/2,-x+1/2,y',
    'x+1/4,-z+1/4,y+1/4',
    'z+1/2,-x,-y+1/2',
    'x+3/4,z+1/4,-y+3/4',
    '-z+1/2,x+1/2,-y',
    '-x+1/4,-z+1/4,-y+1/4',
    'y+1/2,z,x+1/2',
    'y,-z,-x',
    'z+3/4,y+3/4,-x+1/4',
    '-y,z+1/2,-x+1/2',
    '-z+3/4,-y+1/4,-x+3/4',
    '-y+1/2,-z,x+1/2',
    'z+3/4,-y+3/4,x+1/4',
    '-z+1/4,y+3/4,x+3/4',
    '-x+3/4,-y+1/4,-z+3/4',
    'y+1/2,-x,-z+1/2',
    'x+3/4,y+3/4,-z+1/4',
    '-y,x,-z',
    '-x+3/4,y+1/4,z+3/4',
    '-y+1/2,-x,z+1/2',
    'x+3/4,-y+3/4,z+1/4',
    'y,x,z',
    '-z+3/4,-x+1/4,-y+3/4',
    'x+1/2,-z,-y+1/2',
    'z+3/4,x+3/4,-y+1/4',
    '-x,z,-y',
    '-z+3/4,x+1/4,y+3/4',
    '-x+1/2,-z,y+1/2',
    'z+3/4,-x+3/4,y+1/4',
    'x,z,y',
    '-y+3/4,-z+1/4,-x+3/4',
    '-y+1/4,z+1/4,x+1/4',
    '-z+1/2,-y+1/2,x',
    'y+1/4,-z+3/4,x+3/4',
    'z+1/2,y,x+1/2',
    'y+3/4,z+1/4,-x+3/4',
    '-z+1/2,y+1/2,-x',
    'z,-y+1/2,-x+1/2',
    'x+1/2,y+1/2,z',
    '-y+3/4,x+3/4,z+1/4',
    '-x+1/2,-y,z+1/2',
    'y+1/4,-x+3/4,z+3/4',
    'x+1/2,-y+1/2,-z',
    'y+3/4,x+3/4,-z+1/4',
    '-x+1/2,y,-z+1/2',
    '-y+1/4,-x+3/4,-z+3/4',
    'z+1/2,x+1/2,y',
    '-x+3/4,z+3/4,y+1/4',
    '-z+1/2,-x,y+1/2',
    'x+1/4,-z+3/4,y+3/4',
    'z+1/2,-x+1/2,-y',
    'x+3/4,z+3/4,-y+1/4',
    '-z+1/2,x,-y+1/2',
    '-x+1/4,-z+3/4,-y+3/4',
    'y+1/2,z+1/2,x',
    'y,-z+1/2,-x+1/2',
    'z+3/4,y+1/4,-x+3/4',
    '-y,z,-x',
    '-z+3/4,-y+3/4,-x+1/4',
    '-y+1/2,-z+1/2,x',
    'z+3/4,-y+1/4,x+3/4',
    '-z+1/4,y+1/4,x+1/4',
    '-x+3/4,-y+3/4,-z+1/4',
    'y+1/2,-x+1/2,-z',
    'x+3/4,y+1/4,-z+3/4',
    '-y,x+1/2,-z+1/2',
    '-x+3/4,y+3/4,z+1/4',
    '-y+1/2,-x+1/2,z',
    'x+3/4,-y+1/4,z+3/4',
    'y,x+1/2,z+1/2',
    '-z+3/4,-x+3/4,-y+1/4',
    'x+1/2,-z+1/2,-y',
    'z+3/4,x+1/4,-y+3/4',
    '-x,z+1/2,-y+1/2',
    '-z+3/4,x+3/4,y+1/4',
    '-x+1/2,-z+1/2,y',
    'z+3/4,-x+1/4,y+3/4',
    'x,z+1/2,y+1/2',
    '-y+3/4,-z+3/4,-x+1/4',
    '-y+1/4,z+3/4,x+3/4',
    '-z+1/2,-y,x+1/2',
    'y+1/4,-z+1/4,x+1/4',
    'z+1/2,y+1/2,x',
    'y+3/4,z+3/4,-x+1/4',
    '-z+1/2,y,-x+1/2',
    'z,-y,-x',
    ) : ['F D -3 M :1', 'F D -3 M:1'] ,
    (
    'x,y,z',
    '-y+1/4,x+1/4,z+1/4',
    '-x,-y+1/2,z+1/2',
    'y+3/4,-x+1/4,z+3/4',
    'x,-y,-z',
    'y+1/4,x+1/4,-z+1/4',
    '-x,y+1/2,-z+1/2',
    '-y+3/4,-x+1/4,-z+3/4',
    'z,x,y',
    '-x+1/4,z+1/4,y+1/4',
    '-z,-x+1/2,y+1/2',
    'x+3/4,-z+1/4,y+3/4',
    'z,-x,-y',
    'x+1/4,z+1/4,-y+1/4',
    '-z,x+1/2,-y+1/2',
    '-x+3/4,-z+1/4,-y+3/4',
    'y,z,x',
    'y+1/2,-z,-x+1/2',
    'z+1/4,y+3/4,-x+3/4',
    '-y+1/2,z+1/2,-x',
    '-z+1/4,-y+1/4,-x+1/4',
    '-y,-z,x',
    'z+1/4,-y+3/4,x+3/4',
    '-z+3/4,y+3/4,x+1/4',
    '-x+3/4,-y+1/4,-z+1/4',
    'y+1/2,-x,-z',
    'x+3/4,y+3/4,-z+3/4',
    '-y,x,-z+1/2',
    '-x+3/4,y+1/4,z+1/4',
    '-y+1/2,-x,z',
    'x+3/4,-y+3/4,z+3/4',
    'y,x,z+1/2',
    '-z+3/4,-x+1/4,-y+1/4',
    'x+1/2,-z,-y',
    'z+3/4,x+3/4,-y+3/4',
    '-x,z,-y+1/2',
    '-z+3/4,x+1/4,y+1/4',
    '-x+1/2,-z,y',
    'z+3/4,-x+3/4,y+3/4',
    'x,z,y+1/2',
    '-y+3/4,-z+1/4,-x+1/4',
    '-y+1/4,z+1/4,x+3/4',
    '-z+1/2,-y+1/2,x+1/2',
    'y+1/4,-z+3/4,x+1/4',
    'z+1/2,y,x',
    'y+3/4,z+1/4,-x+1/4',
    '-z+1/2,y+1/2,-x+1/2',
    'z,-y+1/2,-x',
    'x,y+1/2,z+1/2',
    '-y+1/4,x+3/4,z+3/4',
    '-x,-y,z',
    'y+3/4,-x+3/4,z+1/4',
    'x,-y+1/2,-z+1/2',
    'y+1/4,x+3/4,-z+3/4',
    '-x,y,-z',
    '-y+3/4,-x+3/4,-z+1/4',
    'z,x+1/2,y+1/2',
    '-x+1/4,z+3/4,y+3/4',
    '-z,-x,y',
    'x+3/4,-z+3/4,y+1/4',
    'z,-x+1/2,-y+1/2',
    'x+1/4,z+3/4,-y+3/4',
    '-z,x,-y',
    '-x+3/4,-z+3/4,-y+1/4',
    'y,z+1/2,x+1/2',
    'y+1/2,-z+1/2,-x',
    'z+1/4,y+1/4,-x+1/4',
    '-y+1/2,z,-x+1/2',
    '-z+1/4,-y+3/4,-x+3/4',
    '-y,-z+1/2,x+1/2',
    'z+1/4,-y+1/4,x+1/4',
    '-z+3/4,y+1/4,x+3/4',
    '-x+3/4,-y+3/4,-z+3/4',
    'y+1/2,-x+1/2,-z+1/2',
    'x+3/4,y+1/4,-z+1/4',
    '-y,x+1/2,-z',
    '-x+3/4,y+3/4,z+3/4',
    '-y+1/2,-x+1/2,z+1/2',
    'x+3/4,-y+1/4,z+1/4',
    'y,x+1/2,z',
    '-z+3/4,-x+3/4,-y+3/4',
    'x+1/2,-z+1/2,-y+1/2',
    'z+3/4,x+1/4,-y+1/4',
    '-x,z+1/2,-y',
    '-z+3/4,x+3/4,y+3/4',
    '-x+1/2,-z+1/2,y+1/2',
    'z+3/4,-x+1/4,y+1/4',
    'x,z+1/2,y',
    '-y+3/4,-z+3/4,-x+3/4',
    '-y+1/4,z+3/4,x+1/4',
    '-z+1/2,-y,x',
    'y+1/4,-z+1/4,x+3/4',
    'z+1/2,y+1/2,x+1/2',
    'y+3/4,z+3/4,-x+3/4',
    '-z+1/2,y,-x',
    'z,-y,-x+1/2',
    'x+1/2,y,z+1/2',
    '-y+3/4,x+1/4,z+3/4',
    '-x+1/2,-y+1/2,z',
    'y+1/4,-x+1/4,z+1/4',
    'x+1/2,-y,-z+1/2',
    'y+3/4,x+1/4,-z+3/4',
    '-x+1/2,y+1/2,-z',
    '-y+1/4,-x+1/4,-z+1/4',
    'z+1/2,x,y+1/2',
    '-x+3/4,z+1/4,y+3/4',
    '-z+1/2,-x+1/2,y',
    'x+1/4,-z+1/4,y+1/4',
    'z+1/2,-x,-y+1/2',
    'x+3/4,z+1/4,-y+3/4',
    '-z+1/2,x+1/2,-y',
    '-x+1/4,-z+1/4,-y+1/4',
    'y+1/2,z,x+1/2',
    'y,-z,-x',
    'z+3/4,y+3/4,-x+1/4',
    '-y,z+1/2,-x+1/2',
    '-z+3/4,-y+1/4,-x+3/4',
    '-y+1/2,-z,x+1/2',
    'z+3/4,-y+3/4,x+1/4',
    '-z+1/4,y+3/4,x+3/4',
    '-x+1/4,-y+1/4,-z+3/4',
    'y,-x,-z+1/2',
    'x+1/4,y+3/4,-z+1/4',
    '-y+1/2,x,-z',
    '-x+1/4,y+1/4,z+3/4',
    '-y,-x,z+1/2',
    'x+1/4,-y+3/4,z+1/4',
    'y+1/2,x,z',
    '-z+1/4,-x+1/4,-y+3/4',
    'x,-z,-y+1/2',
    'z+1/4,x+3/4,-y+1/4',
    '-x+1/2,z,-y',
    '-z+1/4,x+1/4,y+3/4',
    '-x,-z,y+1/2',
    'z+1/4,-x+3/4,y+1/4',
    'x+1/2,z,y',
    '-y+1/4,-z+1/4,-x+3/4',
    '-y+3/4,z+1/4,x+1/4',
    '-z,-y+1/2,x',
    'y+3/4,-z+3/4,x+3/4',
    'z,y,x+1/2',
    'y+1/4,z+1/4,-x+3/4',
    '-z,y+1/2,-x',
    'z+1/2,-y+1/2,-x+1/2',
    'x+1/2,y+1/2,z',
    '-y+3/4,x+3/4,z+1/4',
    '-x+1/2,-y,z+1/2',
    'y+1/4,-x+3/4,z+3/4',
    'x+1/2,-y+1/2,-z',
    'y+3/4,x+3/4,-z+1/4',
    '-x+1/2,y,-z+1/2',
    '-y+1/4,-x+3/4,-z+3/4',
    'z+1/2,x+1/2,y',
    '-x+3/4,z+3/4,y+1/4',
    '-z+1/2,-x,y+1/2',
    'x+1/4,-z+3/4,y+3/4',
    'z+1/2,-x+1/2,-y',
    'x+3/4,z+3/4,-y+1/4',
    '-z+1/2,x,-y+1/2',
    '-x+1/4,-z+3/4,-y+3/4',
    'y+1/2,z+1/2,x',
    'y,-z+1/2,-x+1/2',
    'z+3/4,y+1/4,-x+3/4',
    '-y,z,-x',
    '-z+3/4,-y+3/4,-x+1/4',
    '-y+1/2,-z+1/2,x',
    'z+3/4,-y+1/4,x+3/4',
    '-z+1/4,y+1/4,x+1/4',
    '-x+1/4,-y+3/4,-z+1/4',
    'y,-x+1/2,-z',
    'x+1/4,y+1/4,-z+3/4',
    '-y+1/2,x+1/2,-z+1/2',
    '-x+1/4,y+3/4,z+1/4',
    '-y,-x+1/2,z',
    'x+1/4,-y+1/4,z+3/4',
    'y+1/2,x+1/2,z+1/2',
    '-z+1/4,-x+3/4,-y+1/4',
    'x,-z+1/2,-y',
    'z+1/4,x+1/4,-y+3/4',
    '-x+1/2,z+1/2,-y+1/2',
    '-z+1/4,x+3/4,y+1/4',
    '-x,-z+1/2,y',
    'z+1/4,-x+1/4,y+3/4',
    'x+1/2,z+1/2,y+1/2',
    '-y+1/4,-z+3/4,-x+1/4',
    '-y+3/4,z+3/4,x+3/4',
    '-z,-y,x+1/2',
    'y+3/4,-z+1/4,x+1/4',
    'z,y+1/2,x',
    'y+1/4,z+3/4,-x+1/4',
    '-z,y,-x+1/2',
    'z+1/2,-y,-x',
    ) : ['F D -3 C :1', 'F D -3 C:1'] ,
    (
    'x,y,z',
    '-y+1/4,x+1/4,z+1/4',
    '-x,-y+1/2,z+1/2',
    'y+3/4,-x+1/4,z+3/4',
    'x,-y,-z',
    'y+1/4,x+1/4,-z+1/4',
    '-x,y+1/2,-z+1/2',
    '-y+3/4,-x+1/4,-z+3/4',
    'z,x,y',
    '-x+1/4,z+1/4,y+1/4',
    '-z,-x+1/2,y+1/2',
    'x+3/4,-z+1/4,y+3/4',
    'z,-x,-y',
    'x+1/4,z+1/4,-y+1/4',
    '-z,x+1/2,-y+1/2',
    '-x+3/4,-z+1/4,-y+3/4',
    'y,z,x',
    'y+1/2,-z,-x+1/2',
    'z+1/4,y+3/4,-x+3/4',
    '-y+1/2,z+1/2,-x',
    '-z+1/4,-y+1/4,-x+1/4',
    '-y,-z,x',
    'z+1/4,-y+3/4,x+3/4',
    '-z+3/4,y+3/4,x+1/4',
    'x,y+1/2,z+1/2',
    '-y+1/4,x+3/4,z+3/4',
    '-x,-y,z',
    'y+3/4,-x+3/4,z+1/4',
    'x,-y+1/2,-z+1/2',
    'y+1/4,x+3/4,-z+3/4',
    '-x,y,-z',
    '-y+3/4,-x+3/4,-z+1/4',
    'z,x+1/2,y+1/2',
    '-x+1/4,z+3/4,y+3/4',
    '-z,-x,y',
    'x+3/4,-z+3/4,y+1/4',
    'z,-x+1/2,-y+1/2',
    'x+1/4,z+3/4,-y+3/4',
    '-z,x,-y',
    '-x+3/4,-z+3/4,-y+1/4',
    'y,z+1/2,x+1/2',
    'y+1/2,-z+1/2,-x',
    'z+1/4,y+1/4,-x+1/4',
    '-y+1/2,z,-x+1/2',
    '-z+1/4,-y+3/4,-x+3/4',
    '-y,-z+1/2,x+1/2',
    'z+1/4,-y+1/4,x+1/4',
    '-z+3/4,y+1/4,x+3/4',
    'x+1/2,y,z+1/2',
    '-y+3/4,x+1/4,z+3/4',
    '-x+1/2,-y+1/2,z',
    'y+1/4,-x+1/4,z+1/4',
    'x+1/2,-y,-z+1/2',
    'y+3/4,x+1/4,-z+3/4',
    '-x+1/2,y+1/2,-z',
    '-y+1/4,-x+1/4,-z+1/4',
    'z+1/2,x,y+1/2',
    '-x+3/4,z+1/4,y+3/4',
    '-z+1/2,-x+1/2,y',
    'x+1/4,-z+1/4,y+1/4',
    'z+1/2,-x,-y+1/2',
    'x+3/4,z+1/4,-y+3/4',
    '-z+1/2,x+1/2,-y',
    '-x+1/4,-z+1/4,-y+1/4',
    'y+1/2,z,x+1/2',
    'y,-z,-x',
    'z+3/4,y+3/4,-x+1/4',
    '-y,z+1/2,-x+1/2',
    '-z+3/4,-y+1/4,-x+3/4',
    '-y+1/2,-z,x+1/2',
    'z+3/4,-y+3/4,x+1/4',
    '-z+1/4,y+3/4,x+3/4',
    'x+1/2,y+1/2,z',
    '-y+3/4,x+3/4,z+1/4',
    '-x+1/2,-y,z+1/2',
    'y+1/4,-x+3/4,z+3/4',
    'x+1/2,-y+1/2,-z',
    'y+3/4,x+3/4,-z+1/4',
    '-x+1/2,y,-z+1/2',
    '-y+1/4,-x+3/4,-z+3/4',
    'z+1/2,x+1/2,y',
    '-x+3/4,z+3/4,y+1/4',
    '-z+1/2,-x,y+1/2',
    'x+1/4,-z+3/4,y+3/4',
    'z+1/2,-x+1/2,-y',
    'x+3/4,z+3/4,-y+1/4',
    '-z+1/2,x,-y+1/2',
    '-x+1/4,-z+3/4,-y+3/4',
    'y+1/2,z+1/2,x',
    'y,-z+1/2,-x+1/2',
    'z+3/4,y+1/4,-x+3/4',
    '-y,z,-x',
    '-z+3/4,-y+3/4,-x+1/4',
    '-y+1/2,-z+1/2,x',
    'z+3/4,-y+1/4,x+3/4',
    '-z+1/4,y+1/4,x+1/4',
    ) : ['F 41 3 2'] ,
    (
    'x,y,z',
    '-y+1/4,x+3/4,z+1/4',
    '-x+1/2,-y,z+1/2',
    'y+1/4,-x+1/4,z+3/4',
    'x+1/2,-y+1/2,-z',
    'y+3/4,x+1/4,-z+1/4',
    '-x,y+1/2,-z+1/2',
    '-y+3/4,-x+3/4,-z+3/4',
    'z,x,y',
    '-x+1/4,z+3/4,y+1/4',
    '-z+1/2,-x,y+1/2',
    'x+1/4,-z+1/4,y+3/4',
    'z+1/2,-x+1/2,-y',
    'x+3/4,z+1/4,-y+1/4',
    '-z,x+1/2,-y+1/2',
    '-x+3/4,-z+3/4,-y+3/4',
    'y,z,x',
    'y+1/2,-z+1/2,-x',
    'z+3/4,y+1/4,-x+1/4',
    '-y,z+1/2,-x+1/2',
    '-z+3/4,-y+3/4,-x+3/4',
    '-y+1/2,-z,x+1/2',
    'z+1/4,-y+1/4,x+3/4',
    '-z+1/4,y+3/4,x+1/4',
    ) : ['P 41 3 2'] ,
    (
    'x,y,z',
    '-y+1/4,x+3/4,z+1/4',
    '-x+1/2,-y,z+1/2',
    'y+1/4,-x+1/4,z+3/4',
    'x,-y,-z',
    'y+1/4,x+3/4,-z+1/4',
    '-x+1/2,y,-z+1/2',
    '-y+1/4,-x+1/4,-z+3/4',
    '-x,-y,-z',
    'y+3/4,-x+1/4,-z+3/4',
    'x+1/2,y,-z+1/2',
    '-y+3/4,x+3/4,-z+1/4',
    '-x,y,z',
    '-y+3/4,-x+1/4,z+3/4',
    'x+1/2,-y,z+1/2',
    'y+3/4,x+3/4,z+1/4',
    'x+1/2,y+1/2,z+1/2',
    '-y+3/4,x+1/4,z+3/4',
    '-x,-y+1/2,z',
    'y+3/4,-x+3/4,z+1/4',
    'x+1/2,-y+1/2,-z+1/2',
    'y+3/4,x+1/4,-z+3/4',
    '-x,y+1/2,-z',
    '-y+3/4,-x+3/4,-z+1/4',
    '-x+1/2,-y+1/2,-z+1/2',
    'y+1/4,-x+3/4,-z+1/4',
    'x,y+1/2,-z',
    '-y+1/4,x+1/4,-z+3/4',
    '-x+1/2,y+1/2,z+1/2',
    '-y+1/4,-x+3/4,z+1/4',
    'x,-y+1/2,z',
    'y+1/4,x+1/4,z+3/4',
    ) : ['I 41/A M D :2', 'I 41/A M D:2'] ,
    (
    'x,y,z',
    '-y+1/4,x+3/4,z+1/4',
    '-x+1/2,-y,z+1/2',
    'y+1/4,-x+1/4,z+3/4',
    'x,-y,-z+1/2',
    'y+1/4,x+3/4,-z+3/4',
    '-x+1/2,y,-z',
    '-y+1/4,-x+1/4,-z+1/4',
    '-x,-y,-z',
    'y+3/4,-x+1/4,-z+3/4',
    'x+1/2,y,-z+1/2',
    '-y+3/4,x+3/4,-z+1/4',
    '-x,y,z+1/2',
    '-y+3/4,-x+1/4,z+1/4',
    'x+1/2,-y,z',
    'y+3/4,x+3/4,z+3/4',
    'x+1/2,y+1/2,z+1/2',
    '-y+3/4,x+1/4,z+3/4',
    '-x,-y+1/2,z',
    'y+3/4,-x+3/4,z+1/4',
    'x+1/2,-y+1/2,-z',
    'y+3/4,x+1/4,-z+1/4',
    '-x,y+1/2,-z+1/2',
    '-y+3/4,-x+3/4,-z+3/4',
    '-x+1/2,-y+1/2,-z+1/2',
    'y+1/4,-x+3/4,-z+1/4',
    'x,y+1/2,-z',
    '-y+1/4,x+1/4,-z+3/4',
    '-x+1/2,y+1/2,z',
    '-y+1/4,-x+3/4,z+3/4',
    'x,-y+1/2,z+1/2',
    'y+1/4,x+1/4,z+1/4',
    ) : ['I 41/A C D :2', 'I 41/A C D:2'] ,
    (
    'x,y,z',
    '-y+1/4,x+3/4,z+1/4',
    '-x+1/2,-y,z+1/2',
    'y+1/4,-x+1/4,z+3/4',
    'x,-y,-z+1/2',
    'y+1/4,x+3/4,-z+3/4',
    '-x+1/2,y,-z',
    '-y+1/4,-x+1/4,-z+1/4',
    'z,x,y',
    '-x+1/4,z+3/4,y+1/4',
    '-z+1/2,-x,y+1/2',
    'x+1/4,-z+1/4,y+3/4',
    'z,-x,-y+1/2',
    'x+1/4,z+3/4,-y+3/4',
    '-z+1/2,x,-y',
    '-x+1/4,-z+1/4,-y+1/4',
    'y,z,x',
    'y+1/2,-z+1/2,-x',
    'z+3/4,y+1/4,-x+1/4',
    '-y,z+1/2,-x+1/2',
    '-z+1/4,-y+1/4,-x+1/4',
    '-y+1/2,-z,x+1/2',
    'z+3/4,-y+3/4,x+1/4',
    '-z+3/4,y+1/4,x+3/4',
    '-x,-y,-z',
    'y+3/4,-x+1/4,-z+3/4',
    'x+1/2,y,-z+1/2',
    '-y+3/4,x+3/4,-z+1/4',
    '-x,y,z+1/2',
    '-y+3/4,-x+1/4,z+1/4',
    'x+1/2,-y,z',
    'y+3/4,x+3/4,z+3/4',
    '-z,-x,-y',
    'x+3/4,-z+1/4,-y+3/4',
    'z+1/2,x,-y+1/2',
    '-x+3/4,z+3/4,-y+1/4',
    '-z,x,y+1/2',
    '-x+3/4,-z+1/4,y+1/4',
    'z+1/2,-x,y',
    'x+3/4,z+3/4,y+3/4',
    '-y,-z,-x',
    '-y+1/2,z+1/2,x',
    '-z+1/4,-y+3/4,x+3/4',
    'y,-z+1/2,x+1/2',
    'z+3/4,y+3/4,x+3/4',
    'y+1/2,z,-x+1/2',
    '-z+1/4,y+1/4,-x+3/4',
    'z+1/4,-y+3/4,-x+1/4',
    'x+1/2,y+1/2,z+1/2',
    '-y+3/4,x+1/4,z+3/4',
    '-x,-y+1/2,z',
    'y+3/4,-x+3/4,z+1/4',
    'x+1/2,-y+1/2,-z',
    'y+3/4,x+1/4,-z+1/4',
    '-x,y+1/2,-z+1/2',
    '-y+3/4,-x+3/4,-z+3/4',
    'z+1/2,x+1/2,y+1/2',
    '-x+3/4,z+1/4,y+3/4',
    '-z,-x+1/2,y',
    'x+3/4,-z+3/4,y+1/4',
    'z+1/2,-x+1/2,-y',
    'x+3/4,z+1/4,-y+1/4',
    '-z,x+1/2,-y+1/2',
    '-x+3/4,-z+3/4,-y+3/4',
    'y+1/2,z+1/2,x+1/2',
    'y,-z,-x+1/2',
    'z+1/4,y+3/4,-x+3/4',
    '-y+1/2,z,-x',
    '-z+3/4,-y+3/4,-x+3/4',
    '-y,-z+1/2,x',
    'z+1/4,-y+1/4,x+3/4',
    '-z+1/4,y+3/4,x+1/4',
    '-x+1/2,-y+1/2,-z+1/2',
    'y+1/4,-x+3/4,-z+1/4',
    'x,y+1/2,-z',
    '-y+1/4,x+1/4,-z+3/4',
    '-x+1/2,y+1/2,z',
    '-y+1/4,-x+3/4,z+3/4',
    'x,-y+1/2,z+1/2',
    'y+1/4,x+1/4,z+1/4',
    '-z+1/2,-x+1/2,-y+1/2',
    'x+1/4,-z+3/4,-y+1/4',
    'z,x+1/2,-y',
    '-x+1/4,z+1/4,-y+3/4',
    '-z+1/2,x+1/2,y',
    '-x+1/4,-z+3/4,y+3/4',
    'z,-x+1/2,y+1/2',
    'x+1/4,z+1/4,y+1/4',
    '-y+1/2,-z+1/2,-x+1/2',
    '-y,z,x+1/2',
    '-z+3/4,-y+1/4,x+1/4',
    'y+1/2,-z,x',
    'z+1/4,y+1/4,x+1/4',
    'y,z+1/2,-x',
    '-z+3/4,y+3/4,-x+1/4',
    'z+3/4,-y+1/4,-x+3/4',
    ) : ['I A -3 D'] ,
    (
    'x,y,z',
    '-y+1/4,x+3/4,z+1/4',
    '-x+1/2,-y,z+1/2',
    'y+1/4,-x+1/4,z+3/4',
    'x,-y,-z+1/2',
    'y+1/4,x+3/4,-z+3/4',
    '-x+1/2,y,-z',
    '-y+1/4,-x+1/4,-z+1/4',
    'z,x,y',
    '-x+1/4,z+3/4,y+1/4',
    '-z+1/2,-x,y+1/2',
    'x+1/4,-z+1/4,y+3/4',
    'z,-x,-y+1/2',
    'x+1/4,z+3/4,-y+3/4',
    '-z+1/2,x,-y',
    '-x+1/4,-z+1/4,-y+1/4',
    'y,z,x',
    'y+1/2,-z+1/2,-x',
    'z+3/4,y+1/4,-x+1/4',
    '-y,z+1/2,-x+1/2',
    '-z+1/4,-y+1/4,-x+1/4',
    '-y+1/2,-z,x+1/2',
    'z+3/4,-y+3/4,x+1/4',
    '-z+3/4,y+1/4,x+3/4',
    'x+1/2,y+1/2,z+1/2',
    '-y+3/4,x+1/4,z+3/4',
    '-x,-y+1/2,z',
    'y+3/4,-x+3/4,z+1/4',
    'x+1/2,-y+1/2,-z',
    'y+3/4,x+1/4,-z+1/4',
    '-x,y+1/2,-z+1/2',
    '-y+3/4,-x+3/4,-z+3/4',
    'z+1/2,x+1/2,y+1/2',
    '-x+3/4,z+1/4,y+3/4',
    '-z,-x+1/2,y',
    'x+3/4,-z+3/4,y+1/4',
    'z+1/2,-x+1/2,-y',
    'x+3/4,z+1/4,-y+1/4',
    '-z,x+1/2,-y+1/2',
    '-x+3/4,-z+3/4,-y+3/4',
    'y+1/2,z+1/2,x+1/2',
    'y,-z,-x+1/2',
    'z+1/4,y+3/4,-x+3/4',
    '-y+1/2,z,-x',
    '-z+3/4,-y+3/4,-x+3/4',
    '-y,-z+1/2,x',
    'z+1/4,-y+1/4,x+3/4',
    '-z+1/4,y+3/4,x+1/4',
    ) : ['I 41 3 2'] ,
    (
    'x,y,z',
    '-y+3/4,x+1/4,z+1/4',
    '-x+1/2,-y,z+1/2',
    'y+3/4,-x+3/4,z+3/4',
    '-x,-y,-z',
    'y+1/4,-x+3/4,-z+3/4',
    'x+1/2,y,-z+1/2',
    '-y+1/4,x+1/4,-z+1/4',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/4,x+3/4,z+3/4',
    '-x,-y+1/2,z',
    'y+1/4,-x+1/4,z+1/4',
    '-x+1/2,-y+1/2,-z+1/2',
    'y+3/4,-x+1/4,-z+1/4',
    'x,y+1/2,-z',
    '-y+3/4,x+3/4,-z+3/4',
    ) : ['I 41/A :2', 'I 41/A:2'] ,
    (
    'x,y,z',
    '-y+3/4,x+1/4,z+3/4',
    '-x+1/2,-y,z+1/2',
    'y+3/4,-x+3/4,z+1/4',
    'x+1/2,-y+1/2,-z',
    'y+1/4,x+3/4,-z+3/4',
    '-x,y+1/2,-z+1/2',
    '-y+1/4,-x+1/4,-z+1/4',
    'z,x,y',
    '-x+3/4,z+1/4,y+3/4',
    '-z+1/2,-x,y+1/2',
    'x+3/4,-z+3/4,y+1/4',
    'z+1/2,-x+1/2,-y',
    'x+1/4,z+3/4,-y+3/4',
    '-z,x+1/2,-y+1/2',
    '-x+1/4,-z+1/4,-y+1/4',
    'y,z,x',
    'y+1/2,-z+1/2,-x',
    'z+1/4,y+3/4,-x+3/4',
    '-y,z+1/2,-x+1/2',
    '-z+1/4,-y+1/4,-x+1/4',
    '-y+1/2,-z,x+1/2',
    'z+3/4,-y+3/4,x+1/4',
    '-z+3/4,y+1/4,x+3/4',
    ) : ['P 43 3 2'] ,
    (
    'x,y,z',
    '-y,x+1/2,z+1/2',
    '-x+1/2,-y+1/2,z',
    'y+1/2,-x,z+1/2',
    '-x,-y,-z',
    'y,-x+1/2,-z+1/2',
    'x+1/2,y+1/2,-z',
    '-y+1/2,x,-z+1/2',
    ) : ['P 42/N :2', 'P 42/N:2'] ,
    (
    'x,y,z',
    '-y,x+1/2,z+1/2',
    '-x+1/2,-y+1/2,z',
    'y+1/2,-x,z+1/2',
    'x,-y+1/2,-z+1/2',
    'y+1/2,x+1/2,-z',
    '-x+1/2,y,-z+1/2',
    '-y,-x,-z',
    'z,x,y',
    '-x,z+1/2,y+1/2',
    '-z+1/2,-x+1/2,y',
    'x+1/2,-z,y+1/2',
    'z,-x+1/2,-y+1/2',
    'x+1/2,z+1/2,-y',
    '-z+1/2,x,-y+1/2',
    '-x,-z,-y',
    'y,z,x',
    'y,-z+1/2,-x+1/2',
    'z+1/2,y+1/2,-x',
    '-y+1/2,z,-x+1/2',
    '-z,-y,-x',
    '-y+1/2,-z+1/2,x',
    'z+1/2,-y,x+1/2',
    '-z,y+1/2,x+1/2',
    '-x,-y,-z',
    'y,-x+1/2,-z+1/2',
    'x+1/2,y+1/2,-z',
    '-y+1/2,x,-z+1/2',
    '-x,y+1/2,z+1/2',
    '-y+1/2,-x+1/2,z',
    'x+1/2,-y,z+1/2',
    'y,x,z',
    '-z,-x,-y',
    'x,-z+1/2,-y+1/2',
    'z+1/2,x+1/2,-y',
    '-x+1/2,z,-y+1/2',
    '-z,x+1/2,y+1/2',
    '-x+1/2,-z+1/2,y',
    'z+1/2,-x,y+1/2',
    'x,z,y',
    '-y,-z,-x',
    '-y,z+1/2,x+1/2',
    '-z+1/2,-y+1/2,x',
    'y+1/2,-z,x+1/2',
    'z,y,x',
    'y+1/2,z+1/2,-x',
    '-z+1/2,y,-x+1/2',
    'z,-y+1/2,-x+1/2',
    ) : ['P N -3 M :2', 'P N -3 M:2'] ,
    (
    'x,y,z',
    '-y,x+1/2,z+1/4',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x,z+3/4',
    '-x,-y+1/2,-z+1/4',
    'y,-x,-z',
    'x+1/2,y,-z+3/4',
    '-y+1/2,x+1/2,-z+1/2',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x,z+3/4',
    '-x,-y,z',
    'y,-x+1/2,z+1/4',
    '-x+1/2,-y,-z+3/4',
    'y+1/2,-x+1/2,-z+1/2',
    'x,y+1/2,-z+1/4',
    '-y,x,-z',
    ) : ['I 41/A :1', 'I 41/A:1'] ,
    (
    'x,y,z',
    '-y,x+1/2,z+1/4',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x,z+3/4',
    '-x,y,z',
    '-y,-x+1/2,z+1/4',
    'x+1/2,-y+1/2,z+1/2',
    'y+1/2,x,z+3/4',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x,z+3/4',
    '-x,-y,z',
    'y,-x+1/2,z+1/4',
    '-x+1/2,y+1/2,z+1/2',
    '-y+1/2,-x,z+3/4',
    'x,-y,z',
    'y,x+1/2,z+1/4',
    ) : ['I 41 M D'] ,
    (
    'x,y,z',
    '-y,x+1/2,z+1/4',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x,z+3/4',
    '-x,y,z+1/2',
    '-y,-x+1/2,z+3/4',
    'x+1/2,-y+1/2,z',
    'y+1/2,x,z+1/4',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x,z+3/4',
    '-x,-y,z',
    'y,-x+1/2,z+1/4',
    '-x+1/2,y+1/2,z',
    '-y+1/2,-x,z+1/4',
    'x,-y,z+1/2',
    'y,x+1/2,z+3/4',
    ) : ['I 41 C D'] ,
    (
    'x,y,z',
    '-y,x+1/2,z+1/4',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x,z+3/4',
    'x+1/2,-y,-z+1/4',
    'y,x,-z+1/2',
    '-x,y+1/2,-z+3/4',
    '-y+1/2,-x+1/2,-z',
    '-x,-y+1/2,-z+1/4',
    'y,-x,-z',
    'x+1/2,y,-z+3/4',
    '-y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,z',
    '-y,-x+1/2,z+3/4',
    'x,-y,z+1/2',
    'y+1/2,x,z+1/4',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x,z+3/4',
    '-x,-y,z',
    'y,-x+1/2,z+1/4',
    'x,-y+1/2,-z+3/4',
    'y+1/2,x+1/2,-z',
    '-x+1/2,y,-z+1/4',
    '-y,-x,-z+1/2',
    '-x+1/2,-y,-z+3/4',
    'y+1/2,-x+1/2,-z+1/2',
    'x,y+1/2,-z+1/4',
    '-y,x,-z',
    '-x,y,z+1/2',
    '-y+1/2,-x,z+1/4',
    'x+1/2,-y+1/2,z',
    'y,x+1/2,z+3/4',
    ) : ['I 41/A C D :1', 'I 41/A C D:1'] ,
    (
    'x,y,z',
    '-y,x+1/2,z+1/4',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x,z+3/4',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x,z+3/4',
    '-x,-y,z',
    'y,-x+1/2,z+1/4',
    ) : ['I 41'] ,
    (
    'x,y,z',
    '-y,x+1/2,z+1/4',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x,z+3/4',
    'x,-y+1/2,-z+1/4',
    'y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y,-z+3/4',
    '-y,-x,-z',
    '-x,-y+1/2,-z+1/4',
    'y,-x,-z',
    'x+1/2,y,-z+3/4',
    '-y+1/2,x+1/2,-z+1/2',
    '-x,y,z',
    '-y+1/2,-x,z+3/4',
    'x+1/2,-y+1/2,z+1/2',
    'y,x+1/2,z+1/4',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x,z+3/4',
    '-x,-y,z',
    'y,-x+1/2,z+1/4',
    'x+1/2,-y,-z+3/4',
    'y,x,-z',
    '-x,y+1/2,-z+1/4',
    '-y+1/2,-x+1/2,-z+1/2',
    '-x+1/2,-y,-z+3/4',
    'y+1/2,-x+1/2,-z+1/2',
    'x,y+1/2,-z+1/4',
    '-y,x,-z',
    '-x+1/2,y+1/2,z+1/2',
    '-y,-x+1/2,z+1/4',
    'x,-y,z',
    'y+1/2,x,z+3/4',
    ) : ['I 41/A M D :1', 'I 41/A M D:1'] ,
    (
    'x,y,z',
    '-y,x+1/2,z+1/4',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x,z+3/4',
    'x,-y+1/2,-z+1/4',
    'y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y,-z+3/4',
    '-y,-x,-z',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x,z+3/4',
    '-x,-y,z',
    'y,-x+1/2,z+1/4',
    'x+1/2,-y,-z+3/4',
    'y,x,-z',
    '-x,y+1/2,-z+1/4',
    '-y+1/2,-x+1/2,-z+1/2',
    ) : ['I 41 2 2'] ,
    (
    'x,y,z',
    '-y,x+1/4,z+1/4',
    '-x+3/4,-y+1/4,z+1/2',
    'y+3/4,-x,z+3/4',
    'x,-y+1/4,-z+1/4',
    'y+3/4,x+1/4,-z+1/2',
    '-x+3/4,y,-z+3/4',
    '-y,-x,-z',
    'z,x,y',
    '-x,z+1/4,y+1/4',
    '-z+3/4,-x+1/4,y+1/2',
    'x+3/4,-z,y+3/4',
    'z,-x+1/4,-y+1/4',
    'x+3/4,z+1/4,-y+1/2',
    '-z+3/4,x,-y+3/4',
    '-x,-z,-y',
    'y,z,x',
    'y+1/2,-z+3/4,-x+1/4',
    'z+1/4,y+3/4,-x+1/2',
    '-y+1/4,z+1/2,-x+3/4',
    '-z,-y+1/2,-x+1/2',
    '-y+1/4,-z+1/4,x',
    'z+1/4,-y,x+1/4',
    '-z+1/2,y+1/4,x+3/4',
    '-x,-y,-z',
    'y,-x+3/4,-z+3/4',
    'x+1/4,y+3/4,-z+1/2',
    '-y+1/4,x,-z+1/4',
    '-x,y+3/4,z+3/4',
    '-y+1/4,-x+3/4,z+1/2',
    'x+1/4,-y,z+1/4',
    'y,x,z',
    '-z,-x,-y',
    'x,-z+3/4,-y+3/4',
    'z+1/4,x+3/4,-y+1/2',
    '-x+1/4,z,-y+1/4',
    '-z,x+3/4,y+3/4',
    '-x+1/4,-z+3/4,y+1/2',
    'z+1/4,-x,y+1/4',
    'x,z,y',
    '-y,-z,-x',
    '-y+1/2,z+1/4,x+3/4',
    '-z+3/4,-y+1/4,x+1/2',
    'y+3/4,-z+1/2,x+1/4',
    'z,y+1/2,x+1/2',
    'y+3/4,z+3/4,-x',
    '-z+3/4,y,-x+3/4',
    'z+1/2,-y+3/4,-x+1/4',
    'x,y+1/2,z+1/2',
    '-y,x+3/4,z+3/4',
    '-x+3/4,-y+3/4,z',
    'y+3/4,-x+1/2,z+1/4',
    'x,-y+3/4,-z+3/4',
    'y+3/4,x+3/4,-z',
    '-x+3/4,y+1/2,-z+1/4',
    '-y,-x+1/2,-z+1/2',
    'z,x+1/2,y+1/2',
    '-x,z+3/4,y+3/4',
    '-z+3/4,-x+3/4,y',
    'x+3/4,-z+1/2,y+1/4',
    'z,-x+3/4,-y+3/4',
    'x+3/4,z+3/4,-y',
    '-z+3/4,x+1/2,-y+1/4',
    '-x,-z+1/2,-y+1/2',
    'y,z+1/2,x+1/2',
    'y+1/2,-z+1/4,-x+3/4',
    'z+1/4,y+1/4,-x',
    '-y+1/4,z,-x+1/4',
    '-z,-y,-x',
    '-y+1/4,-z+3/4,x+1/2',
    'z+1/4,-y+1/2,x+3/4',
    '-z+1/2,y+3/4,x+1/4',
    '-x,-y+1/2,-z+1/2',
    'y,-x+1/4,-z+1/4',
    'x+1/4,y+1/4,-z',
    '-y+1/4,x+1/2,-z+3/4',
    '-x,y+1/4,z+1/4',
    '-y+1/4,-x+1/4,z',
    'x+1/4,-y+1/2,z+3/4',
    'y,x+1/2,z+1/2',
    '-z,-x+1/2,-y+1/2',
    'x,-z+1/4,-y+1/4',
    'z+1/4,x+1/4,-y',
    '-x+1/4,z+1/2,-y+3/4',
    '-z,x+1/4,y+1/4',
    '-x+1/4,-z+1/4,y',
    'z+1/4,-x+1/2,y+3/4',
    'x,z+1/2,y+1/2',
    '-y,-z+1/2,-x+1/2',
    '-y+1/2,z+3/4,x+1/4',
    '-z+3/4,-y+3/4,x',
    'y+3/4,-z,x+3/4',
    'z,y,x',
    'y+3/4,z+1/4,-x+1/2',
    '-z+3/4,y+1/2,-x+1/4',
    'z+1/2,-y+1/4,-x+3/4',
    'x+1/2,y,z+1/2',
    '-y+1/2,x+1/4,z+3/4',
    '-x+1/4,-y+1/4,z',
    'y+1/4,-x,z+1/4',
    'x+1/2,-y+1/4,-z+3/4',
    'y+1/4,x+1/4,-z',
    '-x+1/4,y,-z+1/4',
    '-y+1/2,-x,-z+1/2',
    'z+1/2,x,y+1/2',
    '-x+1/2,z+1/4,y+3/4',
    '-z+1/4,-x+1/4,y',
    'x+1/4,-z,y+1/4',
    'z+1/2,-x+1/4,-y+3/4',
    'x+1/4,z+1/4,-y',
    '-z+1/4,x,-y+1/4',
    '-x+1/2,-z,-y+1/2',
    'y+1/2,z,x+1/2',
    'y,-z+3/4,-x+3/4',
    'z+3/4,y+3/4,-x',
    '-y+3/4,z+1/2,-x+1/4',
    '-z+1/2,-y+1/2,-x',
    '-y+3/4,-z+1/4,x+1/2',
    'z+3/4,-y,x+3/4',
    '-z,y+1/4,x+1/4',
    '-x+1/2,-y,-z+1/2',
    'y+1/2,-x+3/4,-z+1/4',
    'x+3/4,y+3/4,-z',
    '-y+3/4,x,-z+3/4',
    '-x+1/2,y+3/4,z+1/4',
    '-y+3/4,-x+3/4,z',
    'x+3/4,-y,z+3/4',
    'y+1/2,x,z+1/2',
    '-z+1/2,-x,-y+1/2',
    'x+1/2,-z+3/4,-y+1/4',
    'z+3/4,x+3/4,-y',
    '-x+3/4,z,-y+3/4',
    '-z+1/2,x+3/4,y+1/4',
    '-x+3/4,-z+3/4,y',
    'z+3/4,-x,y+3/4',
    'x+1/2,z,y+1/2',
    '-y+1/2,-z,-x+1/2',
    '-y,z+1/4,x+1/4',
    '-z+1/4,-y+1/4,x',
    'y+1/4,-z+1/2,x+3/4',
    'z+1/2,y+1/2,x',
    'y+1/4,z+3/4,-x+1/2',
    '-z+1/4,y,-x+1/4',
    'z,-y+3/4,-x+3/4',
    'x+1/2,y+1/2,z',
    '-y+1/2,x+3/4,z+1/4',
    '-x+1/4,-y+3/4,z+1/2',
    'y+1/4,-x+1/2,z+3/4',
    'x+1/2,-y+3/4,-z+1/4',
    'y+1/4,x+3/4,-z+1/2',
    '-x+1/4,y+1/2,-z+3/4',
    '-y+1/2,-x+1/2,-z',
    'z+1/2,x+1/2,y',
    '-x+1/2,z+3/4,y+1/4',
    '-z+1/4,-x+3/4,y+1/2',
    'x+1/4,-z+1/2,y+3/4',
    'z+1/2,-x+3/4,-y+1/4',
    'x+1/4,z+3/4,-y+1/2',
    '-z+1/4,x+1/2,-y+3/4',
    '-x+1/2,-z+1/2,-y',
    'y+1/2,z+1/2,x',
    'y,-z+1/4,-x+1/4',
    'z+3/4,y+1/4,-x+1/2',
    '-y+3/4,z,-x+3/4',
    '-z+1/2,-y,-x+1/2',
    '-y+3/4,-z+3/4,x',
    'z+3/4,-y+1/2,x+1/4',
    '-z,y+3/4,x+3/4',
    '-x+1/2,-y+1/2,-z',
    'y+1/2,-x+1/4,-z+3/4',
    'x+3/4,y+1/4,-z+1/2',
    '-y+3/4,x+1/2,-z+1/4',
    '-x+1/2,y+1/4,z+3/4',
    '-y+3/4,-x+1/4,z+1/2',
    'x+3/4,-y+1/2,z+1/4',
    'y+1/2,x+1/2,z',
    '-z+1/2,-x+1/2,-y',
    'x+1/2,-z+1/4,-y+3/4',
    'z+3/4,x+1/4,-y+1/2',
    '-x+3/4,z+1/2,-y+1/4',
    '-z+1/2,x+1/4,y+3/4',
    '-x+3/4,-z+1/4,y+1/2',
    'z+3/4,-x+1/2,y+1/4',
    'x+1/2,z+1/2,y',
    '-y+1/2,-z+1/2,-x',
    '-y,z+3/4,x+3/4',
    '-z+1/4,-y+3/4,x+1/2',
    'y+1/4,-z,x+1/4',
    'z+1/2,y,x+1/2',
    'y+1/4,z+1/4,-x',
    '-z+1/4,y+1/2,-x+3/4',
    'z,-y+1/4,-x+1/4',
    ) : ['F D -3 M :2', 'F D -3 M:2'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    ) : ['P 4'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    '-x+1/2,y+1/2,z',
    '-y+1/2,-x+1/2,z',
    'x+1/2,-y+1/2,z',
    'y+1/2,x+1/2,z',
    ) : ['P 4 B M'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    '-x+1/2,y+1/2,z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    'y+1/2,x+1/2,z+1/2',
    ) : ['P 4 N C'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    '-x,-y,-z',
    'y,-x,-z',
    'x,y,-z',
    '-y,x,-z',
    ) : ['P 4/M'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    '-x,-y,-z',
    'y,-x,-z',
    'x,y,-z',
    '-y,x,-z',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x+1/2,z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    ) : ['I 4/M'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    '-x,y,z',
    '-y,-x,z',
    'x,-y,z',
    'y,x,z',
    ) : ['P 4 M M'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    '-x,y,z',
    '-y,-x,z',
    'x,-y,z',
    'y,x,z',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x+1/2,z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    'y+1/2,x+1/2,z+1/2',
    ) : ['I 4 M M'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    '-x,y,z+1/2',
    '-y,-x,z+1/2',
    'x,-y,z+1/2',
    'y,x,z+1/2',
    ) : ['P 4 C C'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    '-x,y,z+1/2',
    '-y,-x,z+1/2',
    'x,-y,z+1/2',
    'y,x,z+1/2',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x+1/2,z+1/2',
    '-x+1/2,y+1/2,z',
    '-y+1/2,-x+1/2,z',
    'x+1/2,-y+1/2,z',
    'y+1/2,x+1/2,z',
    ) : ['I 4 C M'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x+1/2,-y+1/2,-z',
    'y+1/2,x+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-y+1/2,-x+1/2,-z',
    '-x,-y,-z',
    'y,-x,-z',
    'x,y,-z',
    '-y,x,-z',
    '-x+1/2,y+1/2,z',
    '-y+1/2,-x+1/2,z',
    'x+1/2,-y+1/2,z',
    'y+1/2,x+1/2,z',
    ) : ['P 4/M B M'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x+1/2,-y+1/2,-z+1/2',
    'y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-y+1/2,-x+1/2,-z+1/2',
    '-x,-y,-z',
    'y,-x,-z',
    'x,y,-z',
    '-y,x,-z',
    '-x+1/2,y+1/2,z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    'y+1/2,x+1/2,z+1/2',
    ) : ['P 4/M N C'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x+1/2,z+1/2',
    ) : ['I 4'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z',
    'y,x,-z',
    '-x,y,-z',
    '-y,-x,-z',
    ) : ['P 4 2 2'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z',
    'y,x,-z',
    '-x,y,-z',
    '-y,-x,-z',
    '-x+1/2,-y+1/2,-z',
    'y+1/2,-x+1/2,-z',
    'x+1/2,y+1/2,-z',
    '-y+1/2,x+1/2,-z',
    '-x+1/2,y+1/2,z',
    '-y+1/2,-x+1/2,z',
    'x+1/2,-y+1/2,z',
    'y+1/2,x+1/2,z',
    ) : ['P 4/N B M :1', 'P 4/N B M:1'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z',
    'y,x,-z',
    '-x,y,-z',
    '-y,-x,-z',
    '-x+1/2,-y+1/2,-z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    'y+1/2,x+1/2,z+1/2',
    ) : ['P 4/N N C :1', 'P 4/N N C:1'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z',
    'y,x,-z',
    '-x,y,-z',
    '-y,-x,-z',
    '-x,-y,-z',
    'y,-x,-z',
    'x,y,-z',
    '-y,x,-z',
    '-x,y,z',
    '-y,-x,z',
    'x,-y,z',
    'y,x,z',
    ) : ['P 4/M M M'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z',
    'y,x,-z',
    '-x,y,-z',
    '-y,-x,-z',
    '-x,-y,-z',
    'y,-x,-z',
    'x,y,-z',
    '-y,x,-z',
    '-x,y,z',
    '-y,-x,z',
    'x,-y,z',
    'y,x,z',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    'y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-y+1/2,-x+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    'y+1/2,x+1/2,z+1/2',
    ) : ['I 4/M M M'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z',
    'y,x,-z',
    '-x,y,-z',
    '-y,-x,-z',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    'y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-y+1/2,-x+1/2,-z+1/2',
    ) : ['I 4 2 2'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z',
    'y,x,-z',
    '-x,y,-z',
    '-y,-x,-z',
    'z,x,y',
    '-x,z,y',
    '-z,-x,y',
    'x,-z,y',
    'z,-x,-y',
    'x,z,-y',
    '-z,x,-y',
    '-x,-z,-y',
    'y,z,x',
    'y,-z,-x',
    'z,y,-x',
    '-y,z,-x',
    '-z,-y,-x',
    '-y,-z,x',
    'z,-y,x',
    '-z,y,x',
    ) : ['P 4 3 2'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z',
    'y,x,-z',
    '-x,y,-z',
    '-y,-x,-z',
    'z,x,y',
    '-x,z,y',
    '-z,-x,y',
    'x,-z,y',
    'z,-x,-y',
    'x,z,-y',
    '-z,x,-y',
    '-x,-z,-y',
    'y,z,x',
    'y,-z,-x',
    'z,y,-x',
    '-y,z,-x',
    '-z,-y,-x',
    '-y,-z,x',
    'z,-y,x',
    '-z,y,x',
    '-x+1/2,-y+1/2,-z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    'y+1/2,x+1/2,z+1/2',
    '-z+1/2,-x+1/2,-y+1/2',
    'x+1/2,-z+1/2,-y+1/2',
    'z+1/2,x+1/2,-y+1/2',
    '-x+1/2,z+1/2,-y+1/2',
    '-z+1/2,x+1/2,y+1/2',
    '-x+1/2,-z+1/2,y+1/2',
    'z+1/2,-x+1/2,y+1/2',
    'x+1/2,z+1/2,y+1/2',
    '-y+1/2,-z+1/2,-x+1/2',
    '-y+1/2,z+1/2,x+1/2',
    '-z+1/2,-y+1/2,x+1/2',
    'y+1/2,-z+1/2,x+1/2',
    'z+1/2,y+1/2,x+1/2',
    'y+1/2,z+1/2,-x+1/2',
    '-z+1/2,y+1/2,-x+1/2',
    'z+1/2,-y+1/2,-x+1/2',
    ) : ['P N -3 N :1', 'P N -3 N:1'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z',
    'y,x,-z',
    '-x,y,-z',
    '-y,-x,-z',
    'z,x,y',
    '-x,z,y',
    '-z,-x,y',
    'x,-z,y',
    'z,-x,-y',
    'x,z,-y',
    '-z,x,-y',
    '-x,-z,-y',
    'y,z,x',
    'y,-z,-x',
    'z,y,-x',
    '-y,z,-x',
    '-z,-y,-x',
    '-y,-z,x',
    'z,-y,x',
    '-z,y,x',
    '-x,-y,-z',
    'y,-x,-z',
    'x,y,-z',
    '-y,x,-z',
    '-x,y,z',
    '-y,-x,z',
    'x,-y,z',
    'y,x,z',
    '-z,-x,-y',
    'x,-z,-y',
    'z,x,-y',
    '-x,z,-y',
    '-z,x,y',
    '-x,-z,y',
    'z,-x,y',
    'x,z,y',
    '-y,-z,-x',
    '-y,z,x',
    '-z,-y,x',
    'y,-z,x',
    'z,y,x',
    'y,z,-x',
    '-z,y,-x',
    'z,-y,-x',
    ) : ['P M -3 M'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z',
    'y,x,-z',
    '-x,y,-z',
    '-y,-x,-z',
    'z,x,y',
    '-x,z,y',
    '-z,-x,y',
    'x,-z,y',
    'z,-x,-y',
    'x,z,-y',
    '-z,x,-y',
    '-x,-z,-y',
    'y,z,x',
    'y,-z,-x',
    'z,y,-x',
    '-y,z,-x',
    '-z,-y,-x',
    '-y,-z,x',
    'z,-y,x',
    '-z,y,x',
    '-x,-y,-z',
    'y,-x,-z',
    'x,y,-z',
    '-y,x,-z',
    '-x,y,z',
    '-y,-x,z',
    'x,-y,z',
    'y,x,z',
    '-z,-x,-y',
    'x,-z,-y',
    'z,x,-y',
    '-x,z,-y',
    '-z,x,y',
    '-x,-z,y',
    'z,-x,y',
    'x,z,y',
    '-y,-z,-x',
    '-y,z,x',
    '-z,-y,x',
    'y,-z,x',
    'z,y,x',
    'y,z,-x',
    '-z,y,-x',
    'z,-y,-x',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    'y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-y+1/2,-x+1/2,-z+1/2',
    'z+1/2,x+1/2,y+1/2',
    '-x+1/2,z+1/2,y+1/2',
    '-z+1/2,-x+1/2,y+1/2',
    'x+1/2,-z+1/2,y+1/2',
    'z+1/2,-x+1/2,-y+1/2',
    'x+1/2,z+1/2,-y+1/2',
    '-z+1/2,x+1/2,-y+1/2',
    '-x+1/2,-z+1/2,-y+1/2',
    'y+1/2,z+1/2,x+1/2',
    'y+1/2,-z+1/2,-x+1/2',
    'z+1/2,y+1/2,-x+1/2',
    '-y+1/2,z+1/2,-x+1/2',
    '-z+1/2,-y+1/2,-x+1/2',
    '-y+1/2,-z+1/2,x+1/2',
    'z+1/2,-y+1/2,x+1/2',
    '-z+1/2,y+1/2,x+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    'y+1/2,x+1/2,z+1/2',
    '-z+1/2,-x+1/2,-y+1/2',
    'x+1/2,-z+1/2,-y+1/2',
    'z+1/2,x+1/2,-y+1/2',
    '-x+1/2,z+1/2,-y+1/2',
    '-z+1/2,x+1/2,y+1/2',
    '-x+1/2,-z+1/2,y+1/2',
    'z+1/2,-x+1/2,y+1/2',
    'x+1/2,z+1/2,y+1/2',
    '-y+1/2,-z+1/2,-x+1/2',
    '-y+1/2,z+1/2,x+1/2',
    '-z+1/2,-y+1/2,x+1/2',
    'y+1/2,-z+1/2,x+1/2',
    'z+1/2,y+1/2,x+1/2',
    'y+1/2,z+1/2,-x+1/2',
    '-z+1/2,y+1/2,-x+1/2',
    'z+1/2,-y+1/2,-x+1/2',
    ) : ['I M -3 M'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z',
    'y,x,-z',
    '-x,y,-z',
    '-y,-x,-z',
    'z,x,y',
    '-x,z,y',
    '-z,-x,y',
    'x,-z,y',
    'z,-x,-y',
    'x,z,-y',
    '-z,x,-y',
    '-x,-z,-y',
    'y,z,x',
    'y,-z,-x',
    'z,y,-x',
    '-y,z,-x',
    '-z,-y,-x',
    '-y,-z,x',
    'z,-y,x',
    '-z,y,x',
    '-x,-y,-z',
    'y,-x,-z',
    'x,y,-z',
    '-y,x,-z',
    '-x,y,z',
    '-y,-x,z',
    'x,-y,z',
    'y,x,z',
    '-z,-x,-y',
    'x,-z,-y',
    'z,x,-y',
    '-x,z,-y',
    '-z,x,y',
    '-x,-z,y',
    'z,-x,y',
    'x,z,y',
    '-y,-z,-x',
    '-y,z,x',
    '-z,-y,x',
    'y,-z,x',
    'z,y,x',
    'y,z,-x',
    '-z,y,-x',
    'z,-y,-x',
    'x,y+1/2,z+1/2',
    '-y,x+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'y,-x+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    'y,x+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-y,-x+1/2,-z+1/2',
    'z,x+1/2,y+1/2',
    '-x,z+1/2,y+1/2',
    '-z,-x+1/2,y+1/2',
    'x,-z+1/2,y+1/2',
    'z,-x+1/2,-y+1/2',
    'x,z+1/2,-y+1/2',
    '-z,x+1/2,-y+1/2',
    '-x,-z+1/2,-y+1/2',
    'y,z+1/2,x+1/2',
    'y,-z+1/2,-x+1/2',
    'z,y+1/2,-x+1/2',
    '-y,z+1/2,-x+1/2',
    '-z,-y+1/2,-x+1/2',
    '-y,-z+1/2,x+1/2',
    'z,-y+1/2,x+1/2',
    '-z,y+1/2,x+1/2',
    '-x,-y+1/2,-z+1/2',
    'y,-x+1/2,-z+1/2',
    'x,y+1/2,-z+1/2',
    '-y,x+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    '-y,-x+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    'y,x+1/2,z+1/2',
    '-z,-x+1/2,-y+1/2',
    'x,-z+1/2,-y+1/2',
    'z,x+1/2,-y+1/2',
    '-x,z+1/2,-y+1/2',
    '-z,x+1/2,y+1/2',
    '-x,-z+1/2,y+1/2',
    'z,-x+1/2,y+1/2',
    'x,z+1/2,y+1/2',
    '-y,-z+1/2,-x+1/2',
    '-y,z+1/2,x+1/2',
    '-z,-y+1/2,x+1/2',
    'y,-z+1/2,x+1/2',
    'z,y+1/2,x+1/2',
    'y,z+1/2,-x+1/2',
    '-z,y+1/2,-x+1/2',
    'z,-y+1/2,-x+1/2',
    'x+1/2,y,z+1/2',
    '-y+1/2,x,z+1/2',
    '-x+1/2,-y,z+1/2',
    'y+1/2,-x,z+1/2',
    'x+1/2,-y,-z+1/2',
    'y+1/2,x,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-y+1/2,-x,-z+1/2',
    'z+1/2,x,y+1/2',
    '-x+1/2,z,y+1/2',
    '-z+1/2,-x,y+1/2',
    'x+1/2,-z,y+1/2',
    'z+1/2,-x,-y+1/2',
    'x+1/2,z,-y+1/2',
    '-z+1/2,x,-y+1/2',
    '-x+1/2,-z,-y+1/2',
    'y+1/2,z,x+1/2',
    'y+1/2,-z,-x+1/2',
    'z+1/2,y,-x+1/2',
    '-y+1/2,z,-x+1/2',
    '-z+1/2,-y,-x+1/2',
    '-y+1/2,-z,x+1/2',
    'z+1/2,-y,x+1/2',
    '-z+1/2,y,x+1/2',
    '-x+1/2,-y,-z+1/2',
    'y+1/2,-x,-z+1/2',
    'x+1/2,y,-z+1/2',
    '-y+1/2,x,-z+1/2',
    '-x+1/2,y,z+1/2',
    '-y+1/2,-x,z+1/2',
    'x+1/2,-y,z+1/2',
    'y+1/2,x,z+1/2',
    '-z+1/2,-x,-y+1/2',
    'x+1/2,-z,-y+1/2',
    'z+1/2,x,-y+1/2',
    '-x+1/2,z,-y+1/2',
    '-z+1/2,x,y+1/2',
    '-x+1/2,-z,y+1/2',
    'z+1/2,-x,y+1/2',
    'x+1/2,z,y+1/2',
    '-y+1/2,-z,-x+1/2',
    '-y+1/2,z,x+1/2',
    '-z+1/2,-y,x+1/2',
    'y+1/2,-z,x+1/2',
    'z+1/2,y,x+1/2',
    'y+1/2,z,-x+1/2',
    '-z+1/2,y,-x+1/2',
    'z+1/2,-y,-x+1/2',
    'x+1/2,y+1/2,z',
    '-y+1/2,x+1/2,z',
    '-x+1/2,-y+1/2,z',
    'y+1/2,-x+1/2,z',
    'x+1/2,-y+1/2,-z',
    'y+1/2,x+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-y+1/2,-x+1/2,-z',
    'z+1/2,x+1/2,y',
    '-x+1/2,z+1/2,y',
    '-z+1/2,-x+1/2,y',
    'x+1/2,-z+1/2,y',
    'z+1/2,-x+1/2,-y',
    'x+1/2,z+1/2,-y',
    '-z+1/2,x+1/2,-y',
    '-x+1/2,-z+1/2,-y',
    'y+1/2,z+1/2,x',
    'y+1/2,-z+1/2,-x',
    'z+1/2,y+1/2,-x',
    '-y+1/2,z+1/2,-x',
    '-z+1/2,-y+1/2,-x',
    '-y+1/2,-z+1/2,x',
    'z+1/2,-y+1/2,x',
    '-z+1/2,y+1/2,x',
    '-x+1/2,-y+1/2,-z',
    'y+1/2,-x+1/2,-z',
    'x+1/2,y+1/2,-z',
    '-y+1/2,x+1/2,-z',
    '-x+1/2,y+1/2,z',
    '-y+1/2,-x+1/2,z',
    'x+1/2,-y+1/2,z',
    'y+1/2,x+1/2,z',
    '-z+1/2,-x+1/2,-y',
    'x+1/2,-z+1/2,-y',
    'z+1/2,x+1/2,-y',
    '-x+1/2,z+1/2,-y',
    '-z+1/2,x+1/2,y',
    '-x+1/2,-z+1/2,y',
    'z+1/2,-x+1/2,y',
    'x+1/2,z+1/2,y',
    '-y+1/2,-z+1/2,-x',
    '-y+1/2,z+1/2,x',
    '-z+1/2,-y+1/2,x',
    'y+1/2,-z+1/2,x',
    'z+1/2,y+1/2,x',
    'y+1/2,z+1/2,-x',
    '-z+1/2,y+1/2,-x',
    'z+1/2,-y+1/2,-x',
    ) : ['F M -3 M'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z',
    'y,x,-z',
    '-x,y,-z',
    '-y,-x,-z',
    'z,x,y',
    '-x,z,y',
    '-z,-x,y',
    'x,-z,y',
    'z,-x,-y',
    'x,z,-y',
    '-z,x,-y',
    '-x,-z,-y',
    'y,z,x',
    'y,-z,-x',
    'z,y,-x',
    '-y,z,-x',
    '-z,-y,-x',
    '-y,-z,x',
    'z,-y,x',
    '-z,y,x',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    'y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    '-y+1/2,-x+1/2,-z+1/2',
    'z+1/2,x+1/2,y+1/2',
    '-x+1/2,z+1/2,y+1/2',
    '-z+1/2,-x+1/2,y+1/2',
    'x+1/2,-z+1/2,y+1/2',
    'z+1/2,-x+1/2,-y+1/2',
    'x+1/2,z+1/2,-y+1/2',
    '-z+1/2,x+1/2,-y+1/2',
    '-x+1/2,-z+1/2,-y+1/2',
    'y+1/2,z+1/2,x+1/2',
    'y+1/2,-z+1/2,-x+1/2',
    'z+1/2,y+1/2,-x+1/2',
    '-y+1/2,z+1/2,-x+1/2',
    '-z+1/2,-y+1/2,-x+1/2',
    '-y+1/2,-z+1/2,x+1/2',
    'z+1/2,-y+1/2,x+1/2',
    '-z+1/2,y+1/2,x+1/2',
    ) : ['I 4 3 2'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z',
    'y,x,-z',
    '-x,y,-z',
    '-y,-x,-z',
    'z,x,y',
    '-x,z,y',
    '-z,-x,y',
    'x,-z,y',
    'z,-x,-y',
    'x,z,-y',
    '-z,x,-y',
    '-x,-z,-y',
    'y,z,x',
    'y,-z,-x',
    'z,y,-x',
    '-y,z,-x',
    '-z,-y,-x',
    '-y,-z,x',
    'z,-y,x',
    '-z,y,x',
    'x,y+1/2,z+1/2',
    '-y,x+1/2,z+1/2',
    '-x,-y+1/2,z+1/2',
    'y,-x+1/2,z+1/2',
    'x,-y+1/2,-z+1/2',
    'y,x+1/2,-z+1/2',
    '-x,y+1/2,-z+1/2',
    '-y,-x+1/2,-z+1/2',
    'z,x+1/2,y+1/2',
    '-x,z+1/2,y+1/2',
    '-z,-x+1/2,y+1/2',
    'x,-z+1/2,y+1/2',
    'z,-x+1/2,-y+1/2',
    'x,z+1/2,-y+1/2',
    '-z,x+1/2,-y+1/2',
    '-x,-z+1/2,-y+1/2',
    'y,z+1/2,x+1/2',
    'y,-z+1/2,-x+1/2',
    'z,y+1/2,-x+1/2',
    '-y,z+1/2,-x+1/2',
    '-z,-y+1/2,-x+1/2',
    '-y,-z+1/2,x+1/2',
    'z,-y+1/2,x+1/2',
    '-z,y+1/2,x+1/2',
    'x+1/2,y,z+1/2',
    '-y+1/2,x,z+1/2',
    '-x+1/2,-y,z+1/2',
    'y+1/2,-x,z+1/2',
    'x+1/2,-y,-z+1/2',
    'y+1/2,x,-z+1/2',
    '-x+1/2,y,-z+1/2',
    '-y+1/2,-x,-z+1/2',
    'z+1/2,x,y+1/2',
    '-x+1/2,z,y+1/2',
    '-z+1/2,-x,y+1/2',
    'x+1/2,-z,y+1/2',
    'z+1/2,-x,-y+1/2',
    'x+1/2,z,-y+1/2',
    '-z+1/2,x,-y+1/2',
    '-x+1/2,-z,-y+1/2',
    'y+1/2,z,x+1/2',
    'y+1/2,-z,-x+1/2',
    'z+1/2,y,-x+1/2',
    '-y+1/2,z,-x+1/2',
    '-z+1/2,-y,-x+1/2',
    '-y+1/2,-z,x+1/2',
    'z+1/2,-y,x+1/2',
    '-z+1/2,y,x+1/2',
    'x+1/2,y+1/2,z',
    '-y+1/2,x+1/2,z',
    '-x+1/2,-y+1/2,z',
    'y+1/2,-x+1/2,z',
    'x+1/2,-y+1/2,-z',
    'y+1/2,x+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-y+1/2,-x+1/2,-z',
    'z+1/2,x+1/2,y',
    '-x+1/2,z+1/2,y',
    '-z+1/2,-x+1/2,y',
    'x+1/2,-z+1/2,y',
    'z+1/2,-x+1/2,-y',
    'x+1/2,z+1/2,-y',
    '-z+1/2,x+1/2,-y',
    '-x+1/2,-z+1/2,-y',
    'y+1/2,z+1/2,x',
    'y+1/2,-z+1/2,-x',
    'z+1/2,y+1/2,-x',
    '-y+1/2,z+1/2,-x',
    '-z+1/2,-y+1/2,-x',
    '-y+1/2,-z+1/2,x',
    'z+1/2,-y+1/2,x',
    '-z+1/2,y+1/2,x',
    ) : ['F 4 3 2'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z+1/2',
    'y,x,-z+1/2',
    '-x,y,-z+1/2',
    '-y,-x,-z+1/2',
    '-x,-y,-z',
    'y,-x,-z',
    'x,y,-z',
    '-y,x,-z',
    '-x,y,z+1/2',
    '-y,-x,z+1/2',
    'x,-y,z+1/2',
    'y,x,z+1/2',
    ) : ['P 4/M C C'] ,
    (
    'x,y,z',
    '-y,x,z',
    '-x,-y,z',
    'y,-x,z',
    'x,-y,-z+1/2',
    'y,x,-z+1/2',
    '-x,y,-z+1/2',
    '-y,-x,-z+1/2',
    '-x,-y,-z',
    'y,-x,-z',
    'x,y,-z',
    '-y,x,-z',
    '-x,y,z+1/2',
    '-y,-x,z+1/2',
    'x,-y,z+1/2',
    'y,x,z+1/2',
    'x+1/2,y+1/2,z+1/2',
    '-y+1/2,x+1/2,z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    'y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,-z',
    'y+1/2,x+1/2,-z',
    '-x+1/2,y+1/2,-z',
    '-y+1/2,-x+1/2,-z',
    '-x+1/2,-y+1/2,-z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,z',
    '-y+1/2,-x+1/2,z',
    'x+1/2,-y+1/2,z',
    'y+1/2,x+1/2,z',
    ) : ['I 4/M C M'] ,
    (
    'x,y,z',
    '-y,x,z+1/2',
    '-x,-y,z',
    'y,-x,z+1/2',
    ) : ['P 42'] ,
    (
    'x,y,z',
    '-y,x,z+1/2',
    '-x,-y,z',
    'y,-x,z+1/2',
    '-x+1/2,y+1/2,z',
    '-y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,z',
    'y+1/2,x+1/2,z+1/2',
    ) : ['P 42 B C'] ,
    (
    'x,y,z',
    '-y,x,z+1/2',
    '-x,-y,z',
    'y,-x,z+1/2',
    '-x,-y,-z',
    'y,-x,-z+1/2',
    'x,y,-z',
    '-y,x,-z+1/2',
    ) : ['P 42/M'] ,
    (
    'x,y,z',
    '-y,x,z+1/2',
    '-x,-y,z',
    'y,-x,z+1/2',
    '-x,y,z',
    '-y,-x,z+1/2',
    'x,-y,z',
    'y,x,z+1/2',
    ) : ['P 42 M C'] ,
    (
    'x,y,z',
    '-y,x,z+1/2',
    '-x,-y,z',
    'y,-x,z+1/2',
    '-x,y,z+1/2',
    '-y,-x,z',
    'x,-y,z+1/2',
    'y,x,z',
    ) : ['P 42 C M'] ,
    (
    'x,y,z',
    '-y,x,z+1/2',
    '-x,-y,z',
    'y,-x,z+1/2',
    'x+1/2,-y+1/2,-z',
    'y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,-z',
    '-y+1/2,-x+1/2,-z+1/2',
    '-x,-y,-z',
    'y,-x,-z+1/2',
    'x,y,-z',
    '-y,x,-z+1/2',
    '-x+1/2,y+1/2,z',
    '-y+1/2,-x+1/2,z+1/2',
    'x+1/2,-y+1/2,z',
    'y+1/2,x+1/2,z+1/2',
    ) : ['P 42/M B C'] ,
    (
    'x,y,z',
    '-y,x,z+1/2',
    '-x,-y,z',
    'y,-x,z+1/2',
    'x,-y,-z',
    'y,x,-z+1/2',
    '-x,y,-z',
    '-y,-x,-z+1/2',
    ) : ['P 42 2 2'] ,
    (
    'x,y,z',
    '-y,x,z+1/2',
    '-x,-y,z',
    'y,-x,z+1/2',
    'x,-y,-z',
    'y,x,-z+1/2',
    '-x,y,-z',
    '-y,-x,-z+1/2',
    '-x,-y,-z',
    'y,-x,-z+1/2',
    'x,y,-z',
    '-y,x,-z+1/2',
    '-x,y,z',
    '-y,-x,z+1/2',
    'x,-y,z',
    'y,x,z+1/2',
    ) : ['P 42/M M C'] ,
    (
    'x,y,z',
    '-y,x,z+1/2',
    '-x,-y,z',
    'y,-x,z+1/2',
    'x,-y,-z+1/2',
    'y,x,-z',
    '-x,y,-z+1/2',
    '-y,-x,-z',
    '-x,-y,-z',
    'y,-x,-z+1/2',
    'x,y,-z',
    '-y,x,-z+1/2',
    '-x,y,z+1/2',
    '-y,-x,z',
    'x,-y,z+1/2',
    'y,x,z',
    ) : ['P 42/M C M'] ,
    (
    'x,y,z',
    '-y,x,z+1/4',
    '-x,-y,z+1/2',
    'y,-x,z+3/4',
    ) : ['P 41'] ,
    (
    'x,y,z',
    '-y,x,z+1/4',
    '-x,-y,z+1/2',
    'y,-x,z+3/4',
    'x,-y,-z+1/2',
    'y,x,-z+3/4',
    '-x,y,-z',
    '-y,-x,-z+1/4',
    ) : ['P 41 2 2'] ,
    (
    'x,y,z',
    '-y,x,z+3/4',
    '-x,-y,z+1/2',
    'y,-x,z+1/4',
    ) : ['P 43'] ,
    (
    'x,y,z',
    '-y,x,z+3/4',
    '-x,-y,z+1/2',
    'y,-x,z+1/4',
    'x,-y,-z+1/2',
    'y,x,-z+1/4',
    '-x,y,-z',
    '-y,-x,-z+3/4',
    ) : ['P 43 2 2'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    ) : ['P 3'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    '-x,-y,-z',
    'y,-x+y,-z',
    'x-y,x,-z',
    ) : ['P -3'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    '-x,-y,-z',
    'y,-x+y,-z',
    'x-y,x,-z',
    'x+2/3,y+1/3,z+1/3',
    '-y+2/3,x-y+1/3,z+1/3',
    '-x+y+2/3,-x+1/3,z+1/3',
    '-x+2/3,-y+1/3,-z+1/3',
    'y+2/3,-x+y+1/3,-z+1/3',
    'x-y+2/3,x+1/3,-z+1/3',
    'x+1/3,y+2/3,z+2/3',
    '-y+1/3,x-y+2/3,z+2/3',
    '-x+y+1/3,-x+2/3,z+2/3',
    '-x+1/3,-y+2/3,-z+2/3',
    'y+1/3,-x+y+2/3,-z+2/3',
    'x-y+1/3,x+2/3,-z+2/3',
    ) : ['H -3', 'R -3 :H', 'R -3:H'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    '-y,-x,-z',
    'x,x-y,-z',
    '-x+y,y,-z',
    ) : ['P 3 1 2'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    '-y,-x,-z',
    'x,x-y,-z',
    '-x+y,y,-z',
    '-x,-y,-z',
    'y,-x+y,-z',
    'x-y,x,-z',
    'y,x,z',
    '-x,-x+y,z',
    'x-y,-y,z',
    ) : ['P -3 1 M'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    '-y,-x,-z+1/2',
    'x,x-y,-z+1/2',
    '-x+y,y,-z+1/2',
    '-x,-y,-z',
    'y,-x+y,-z',
    'x-y,x,-z',
    'y,x,z+1/2',
    '-x,-x+y,z+1/2',
    'x-y,-y,z+1/2',
    ) : ['P -3 1 C'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    '-y,-x,z',
    'x,x-y,z',
    '-x+y,y,z',
    ) : ['P 3 M 1'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    '-y,-x,z',
    'x,x-y,z',
    '-x+y,y,z',
    'x+2/3,y+1/3,z+1/3',
    '-y+2/3,x-y+1/3,z+1/3',
    '-x+y+2/3,-x+1/3,z+1/3',
    '-y+2/3,-x+1/3,z+1/3',
    'x+2/3,x-y+1/3,z+1/3',
    '-x+y+2/3,y+1/3,z+1/3',
    'x+1/3,y+2/3,z+2/3',
    '-y+1/3,x-y+2/3,z+2/3',
    '-x+y+1/3,-x+2/3,z+2/3',
    '-y+1/3,-x+2/3,z+2/3',
    'x+1/3,x-y+2/3,z+2/3',
    '-x+y+1/3,y+2/3,z+2/3',
    ) : ['H 3 M', 'R 3 M :H', 'R 3 M:H'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    '-y,-x,z+1/2',
    'x,x-y,z+1/2',
    '-x+y,y,z+1/2',
    ) : ['P 3 C 1'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    '-y,-x,z+1/2',
    'x,x-y,z+1/2',
    '-x+y,y,z+1/2',
    'x+2/3,y+1/3,z+1/3',
    '-y+2/3,x-y+1/3,z+1/3',
    '-x+y+2/3,-x+1/3,z+1/3',
    '-y+2/3,-x+1/3,z+5/6',
    'x+2/3,x-y+1/3,z+5/6',
    '-x+y+2/3,y+1/3,z+5/6',
    'x+1/3,y+2/3,z+2/3',
    '-y+1/3,x-y+2/3,z+2/3',
    '-x+y+1/3,-x+2/3,z+2/3',
    '-y+1/3,-x+2/3,z+1/6',
    'x+1/3,x-y+2/3,z+1/6',
    '-x+y+1/3,y+2/3,z+1/6',
    ) : ['H 3 C', 'R 3 C :H', 'R 3 C:H'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    'x+2/3,y+1/3,z+1/3',
    '-y+2/3,x-y+1/3,z+1/3',
    '-x+y+2/3,-x+1/3,z+1/3',
    'x+1/3,y+2/3,z+2/3',
    '-y+1/3,x-y+2/3,z+2/3',
    '-x+y+1/3,-x+2/3,z+2/3',
    ) : ['H 3', 'R 3', 'R 3 :H', 'R 3:H'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    'y,x,-z',
    '-x,-x+y,-z',
    'x-y,-y,-z',
    ) : ['P 3 2 1'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    'y,x,-z',
    '-x,-x+y,-z',
    'x-y,-y,-z',
    '-x,-y,-z',
    'y,-x+y,-z',
    'x-y,x,-z',
    '-y,-x,z',
    'x,x-y,z',
    '-x+y,y,z',
    ) : ['P -3 M 1'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    'y,x,-z',
    '-x,-x+y,-z',
    'x-y,-y,-z',
    '-x,-y,-z',
    'y,-x+y,-z',
    'x-y,x,-z',
    '-y,-x,z',
    'x,x-y,z',
    '-x+y,y,z',
    'x+2/3,y+1/3,z+1/3',
    '-y+2/3,x-y+1/3,z+1/3',
    '-x+y+2/3,-x+1/3,z+1/3',
    'y+2/3,x+1/3,-z+1/3',
    '-x+2/3,-x+y+1/3,-z+1/3',
    'x-y+2/3,-y+1/3,-z+1/3',
    '-x+2/3,-y+1/3,-z+1/3',
    'y+2/3,-x+y+1/3,-z+1/3',
    'x-y+2/3,x+1/3,-z+1/3',
    '-y+2/3,-x+1/3,z+1/3',
    'x+2/3,x-y+1/3,z+1/3',
    '-x+y+2/3,y+1/3,z+1/3',
    'x+1/3,y+2/3,z+2/3',
    '-y+1/3,x-y+2/3,z+2/3',
    '-x+y+1/3,-x+2/3,z+2/3',
    'y+1/3,x+2/3,-z+2/3',
    '-x+1/3,-x+y+2/3,-z+2/3',
    'x-y+1/3,-y+2/3,-z+2/3',
    '-x+1/3,-y+2/3,-z+2/3',
    'y+1/3,-x+y+2/3,-z+2/3',
    'x-y+1/3,x+2/3,-z+2/3',
    '-y+1/3,-x+2/3,z+2/3',
    'x+1/3,x-y+2/3,z+2/3',
    '-x+y+1/3,y+2/3,z+2/3',
    ) : ['H -3 2/M', 'H -3 M', 'R -3 M :H', 'R -3 M:H'] ,
    (
    'x,y,z',#
    '-y,x-y,z',#
    '-x+y,-x,z',#
    'y,x,-z',#
    '-x,-x+y,-z',#
    'x-y,-y,-z',#
    'x+2/3,y+1/3,z+1/3',#
    '-y+2/3,x-y+1/3,z+1/3',#
    '-x+y+2/3,-x+1/3,z+1/3',#
    'y+2/3,x+1/3,-z+1/3',#
    '-x+2/3,-x+y+1/3,-z+1/3',#
    'x-y+2/3,-y+1/3,-z+1/3',#
    'x+1/3,y+2/3,z+2/3',#
    '-y+1/3,x-y+2/3,z+2/3',#
    '-x+y+1/3,-x+2/3,z+2/3',#
    'y+1/3,x+2/3,-z+2/3',#
    '-x+1/3,-x+y+2/3,-z+2/3',#
    'x-y+1/3,-y+2/3,-z+2/3',#
    ) : ['H 3 2', 'R 3 2', 'R 3 2 :H', 'R 3 2:H', 'R 32'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    'y,x,-z+1/2',
    '-x,-x+y,-z+1/2',
    'x-y,-y,-z+1/2',
    '-x,-y,-z',
    'y,-x+y,-z',
    'x-y,x,-z',
    '-y,-x,z+1/2',
    'x,x-y,z+1/2',
    '-x+y,y,z+1/2',
    ) : ['P -3 C 1'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    'y,x,-z+1/2',
    '-x,-x+y,-z+1/2',
    'x-y,-y,-z+1/2',
    '-x,-y,-z',
    'y,-x+y,-z',
    'x-y,x,-z',
    '-y,-x,z+1/2',
    'x,x-y,z+1/2',
    '-x+y,y,z+1/2',
    'x+2/3,y+1/3,z+1/3',
    '-y+2/3,x-y+1/3,z+1/3',
    '-x+y+2/3,-x+1/3,z+1/3',
    'y+2/3,x+1/3,-z+5/6',
    '-x+2/3,-x+y+1/3,-z+5/6',
    'x-y+2/3,-y+1/3,-z+5/6',
    '-x+2/3,-y+1/3,-z+1/3',
    'y+2/3,-x+y+1/3,-z+1/3',
    'x-y+2/3,x+1/3,-z+1/3',
    '-y+2/3,-x+1/3,z+5/6',
    'x+2/3,x-y+1/3,z+5/6',
    '-x+y+2/3,y+1/3,z+5/6',
    'x+1/3,y+2/3,z+2/3',
    '-y+1/3,x-y+2/3,z+2/3',
    '-x+y+1/3,-x+2/3,z+2/3',
    'y+1/3,x+2/3,-z+1/6',
    '-x+1/3,-x+y+2/3,-z+1/6',
    'x-y+1/3,-y+2/3,-z+1/6',
    '-x+1/3,-y+2/3,-z+2/3',
    'y+1/3,-x+y+2/3,-z+2/3',
    'x-y+1/3,x+2/3,-z+2/3',
    '-y+1/3,-x+2/3,z+1/6',
    'x+1/3,x-y+2/3,z+1/6',
    '-x+y+1/3,y+2/3,z+1/6',
    ) : ['H -3 2/C', 'H -3 C', 'R -3 C :H', 'R -3 C:H'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    'y,x,z',
    '-x,-x+y,z',
    'x-y,-y,z',
    ) : ['P 3 1 M'] ,
    (
    'x,y,z',
    '-y,x-y,z',
    '-x+y,-x,z',
    'y,x,z+1/2',
    '-x,-x+y,z+1/2',
    'x-y,-y,z+1/2',
    ) : ['P 3 1 C'] ,
    (
    'x,y,z',
    '-y,x-y,z+1/3',
    '-x+y,-x,z+2/3',
    ) : ['P 31'] ,
    (
    'x,y,z',
    '-y,x-y,z+1/3',
    '-x+y,-x,z+2/3',
    '-y,-x,-z+2/3',
    'x,x-y,-z',
    '-x+y,y,-z+1/3',
    ) : ['P 31 1 2'] ,
    (
    'x,y,z',
    '-y,x-y,z+1/3',
    '-x+y,-x,z+2/3',
    'y,x,-z',
    '-x,-x+y,-z+1/3',
    'x-y,-y,-z+2/3',
    ) : ['P 31 2 1'] ,
    (
    'x,y,z',
    '-y,x-y,z+2/3',
    '-x+y,-x,z+1/3',
    ) : ['P 32'] ,
    (
    'x,y,z',
    '-y,x-y,z+2/3',
    '-x+y,-x,z+1/3',
    '-y,-x,-z+1/3',
    'x,x-y,-z',
    '-x+y,y,-z+2/3',
    ) : ['P 32 1 2'] ,
    (
    'x,y,z',
    '-y,x-y,z+2/3',
    '-x+y,-x,z+1/3',
    'y,x,-z',
    '-x,-x+y,-z+2/3',
    'x-y,-y,-z+1/3',
    ) : ['P 32 2 1'] ,
    (
    'x,y,z',
    'x+1/2,-y+1/2,-z',
    '-x,-y,-z',
    '-x+1/2,y+1/2,z',
    ) : ['P 21/B 1 1'] ,
    (
    'x,y,z',
    'x+1/2,-y+1/2,-z',
    '-x,-y,-z',
    '-x+1/2,y+1/2,z',
    'x+1/2,y,z+1/2',
    'x,-y+1/2,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    '-x,y+1/2,z+1/2',
    ) : ['B 2/N 1 1'] ,
    (
    'x,y,z',
    'x+1/2,-y+1/2,-z+1/2',
    '-x,-y,-z',
    '-x+1/2,y+1/2,z+1/2',
    ) : ['P 21/N 1 1'] ,
    (
    'x,y,z',
    'x+1/2,-y+1/2,z',
    'x,y+1/2,z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['A 1 N 1'] ,
    (
    'x,y,z',
    'x+1/2,-y,-z',
    ) : ['P 21 1 1'] ,
    (
    'x,y,z',
    'x+1/2,-y,-z',
    '-x,-y,-z',
    '-x+1/2,y,z',
    ) : ['P 21/M 1 1'] ,
    (
    'x,y,z',
    'x+1/2,-y,-z+1/2',
    '-x,-y,-z',
    '-x+1/2,y,z+1/2',
    ) : ['P 21/C 1 1'] ,
    (
    'x,y,z',
    'x+1/2,-y,-z+1/2',
    '-x,-y,-z',
    '-x+1/2,y,z+1/2',
    'x+1/2,y+1/2,z',
    'x,-y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z',
    '-x,y+1/2,z+1/2',
    ) : ['C 2/N 1 1'] ,
    (
    'x,y,z',
    'x+1/2,-y,z',
    ) : ['P 1 A 1'] ,
    (
    'x,y,z',
    'x+1/2,-y,z',
    'x+1/2,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['I 1 A 1'] ,
    (
    'x,y,z',
    'x+1/2,-y,z',
    'x,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['A 1 A 1'] ,
    (
    'x,y,z',
    'x+1/2,-y,z+1/2',
    ) : ['P 1 N 1'] ,
    (
    'x,y,z',
    'x+1/2,-y,z+1/2',
    'x+1/2,y+1/2,z',
    'x,-y+1/2,z+1/2',
    ) : ['C 1 N 1'] ,
    (
    'x,y,z',
    'x+1/2,y+1/2,-z',
    ) : ['P 1 1 N'] ,
    (
    'x,y,z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    '-x,y,-z',
    ) : ['P B 2 N'] ,
    (
    'x,y,z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    '-x,y,-z',
    'x,y+1/2,z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    '-x,y+1/2,-z+1/2',
    ) : ['A C 2 A'] ,
    (
    'x,y,z',
    'x+1/2,y+1/2,-z',
    '-x,y,z',
    '-x+1/2,y+1/2,-z',
    ) : ['P M 21 N'] ,
    (
    'x,y,z',
    'x+1/2,y+1/2,-z',
    'x+1/2,-y+1/2,-z',
    'x,-y,z',
    ) : ['P 21 M N'] ,
    (
    'x,y,z',
    'x+1/2,y+1/2,-z',
    'x+1/2,y,z+1/2',
    'x,y+1/2,-z+1/2',
    ) : ['B 1 1 N'] ,
    (
    'x,y,z',
    'x+1/2,y+1/2,-z',
    'x,-y,-z',
    'x+1/2,-y+1/2,z',
    ) : ['P 2 A N'] ,
    (
    'x,y,z',
    'x+1/2,y+1/2,-z',
    'x,-y,-z',
    'x+1/2,-y+1/2,z',
    'x+1/2,y,z+1/2',
    'x,y+1/2,-z+1/2',
    'x+1/2,-y,-z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['B 2 C B'] ,
    (
    'x,y,z',
    'x+1/2,y+1/2,-z',
    'x,y+1/2,z+1/2',
    'x+1/2,y,-z+1/2',
    ) : ['A 1 1 N'] ,
    (
    'x,y,z',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-x,y,-z',
    ) : ['P N 2 N'] ,
    (
    'x,y,z',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y,z+1/2',
    '-x,y+1/2,-z',
    ) : ['P C 21 N'] ,
    (
    'x,y,z',
    'x+1/2,y+1/2,-z+1/2',
    'x+1/2,-y,-z',
    'x,-y+1/2,z+1/2',
    ) : ['P 21 C N'] ,
    (
    'x,y,z',
    'x+1/2,y+1/2,-z+1/2',
    'x,-y,-z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P 2 N N'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    ) : ['P 1 1 A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    '-x+1/2,y+1/2,z',
    '-x,y+1/2,-z',
    ) : ['P B 21 A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    '-x+1/2,y,z',
    '-x,y,-z',
    ) : ['P M 2 A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    '-x+1/2,y,z',
    '-x,y,-z',
    'x+1/2,y+1/2,z',
    'x,y+1/2,-z',
    '-x,y+1/2,z',
    '-x+1/2,y+1/2,-z',
    ) : ['C M 2 A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    '-x+1/2,y,z',
    '-x,y,-z',
    'x+1/2,y+1/2,z+1/2',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    ) : ['I M 2 A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    '-x+1/2,y,z',
    '-x,y,-z',
    'x,y+1/2,z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-x,y+1/2,-z+1/2',
    ) : ['A M 2 A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    'x+1/2,-y,-z',
    'x,-y,z',
    ) : ['P 21 M A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    'x+1/2,-y,-z',
    'x,-y,z',
    'x,y+1/2,z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['A 21 M A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    'x+1/2,y+1/2,z+1/2',
    'x,y+1/2,-z+1/2',
    ) : ['I 1 1 A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    'x,-y,-z',
    'x+1/2,-y,z',
    ) : ['P 2 A A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    'x,-y,-z',
    'x+1/2,-y,z',
    'x+1/2,y+1/2,z',
    'x,y+1/2,-z',
    'x+1/2,-y+1/2,-z',
    'x,-y+1/2,z',
    ) : ['C 2 M B'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    'x,-y,-z',
    'x+1/2,-y,z',
    'x+1/2,y+1/2,z+1/2',
    'x,y+1/2,-z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['I 2 C B'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    'x,-y,-z',
    'x+1/2,-y,z',
    'x+1/2,y,z+1/2',
    'x,y,-z+1/2',
    'x+1/2,-y,-z+1/2',
    'x,-y,z+1/2',
    ) : ['B 2 C M'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    'x,-y,-z',
    'x+1/2,-y,z',
    'x,y+1/2,z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    'x,-y+1/2,-z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['A 2 A A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z',
    'x,y+1/2,z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    ) : ['A 1 1 A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-x,y+1/2,-z',
    ) : ['P N 21 A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    '-x,y,-z',
    ) : ['P C 2 A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    '-x,y,-z',
    'x+1/2,y+1/2,z',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    '-x+1/2,y+1/2,-z',
    ) : ['C C 2 A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z+1/2',
    'x+1/2,-y,-z',
    'x,-y,z+1/2',
    ) : ['P 21 C A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z+1/2',
    'x,-y,-z',
    'x+1/2,-y,z+1/2',
    ) : ['P 2 N A'] ,
    (
    'x,y,z',
    'x+1/2,y,-z+1/2',
    'x,-y,-z',
    'x+1/2,-y,z+1/2',
    'x+1/2,y+1/2,z',
    'x,y+1/2,-z+1/2',
    'x+1/2,-y+1/2,-z',
    'x,-y+1/2,z+1/2',
    ) : ['C 2 C B'] ,
    (
    'x,y,z',
    'x+1/4,y+1/4,-z+1/4',
    '-x+1/4,y+1/4,z+1/4',
    '-x+1/2,y+1/2,-z',
    'x,y+1/2,z+1/2',
    'x+1/4,y+3/4,-z+3/4',
    '-x+1/4,y+3/4,z+3/4',
    '-x+1/2,y,-z+1/2',
    'x+1/2,y,z+1/2',
    'x+3/4,y+1/4,-z+3/4',
    '-x+3/4,y+1/4,z+3/4',
    '-x,y+1/2,-z+1/2',
    'x+1/2,y+1/2,z',
    'x+3/4,y+3/4,-z+1/4',
    '-x+3/4,y+3/4,z+1/4',
    '-x,y,-z',
    ) : ['F D 2 D'] ,
    (
    'x,y,z',
    'x+1/4,y+1/4,-z+1/4',
    'x,-y,-z',
    'x+1/4,-y+1/4,z+1/4',
    'x,y+1/2,z+1/2',
    'x+1/4,y+3/4,-z+3/4',
    'x,-y+1/2,-z+1/2',
    'x+1/4,-y+3/4,z+3/4',
    'x+1/2,y,z+1/2',
    'x+3/4,y+1/4,-z+3/4',
    'x+1/2,-y,-z+1/2',
    'x+3/4,-y+1/4,z+3/4',
    'x+1/2,y+1/2,z',
    'x+3/4,y+3/4,-z+1/4',
    'x+1/2,-y+1/2,-z',
    'x+3/4,-y+3/4,z+1/4',
    ) : ['F 2 D D'] ,
    (
    'x,y,z',
    'x,-y+1/2,-z',
    '-x,-y,-z',
    '-x,y+1/2,z',
    ) : ['P 2/B 1 1'] ,
    (
    'x,y,z',
    'x,-y+1/2,-z',
    '-x,-y,-z',
    '-x,y+1/2,z',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y,z+1/2',
    ) : ['I 2/B 1 1'] ,
    (
    'x,y,z',
    'x,-y+1/2,-z',
    '-x,-y,-z',
    '-x,y+1/2,z',
    'x+1/2,y,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    ) : ['B 2/B 1 1'] ,
    (
    'x,y,z',
    'x,-y+1/2,-z+1/2',
    '-x,-y,-z',
    '-x,y+1/2,z+1/2',
    ) : ['P 2/N 1 1'] ,
    (
    'x,y,z',
    'x,-y,-z',
    ) : ['P 2 1 1'] ,
    (
    'x,y,z',
    'x,-y,-z',
    '-x,-y,-z',
    '-x,y,z',
    ) : ['P 2/M 1 1'] ,
    (
    'x,y,z',
    'x,-y,-z',
    '-x,-y,-z',
    '-x,y,z',
    'x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,z',
    ) : ['C 2/M 1 1'] ,
    (
    'x,y,z',
    'x,-y,-z',
    '-x,-y,-z',
    '-x,y,z',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    ) : ['I 2/M 1 1'] ,
    (
    'x,y,z',
    'x,-y,-z',
    '-x,-y,-z',
    '-x,y,z',
    'x+1/2,y,z+1/2',
    'x+1/2,-y,-z+1/2',
    '-x+1/2,-y,-z+1/2',
    '-x+1/2,y,z+1/2',
    ) : ['B 2/M 1 1'] ,
    (
    'x,y,z',
    'x,-y,-z',
    'x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,-z',
    ) : ['C 2 1 1'] ,
    (
    'x,y,z',
    'x,-y,-z',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    ) : ['I 2 1 1'] ,
    (
    'x,y,z',
    'x,-y,-z',
    'x+1/2,y,z+1/2',
    'x+1/2,-y,-z+1/2',
    ) : ['B 2 1 1'] ,
    (
    'x,y,z',
    'x,-y,-z+1/2',
    '-x,-y,-z',
    '-x,y,z+1/2',
    ) : ['P 2/C 1 1'] ,
    (
    'x,y,z',
    'x,-y,-z+1/2',
    '-x,-y,-z',
    '-x,y,z+1/2',
    'x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,-y+1/2,-z',
    '-x+1/2,y+1/2,z+1/2',
    ) : ['C 2/C 1 1'] ,
    (
    'x,y,z',
    'x,-y,-z+1/2',
    '-x,-y,-z',
    '-x,y,z+1/2',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,-z',
    '-x+1/2,-y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z',
    ) : ['I 2/C 1 1'] ,
    (
    'x,y,z',
    'x,-y,z',
    ) : ['P 1 M 1'] ,
    (
    'x,y,z',
    'x,-y,z',
    'x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z',
    ) : ['C 1 M 1'] ,
    (
    'x,y,z',
    'x,-y,z',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['I 1 M 1'] ,
    (
    'x,y,z',
    'x,-y,z',
    'x,y+1/2,z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['A 1 M 1'] ,
    (
    'x,y,z',
    'x,-y,z+1/2',
    ) : ['P 1 C 1'] ,
    (
    'x,y,z',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['C 1 C 1'] ,
    (
    'x,y,z',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,-y+1/2,z',
    ) : ['I 1 C 1'] ,
    (
    'x,y,z',
    'x,y+1/2,-z',
    ) : ['P 1 1 B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z',
    '-x,y+1/2,z',
    '-x,y,-z',
    ) : ['P B 2 B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z',
    '-x,y+1/2,z',
    '-x,y,-z',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    ) : ['I C 2 A'] ,
    (
    'x,y,z',
    'x,y+1/2,-z',
    '-x,y+1/2,z',
    '-x,y,-z',
    'x+1/2,y,z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-x+1/2,y,-z+1/2',
    ) : ['B B 2 B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z',
    '-x,y+1/2,z',
    '-x,y,-z',
    'x,y+1/2,z+1/2',
    'x,y,-z+1/2',
    '-x,y,z+1/2',
    '-x,y+1/2,-z+1/2',
    ) : ['A C 2 M'] ,
    (
    'x,y,z',
    'x,y+1/2,-z',
    '-x,y,z',
    '-x,y+1/2,-z',
    ) : ['P M 21 B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z',
    '-x,y,z',
    '-x,y+1/2,-z',
    'x+1/2,y,z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y,z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    ) : ['B M 21 B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z',
    'x+1/2,-y,-z',
    'x+1/2,-y+1/2,z',
    ) : ['P 21 A B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,y,-z+1/2',
    ) : ['I 1 1 B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z',
    'x+1/2,y,z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    ) : ['B 1 1 B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z',
    'x,-y,-z',
    'x,-y+1/2,z',
    ) : ['P 2 M B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z',
    'x,-y,-z',
    'x,-y+1/2,z',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,y,-z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['I 2 M B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z',
    'x,-y,-z',
    'x,-y+1/2,z',
    'x+1/2,y,z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    'x+1/2,-y,-z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['B 2 M B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    '-x,y,-z',
    ) : ['P N 2 B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z+1/2',
    '-x,y,z+1/2',
    '-x,y+1/2,-z',
    ) : ['P C 21 B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z+1/2',
    'x+1/2,-y,-z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['P 21 N B'] ,
    (
    'x,y,z',
    'x,y+1/2,-z+1/2',
    'x,-y,-z',
    'x,-y+1/2,z+1/2',
    ) : ['P 2 C B'] ,
    (
    'x,y,z',
    'x,y,-z',
    ) : ['P 1 1 M'] ,
    (
    'x,y,z',
    'x,y,-z',
    '-x,y+1/2,z',
    '-x,y+1/2,-z',
    ) : ['P B 21 M'] ,
    (
    'x,y,z',
    'x,y,-z',
    '-x,y+1/2,z',
    '-x,y+1/2,-z',
    'x+1/2,y,z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    ) : ['B B 21 M'] ,
    (
    'x,y,z',
    'x,y,-z',
    '-x,y+1/2,z+1/2',
    '-x,y+1/2,-z+1/2',
    ) : ['P N 21 M'] ,
    (
    'x,y,z',
    'x,y,-z',
    '-x,y,z',
    '-x,y,-z',
    ) : ['P M 2 M'] ,
    (
    'x,y,z',
    'x,y,-z',
    '-x,y,z',
    '-x,y,-z',
    'x+1/2,y+1/2,z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    '-x+1/2,y+1/2,-z',
    ) : ['C M 2 M'] ,
    (
    'x,y,z',
    'x,y,-z',
    '-x,y,z',
    '-x,y,-z',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    ) : ['I M 2 M'] ,
    (
    'x,y,z',
    'x,y,-z',
    '-x,y,z',
    '-x,y,-z',
    'x+1/2,y,z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    '-x+1/2,y,-z+1/2',
    ) : ['B M 2 M'] ,
    (
    'x,y,z',
    'x,y,-z',
    '-x,y,z',
    '-x,y,-z',
    'x,y+1/2,z+1/2',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    '-x,y+1/2,-z+1/2',
    ) : ['A M 2 M'] ,
    (
    'x,y,z',
    'x,y,-z',
    '-x,y,z',
    '-x,y,-z',
    'x,y+1/2,z+1/2',
    'x,y+1/2,-z+1/2',
    '-x,y+1/2,z+1/2',
    '-x,y+1/2,-z+1/2',
    'x+1/2,y,z+1/2',
    'x+1/2,y,-z+1/2',
    '-x+1/2,y,z+1/2',
    '-x+1/2,y,-z+1/2',
    'x+1/2,y+1/2,z',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    '-x+1/2,y+1/2,-z',
    ) : ['F M 2 M'] ,
    (
    'x,y,z',
    'x,y,-z',
    'x+1/2,-y,-z',
    'x+1/2,-y,z',
    ) : ['P 21 A M'] ,
    (
    'x,y,z',
    'x,y,-z',
    'x+1/2,-y,-z',
    'x+1/2,-y,z',
    'x,y+1/2,z+1/2',
    'x,y+1/2,-z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['A 21 A M'] ,
    (
    'x,y,z',
    'x,y,-z',
    'x+1/2,-y,-z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['P 21 N M'] ,
    (
    'x,y,z',
    'x,y,-z',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    ) : ['I 1 1 M'] ,
    (
    'x,y,z',
    'x,y,-z',
    'x+1/2,y,z+1/2',
    'x+1/2,y,-z+1/2',
    ) : ['B 1 1 M'] ,
    (
    'x,y,z',
    'x,y,-z',
    'x,-y,-z',
    'x,-y,z',
    ) : ['P 2 M M'] ,
    (
    'x,y,z',
    'x,y,-z',
    'x,-y,-z',
    'x,-y,z',
    'x+1/2,y+1/2,z',
    'x+1/2,y+1/2,-z',
    'x+1/2,-y+1/2,-z',
    'x+1/2,-y+1/2,z',
    ) : ['C 2 M M'] ,
    (
    'x,y,z',
    'x,y,-z',
    'x,-y,-z',
    'x,-y,z',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,y+1/2,-z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['I 2 M M'] ,
    (
    'x,y,z',
    'x,y,-z',
    'x,-y,-z',
    'x,-y,z',
    'x+1/2,y,z+1/2',
    'x+1/2,y,-z+1/2',
    'x+1/2,-y,-z+1/2',
    'x+1/2,-y,z+1/2',
    ) : ['B 2 M M'] ,
    (
    'x,y,z',
    'x,y,-z',
    'x,-y,-z',
    'x,-y,z',
    'x,y+1/2,z+1/2',
    'x,y+1/2,-z+1/2',
    'x,-y+1/2,-z+1/2',
    'x,-y+1/2,z+1/2',
    ) : ['A 2 M M'] ,
    (
    'x,y,z',
    'x,y,-z',
    'x,-y,-z',
    'x,-y,z',
    'x,y+1/2,z+1/2',
    'x,y+1/2,-z+1/2',
    'x,-y+1/2,-z+1/2',
    'x,-y+1/2,z+1/2',
    'x+1/2,y,z+1/2',
    'x+1/2,y,-z+1/2',
    'x+1/2,-y,-z+1/2',
    'x+1/2,-y,z+1/2',
    'x+1/2,y+1/2,z',
    'x+1/2,y+1/2,-z',
    'x+1/2,-y+1/2,-z',
    'x+1/2,-y+1/2,z',
    ) : ['F 2 M M'] ,
    (
    'x,y,z',
    'x,y,-z',
    'x,y+1/2,z+1/2',
    'x,y+1/2,-z+1/2',
    ) : ['A 1 1 M'] ,
    (
    'x,y,z',
    'x,y,-z+1/2',
    '-x,y,z+1/2',
    '-x,y,-z',
    ) : ['P C 2 M'] ,
    (
    'x,y,z',
    'x,y,-z+1/2',
    '-x,y,z+1/2',
    '-x,y,-z',
    'x+1/2,y+1/2,z',
    'x+1/2,y+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    '-x+1/2,y+1/2,-z',
    ) : ['C C 2 M'] ,
    (
    'x,y,z',
    'x,y,-z+1/2',
    '-x,y,z+1/2',
    '-x,y,-z',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,y+1/2,-z',
    '-x+1/2,y+1/2,z',
    '-x+1/2,y+1/2,-z+1/2',
    ) : ['I C 2 M'] ,
    (
    'x,y,z',
    'x,y,-z+1/2',
    'x,-y,-z',
    'x,-y,z+1/2',
    ) : ['P 2 C M'] ,
    (
    'x,y,z',
    'x,y,-z+1/2',
    'x,-y,-z',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z',
    'x+1/2,y+1/2,-z+1/2',
    'x+1/2,-y+1/2,-z',
    'x+1/2,-y+1/2,z+1/2',
    ) : ['C 2 C M'] ,
    (
    'x,y,z',
    'x,y,-z+1/2',
    'x,-y,-z',
    'x,-y,z+1/2',
    'x+1/2,y+1/2,z+1/2',
    'x+1/2,y+1/2,-z',
    'x+1/2,-y+1/2,-z+1/2',
    'x+1/2,-y+1/2,z',
    ) : ['I 2 C M'] ,
    (
    'x,y,z',
    'x-y,x,z',
    '-y,x-y,z',
    '-x,-y,z',
    '-x+y,-x,z',
    'y,-x+y,z',
    ) : ['P 6'] ,
    (
    'x,y,z',
    'x-y,x,z',
    '-y,x-y,z',
    '-x,-y,z',
    '-x+y,-x,z',
    'y,-x+y,z',
    '-x,-y,-z',
    '-x+y,-x,-z',
    'y,-x+y,-z',
    'x,y,-z',
    'x-y,x,-z',
    '-y,x-y,-z',
    ) : ['P 6/M'] ,
    (
    'x,y,z',
    'x-y,x,z',
    '-y,x-y,z',
    '-x,-y,z',
    '-x+y,-x,z',
    'y,-x+y,z',
    '-y,-x,-z',
    'x-y,-y,-z',
    'x,x-y,-z',
    'y,x,-z',
    '-x+y,y,-z',
    '-x,-x+y,-z',
    ) : ['P 6 2 2'] ,
    (
    'x,y,z',
    'x-y,x,z',
    '-y,x-y,z',
    '-x,-y,z',
    '-x+y,-x,z',
    'y,-x+y,z',
    '-y,-x,-z',
    'x-y,-y,-z',
    'x,x-y,-z',
    'y,x,-z',
    '-x+y,y,-z',
    '-x,-x+y,-z',
    '-x,-y,-z',
    '-x+y,-x,-z',
    'y,-x+y,-z',
    'x,y,-z',
    'x-y,x,-z',
    '-y,x-y,-z',
    'y,x,z',
    '-x+y,y,z',
    '-x,-x+y,z',
    '-y,-x,z',
    'x-y,-y,z',
    'x,x-y,z',
    ) : ['P 6/M M M'] ,
    (
    'x,y,z',
    'x-y,x,z',
    '-y,x-y,z',
    '-x,-y,z',
    '-x+y,-x,z',
    'y,-x+y,z',
    '-y,-x,-z+1/2',
    'x-y,-y,-z+1/2',
    'x,x-y,-z+1/2',
    'y,x,-z+1/2',
    '-x+y,y,-z+1/2',
    '-x,-x+y,-z+1/2',
    '-x,-y,-z',
    '-x+y,-x,-z',
    'y,-x+y,-z',
    'x,y,-z',
    'x-y,x,-z',
    '-y,x-y,-z',
    'y,x,z+1/2',
    '-x+y,y,z+1/2',
    '-x,-x+y,z+1/2',
    '-y,-x,z+1/2',
    'x-y,-y,z+1/2',
    'x,x-y,z+1/2',
    ) : ['P 6/M C C'] ,
    (
    'x,y,z',
    'x-y,x,z',
    '-y,x-y,z',
    '-x,-y,z',
    '-x+y,-x,z',
    'y,-x+y,z',
    'y,x,z',
    '-x+y,y,z',
    '-x,-x+y,z',
    '-y,-x,z',
    'x-y,-y,z',
    'x,x-y,z',
    ) : ['P 6 M M'] ,
    (
    'x,y,z',
    'x-y,x,z',
    '-y,x-y,z',
    '-x,-y,z',
    '-x+y,-x,z',
    'y,-x+y,z',
    'y,x,z+1/2',
    '-x+y,y,z+1/2',
    '-x,-x+y,z+1/2',
    '-y,-x,z+1/2',
    'x-y,-y,z+1/2',
    'x,x-y,z+1/2',
    ) : ['P 6 C C'] ,
    (
    'x,y,z',
    'x-y,x,z+1/2',
    '-y,x-y,z',
    '-x,-y,z+1/2',
    '-x+y,-x,z',
    'y,-x+y,z+1/2',
    ) : ['P 63'] ,
    (
    'x,y,z',
    'x-y,x,z+1/2',
    '-y,x-y,z',
    '-x,-y,z+1/2',
    '-x+y,-x,z',
    'y,-x+y,z+1/2',
    '-x,-y,-z',
    '-x+y,-x,-z+1/2',
    'y,-x+y,-z',
    'x,y,-z+1/2',
    'x-y,x,-z',
    '-y,x-y,-z+1/2',
    ) : ['P 63/M'] ,
    (
    'x,y,z',
    'x-y,x,z+1/2',
    '-y,x-y,z',
    '-x,-y,z+1/2',
    '-x+y,-x,z',
    'y,-x+y,z+1/2',
    '-y,-x,-z',
    'x-y,-y,-z+1/2',
    'x,x-y,-z',
    'y,x,-z+1/2',
    '-x+y,y,-z',
    '-x,-x+y,-z+1/2',
    '-x,-y,-z',
    '-x+y,-x,-z+1/2',
    'y,-x+y,-z',
    'x,y,-z+1/2',
    'x-y,x,-z',
    '-y,x-y,-z+1/2',
    'y,x,z',
    '-x+y,y,z+1/2',
    '-x,-x+y,z',
    '-y,-x,z+1/2',
    'x-y,-y,z',
    'x,x-y,z+1/2',
    ) : ['P 63/M C M'] ,
    (
    'x,y,z',
    'x-y,x,z+1/2',
    '-y,x-y,z',
    '-x,-y,z+1/2',
    '-x+y,-x,z',
    'y,-x+y,z+1/2',
    '-y,-x,-z+1/2',
    'x-y,-y,-z',
    'x,x-y,-z+1/2',
    'y,x,-z',
    '-x+y,y,-z+1/2',
    '-x,-x+y,-z',
    ) : ['P 63 2 2'] ,
    (
    'x,y,z',
    'x-y,x,z+1/2',
    '-y,x-y,z',
    '-x,-y,z+1/2',
    '-x+y,-x,z',
    'y,-x+y,z+1/2',
    '-y,-x,-z+1/2',
    'x-y,-y,-z',
    'x,x-y,-z+1/2',
    'y,x,-z',
    '-x+y,y,-z+1/2',
    '-x,-x+y,-z',
    '-x,-y,-z',
    '-x+y,-x,-z+1/2',
    'y,-x+y,-z',
    'x,y,-z+1/2',
    'x-y,x,-z',
    '-y,x-y,-z+1/2',
    'y,x,z+1/2',
    '-x+y,y,z',
    '-x,-x+y,z+1/2',
    '-y,-x,z',
    'x-y,-y,z+1/2',
    'x,x-y,z',
    ) : ['P 63/M M C'] ,
    (
    'x,y,z',
    'x-y,x,z+1/2',
    '-y,x-y,z',
    '-x,-y,z+1/2',
    '-x+y,-x,z',
    'y,-x+y,z+1/2',
    'y,x,z',
    '-x+y,y,z+1/2',
    '-x,-x+y,z',
    '-y,-x,z+1/2',
    'x-y,-y,z',
    'x,x-y,z+1/2',
    ) : ['P 63 C M'] ,
    (
    'x,y,z',
    'x-y,x,z+1/2',
    '-y,x-y,z',
    '-x,-y,z+1/2',
    '-x+y,-x,z',
    'y,-x+y,z+1/2',
    'y,x,z+1/2',
    '-x+y,y,z',
    '-x,-x+y,z+1/2',
    '-y,-x,z',
    'x-y,-y,z+1/2',
    'x,x-y,z',
    ) : ['P 63 M C'] ,
    (
    'x,y,z',
    'x-y,x,z+1/3',
    '-y,x-y,z+2/3',
    '-x,-y,z',
    '-x+y,-x,z+1/3',
    'y,-x+y,z+2/3',
    ) : ['P 62'] ,
    (
    'x,y,z',
    'x-y,x,z+1/3',
    '-y,x-y,z+2/3',
    '-x,-y,z',
    '-x+y,-x,z+1/3',
    'y,-x+y,z+2/3',
    '-y,-x,-z+2/3',
    'x-y,-y,-z',
    'x,x-y,-z+1/3',
    'y,x,-z+2/3',
    '-x+y,y,-z',
    '-x,-x+y,-z+1/3',
    ) : ['P 62 2 2'] ,
    (
    'x,y,z',
    'x-y,x,z+1/6',
    '-y,x-y,z+1/3',
    '-x,-y,z+1/2',
    '-x+y,-x,z+2/3',
    'y,-x+y,z+5/6',
    ) : ['P 61'] ,
    (
    'x,y,z',
    'x-y,x,z+1/6',
    '-y,x-y,z+1/3',
    '-x,-y,z+1/2',
    '-x+y,-x,z+2/3',
    'y,-x+y,z+5/6',
    '-y,-x,-z+5/6',
    'x-y,-y,-z',
    'x,x-y,-z+1/6',
    'y,x,-z+1/3',
    '-x+y,y,-z+1/2',
    '-x,-x+y,-z+2/3',
    ) : ['P 61 2 2'] ,
    (
    'x,y,z',
    'x-y,x,z+2/3',
    '-y,x-y,z+1/3',
    '-x,-y,z',
    '-x+y,-x,z+2/3',
    'y,-x+y,z+1/3',
    ) : ['P 64'] ,
    (
    'x,y,z',
    'x-y,x,z+2/3',
    '-y,x-y,z+1/3',
    '-x,-y,z',
    '-x+y,-x,z+2/3',
    'y,-x+y,z+1/3',
    '-y,-x,-z+1/3',
    'x-y,-y,-z',
    'x,x-y,-z+2/3',
    'y,x,-z+1/3',
    '-x+y,y,-z',
    '-x,-x+y,-z+2/3',
    ) : ['P 64 2 2'] ,
    (
    'x,y,z',
    'x-y,x,z+5/6',
    '-y,x-y,z+2/3',
    '-x,-y,z+1/2',
    '-x+y,-x,z+1/3',
    'y,-x+y,z+1/6',
    ) : ['P 65'] ,
    (
    'x,y,z',
    'x-y,x,z+5/6',
    '-y,x-y,z+2/3',
    '-x,-y,z+1/2',
    '-x+y,-x,z+1/3',
    'y,-x+y,z+1/6',
    '-y,-x,-z+1/6',
    'x-y,-y,-z',
    'x,x-y,-z+5/6',
    'y,x,-z+2/3',
    '-x+y,y,-z+1/2',
    '-x,-x+y,-z+1/3',
    ) : ['P 65 2 2'] ,
    (
    'x,y,z',
    'y+1/2,-x+1/2,-z+1/2',
    '-x,-y,z',
    '-y+1/2,x+1/2,-z+1/2',
    'x,-y,-z',
    '-y+1/2,-x+1/2,z+1/2',
    '-x,y,-z',
    'y+1/2,x+1/2,z+1/2',
    'z,x,y',
    'x+1/2,-z+1/2,-y+1/2',
    '-z,-x,y',
    '-x+1/2,z+1/2,-y+1/2',
    'z,-x,-y',
    '-x+1/2,-z+1/2,y+1/2',
    '-z,x,-y',
    'x+1/2,z+1/2,y+1/2',
    'y,z,x',
    'y,-z,-x',
    '-z+1/2,-y+1/2,x+1/2',
    '-y,z,-x',
    'z+1/2,y+1/2,x+1/2',
    '-y,-z,x',
    '-z+1/2,y+1/2,-x+1/2',
    'z+1/2,-y+1/2,-x+1/2',
    ) : ['P -4 3 N'] ,
    (
    'x,y,z',
    'y+1/2,-x,-z',
    '-x+1/2,-y+1/2,z',
    '-y,x+1/2,-z',
    'x,-y,-z',
    '-y+1/2,-x,z',
    '-x+1/2,y+1/2,-z',
    'y,x+1/2,z',
    'z,x,y',
    'x+1/2,-z,-y',
    '-z+1/2,-x+1/2,y',
    '-x,z+1/2,-y',
    'z,-x,-y',
    '-x+1/2,-z,y',
    '-z+1/2,x+1/2,-y',
    'x,z+1/2,y',
    'y,z,x',
    'y,-z+1/2,-x+1/2',
    '-z,-y,x+1/2',
    '-y+1/2,z,-x+1/2',
    'z+1/2,y,x',
    '-y,-z,x',
    '-z,y,-x+1/2',
    'z+1/2,-y+1/2,-x+1/2',
    'x,y+1/2,z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    '-x+1/2,-y,z+1/2',
    '-y,x,-z+1/2',
    'x,-y+1/2,-z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    '-x+1/2,y,-z+1/2',
    'y,x,z+1/2',
    'z,x+1/2,y+1/2',
    'x+1/2,-z+1/2,-y+1/2',
    '-z+1/2,-x,y+1/2',
    '-x,z,-y+1/2',
    'z,-x+1/2,-y+1/2',
    '-x+1/2,-z+1/2,y+1/2',
    '-z+1/2,x,-y+1/2',
    'x,z,y+1/2',
    'y,z+1/2,x+1/2',
    'y,-z,-x',
    '-z,-y+1/2,x',
    '-y+1/2,z+1/2,-x',
    'z+1/2,y+1/2,x+1/2',
    '-y,-z+1/2,x+1/2',
    '-z,y+1/2,-x',
    'z+1/2,-y,-x',
    'x+1/2,y,z+1/2',
    'y,-x,-z+1/2',
    '-x,-y+1/2,z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    'x+1/2,-y,-z+1/2',
    '-y,-x,z+1/2',
    '-x,y+1/2,-z+1/2',
    'y+1/2,x+1/2,z+1/2',
    'z+1/2,x,y+1/2',
    'x,-z,-y+1/2',
    '-z,-x+1/2,y+1/2',
    '-x+1/2,z+1/2,-y+1/2',
    'z+1/2,-x,-y+1/2',
    '-x,-z,y+1/2',
    '-z,x+1/2,-y+1/2',
    'x+1/2,z+1/2,y+1/2',
    'y+1/2,z,x+1/2',
    'y+1/2,-z+1/2,-x',
    '-z+1/2,-y,x',
    '-y,z,-x',
    'z,y,x+1/2',
    '-y+1/2,-z,x+1/2',
    '-z+1/2,y,-x',
    'z,-y+1/2,-x',
    'x+1/2,y+1/2,z',
    'y,-x+1/2,-z',
    '-x,-y,z',
    '-y+1/2,x,-z',
    'x+1/2,-y+1/2,-z',
    '-y,-x+1/2,z',
    '-x,y,-z',
    'y+1/2,x,z',
    'z+1/2,x+1/2,y',
    'x,-z+1/2,-y',
    '-z,-x,y',
    '-x+1/2,z,-y',
    'z+1/2,-x+1/2,-y',
    '-x,-z+1/2,y',
    '-z,x,-y',
    'x+1/2,z,y',
    'y+1/2,z+1/2,x',
    'y+1/2,-z,-x+1/2',
    '-z+1/2,-y+1/2,x+1/2',
    '-y,z+1/2,-x+1/2',
    'z,y+1/2,x',
    '-y+1/2,-z+1/2,x',
    '-z+1/2,y+1/2,-x+1/2',
    'z,-y,-x+1/2',
    ) : ['F -4 3 C'] ,
    (
    'x,y,z',
    'y+1/4,-x+3/4,-z+1/4',
    '-x,-y+1/2,z',
    '-y+3/4,x+3/4,-z+1/4',
    'x,-y,-z+1/2',
    '-y+1/4,-x+3/4,z+3/4',
    '-x,y+1/2,-z+1/2',
    'y+3/4,x+3/4,z+3/4',
    'z,x,y',
    'x+1/4,-z+3/4,-y+1/4',
    '-z,-x+1/2,y',
    '-x+3/4,z+3/4,-y+1/4',
    'z,-x,-y+1/2',
    '-x+1/4,-z+3/4,y+3/4',
    '-z,x+1/2,-y+1/2',
    'x+3/4,z+3/4,y+3/4',
    'y,z,x',
    'y,-z,-x+1/2',
    '-z+1/4,-y+3/4,x+3/4',
    '-y,z+1/2,-x+1/2',
    'z+1/4,y+1/4,x+1/4',
    '-y+1/2,-z,x+1/2',
    '-z+1/4,y+1/4,-x+3/4',
    'z+3/4,-y+1/4,-x+3/4',
    'x+1/2,y+1/2,z+1/2',
    'y+3/4,-x+1/4,-z+3/4',
    '-x+1/2,-y,z+1/2',
    '-y+1/4,x+1/4,-z+3/4',
    'x+1/2,-y+1/2,-z',
    '-y+3/4,-x+1/4,z+1/4',
    '-x+1/2,y,-z',
    'y+1/4,x+1/4,z+1/4',
    'z+1/2,x+1/2,y+1/2',
    'x+3/4,-z+1/4,-y+3/4',
    '-z+1/2,-x,y+1/2',
    '-x+1/4,z+1/4,-y+3/4',
    'z+1/2,-x+1/2,-y',
    '-x+3/4,-z+1/4,y+1/4',
    '-z+1/2,x,-y',
    'x+1/4,z+1/4,y+1/4',
    'y+1/2,z+1/2,x+1/2',
    'y+1/2,-z+1/2,-x',
    '-z+3/4,-y+1/4,x+1/4',
    '-y+1/2,z,-x',
    'z+3/4,y+3/4,x+3/4',
    '-y,-z+1/2,x',
    '-z+3/4,y+3/4,-x+1/4',
    'z+1/4,-y+3/4,-x+1/4',
    ) : ['I -4 3 D'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    ) : ['P -4'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    '-x+1/2,y+1/2,z',
    'y+1/2,x+1/2,-z',
    'x+1/2,-y+1/2,z',
    '-y+1/2,-x+1/2,-z',
    ) : ['P -4 B 2'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    '-x+1/2,y+1/2,z+1/2',
    'y+1/2,x+1/2,-z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    '-y+1/2,-x+1/2,-z+1/2',
    ) : ['P -4 N 2'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    '-x,y,z',
    'y,x,-z',
    'x,-y,z',
    '-y,-x,-z',
    ) : ['P -4 M 2'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    '-x,y,z',
    'y,x,-z',
    'x,-y,z',
    '-y,-x,-z',
    'x+1/2,y+1/2,z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,z+1/2',
    'y+1/2,x+1/2,-z+1/2',
    'x+1/2,-y+1/2,z+1/2',
    '-y+1/2,-x+1/2,-z+1/2',
    ) : ['I -4 M 2'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    '-x,y,z+1/2',
    'y,x,-z+1/2',
    'x,-y,z+1/2',
    '-y,-x,-z+1/2',
    ) : ['P -4 C 2'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    '-x,y,z+1/2',
    'y,x,-z+1/2',
    'x,-y,z+1/2',
    '-y,-x,-z+1/2',
    'x+1/2,y+1/2,z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    '-x+1/2,y+1/2,z',
    'y+1/2,x+1/2,-z',
    'x+1/2,-y+1/2,z',
    '-y+1/2,-x+1/2,-z',
    ) : ['I -4 C 2'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    'x+1/2,-y+1/2,-z',
    '-y+1/2,-x+1/2,z',
    '-x+1/2,y+1/2,-z',
    'y+1/2,x+1/2,z',
    ) : ['P -4 21 M'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    'x+1/2,-y+1/2,-z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    'y+1/2,x+1/2,z+1/2',
    ) : ['P -4 21 C'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    'x+1/2,y+1/2,z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    ) : ['I -4'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    'x,-y+1/2,-z+1/4',
    '-y+1/2,-x,z+3/4',
    '-x,y+1/2,-z+1/4',
    'y+1/2,x,z+3/4',
    'x+1/2,y+1/2,z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    'x+1/2,-y,-z+3/4',
    '-y,-x+1/2,z+1/4',
    '-x+1/2,y,-z+3/4',
    'y,x+1/2,z+1/4',
    ) : ['I -4 2 D'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    'x,-y,-z',
    '-y,-x,z',
    '-x,y,-z',
    'y,x,z',
    ) : ['P -4 2 M'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    'x,-y,-z',
    '-y,-x,z',
    '-x,y,-z',
    'y,x,z',
    'x+1/2,y+1/2,z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    'y+1/2,x+1/2,z+1/2',
    ) : ['I -4 2 M'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    'x,-y,-z',
    '-y,-x,z',
    '-x,y,-z',
    'y,x,z',
    'z,x,y',
    'x,-z,-y',
    '-z,-x,y',
    '-x,z,-y',
    'z,-x,-y',
    '-x,-z,y',
    '-z,x,-y',
    'x,z,y',
    'y,z,x',
    'y,-z,-x',
    '-z,-y,x',
    '-y,z,-x',
    'z,y,x',
    '-y,-z,x',
    '-z,y,-x',
    'z,-y,-x',
    ) : ['P -4 3 M'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    'x,-y,-z',
    '-y,-x,z',
    '-x,y,-z',
    'y,x,z',
    'z,x,y',
    'x,-z,-y',
    '-z,-x,y',
    '-x,z,-y',
    'z,-x,-y',
    '-x,-z,y',
    '-z,x,-y',
    'x,z,y',
    'y,z,x',
    'y,-z,-x',
    '-z,-y,x',
    '-y,z,-x',
    'z,y,x',
    '-y,-z,x',
    '-z,y,-x',
    'z,-y,-x',
    'x+1/2,y+1/2,z+1/2',
    'y+1/2,-x+1/2,-z+1/2',
    '-x+1/2,-y+1/2,z+1/2',
    '-y+1/2,x+1/2,-z+1/2',
    'x+1/2,-y+1/2,-z+1/2',
    '-y+1/2,-x+1/2,z+1/2',
    '-x+1/2,y+1/2,-z+1/2',
    'y+1/2,x+1/2,z+1/2',
    'z+1/2,x+1/2,y+1/2',
    'x+1/2,-z+1/2,-y+1/2',
    '-z+1/2,-x+1/2,y+1/2',
    '-x+1/2,z+1/2,-y+1/2',
    'z+1/2,-x+1/2,-y+1/2',
    '-x+1/2,-z+1/2,y+1/2',
    '-z+1/2,x+1/2,-y+1/2',
    'x+1/2,z+1/2,y+1/2',
    'y+1/2,z+1/2,x+1/2',
    'y+1/2,-z+1/2,-x+1/2',
    '-z+1/2,-y+1/2,x+1/2',
    '-y+1/2,z+1/2,-x+1/2',
    'z+1/2,y+1/2,x+1/2',
    '-y+1/2,-z+1/2,x+1/2',
    '-z+1/2,y+1/2,-x+1/2',
    'z+1/2,-y+1/2,-x+1/2',
    ) : ['I -4 3 M'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    'x,-y,-z',
    '-y,-x,z',
    '-x,y,-z',
    'y,x,z',
    'z,x,y',
    'x,-z,-y',
    '-z,-x,y',
    '-x,z,-y',
    'z,-x,-y',
    '-x,-z,y',
    '-z,x,-y',
    'x,z,y',
    'y,z,x',
    'y,-z,-x',
    '-z,-y,x',
    '-y,z,-x',
    'z,y,x',
    '-y,-z,x',
    '-z,y,-x',
    'z,-y,-x',
    'x,y+1/2,z+1/2',
    'y,-x+1/2,-z+1/2',
    '-x,-y+1/2,z+1/2',
    '-y,x+1/2,-z+1/2',
    'x,-y+1/2,-z+1/2',
    '-y,-x+1/2,z+1/2',
    '-x,y+1/2,-z+1/2',
    'y,x+1/2,z+1/2',
    'z,x+1/2,y+1/2',
    'x,-z+1/2,-y+1/2',
    '-z,-x+1/2,y+1/2',
    '-x,z+1/2,-y+1/2',
    'z,-x+1/2,-y+1/2',
    '-x,-z+1/2,y+1/2',
    '-z,x+1/2,-y+1/2',
    'x,z+1/2,y+1/2',
    'y,z+1/2,x+1/2',
    'y,-z+1/2,-x+1/2',
    '-z,-y+1/2,x+1/2',
    '-y,z+1/2,-x+1/2',
    'z,y+1/2,x+1/2',
    '-y,-z+1/2,x+1/2',
    '-z,y+1/2,-x+1/2',
    'z,-y+1/2,-x+1/2',
    'x+1/2,y,z+1/2',
    'y+1/2,-x,-z+1/2',
    '-x+1/2,-y,z+1/2',
    '-y+1/2,x,-z+1/2',
    'x+1/2,-y,-z+1/2',
    '-y+1/2,-x,z+1/2',
    '-x+1/2,y,-z+1/2',
    'y+1/2,x,z+1/2',
    'z+1/2,x,y+1/2',
    'x+1/2,-z,-y+1/2',
    '-z+1/2,-x,y+1/2',
    '-x+1/2,z,-y+1/2',
    'z+1/2,-x,-y+1/2',
    '-x+1/2,-z,y+1/2',
    '-z+1/2,x,-y+1/2',
    'x+1/2,z,y+1/2',
    'y+1/2,z,x+1/2',
    'y+1/2,-z,-x+1/2',
    '-z+1/2,-y,x+1/2',
    '-y+1/2,z,-x+1/2',
    'z+1/2,y,x+1/2',
    '-y+1/2,-z,x+1/2',
    '-z+1/2,y,-x+1/2',
    'z+1/2,-y,-x+1/2',
    'x+1/2,y+1/2,z',
    'y+1/2,-x+1/2,-z',
    '-x+1/2,-y+1/2,z',
    '-y+1/2,x+1/2,-z',
    'x+1/2,-y+1/2,-z',
    '-y+1/2,-x+1/2,z',
    '-x+1/2,y+1/2,-z',
    'y+1/2,x+1/2,z',
    'z+1/2,x+1/2,y',
    'x+1/2,-z+1/2,-y',
    '-z+1/2,-x+1/2,y',
    '-x+1/2,z+1/2,-y',
    'z+1/2,-x+1/2,-y',
    '-x+1/2,-z+1/2,y',
    '-z+1/2,x+1/2,-y',
    'x+1/2,z+1/2,y',
    'y+1/2,z+1/2,x',
    'y+1/2,-z+1/2,-x',
    '-z+1/2,-y+1/2,x',
    '-y+1/2,z+1/2,-x',
    'z+1/2,y+1/2,x',
    '-y+1/2,-z+1/2,x',
    '-z+1/2,y+1/2,-x',
    'z+1/2,-y+1/2,-x',
    ) : ['F -4 3 M'] ,
    (
    'x,y,z',
    'y,-x,-z',
    '-x,-y,z',
    '-y,x,-z',
    'x,-y,-z+1/2',
    '-y,-x,z+1/2',
    '-x,y,-z+1/2',
    'y,x,z+1/2',
    ) : ['P -4 2 C'] ,
    (
    'x,y,z',
    'z,x,y',
    'y,z,x',
    ) : ['R 3 :R', 'R 3:R'] ,
    (
    'x,y,z',
    'z,x,y',
    'y,z,x',
    '-x,-y,-z',
    '-z,-x,-y',
    '-y,-z,-x',
    ) : ['R -3 :R', 'R -3:R'] ,
    (
    'x,y,z',
    'z,x,y',
    'y,z,x',
    '-y+1/2,-x+1/2,-z+1/2',
    '-z+1/2,-y+1/2,-x+1/2',
    '-x+1/2,-z+1/2,-y+1/2',
    '-x,-y,-z',
    '-z,-x,-y',
    '-y,-z,-x',
    'y+1/2,x+1/2,z+1/2',
    'z+1/2,y+1/2,x+1/2',
    'x+1/2,z+1/2,y+1/2',
    ) : ['R -3 C :R', 'R -3 C:R'] ,
    (
    'x,y,z',
    'z,x,y',
    'y,z,x',
    '-y,-x,-z',
    '-z,-y,-x',
    '-x,-z,-y',
    ) : ['R 3 2', 'R 3 2 :R', 'R 3 2:R'] ,
    (
    'x,y,z',
    'z,x,y',
    'y,z,x',
    '-y,-x,-z',
    '-z,-y,-x',
    '-x,-z,-y',
    '-x,-y,-z',
    '-z,-x,-y',
    '-y,-z,-x',
    'y,x,z',
    'z,y,x',
    'x,z,y',
    ) : ['R -3 M :R', 'R -3 M:R'] ,
    (
    'x,y,z',
    'z,x,y',
    'y,z,x',
    'y+1/2,x+1/2,z+1/2',
    'z+1/2,y+1/2,x+1/2',
    'x+1/2,z+1/2,y+1/2',
    ) : ['R 3 C :R', 'R 3 C:R'] ,
    (
    'x,y,z',
    'z,x,y',
    'y,z,x',
    'y,x,z',
    'z,y,x',
    'x,z,y',
    ) : ['R 3 M :R', 'R 3 M:R'] ,
}

sym_dict = {}

for key in sym_base.keys():
    for sym in sym_base[key]:
        sym_dict[sym] = key


space_group_map = {
    ""       : "",
    "P1"     : "P 1",       
    "P111"   : "P 1 1 1",    
    "A111"   : "A 1 1 1",
    "P-1"    : "P -1",
    "P1-"    : "P 1-",
    "P2"     : "P 2",
    "P121"   : "P 1 2 1",
    "P21"    : "P 21", 
    "P1211"  : "P 1 21 1", 
    "P1121"  : "P 1 1 21",
    "B2"     : "B 2",
    "B112"   : "B 1 1 2",
    "C2"     : "C 2",
    "C121"   : "C 1 2 1",
    "C1211"  : "C 1 21 1",
    "P222"   : "P 2 2 2",
    "P2221"  : "P 2 2 21",
    "P21212" : "P 21 21 2",
    "P21212A": "P 21 21 2A",
    "P21221" : "P 21 2 21",
    "P212121": "P 21 21 21",
    "B2212"  : "B 2 21 2",
    "C2221"  : "C 2 2 21",
    "C222"   : "C 2 2 2",
    "F222"   : "F 2 2 2",
    "I222"   : "I 2 2 2",
    "I212121": "I 21 21 21",
    "P4"     : "P 4",
    "P41"    : "P 41",
    "P42"    : "P 42",
    "P43"    : "P 43",
    "I4"     : "I 4",
    "I41"    : "I 41",
    "P422"   : "P 4 2 2",
    "P4212"  : "P 4 21 2",
    "P4122"  : "P 41 2 2",
    "P41212" : "P 41 21 2",
    "P4222"  : "P 42 2 2",
    "P42212" : "P 42 21 2",
    "P4322"  : "P 43 2 2",
    "P43212" : "P 43 21 2",
    "I422"   : "I 4 2 2",
    "I4132"  : "I 41 3 2",     
    "I432"   : "I 4 3 2",
    "I4122"  : "I 41 2 2",
    "P3"     : "P 3",
    "P31"    : "P 31",
    "P32"    : "P 32",
    "R3"     : "R 3",
    "H3"     : "H 3",
    "P312"   : "P 3 1 2",
    "P321"   : "P 3 2 1",
    "P3112"  : "P 31 1 2",
    "P3121"  : "P 31 2 1",
    "P3212"  : "P 32 1 2",
    "P3221"  : "P 32 2 1", 
    "H32"    : "H 3 2",
    "R32"    : "R 3 2",
    "P6"     : "P 6",
    "P61"    : "P 61",
    "P65"    : "P 65",
    "P62"    : "P 62",
    "P6222"  : "P 62 2 2",
    "P64"    : "P 64",
    "P63"    : "P 63",
    "P622"   : "P 6 2 2",
    "P6122"  : "P 61 2 2",
    "P6522"  : "P 65 2 2",
    "P6522"  : "P 65 2 2",
    "P6422"  : "P 64 2 2",
    "P6322"  : "P 63 2 2",
    "P23"    : "P 2 3",
    "F23"    : "F 2 3",
    "I23"    : "I 2 3",
    "P213"   : "P 21 3",
    "I213"   : "I 21 3",
    "F432"   : "F 4 3 2",
    "P432"   : "P 4 3 2",
    "P4232"  : "P 42 3 2",
    "P4332"  : "P 43 3 2",
    "P4132"  : "P 41 3 2",
    "F4132"  : "F 41 3 2" }
