# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

#### Public Classes

* [`apache`](#apache): Guides the basic setup and installation of Apache on your system.
* [`apache::dev`](#apache--dev): Installs Apache development libraries.
* [`apache::mod::actions`](#apache--mod--actions): Installs Apache mod_actions
* [`apache::mod::alias`](#apache--mod--alias): Installs and configures `mod_alias`.
* [`apache::mod::apreq2`](#apache--mod--apreq2): Installs `mod_apreq2`.
* [`apache::mod::auth_basic`](#apache--mod--auth_basic): Installs `mod_auth_basic`
* [`apache::mod::auth_cas`](#apache--mod--auth_cas): Installs and configures `mod_auth_cas`.
* [`apache::mod::auth_gssapi`](#apache--mod--auth_gssapi): Installs `mod_auth_gsappi`.
* [`apache::mod::auth_kerb`](#apache--mod--auth_kerb): Installs `mod_auth_kerb`
* [`apache::mod::auth_mellon`](#apache--mod--auth_mellon): Installs and configures `mod_auth_mellon`.
* [`apache::mod::auth_openidc`](#apache--mod--auth_openidc): Installs and configures `mod_auth_openidc`.
* [`apache::mod::authn_core`](#apache--mod--authn_core): Installs `mod_authn_core`.
* [`apache::mod::authn_dbd`](#apache--mod--authn_dbd): Installs `mod_authn_dbd`.
* [`apache::mod::authn_file`](#apache--mod--authn_file): Installs `mod_authn_file`.
* [`apache::mod::authnz_ldap`](#apache--mod--authnz_ldap): Installs `mod_authnz_ldap`.
* [`apache::mod::authnz_pam`](#apache--mod--authnz_pam): Installs `mod_authnz_pam`.
* [`apache::mod::authz_core`](#apache--mod--authz_core): Installs `mod_authz_core`.
* [`apache::mod::authz_groupfile`](#apache--mod--authz_groupfile): Installs `mod_authz_groupfile`
* [`apache::mod::authz_user`](#apache--mod--authz_user): Installs `mod_authz_user`
* [`apache::mod::autoindex`](#apache--mod--autoindex): Installs `mod_autoindex`
* [`apache::mod::cache`](#apache--mod--cache): Installs `mod_cache`
* [`apache::mod::cgi`](#apache--mod--cgi): Installs `mod_cgi`.
* [`apache::mod::cgid`](#apache--mod--cgid): Installs `mod_cgid`.
* [`apache::mod::cluster`](#apache--mod--cluster): Installs `mod_cluster`.
* [`apache::mod::data`](#apache--mod--data): Installs and configures `mod_data`.
* [`apache::mod::dav`](#apache--mod--dav): Installs `mod_dav`.
* [`apache::mod::dav_fs`](#apache--mod--dav_fs): Installs `mod_dav_fs`.
* [`apache::mod::dav_svn`](#apache--mod--dav_svn): Installs and configures `mod_dav_svn`.
* [`apache::mod::dbd`](#apache--mod--dbd): Installs `mod_dbd`.
* [`apache::mod::deflate`](#apache--mod--deflate): Installs and configures `mod_deflate`.
* [`apache::mod::dir`](#apache--mod--dir): Installs and configures `mod_dir`.
* [`apache::mod::disk_cache`](#apache--mod--disk_cache): Installs and configures `mod_disk_cache`.
* [`apache::mod::dumpio`](#apache--mod--dumpio): Installs and configures `mod_dumpio`.
* [`apache::mod::env`](#apache--mod--env): Installs `mod_env`.
* [`apache::mod::event`](#apache--mod--event): Installs and configures `mod_event`.
* [`apache::mod::expires`](#apache--mod--expires): Installs and configures `mod_expires`.
* [`apache::mod::ext_filter`](#apache--mod--ext_filter): Installs and configures `mod_ext_filter`.
* [`apache::mod::fcgid`](#apache--mod--fcgid): Installs and configures `mod_fcgid`.
* [`apache::mod::filter`](#apache--mod--filter): Installs `mod_filter`.
* [`apache::mod::geoip`](#apache--mod--geoip): Installs and configures `mod_geoip`.
* [`apache::mod::headers`](#apache--mod--headers): Installs and configures `mod_headers`.
* [`apache::mod::http2`](#apache--mod--http2): Installs and configures `mod_http2`.
* [`apache::mod::include`](#apache--mod--include): Installs `mod_include`.
* [`apache::mod::info`](#apache--mod--info): Installs and configures `mod_info`.
* [`apache::mod::intercept_form_submit`](#apache--mod--intercept_form_submit): Installs `mod_intercept_form_submit`.
* [`apache::mod::itk`](#apache--mod--itk): Installs MPM `mod_itk`.
* [`apache::mod::jk`](#apache--mod--jk): Installs `mod_jk`.
* [`apache::mod::lbmethod_bybusyness`](#apache--mod--lbmethod_bybusyness): Installs `lbmethod_bybusyness`.
* [`apache::mod::lbmethod_byrequests`](#apache--mod--lbmethod_byrequests): Installs `lbmethod_byrequests`.
* [`apache::mod::lbmethod_bytraffic`](#apache--mod--lbmethod_bytraffic): Installs `lbmethod_bytraffic`.
* [`apache::mod::lbmethod_heartbeat`](#apache--mod--lbmethod_heartbeat): Installs `lbmethod_heartbeat`.
* [`apache::mod::ldap`](#apache--mod--ldap): Installs and configures `mod_ldap`.
* [`apache::mod::log_forensic`](#apache--mod--log_forensic): Installs `mod_log_forensic`
* [`apache::mod::lookup_identity`](#apache--mod--lookup_identity): Installs `mod_lookup_identity`
* [`apache::mod::macro`](#apache--mod--macro): Installs `mod_macro`.
* [`apache::mod::md`](#apache--mod--md): Installs and configures `mod_md`.
* [`apache::mod::mime`](#apache--mod--mime): Installs and configures `mod_mime`.
* [`apache::mod::mime_magic`](#apache--mod--mime_magic): Installs and configures `mod_mime_magic`.
* [`apache::mod::negotiation`](#apache--mod--negotiation): Installs and configures `mod_negotiation`.
* [`apache::mod::nss`](#apache--mod--nss): Installs and configures `mod_nss`.
* [`apache::mod::pagespeed`](#apache--mod--pagespeed): Installs and manages mod_pagespeed, which is a Google module that rewrites web pages to reduce latency and bandwidth.

This module does *not* manage the software repositories needed to automatically install the
mod-pagespeed-stable package. The module does however require that the package be installed,
or be installable using the system's default package provider.  You should ensure that this
pre-requisite is met or declaring `apache::mod::pagespeed` will cause the puppet run to fail.
* [`apache::mod::passenger`](#apache--mod--passenger): Installs `mod_pasenger`.
> **Note**: This module support Passenger 4.0.0 and higher.
* [`apache::mod::perl`](#apache--mod--perl): Installs `mod_perl`.
* [`apache::mod::peruser`](#apache--mod--peruser): Installs `mod_peruser`.
* [`apache::mod::php`](#apache--mod--php): Installs `mod_php`.
* [`apache::mod::prefork`](#apache--mod--prefork): Installs and configures MPM `prefork`.
* [`apache::mod::proxy`](#apache--mod--proxy): Installs and configures `mod_proxy`.
* [`apache::mod::proxy_ajp`](#apache--mod--proxy_ajp): Installs `mod_proxy_ajp`.
* [`apache::mod::proxy_balancer`](#apache--mod--proxy_balancer): Installs and configures `mod_proxy_balancer`.
* [`apache::mod::proxy_connect`](#apache--mod--proxy_connect): Installs `mod_proxy_connect`.
* [`apache::mod::proxy_fcgi`](#apache--mod--proxy_fcgi): Installs `mod_proxy_fcgi`.
* [`apache::mod::proxy_html`](#apache--mod--proxy_html): Installs `mod_proxy_html`.
* [`apache::mod::proxy_http`](#apache--mod--proxy_http): Installs `mod_proxy_http`.
* [`apache::mod::proxy_http2`](#apache--mod--proxy_http2): Installs `mod_proxy_http2`.
* [`apache::mod::proxy_wstunnel`](#apache--mod--proxy_wstunnel): Installs `mod_proxy_wstunnel`.
* [`apache::mod::python`](#apache--mod--python): Installs and configures `mod_python`.
* [`apache::mod::remoteip`](#apache--mod--remoteip): Installs and configures `mod_remoteip`.
* [`apache::mod::reqtimeout`](#apache--mod--reqtimeout): Installs and configures `mod_reqtimeout`.
* [`apache::mod::rewrite`](#apache--mod--rewrite): Installs `mod_rewrite`.
* [`apache::mod::rpaf`](#apache--mod--rpaf): Installs and configures `mod_rpaf`.
* [`apache::mod::security`](#apache--mod--security): Installs and configures `mod_security`.
* [`apache::mod::setenvif`](#apache--mod--setenvif): Installs `mod_setenvif`.
* [`apache::mod::shib`](#apache--mod--shib): Installs and configures `mod_shib`.
* [`apache::mod::socache_shmcb`](#apache--mod--socache_shmcb): Installs `mod_socache_shmcb`.
* [`apache::mod::speling`](#apache--mod--speling): Installs `mod_spelling`.
* [`apache::mod::ssl`](#apache--mod--ssl): Installs `mod_ssl`.
* [`apache::mod::status`](#apache--mod--status): Installs and configures `mod_status`.
* [`apache::mod::suexec`](#apache--mod--suexec): Installs `mod_suexec`.
* [`apache::mod::userdir`](#apache--mod--userdir): Installs and configures `mod_userdir`.
* [`apache::mod::version`](#apache--mod--version): Installs `mod_version`.
* [`apache::mod::vhost_alias`](#apache--mod--vhost_alias): Installs Apache `mod_vhost_alias`.
* [`apache::mod::watchdog`](#apache--mod--watchdog): Installs and configures `mod_watchdog`.
* [`apache::mod::worker`](#apache--mod--worker): Installs and manages the MPM `worker`.
* [`apache::mod::wsgi`](#apache--mod--wsgi): Installs and configures `mod_wsgi`.
* [`apache::mod::xsendfile`](#apache--mod--xsendfile): Installs `mod_xsendfile`.
* [`apache::mpm::disable_mpm_event`](#apache--mpm--disable_mpm_event): disable Apache-Module event
* [`apache::mpm::disable_mpm_prefork`](#apache--mpm--disable_mpm_prefork): disable Apache-Module prefork
* [`apache::mpm::disable_mpm_worker`](#apache--mpm--disable_mpm_worker): disable Apache-Module worker
* [`apache::vhosts`](#apache--vhosts): Creates `apache::vhost` defined types.

#### Private Classes

* `apache::confd::no_accf`: Manages the `no-accf.conf` file.
* `apache::default_confd_files`: Helper for setting up default conf.d files.
* `apache::default_mods`: Installs and congfigures default mods for Apache
* `apache::mod::ssl::reload`: Manages the puppet_ssl folder for ssl file copies, which is needed to track changes for reloading service on changes
* `apache::package`: Installs an Apache MPM.
* `apache::params`: This class manages Apache parameters
* `apache::service`: Installs and configures Apache service.
* `apache::version`: Try to automatically detect the version by OS

### Defined types

#### Public Defined types

* [`apache::balancer`](#apache--balancer): This type will create an apache balancer cluster file inside the conf.d
directory.
* [`apache::balancermember`](#apache--balancermember): Defines members of `mod_proxy_balancer`
* [`apache::custom_config`](#apache--custom_config): Adds a custom configuration file to the Apache server's `conf.d` directory.
* [`apache::fastcgi::server`](#apache--fastcgi--server): Defines one or more external FastCGI servers to handle specific file types. Use this
defined type with `mod_fastcgi`.
* [`apache::listen`](#apache--listen): Adds `Listen` directives to `ports.conf` that define the
Apache server's or a virtual host's listening address and port.
* [`apache::mod`](#apache--mod): Installs packages for an Apache module that doesn't have a corresponding
`apache::mod::<MODULE NAME>` class.
* [`apache::namevirtualhost`](#apache--namevirtualhost): Enables name-based virtual hosts
* [`apache::vhost`](#apache--vhost): Allows specialised configurations for virtual hosts that possess requirements
outside of the defaults.
* [`apache::vhost::custom`](#apache--vhost--custom): A wrapper around the `apache::custom_config` defined type.
* [`apache::vhost::fragment`](#apache--vhost--fragment): Define a fragment within a vhost
* [`apache::vhost::proxy`](#apache--vhost--proxy): Configure a reverse proxy for a vhost

#### Private Defined types

* `apache::default_mods::load`: Helper used by `apache::default_mods`
* `apache::mpm`: Enables the use of Apache MPMs.
* `apache::peruser::multiplexer`: Checks if an Apache module has a class.
* `apache::peruser::processor`: Enables the `Peruser` module for FreeBSD only.
* `apache::security::rule_link`: Links the activated_rules from `apache::mod::security` to the respective CRS rules on disk.

### Functions

* [`apache::apache_pw_hash`](#apache--apache_pw_hash): DEPRECATED.  Use the function [`apache::pw_hash`](#apachepw_hash) instead.
* [`apache::authz_core_config`](#apache--authz_core_config): Function to generate the authz_core configuration directives.
* [`apache::bool2httpd`](#apache--bool2httpd): Transform a supposed boolean to On or Off. Passes all other values through.
* [`apache::pw_hash`](#apache--pw_hash): Hashes a password in a format suitable for htpasswd files read by apache.
* [`apache_pw_hash`](#apache_pw_hash): DEPRECATED.  Use the namespaced function [`apache::pw_hash`](#apachepw_hash) instead.
* [`bool2httpd`](#bool2httpd): DEPRECATED.  Use the namespaced function [`apache::bool2httpd`](#apachebool2httpd) instead.

### Data types

* [`Apache::LogLevel`](#Apache--LogLevel): A string that conforms to the Apache `LogLevel` syntax.
* [`Apache::ModProxyProtocol`](#Apache--ModProxyProtocol): Supported protocols / schemes by mod_proxy
* [`Apache::OIDCSettings`](#Apache--OIDCSettings): https://github.com/zmartzone/mod_auth_openidc/blob/master/auth_openidc.conf
* [`Apache::OnOff`](#Apache--OnOff): A string that is accepted in Apache config to turn something on or off
* [`Apache::ServerTokens`](#Apache--ServerTokens): A string that conforms to the Apache `ServerTokens` syntax.
* [`Apache::Vhost::Priority`](#Apache--Vhost--Priority): The priority on vhost
* [`Apache::Vhost::ProxyPass`](#Apache--Vhost--ProxyPass): Struct representing reverse proxy configuration for an Apache vhost, used by the Apache::Vhost::Proxy defined resource type.

### Tasks

* [`init`](#init): Allows you to perform apache service functions

## Classes

### <a name="apache"></a>`apache`

When this class is declared with the default options, Puppet:
- Installs the appropriate Apache software package and [required Apache modules](#default_mods) for your operating system.
- Places the required configuration files in a directory, with the [default location](#conf_dir) determined by your operating system.
- Configures the server with a default virtual host and standard port (`80`) and address (`\*`) bindings.
- Creates a document root directory determined by your operating system, typically `/var/www`.
- Starts the Apache service.

If an ldaps:// URL is specified, the mode becomes SSL and the setting of LDAPTrustedMode is ignored.

#### Examples

##### 

```puppet
class { 'apache': }
```

#### Parameters

The following parameters are available in the `apache` class:

* [`allow_encoded_slashes`](#-apache--allow_encoded_slashes)
* [`conf_dir`](#-apache--conf_dir)
* [`conf_template`](#-apache--conf_template)
* [`confd_dir`](#-apache--confd_dir)
* [`default_charset`](#-apache--default_charset)
* [`default_confd_files`](#-apache--default_confd_files)
* [`default_mods`](#-apache--default_mods)
* [`default_ssl_ca`](#-apache--default_ssl_ca)
* [`default_ssl_cert`](#-apache--default_ssl_cert)
* [`default_ssl_chain`](#-apache--default_ssl_chain)
* [`default_ssl_crl`](#-apache--default_ssl_crl)
* [`default_ssl_crl_path`](#-apache--default_ssl_crl_path)
* [`default_ssl_crl_check`](#-apache--default_ssl_crl_check)
* [`default_ssl_key`](#-apache--default_ssl_key)
* [`default_ssl_reload_on_change`](#-apache--default_ssl_reload_on_change)
* [`default_ssl_vhost`](#-apache--default_ssl_vhost)
* [`default_vhost`](#-apache--default_vhost)
* [`dev_packages`](#-apache--dev_packages)
* [`docroot`](#-apache--docroot)
* [`error_documents`](#-apache--error_documents)
* [`group`](#-apache--group)
* [`httpd_dir`](#-apache--httpd_dir)
* [`http_protocol_options`](#-apache--http_protocol_options)
* [`keepalive`](#-apache--keepalive)
* [`keepalive_timeout`](#-apache--keepalive_timeout)
* [`max_keepalive_requests`](#-apache--max_keepalive_requests)
* [`hostname_lookups`](#-apache--hostname_lookups)
* [`ldap_trusted_mode`](#-apache--ldap_trusted_mode)
* [`ldap_verify_server_cert`](#-apache--ldap_verify_server_cert)
* [`lib_path`](#-apache--lib_path)
* [`log_level`](#-apache--log_level)
* [`log_formats`](#-apache--log_formats)
* [`logroot`](#-apache--logroot)
* [`logroot_mode`](#-apache--logroot_mode)
* [`manage_group`](#-apache--manage_group)
* [`supplementary_groups`](#-apache--supplementary_groups)
* [`manage_user`](#-apache--manage_user)
* [`mod_dir`](#-apache--mod_dir)
* [`mod_libs`](#-apache--mod_libs)
* [`mod_packages`](#-apache--mod_packages)
* [`mpm_module`](#-apache--mpm_module)
* [`package_ensure`](#-apache--package_ensure)
* [`pidfile`](#-apache--pidfile)
* [`ports_file`](#-apache--ports_file)
* [`protocols`](#-apache--protocols)
* [`protocols_honor_order`](#-apache--protocols_honor_order)
* [`purge_configs`](#-apache--purge_configs)
* [`purge_vhost_dir`](#-apache--purge_vhost_dir)
* [`sendfile`](#-apache--sendfile)
* [`serveradmin`](#-apache--serveradmin)
* [`servername`](#-apache--servername)
* [`server_root`](#-apache--server_root)
* [`server_signature`](#-apache--server_signature)
* [`server_tokens`](#-apache--server_tokens)
* [`service_enable`](#-apache--service_enable)
* [`service_ensure`](#-apache--service_ensure)
* [`service_name`](#-apache--service_name)
* [`service_manage`](#-apache--service_manage)
* [`service_restart`](#-apache--service_restart)
* [`timeout`](#-apache--timeout)
* [`trace_enable`](#-apache--trace_enable)
* [`use_canonical_name`](#-apache--use_canonical_name)
* [`use_systemd`](#-apache--use_systemd)
* [`file_mode`](#-apache--file_mode)
* [`root_directory_options`](#-apache--root_directory_options)
* [`root_directory_secured`](#-apache--root_directory_secured)
* [`vhost_dir`](#-apache--vhost_dir)
* [`vhost_include_pattern`](#-apache--vhost_include_pattern)
* [`user`](#-apache--user)
* [`apache_name`](#-apache--apache_name)
* [`error_log`](#-apache--error_log)
* [`scriptalias`](#-apache--scriptalias)
* [`access_log_file`](#-apache--access_log_file)
* [`limitreqfields`](#-apache--limitreqfields)
* [`limitreqfieldsize`](#-apache--limitreqfieldsize)
* [`limitreqline`](#-apache--limitreqline)
* [`ip`](#-apache--ip)
* [`conf_enabled`](#-apache--conf_enabled)
* [`vhost_enable_dir`](#-apache--vhost_enable_dir)
* [`manage_vhost_enable_dir`](#-apache--manage_vhost_enable_dir)
* [`mod_enable_dir`](#-apache--mod_enable_dir)
* [`ssl_file`](#-apache--ssl_file)
* [`file_e_tag`](#-apache--file_e_tag)
* [`use_optional_includes`](#-apache--use_optional_includes)
* [`mime_types_additional`](#-apache--mime_types_additional)

##### <a name="-apache--allow_encoded_slashes"></a>`allow_encoded_slashes`

Data type: `Optional[Variant[Apache::OnOff, Enum['nodecode']]]`

Sets the server default for the `AllowEncodedSlashes` declaration, which modifies the
responses to URLs containing '\' and '/' characters. If not specified, this parameter omits
the declaration from the server's configuration and uses Apache's default setting of 'off'.

Default value: `undef`

##### <a name="-apache--conf_dir"></a>`conf_dir`

Data type: `Stdlib::Absolutepath`

Sets the directory where the Apache server's main configuration file is located.

Default value: `$apache::params::conf_dir`

##### <a name="-apache--conf_template"></a>`conf_template`

Data type: `String`

Defines the template used for the main Apache configuration file. Modifying this
parameter is potentially risky, as the apache module is designed to use a minimal
configuration file customized by `conf.d` entries.

Default value: `$apache::params::conf_template`

##### <a name="-apache--confd_dir"></a>`confd_dir`

Data type: `Stdlib::Absolutepath`

Sets the location of the Apache server's custom configuration directory.

Default value: `$apache::params::confd_dir`

##### <a name="-apache--default_charset"></a>`default_charset`

Data type: `Optional[String]`

Used as the `AddDefaultCharset` directive in the main configuration file.

Default value: `undef`

##### <a name="-apache--default_confd_files"></a>`default_confd_files`

Data type: `Boolean`

Determines whether Puppet generates a default set of includable Apache configuration files
in the directory defined by the `confd_dir` parameter. These configuration files
correspond to what is typically installed with the Apache package on the server's
operating system.

Default value: `true`

##### <a name="-apache--default_mods"></a>`default_mods`

Data type: `Variant[Array[String[1]], Boolean]`

Determines whether to configure and enable a set of default Apache modules depending on
your operating system.<br />
If `false`, Puppet includes only the Apache modules required to make the HTTP daemon work
on your operating system, and you can declare any other modules separately using the
`apache::mod::<MODULE NAME>` class or `apache::mod` defined type.<br />
If `true`, Puppet installs additional modules, depending on the operating system and
the value of the `mpm_module` parameter. Because these lists of
modules can change frequently, consult the Puppet module's code for up-to-date lists.<br />
If this parameter contains an array, Puppet instead enables all passed Apache modules.

Default value: `true`

##### <a name="-apache--default_ssl_ca"></a>`default_ssl_ca`

Data type: `Optional[Stdlib::Absolutepath]`

Sets the default certificate authority for the Apache server.<br />
Although the default value results in a functioning Apache server, you **must** update
this parameter with your certificate authority information before deploying this server in
a production environment.

Default value: `undef`

##### <a name="-apache--default_ssl_cert"></a>`default_ssl_cert`

Data type: `Stdlib::Absolutepath`

Sets the SSL encryption certificate location.<br />
Although the default value results in a functioning Apache server, you **must** update this
parameter with your certificate location before deploying this server in a production environment.

Default value: `$apache::params::default_ssl_cert`

##### <a name="-apache--default_ssl_chain"></a>`default_ssl_chain`

Data type: `Optional[Stdlib::Absolutepath]`

Sets the default SSL chain location.<br />
Although this default value results in a functioning Apache server, you **must** update
this parameter with your SSL chain before deploying this server in a production environment.

Default value: `undef`

##### <a name="-apache--default_ssl_crl"></a>`default_ssl_crl`

Data type: `Optional[Stdlib::Absolutepath]`

Sets the path of the default certificate revocation list (CRL) file to use.<br />
Although this default value results in a functioning Apache server, you **must** update
this parameter with the CRL file path before deploying this server in a production
environment. You can use this parameter with or in place of the `default_ssl_crl_path`.

Default value: `undef`

##### <a name="-apache--default_ssl_crl_path"></a>`default_ssl_crl_path`

Data type: `Optional[Stdlib::Absolutepath]`

Sets the server's certificate revocation list path, which contains your CRLs.<br />
Although this default value results in a functioning Apache server, you **must** update
this parameter with the CRL file path before deploying this server in a production environment.

Default value: `undef`

##### <a name="-apache--default_ssl_crl_check"></a>`default_ssl_crl_check`

Data type: `Optional[String]`

Sets the default certificate revocation check level via the `SSLCARevocationCheck` directive.
This parameter applies only to Apache 2.4 or higher and is ignored on older versions.<br />
Although this default value results in a functioning Apache server, you **must** specify
this parameter when using certificate revocation lists in a production environment.

Default value: `undef`

##### <a name="-apache--default_ssl_key"></a>`default_ssl_key`

Data type: `Stdlib::Absolutepath`

Sets the SSL certificate key file location.
Although the default values result in a functioning Apache server, you **must** update
this parameter with your SSL key's location before deploying this server in a production
environment.

Default value: `$apache::params::default_ssl_key`

##### <a name="-apache--default_ssl_reload_on_change"></a>`default_ssl_reload_on_change`

Data type: `Boolean`

Enable reloading of apache if the content of ssl files have changed.

Default value: `false`

##### <a name="-apache--default_ssl_vhost"></a>`default_ssl_vhost`

Data type: `Boolean`

Configures a default SSL virtual host.
If `true`, Puppet automatically configures the following virtual host using the
`apache::vhost` defined type:
```puppet
apache::vhost { 'default-ssl':
  port            => 443,
  ssl             => true,
  docroot         => $docroot,
  scriptalias     => $scriptalias,
  serveradmin     => $serveradmin,
  access_log_file => "ssl_${access_log_file}",
}
```
**Note**: SSL virtual hosts only respond to HTTPS queries.

Default value: `false`

##### <a name="-apache--default_vhost"></a>`default_vhost`

Data type: `Boolean`

Configures a default virtual host when the class is declared.<br />
To configure customized virtual hosts, set this parameter's
value to `false`.<br />
> **Note**: Apache will not start without at least one virtual host. If you set this
to `false` you must configure a virtual host elsewhere.

Default value: `true`

##### <a name="-apache--dev_packages"></a>`dev_packages`

Data type: `Optional[Variant[Array, String]]`

Configures a specific dev package to use.<br />
For example, using httpd 2.4 from the IUS yum repo:<br />
``` puppet
include ::apache::dev
class { 'apache':
  apache_name  => 'httpd24u',
  dev_packages => 'httpd24u-devel',
}
```

Default value: `$apache::params::dev_packages`

##### <a name="-apache--docroot"></a>`docroot`

Data type: `Stdlib::Absolutepath`

Sets the default `DocumentRoot` location.

Default value: `$apache::params::docroot`

##### <a name="-apache--error_documents"></a>`error_documents`

Data type: `Boolean`

Determines whether to enable [custom error documents](https://httpd.apache.org/docs/current/custom-error.html) on the Apache server.

Default value: `false`

##### <a name="-apache--group"></a>`group`

Data type: `String`

Sets the group ID that owns any Apache processes spawned to answer requests.<br />
By default, Puppet attempts to manage this group as a resource under the `apache`
class, determining the group based on the operating system as detected by the
`apache::params` class. To prevent the group resource from being created and use a group
created by another Puppet module, set the `manage_group` parameter's value to `false`.<br />
> **Note**: Modifying this parameter only changes the group ID that Apache uses to spawn
child processes to access resources. It does not change the user that owns the parent server
process.

Default value: `$apache::params::group`

##### <a name="-apache--httpd_dir"></a>`httpd_dir`

Data type: `Stdlib::Absolutepath`

Sets the Apache server's base configuration directory. This is useful for specially
repackaged Apache server builds but might have unintended consequences when combined
with the default distribution packages.

Default value: `$apache::params::httpd_dir`

##### <a name="-apache--http_protocol_options"></a>`http_protocol_options`

Data type: `Optional[String]`

Specifies the strictness of HTTP protocol checks.<br />
Valid options: any sequence of the following alternative values: `Strict` or `Unsafe`,
`RegisteredMethods` or `LenientMethods`, and `Allow0.9` or `Require1.0`.

Default value: `$apache::params::http_protocol_options`

##### <a name="-apache--keepalive"></a>`keepalive`

Data type: `Apache::OnOff`

Determines whether to enable persistent HTTP connections with the `KeepAlive` directive.
If you set this to `On`, use the `keepalive_timeout` and `max_keepalive_requests` parameters
to set relevant options.<br />

Default value: `$apache::params::keepalive`

##### <a name="-apache--keepalive_timeout"></a>`keepalive_timeout`

Data type: `Integer`

Sets the `KeepAliveTimeout` directive, which determines the amount of time the Apache
server waits for subsequent requests on a persistent HTTP connection. This parameter is
only relevant if the `keepalive` parameter is enabled.

Default value: `$apache::params::keepalive_timeout`

##### <a name="-apache--max_keepalive_requests"></a>`max_keepalive_requests`

Data type: `Integer`

Limits the number of requests allowed per connection when the `keepalive` parameter is enabled.

Default value: `$apache::params::max_keepalive_requests`

##### <a name="-apache--hostname_lookups"></a>`hostname_lookups`

Data type: `Variant[Apache::OnOff, Enum['Double', 'double']]`

This directive enables DNS lookups so that host names can be logged and passed to
CGIs/SSIs in REMOTE_HOST.<br />
> **Note**: If enabled, it impacts performance significantly.

Default value: `$apache::params::hostname_lookups`

##### <a name="-apache--ldap_trusted_mode"></a>`ldap_trusted_mode`

Data type: `Optional[String]`

The following modes are supported:

  NONE - no encryption
  SSL - ldaps:// encryption on default port 636
  TLS - STARTTLS encryption on default port 389
Not all LDAP toolkits support all the above modes. An error message will be logged at
runtime if a mode is not supported, and the connection to the LDAP server will fail.

Default value: `undef`

##### <a name="-apache--ldap_verify_server_cert"></a>`ldap_verify_server_cert`

Data type: `Optional[Apache::OnOff]`

Specifies whether to force the verification of a server certificate when establishing an SSL
connection to the LDAP server.
On|Off

Default value: `undef`

##### <a name="-apache--lib_path"></a>`lib_path`

Data type: `String`

Specifies the location whereApache module files are stored.<br />
> **Note**: Do not configure this parameter manually without special reason.

Default value: `$apache::params::lib_path`

##### <a name="-apache--log_level"></a>`log_level`

Data type: `Apache::LogLevel`

Configures the apache [LogLevel](https://httpd.apache.org/docs/current/mod/core.html#loglevel) directive
which adjusts the verbosity of the messages recorded in the error logs.

Default value: `$apache::params::log_level`

##### <a name="-apache--log_formats"></a>`log_formats`

Data type: `Hash`

Define additional `LogFormat` directives. Values: A hash, such as:
``` puppet
$log_formats = { vhost_common => '%v %h %l %u %t \"%r\" %>s %b' }
```
  There are a number of predefined `LogFormats` in the `httpd.conf` that Puppet creates:
``` httpd
  LogFormat "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"" combined
  LogFormat "%h %l %u %t \"%r\" %>s %b" common
  LogFormat "%{Referer}i -> %U" referer
  LogFormat "%{User-agent}i" agent
  LogFormat "%{X-Forwarded-For}i %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-agent}i\"" forwarded
```
If your `log_formats` parameter contains one of those, it will be overwritten with **your** definition.

Default value: `{}`

##### <a name="-apache--logroot"></a>`logroot`

Data type: `Stdlib::Absolutepath`

Changes the directory of Apache log files for the virtual host.

Default value: `$apache::params::logroot`

##### <a name="-apache--logroot_mode"></a>`logroot_mode`

Data type: `Optional[Stdlib::Filemode]`

Overrides the default `logroot` directory's mode.<br />
> **Note**: Do _not_ grant write access to the directory where the logs are stored
without being aware of the consequences. See the [Apache documentation](https://httpd.apache.org/docs/current/logs.html#security)
for details.

Default value: `$apache::params::logroot_mode`

##### <a name="-apache--manage_group"></a>`manage_group`

Data type: `Boolean`

When `false`, stops Puppet from creating the group resource.<br />
If you have a group created from another Puppet module that you want to use to run Apache,
set this to `false`. Without this parameter, attempting to use a previously established
group results in a duplicate resource error.

Default value: `true`

##### <a name="-apache--supplementary_groups"></a>`supplementary_groups`

Data type: `Array`

A list of groups to which the user belongs. These groups are in addition to the primary group.<br />
Notice: This option only has an effect when `manage_user` is set to true.

Default value: `[]`

##### <a name="-apache--manage_user"></a>`manage_user`

Data type: `Boolean`

When `false`, stops Puppet from creating the user resource.<br />
This is for instances when you have a user, created from another Puppet module, you want
to use to run Apache. Without this parameter, attempting to use a previously established
user would result in a duplicate resource error.

Default value: `true`

##### <a name="-apache--mod_dir"></a>`mod_dir`

Data type: `Stdlib::Absolutepath`

Sets where Puppet places configuration files for your Apache modules.

Default value: `$apache::params::mod_dir`

##### <a name="-apache--mod_libs"></a>`mod_libs`

Data type: `Hash`

Allows the user to override default module library names.
```puppet
include apache::params
class { 'apache':
  mod_libs => merge($::apache::params::mod_libs, {
    'wsgi' => 'mod_wsgi_python3.so',
  })
}
```

Default value: `$apache::params::mod_libs`

##### <a name="-apache--mod_packages"></a>`mod_packages`

Data type: `Hash`

Allows the user to override default module package names.
```puppet
include apache::params
class { 'apache':
  mod_packages => merge($::apache::params::mod_packages, {
    'auth_kerb' => 'httpd24-mod_auth_kerb',
  })
}
```

Default value: `$apache::params::mod_packages`

##### <a name="-apache--mpm_module"></a>`mpm_module`

Data type: `Variant[Boolean, Enum['event', 'itk', 'peruser', 'prefork', 'worker']]`

Determines which [multi-processing module](https://httpd.apache.org/docs/current/mpm.html) (MPM) is loaded and configured for the
HTTPD process. Valid values are: `event`, `itk`, `peruser`, `prefork`, `worker` or `false`.<br />
You must set this to `false` to explicitly declare the following classes with custom parameters:
- `apache::mod::event`
- `apache::mod::itk`
- `apache::mod::peruser`
- `apache::mod::prefork`
- `apache::mod::worker`

Default value: `$apache::params::mpm_module`

##### <a name="-apache--package_ensure"></a>`package_ensure`

Data type: `String`

Controls the `package` resource's `ensure` attribute. Valid values are: `absent`, `installed`
(or equivalent `present`), or a version string.

Default value: `'installed'`

##### <a name="-apache--pidfile"></a>`pidfile`

Data type: `String`

Allows settting a custom location for the pid file. Useful if using a custom-built Apache rpm.

Default value: `$apache::params::pidfile`

##### <a name="-apache--ports_file"></a>`ports_file`

Data type: `Stdlib::Absolutepath`

Sets the path to the file containing Apache ports configuration.

Default value: `$apache::params::ports_file`

##### <a name="-apache--protocols"></a>`protocols`

Data type: `Array[Enum['h2', 'h2c', 'http/1.1']]`

Sets the [Protocols](https://httpd.apache.org/docs/current/en/mod/core.html#protocols)
directive, which lists available protocols for the server.

Default value: `[]`

##### <a name="-apache--protocols_honor_order"></a>`protocols_honor_order`

Data type: `Optional[Boolean]`

Sets the [ProtocolsHonorOrder](https://httpd.apache.org/docs/current/en/mod/core.html#protocolshonororder)
directive which determines whether the order of Protocols sets precedence during negotiation.

Default value: `undef`

##### <a name="-apache--purge_configs"></a>`purge_configs`

Data type: `Boolean`

Removes all other Apache configs and virtual hosts.<br />
Setting this to `false` is a stopgap measure to allow the apache module to coexist with
existing or unmanaged configurations. We recommend moving your configuration to resources
within this module. For virtual host configurations, see `purge_vhost_dir`.

Default value: `true`

##### <a name="-apache--purge_vhost_dir"></a>`purge_vhost_dir`

Data type: `Optional[Boolean]`

If the `vhost_dir` parameter's value differs from the `confd_dir` parameter's, this parameter
determines whether Puppet removes any configurations inside `vhost_dir` that are _not_ managed
by Puppet.<br />
Setting `purge_vhost_dir` to `false` is a stopgap measure to allow the apache module to
coexist with existing or otherwise unmanaged configurations within `vhost_dir`.

Default value: `undef`

##### <a name="-apache--sendfile"></a>`sendfile`

Data type: `Apache::OnOff`

Forces Apache to use the Linux kernel's `sendfile` support to serve static files, via the
`EnableSendfile` directive.

Default value: `'On'`

##### <a name="-apache--serveradmin"></a>`serveradmin`

Data type: `Optional[String[1]]`

Sets the Apache server administrator's contact information via Apache's `ServerAdmin` directive.

Default value: `undef`

##### <a name="-apache--servername"></a>`servername`

Data type: `Optional[String]`

Sets the Apache server name via Apache's `ServerName` directive.
Setting to `false` will not set ServerName at all.

Default value: `$apache::params::servername`

##### <a name="-apache--server_root"></a>`server_root`

Data type: `Stdlib::Absolutepath`

Sets the Apache server's root directory via Apache's `ServerRoot` directive.

Default value: `$apache::params::server_root`

##### <a name="-apache--server_signature"></a>`server_signature`

Data type: `Variant[Apache::OnOff, String]`

Configures a trailing footer line to display at the bottom of server-generated documents,
such as error documents and output of certain Apache modules, via Apache's `ServerSignature`
directive. Valid values are: `On` or `Off`.

Default value: `'On'`

##### <a name="-apache--server_tokens"></a>`server_tokens`

Data type: `Apache::ServerTokens`

Controls how much information Apache sends to the browser about itself and the operating
system, via Apache's `ServerTokens` directive.

Default value: `'Prod'`

##### <a name="-apache--service_enable"></a>`service_enable`

Data type: `Boolean`

Determines whether Puppet enables the Apache HTTPD service when the system is booted.

Default value: `true`

##### <a name="-apache--service_ensure"></a>`service_ensure`

Data type: `Variant[Stdlib::Ensure::Service, Boolean]`

Determines whether Puppet should make sure the service is running.
Valid values are: `true` (or `running`) or `false` (or `stopped`).<br />
The `false` or `stopped` values set the 'httpd' service resource's `ensure` parameter
to `false`, which is useful when you want to let the service be managed by another
application, such as Pacemaker.<br />

Default value: `'running'`

##### <a name="-apache--service_name"></a>`service_name`

Data type: `String`

Sets the name of the Apache service.

Default value: `$apache::params::service_name`

##### <a name="-apache--service_manage"></a>`service_manage`

Data type: `Boolean`

Determines whether Puppet manages the HTTPD service's state.

Default value: `true`

##### <a name="-apache--service_restart"></a>`service_restart`

Data type: `Optional[String]`

Determines whether Puppet should use a specific command to restart the HTTPD service.
Values: a command to restart the Apache service.

Default value: `undef`

##### <a name="-apache--timeout"></a>`timeout`

Data type: `Integer[0]`

Sets Apache's `TimeOut` directive, which defines the number of seconds Apache waits for
certain events before failing a request.

Default value: `60`

##### <a name="-apache--trace_enable"></a>`trace_enable`

Data type: `Variant[Apache::OnOff, Enum['extended']]`

Controls how Apache handles `TRACE` requests (per RFC 2616) via the `TraceEnable` directive.

Default value: `'On'`

##### <a name="-apache--use_canonical_name"></a>`use_canonical_name`

Data type: `Optional[Variant[Apache::OnOff, Enum['DNS', 'dns']]]`

Controls Apache's `UseCanonicalName` directive which controls how Apache handles
self-referential URLs. If not specified, this parameter omits the declaration from the
server's configuration and uses Apache's default setting of 'off'.

Default value: `undef`

##### <a name="-apache--use_systemd"></a>`use_systemd`

Data type: `Boolean`

Controls whether the systemd module should be installed on Centos 7 servers, this is
especially useful if using custom-built RPMs.

Default value: `$apache::params::use_systemd`

##### <a name="-apache--file_mode"></a>`file_mode`

Data type: `Stdlib::Filemode`

Sets the desired permissions mode for config files.
Valid values are: a string, with permissions mode in symbolic or numeric notation.

Default value: `$apache::params::file_mode`

##### <a name="-apache--root_directory_options"></a>`root_directory_options`

Data type: `Array`

Array of the desired options for the `/` directory in httpd.conf.

Default value: `$apache::params::root_directory_options`

##### <a name="-apache--root_directory_secured"></a>`root_directory_secured`

Data type: `Boolean`

Sets the default access policy for the `/` directory in httpd.conf. A value of `false`
allows access to all resources that are missing a more specific access policy. A value of
`true` denies access to all resources by default. If `true`, more specific rules must be
used to allow access to these resources (for example, in a directory block using the
`directories` parameter).

Default value: `false`

##### <a name="-apache--vhost_dir"></a>`vhost_dir`

Data type: `Stdlib::Absolutepath`

Changes your virtual host configuration files' location.

Default value: `$apache::params::vhost_dir`

##### <a name="-apache--vhost_include_pattern"></a>`vhost_include_pattern`

Data type: `String`

Defines the pattern for files included from the `vhost_dir`.
If set to a value like `[^.#]\*.conf[^~]` to make sure that files accidentally created in
this directory (such as files created by version control systems or editor backups) are
*not* included in your server configuration.<br />
Some operating systems use a value of `*.conf`. By default, this module creates configuration
files ending in `.conf`.

Default value: `$apache::params::vhost_include_pattern`

##### <a name="-apache--user"></a>`user`

Data type: `String`

Changes the user that Apache uses to answer requests. Apache's parent process continues
to run as root, but child processes access resources as the user defined by this parameter.
To prevent Puppet from managing the user, set the `manage_user` parameter to `false`.

Default value: `$apache::params::user`

##### <a name="-apache--apache_name"></a>`apache_name`

Data type: `String`

The name of the Apache package to install. If you are using a non-standard Apache package
you might need to override the default setting.<br />
For CentOS/RHEL Software Collections (SCL), you can also use `apache::version::scl_httpd_version`.

Default value: `$apache::params::apache_name`

##### <a name="-apache--error_log"></a>`error_log`

Data type: `String`

The name of the error log file for the main server instance. If the string starts with
`/`, `|`, or `syslog`: the full path is set. Otherwise, the filename  is prefixed with
`$logroot`.

Default value: `$apache::params::error_log`

##### <a name="-apache--scriptalias"></a>`scriptalias`

Data type: `String`

Directory to use for global script alias

Default value: `$apache::params::scriptalias`

##### <a name="-apache--access_log_file"></a>`access_log_file`

Data type: `String`

The name of the access log file for the main server instance.

Default value: `$apache::params::access_log_file`

##### <a name="-apache--limitreqfields"></a>`limitreqfields`

Data type: `Integer`

The `limitreqfields` parameter sets the maximum number of request header fields in
an HTTP request. This directive gives the server administrator greater control over
abnormal client request behavior, which may be useful for avoiding some forms of
denial-of-service attacks. The value should be increased if normal clients see an error
response from the server that indicates too many fields were sent in the request.

Default value: `100`

##### <a name="-apache--limitreqfieldsize"></a>`limitreqfieldsize`

Data type: `Integer`

The `limitreqfieldsize` parameter sets the maximum ammount of _bytes_ that will
be allowed within a request header.

Default value: `8190`

##### <a name="-apache--limitreqline"></a>`limitreqline`

Data type: `Optional[Integer]`

The 'limitreqline' parameter sets the limit on the allowed size of a client's HTTP request-line

Default value: `undef`

##### <a name="-apache--ip"></a>`ip`

Data type: `Optional[String]`

Specifies the ip address

Default value: `undef`

##### <a name="-apache--conf_enabled"></a>`conf_enabled`

Data type: `Optional[Stdlib::Absolutepath]`

Whether the additional config files in `/etc/apache2/conf-enabled` should be managed.

Default value: `$apache::params::conf_enabled`

##### <a name="-apache--vhost_enable_dir"></a>`vhost_enable_dir`

Data type: `Optional[Stdlib::Absolutepath]`

Set's the vhost definitions which will be stored in sites-availible and if
they will be symlinked to and from sites-enabled.

Default value: `$apache::params::vhost_enable_dir`

##### <a name="-apache--manage_vhost_enable_dir"></a>`manage_vhost_enable_dir`

Data type: `Boolean`

Overides the vhost_enable_dir inherited parameters and allows it to be disabled

Default value: `true`

##### <a name="-apache--mod_enable_dir"></a>`mod_enable_dir`

Data type: `Optional[Stdlib::Absolutepath]`

Set's whether the mods-enabled directory should be managed.

Default value: `$apache::params::mod_enable_dir`

##### <a name="-apache--ssl_file"></a>`ssl_file`

Data type: `Optional[String]`

This parameter allows you to set an ssl.conf file to be managed in order to implement
an SSL Certificate.

Default value: `undef`

##### <a name="-apache--file_e_tag"></a>`file_e_tag`

Data type: `Optional[String]`

Sets the server default for the `FileETag` declaration, which modifies the response header
field for static files.

Default value: `undef`

##### <a name="-apache--use_optional_includes"></a>`use_optional_includes`

Data type: `Boolean`

Specifies whether Apache uses the `IncludeOptional` directive instead of `Include` for
`additional_includes` in Apache 2.4 or newer.

Default value: `$apache::params::use_optional_includes`

##### <a name="-apache--mime_types_additional"></a>`mime_types_additional`

Data type: `Hash`

Specifies any idditional Internet media (mime) types that you wish to be configured.

Default value: `$apache::params::mime_types_additional`

### <a name="apache--dev"></a>`apache::dev`

The libraries installed depends on the `dev_packages` parameter of the `apache::params`
class, based on your operating system:
- **Debian** : `libaprutil1-dev`, `libapr1-dev`; `apache2-dev`
- **FreeBSD**: `undef`; on FreeBSD, you must declare the `apache::package` or `apache` classes before declaring `apache::dev`.
- **Gentoo**: `undef`.
- **Red Hat**: `httpd-devel`.

### <a name="apache--mod--actions"></a>`apache::mod::actions`

Installs Apache mod_actions

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_actions.html
    * for additional documentation.

### <a name="apache--mod--alias"></a>`apache::mod::alias`

Installs and configures `mod_alias`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_alias.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::alias` class:

* [`icons_options`](#-apache--mod--alias--icons_options)
* [`icons_path`](#-apache--mod--alias--icons_path)
* [`icons_prefix`](#-apache--mod--alias--icons_prefix)

##### <a name="-apache--mod--alias--icons_options"></a>`icons_options`

Data type: `String`

Disables directory listings for the icons directory, via Apache [Options](https://httpd.apache.org/docs/current/mod/core.html#options)
directive.

Default value: `'Indexes MultiViews'`

##### <a name="-apache--mod--alias--icons_path"></a>`icons_path`

Data type: `Variant[Boolean, Stdlib::Absolutepath]`

Sets the local path for an /icons/ Alias. Default depends on operating system:
- Debian: /usr/share/apache2/icons
- FreeBSD: /usr/local/www/apache24/icons
- Gentoo: /var/www/icons
- Red Hat: /var/www/icons, except on Apache 2.4, where it's /usr/share/httpd/icons
Set to 'false' to disable the alias

Default value: `$apache::params::alias_icons_path`

##### <a name="-apache--mod--alias--icons_prefix"></a>`icons_prefix`

Data type: `String`

Change the alias for /icons/.

Default value: `$apache::params::icons_prefix`

### <a name="apache--mod--apreq2"></a>`apache::mod::apreq2`

Installs `mod_apreq2`.

* **Note** Unsupported platforms: CentOS: all; OracleLinux: all; RedHat: all; Scientific: all; SLES: all; Ubuntu: all

* **See also**
  * http://httpd.apache.org/apreq/docs/libapreq2/group__mod__apreq2.html
    * for additional documentation.

### <a name="apache--mod--auth_basic"></a>`apache::mod::auth_basic`

Installs `mod_auth_basic`

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_auth_basic.html
    * for additional documentation.

### <a name="apache--mod--auth_cas"></a>`apache::mod::auth_cas`

Installs and configures `mod_auth_cas`.

* **Note** The auth_cas module isn't available on RH/CentOS without providing dependency packages provided by EPEL.

* **See also**
  * https://github.com/apereo/mod_auth_cas
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::auth_cas` class:

* [`cas_login_url`](#-apache--mod--auth_cas--cas_login_url)
* [`cas_validate_url`](#-apache--mod--auth_cas--cas_validate_url)
* [`cas_cookie_path`](#-apache--mod--auth_cas--cas_cookie_path)
* [`cas_cookie_path_mode`](#-apache--mod--auth_cas--cas_cookie_path_mode)
* [`cas_version`](#-apache--mod--auth_cas--cas_version)
* [`cas_debug`](#-apache--mod--auth_cas--cas_debug)
* [`cas_validate_server`](#-apache--mod--auth_cas--cas_validate_server)
* [`cas_validate_depth`](#-apache--mod--auth_cas--cas_validate_depth)
* [`cas_certificate_path`](#-apache--mod--auth_cas--cas_certificate_path)
* [`cas_proxy_validate_url`](#-apache--mod--auth_cas--cas_proxy_validate_url)
* [`cas_root_proxied_as`](#-apache--mod--auth_cas--cas_root_proxied_as)
* [`cas_cookie_entropy`](#-apache--mod--auth_cas--cas_cookie_entropy)
* [`cas_timeout`](#-apache--mod--auth_cas--cas_timeout)
* [`cas_idle_timeout`](#-apache--mod--auth_cas--cas_idle_timeout)
* [`cas_cache_clean_interval`](#-apache--mod--auth_cas--cas_cache_clean_interval)
* [`cas_cookie_domain`](#-apache--mod--auth_cas--cas_cookie_domain)
* [`cas_cookie_http_only`](#-apache--mod--auth_cas--cas_cookie_http_only)
* [`cas_authoritative`](#-apache--mod--auth_cas--cas_authoritative)
* [`cas_validate_saml`](#-apache--mod--auth_cas--cas_validate_saml)
* [`cas_sso_enabled`](#-apache--mod--auth_cas--cas_sso_enabled)
* [`cas_attribute_prefix`](#-apache--mod--auth_cas--cas_attribute_prefix)
* [`cas_attribute_delimiter`](#-apache--mod--auth_cas--cas_attribute_delimiter)
* [`cas_scrub_request_headers`](#-apache--mod--auth_cas--cas_scrub_request_headers)
* [`suppress_warning`](#-apache--mod--auth_cas--suppress_warning)

##### <a name="-apache--mod--auth_cas--cas_login_url"></a>`cas_login_url`

Data type: `String`

Sets the URL to which the module redirects users when they attempt to access a
CAS-protected resource and don't have an active session.

##### <a name="-apache--mod--auth_cas--cas_validate_url"></a>`cas_validate_url`

Data type: `String`

Sets the URL to use when validating a client-presented ticket in an HTTP query string.

##### <a name="-apache--mod--auth_cas--cas_cookie_path"></a>`cas_cookie_path`

Data type: `String`

Sets the location where information on the current session should be stored. This should
be writable by the web server only.

Default value: `$apache::params::cas_cookie_path`

##### <a name="-apache--mod--auth_cas--cas_cookie_path_mode"></a>`cas_cookie_path_mode`

Data type: `Stdlib::Filemode`

The mode of cas_cookie_path.

Default value: `'0750'`

##### <a name="-apache--mod--auth_cas--cas_version"></a>`cas_version`

Data type: `Integer`

The version of the CAS protocol to adhere to.

Default value: `2`

##### <a name="-apache--mod--auth_cas--cas_debug"></a>`cas_debug`

Data type: `String`

Whether to enable or disable debug mode.

Default value: `'Off'`

##### <a name="-apache--mod--auth_cas--cas_validate_server"></a>`cas_validate_server`

Data type: `Optional[String]`

Whether to validate the presented certificate. This has been deprecated and
removed from Version 1.1-RC1 onward.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_validate_depth"></a>`cas_validate_depth`

Data type: `Optional[String]`

The maximum depth for chained certificate validation.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_certificate_path"></a>`cas_certificate_path`

Data type: `Optional[String]`

The path leading to the certificate

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_proxy_validate_url"></a>`cas_proxy_validate_url`

Data type: `Optional[String]`

The URL to use when performing a proxy validation.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_root_proxied_as"></a>`cas_root_proxied_as`

Data type: `Optional[String]`

Sets the URL end users see when access to this Apache server is proxied per vhost.
This URL should not include a trailing slash.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_cookie_entropy"></a>`cas_cookie_entropy`

Data type: `Optional[String]`

When creating a local session, this many random bytes are used to create a unique
session identifier.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_timeout"></a>`cas_timeout`

Data type: `Optional[Integer[0]]`

The hard limit, in seconds, for a mod_auth_cas session.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_idle_timeout"></a>`cas_idle_timeout`

Data type: `Optional[Integer[0]]`

The limit, in seconds, of how long a mod_auth_cas session can be idle.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_cache_clean_interval"></a>`cas_cache_clean_interval`

Data type: `Optional[String]`

The minimum amount of time that must pass inbetween cache cleanings.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_cookie_domain"></a>`cas_cookie_domain`

Data type: `Optional[String]`

The value for the 'Domain=' parameter in the Set-Cookie header.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_cookie_http_only"></a>`cas_cookie_http_only`

Data type: `Optional[String]`

Setting this flag prevents the mod_auth_cas cookies from being accessed by
client side Javascript.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_authoritative"></a>`cas_authoritative`

Data type: `Optional[String]`

Determines whether an optional authorization directive is authoritative and thus binding.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_validate_saml"></a>`cas_validate_saml`

Data type: `Optional[String]`

Parse response from CAS server for SAML.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_sso_enabled"></a>`cas_sso_enabled`

Data type: `Optional[String]`

Enables experimental support for single sign out (may mangle POST data).

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_attribute_prefix"></a>`cas_attribute_prefix`

Data type: `Optional[String]`

Adds a header with the value of this header being the attribute values when SAML
validation is enabled.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_attribute_delimiter"></a>`cas_attribute_delimiter`

Data type: `Optional[String]`

Sets the delimiter between attribute values in the header created by `cas_attribute_prefix`.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--cas_scrub_request_headers"></a>`cas_scrub_request_headers`

Data type: `Optional[String]`

Remove inbound request headers that may have special meaning within mod_auth_cas.

Default value: `undef`

##### <a name="-apache--mod--auth_cas--suppress_warning"></a>`suppress_warning`

Data type: `Boolean`

Suppress warning about being on RedHat (mod_auth_cas package is now available in epel-testing repo).

Default value: `false`

### <a name="apache--mod--auth_gssapi"></a>`apache::mod::auth_gssapi`

Installs `mod_auth_gsappi`.

* **See also**
  * https://github.com/modauthgssapi/mod_auth_gssapi
    * for additional documentation.

### <a name="apache--mod--auth_kerb"></a>`apache::mod::auth_kerb`

Installs `mod_auth_kerb`

* **See also**
  * http://modauthkerb.sourceforge.net
    * for additional documentation.

### <a name="apache--mod--auth_mellon"></a>`apache::mod::auth_mellon`

Installs and configures `mod_auth_mellon`.

* **See also**
  * https://github.com/Uninett/mod_auth_mellon
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::auth_mellon` class:

* [`mellon_cache_size`](#-apache--mod--auth_mellon--mellon_cache_size)
* [`mellon_lock_file`](#-apache--mod--auth_mellon--mellon_lock_file)
* [`mellon_post_directory`](#-apache--mod--auth_mellon--mellon_post_directory)
* [`mellon_cache_entry_size`](#-apache--mod--auth_mellon--mellon_cache_entry_size)
* [`mellon_post_ttl`](#-apache--mod--auth_mellon--mellon_post_ttl)
* [`mellon_post_size`](#-apache--mod--auth_mellon--mellon_post_size)
* [`mellon_post_count`](#-apache--mod--auth_mellon--mellon_post_count)

##### <a name="-apache--mod--auth_mellon--mellon_cache_size"></a>`mellon_cache_size`

Data type: `Optional[Integer]`

Maximum number of sessions which can be active at once.

Default value: `$apache::params::mellon_cache_size`

##### <a name="-apache--mod--auth_mellon--mellon_lock_file"></a>`mellon_lock_file`

Data type: `Optional[Stdlib::Absolutepath]`

Full path to a file used for synchronizing access to the session data.

Default value: `$apache::params::mellon_lock_file`

##### <a name="-apache--mod--auth_mellon--mellon_post_directory"></a>`mellon_post_directory`

Data type: `Optional[Stdlib::Absolutepath]`

Full path of a directory where POST requests are saved during authentication.

Default value: `$apache::params::mellon_post_directory`

##### <a name="-apache--mod--auth_mellon--mellon_cache_entry_size"></a>`mellon_cache_entry_size`

Data type: `Optional[Integer]`

Maximum size for a single session entry in bytes.

Default value: `undef`

##### <a name="-apache--mod--auth_mellon--mellon_post_ttl"></a>`mellon_post_ttl`

Data type: `Optional[Integer]`

Delay in seconds before a saved POST request can be flushed.

Default value: `undef`

##### <a name="-apache--mod--auth_mellon--mellon_post_size"></a>`mellon_post_size`

Data type: `Optional[Integer]`

Maximum size for saved POST requests.

Default value: `undef`

##### <a name="-apache--mod--auth_mellon--mellon_post_count"></a>`mellon_post_count`

Data type: `Optional[Integer]`

Maximum amount of saved POST requests.

Default value: `undef`

### <a name="apache--mod--auth_openidc"></a>`apache::mod::auth_openidc`

Installs and configures `mod_auth_openidc`.

* **Note** Unsupported platforms: OracleLinux: 6; RedHat: 6; Scientific: 6; SLES: all

* **See also**
  * https://github.com/zmartzone/mod_auth_openidc
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::auth_openidc` class:

* [`manage_dnf_module`](#-apache--mod--auth_openidc--manage_dnf_module)
* [`dnf_module_ensure`](#-apache--mod--auth_openidc--dnf_module_ensure)
* [`dnf_module_name`](#-apache--mod--auth_openidc--dnf_module_name)

##### <a name="-apache--mod--auth_openidc--manage_dnf_module"></a>`manage_dnf_module`

Data type: `Boolean`

Whether to manage the DNF module

Default value: `$facts['os']['family'] == 'RedHat' and $facts['os']['release']['major'] == '8'`

##### <a name="-apache--mod--auth_openidc--dnf_module_ensure"></a>`dnf_module_ensure`

Data type: `String[1]`

The DNF module name to ensure. Only relevant if manage_dnf_module is set to true.

Default value: `'present'`

##### <a name="-apache--mod--auth_openidc--dnf_module_name"></a>`dnf_module_name`

Data type: `String[1]`

The DNF module name to manage. Only relevant if manage_dnf_module is set to true.

Default value: `'mod_auth_openidc'`

### <a name="apache--mod--authn_core"></a>`apache::mod::authn_core`

Installs `mod_authn_core`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_authn_core.html
    * for additional documentation.

### <a name="apache--mod--authn_dbd"></a>`apache::mod::authn_dbd`

Installs `mod_authn_dbd`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_authn_dbd.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::authn_dbd` class:

* [`authn_dbd_params`](#-apache--mod--authn_dbd--authn_dbd_params)
* [`authn_dbd_dbdriver`](#-apache--mod--authn_dbd--authn_dbd_dbdriver)
* [`authn_dbd_query`](#-apache--mod--authn_dbd--authn_dbd_query)
* [`authn_dbd_min`](#-apache--mod--authn_dbd--authn_dbd_min)
* [`authn_dbd_max`](#-apache--mod--authn_dbd--authn_dbd_max)
* [`authn_dbd_keep`](#-apache--mod--authn_dbd--authn_dbd_keep)
* [`authn_dbd_exptime`](#-apache--mod--authn_dbd--authn_dbd_exptime)
* [`authn_dbd_alias`](#-apache--mod--authn_dbd--authn_dbd_alias)

##### <a name="-apache--mod--authn_dbd--authn_dbd_params"></a>`authn_dbd_params`

Data type: `Optional[String]`

The params needed for the mod to function.

##### <a name="-apache--mod--authn_dbd--authn_dbd_dbdriver"></a>`authn_dbd_dbdriver`

Data type: `String`

Selects an apr_dbd driver by name.

Default value: `'mysql'`

##### <a name="-apache--mod--authn_dbd--authn_dbd_query"></a>`authn_dbd_query`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-apache--mod--authn_dbd--authn_dbd_min"></a>`authn_dbd_min`

Data type: `Integer`

Set the minimum number of connections per process.

Default value: `4`

##### <a name="-apache--mod--authn_dbd--authn_dbd_max"></a>`authn_dbd_max`

Data type: `Integer`

Set the maximum number of connections per process.

Default value: `20`

##### <a name="-apache--mod--authn_dbd--authn_dbd_keep"></a>`authn_dbd_keep`

Data type: `Integer`

Set the maximum number of connections per process to be sustained.

Default value: `8`

##### <a name="-apache--mod--authn_dbd--authn_dbd_exptime"></a>`authn_dbd_exptime`

Data type: `Integer`

Set the time to keep idle connections alive when the number of
connections specified in DBDKeep has been exceeded.

Default value: `300`

##### <a name="-apache--mod--authn_dbd--authn_dbd_alias"></a>`authn_dbd_alias`

Data type: `Optional[String]`

Sets an alias for `AuthnProvider.

Default value: `undef`

### <a name="apache--mod--authn_file"></a>`apache::mod::authn_file`

Installs `mod_authn_file`.

* **See also**
  * https://httpd.apache.org/docs/2.4/mod/mod_authn_file.html
    * for additional documentation.

### <a name="apache--mod--authnz_ldap"></a>`apache::mod::authnz_ldap`

Installs `mod_authnz_ldap`.

* **Note** Unsupported platforms: RedHat: 6, 8, 9; CentOS: 6, 8; OracleLinux: 6, 8; Ubuntu: all; Debian: all; SLES: all

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_authnz_ldap.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::authnz_ldap` class:

* [`verify_server_cert`](#-apache--mod--authnz_ldap--verify_server_cert)
* [`package_name`](#-apache--mod--authnz_ldap--package_name)

##### <a name="-apache--mod--authnz_ldap--verify_server_cert"></a>`verify_server_cert`

Data type: `Boolean`

Whether to force te verification of a server cert or not.

Default value: `true`

##### <a name="-apache--mod--authnz_ldap--package_name"></a>`package_name`

Data type: `Optional[String]`

The name of the ldap package.

Default value: `undef`

### <a name="apache--mod--authnz_pam"></a>`apache::mod::authnz_pam`

Installs `mod_authnz_pam`.

* **See also**
  * https://www.adelton.com/apache/mod_authnz_pam
    * for additional documentation.

### <a name="apache--mod--authz_core"></a>`apache::mod::authz_core`

Installs `mod_authz_core`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_authz_core.html
    * for additional documentation.

### <a name="apache--mod--authz_groupfile"></a>`apache::mod::authz_groupfile`

Installs `mod_authz_groupfile`

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_authz_groupfile.html
    * for additional documentation.

### <a name="apache--mod--authz_user"></a>`apache::mod::authz_user`

Installs `mod_authz_user`

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_authz_user.html
    * for additional documentation.

### <a name="apache--mod--autoindex"></a>`apache::mod::autoindex`

Installs `mod_autoindex`

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_autoindex.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::autoindex` class:

* [`icons_prefix`](#-apache--mod--autoindex--icons_prefix)

##### <a name="-apache--mod--autoindex--icons_prefix"></a>`icons_prefix`

Data type: `String`

Change the alias for /icons/.

Default value: `$apache::params::icons_prefix`

### <a name="apache--mod--cache"></a>`apache::mod::cache`

Installs `mod_cache`

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_cache.html
    * for additional documentation.

### <a name="apache--mod--cgi"></a>`apache::mod::cgi`

Installs `mod_cgi`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_cgi.html
    * for additional documentation.

### <a name="apache--mod--cgid"></a>`apache::mod::cgid`

Installs `mod_cgid`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_cgid.html

### <a name="apache--mod--cluster"></a>`apache::mod::cluster`

Installs `mod_cluster`.

* **Note** There is no official package available for mod_cluster, so you must make it available outside of the apache module.
Binaries can be found [here](https://modcluster.io/).

* **See also**
  * https://modcluster.io/
    * for additional documentation.

#### Examples

##### 

```puppet
class { '::apache::mod::cluster':
  ip                      => '172.17.0.1',
  allowed_network         => '172.17.0.',
  balancer_name           => 'mycluster',
  version                 => '1.3.1'
}
```

#### Parameters

The following parameters are available in the `apache::mod::cluster` class:

* [`allowed_network`](#-apache--mod--cluster--allowed_network)
* [`balancer_name`](#-apache--mod--cluster--balancer_name)
* [`ip`](#-apache--mod--cluster--ip)
* [`version`](#-apache--mod--cluster--version)
* [`enable_mcpm_receive`](#-apache--mod--cluster--enable_mcpm_receive)
* [`port`](#-apache--mod--cluster--port)
* [`keep_alive_timeout`](#-apache--mod--cluster--keep_alive_timeout)
* [`manager_allowed_network`](#-apache--mod--cluster--manager_allowed_network)
* [`max_keep_alive_requests`](#-apache--mod--cluster--max_keep_alive_requests)
* [`server_advertise`](#-apache--mod--cluster--server_advertise)
* [`advertise_frequency`](#-apache--mod--cluster--advertise_frequency)

##### <a name="-apache--mod--cluster--allowed_network"></a>`allowed_network`

Data type: `String`

Balanced members network.

##### <a name="-apache--mod--cluster--balancer_name"></a>`balancer_name`

Data type: `String`

Name of balancer.

##### <a name="-apache--mod--cluster--ip"></a>`ip`

Data type: `Stdlib::IP::Address`

Specifies the IP address to listen to.

##### <a name="-apache--mod--cluster--version"></a>`version`

Data type: `String`

Specifies the mod_cluster version. Version 1.3.0 or greater is required for httpd 2.4.

##### <a name="-apache--mod--cluster--enable_mcpm_receive"></a>`enable_mcpm_receive`

Data type: `Boolean`

Whether MCPM should be enabled.

Default value: `true`

##### <a name="-apache--mod--cluster--port"></a>`port`

Data type: `Stdlib::Port`

mod_cluster listen port.

Default value: `6666`

##### <a name="-apache--mod--cluster--keep_alive_timeout"></a>`keep_alive_timeout`

Data type: `Integer`

Specifies how long Apache should wait for a request, in seconds.

Default value: `60`

##### <a name="-apache--mod--cluster--manager_allowed_network"></a>`manager_allowed_network`

Data type: `Stdlib::IP::Address`

Whether to allow the network to access the mod_cluster_manager.

Default value: `'127.0.0.1'`

##### <a name="-apache--mod--cluster--max_keep_alive_requests"></a>`max_keep_alive_requests`

Data type: `Integer`

Maximum number of requests kept alive.

Default value: `0`

##### <a name="-apache--mod--cluster--server_advertise"></a>`server_advertise`

Data type: `Boolean`

Whether the server should advertise.

Default value: `true`

##### <a name="-apache--mod--cluster--advertise_frequency"></a>`advertise_frequency`

Data type: `Optional[String]`

Sets the interval between advertise messages in seconds.

Default value: `undef`

### <a name="apache--mod--data"></a>`apache::mod::data`

Installs and configures `mod_data`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_data.html
    * for additional documentation.

### <a name="apache--mod--dav"></a>`apache::mod::dav`

Installs `mod_dav`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_dav.html
    * for additional documentation.

### <a name="apache--mod--dav_fs"></a>`apache::mod::dav_fs`

Installs `mod_dav_fs`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_dav_fs.html
    * for additional documentation.

### <a name="apache--mod--dav_svn"></a>`apache::mod::dav_svn`

Installs and configures `mod_dav_svn`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_dav_svn.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::dav_svn` class:

* [`authz_svn_enabled`](#-apache--mod--dav_svn--authz_svn_enabled)

##### <a name="-apache--mod--dav_svn--authz_svn_enabled"></a>`authz_svn_enabled`

Data type: `Boolean`

Specifies whether to install Apache mod_authz_svn

Default value: `false`

### <a name="apache--mod--dbd"></a>`apache::mod::dbd`

Installs `mod_dbd`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_dbd.html
    * for additional documentation.

### <a name="apache--mod--deflate"></a>`apache::mod::deflate`

Installs and configures `mod_deflate`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_deflate.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::deflate` class:

* [`types`](#-apache--mod--deflate--types)
* [`notes`](#-apache--mod--deflate--notes)

##### <a name="-apache--mod--deflate--types"></a>`types`

Data type: `Array[String]`

An array of MIME types to be deflated. See https://www.iana.org/assignments/media-types/media-types.xhtml.

Default value:

```puppet
[
    'text/html text/plain text/xml',
    'text/css',
    'application/x-javascript application/javascript application/ecmascript',
    'application/rss+xml',
    'application/json',
  ]
```

##### <a name="-apache--mod--deflate--notes"></a>`notes`

Data type: `Hash`

A Hash where the key represents the type and the value represents the note name.

Default value:

```puppet
{
    'Input'  => 'instream',
    'Output' => 'outstream',
    'Ratio'  => 'ratio',
  }
```

### <a name="apache--mod--dir"></a>`apache::mod::dir`

Installs and configures `mod_dir`.

* **TODO** This sets the global DirectoryIndex directive, so it may be necessary to consider being able to modify the apache::vhost to declare
DirectoryIndex statements in a vhost configuration

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_dir.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::dir` class:

* [`dir`](#-apache--mod--dir--dir)
* [`indexes`](#-apache--mod--dir--indexes)

##### <a name="-apache--mod--dir--dir"></a>`dir`

Data type: `String`



Default value: `'public_html'`

##### <a name="-apache--mod--dir--indexes"></a>`indexes`

Data type: `Array[String]`

Provides a string for the DirectoryIndex directive

Default value:

```puppet
[
    'index.html',
    'index.html.var',
    'index.cgi',
    'index.pl',
    'index.php',
    'index.xhtml',
  ]
```

### <a name="apache--mod--disk_cache"></a>`apache::mod::disk_cache`

Installs and configures `mod_disk_cache`.

* **Note** On Apache 2.4, mod_cache_disk installed.

* **See also**
  * https://httpd.apache.org/docs/2.4/mod/mod_cache_disk.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::disk_cache` class:

* [`cache_root`](#-apache--mod--disk_cache--cache_root)
* [`cache_ignore_headers`](#-apache--mod--disk_cache--cache_ignore_headers)
* [`default_cache_enable`](#-apache--mod--disk_cache--default_cache_enable)

##### <a name="-apache--mod--disk_cache--cache_root"></a>`cache_root`

Data type: `Optional[Stdlib::Absolutepath]`

Defines the name of the directory on the disk to contain cache files.
Default depends on the Apache version and operating system:
- Debian: /var/cache/apache2/mod_cache_disk
- FreeBSD: /var/cache/mod_cache_disk
- Red Hat: /var/cache/httpd/proxy

Default value: `undef`

##### <a name="-apache--mod--disk_cache--cache_ignore_headers"></a>`cache_ignore_headers`

Data type: `Optional[String]`

Specifies HTTP header(s) that should not be stored in the cache.

Default value: `undef`

##### <a name="-apache--mod--disk_cache--default_cache_enable"></a>`default_cache_enable`

Data type: `Boolean`

Default value is true, which enables "CacheEnable disk /" in disk_cache.conf for the webserver. This would cache
every request to apache by default for every vhost. If set to false the default cache all behaviour is supressed.
You can then control this behaviour in individual vhosts by explicitly defining CacheEnable.

Default value: `true`

### <a name="apache--mod--dumpio"></a>`apache::mod::dumpio`

Installs and configures `mod_dumpio`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_dumpio.html
    * for additional documentation.

#### Examples

##### 

```puppet
class{'apache':
  default_mods => false,
  log_level    => 'dumpio:trace7',
}
class{'apache::mod::dumpio':
  dump_io_input  => 'On',
  dump_io_output => 'Off',
}
```

#### Parameters

The following parameters are available in the `apache::mod::dumpio` class:

* [`dump_io_input`](#-apache--mod--dumpio--dump_io_input)
* [`dump_io_output`](#-apache--mod--dumpio--dump_io_output)

##### <a name="-apache--mod--dumpio--dump_io_input"></a>`dump_io_input`

Data type: `Apache::OnOff`

Dump all input data to the error log

Default value: `'Off'`

##### <a name="-apache--mod--dumpio--dump_io_output"></a>`dump_io_output`

Data type: `Apache::OnOff`

Dump all output data to the error log

Default value: `'Off'`

### <a name="apache--mod--env"></a>`apache::mod::env`

Installs `mod_env`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_env.html
    * for additional documentation.

### <a name="apache--mod--event"></a>`apache::mod::event`

Installs and configures `mod_event`.

* **Note** You cannot include apache::mod::event with apache::mod::itk, apache::mod::peruser, apache::mod::prefork, or
apache::mod::worker on the same server.

* **See also**
  * https://httpd.apache.org/docs/current/mod/event.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::event` class:

* [`startservers`](#-apache--mod--event--startservers)
* [`maxrequestworkers`](#-apache--mod--event--maxrequestworkers)
* [`minsparethreads`](#-apache--mod--event--minsparethreads)
* [`maxsparethreads`](#-apache--mod--event--maxsparethreads)
* [`threadsperchild`](#-apache--mod--event--threadsperchild)
* [`maxconnectionsperchild`](#-apache--mod--event--maxconnectionsperchild)
* [`serverlimit`](#-apache--mod--event--serverlimit)
* [`threadlimit`](#-apache--mod--event--threadlimit)
* [`listenbacklog`](#-apache--mod--event--listenbacklog)

##### <a name="-apache--mod--event--startservers"></a>`startservers`

Data type: `Variant[Integer, Boolean]`

Sets the number of child server processes created at startup, via the module's `StartServers` directive. Setting this to `false`
removes the parameter.

Default value: `2`

##### <a name="-apache--mod--event--maxrequestworkers"></a>`maxrequestworkers`

Data type: `Optional[Variant[Integer, Boolean]]`

Sets the maximum number of connections Apache can simultaneously process, via the module's `MaxRequestWorkers` directive. Setting
these to `false` removes the parameters.

Default value: `undef`

##### <a name="-apache--mod--event--minsparethreads"></a>`minsparethreads`

Data type: `Variant[Integer, Boolean]`

Sets the minimum number of idle threads, via the `MinSpareThreads` directive. Setting this to `false` removes the parameters.

Default value: `25`

##### <a name="-apache--mod--event--maxsparethreads"></a>`maxsparethreads`

Data type: `Variant[Integer, Boolean]`

Sets the maximum number of idle threads, via the `MaxSpareThreads` directive. Setting this to `false` removes the parameters.

Default value: `75`

##### <a name="-apache--mod--event--threadsperchild"></a>`threadsperchild`

Data type: `Variant[Integer, Boolean]`

Number of threads created by each child process.

Default value: `25`

##### <a name="-apache--mod--event--maxconnectionsperchild"></a>`maxconnectionsperchild`

Data type: `Optional[Variant[Integer, Boolean]]`

Limit on the number of connections that an individual child server will handle during its life.

Default value: `undef`

##### <a name="-apache--mod--event--serverlimit"></a>`serverlimit`

Data type: `Variant[Integer, Boolean]`

Limits the configurable number of processes via the `ServerLimit` directive. Setting this to `false` removes the parameter.

Default value: `25`

##### <a name="-apache--mod--event--threadlimit"></a>`threadlimit`

Data type: `Variant[Integer, Boolean]`

Limits the number of event threads via the module's `ThreadLimit` directive. Setting this to `false` removes the parameter.

Default value: `64`

##### <a name="-apache--mod--event--listenbacklog"></a>`listenbacklog`

Data type: `Variant[Integer, Boolean]`

Sets the maximum length of the pending connections queue via the module's `ListenBackLog` directive. Setting this to `false` removes
the parameter.

Default value: `511`

### <a name="apache--mod--expires"></a>`apache::mod::expires`

Installs and configures `mod_expires`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_expires.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::expires` class:

* [`expires_active`](#-apache--mod--expires--expires_active)
* [`expires_default`](#-apache--mod--expires--expires_default)
* [`expires_by_type`](#-apache--mod--expires--expires_by_type)

##### <a name="-apache--mod--expires--expires_active"></a>`expires_active`

Data type: `Boolean`

Enables generation of Expires headers.

Default value: `true`

##### <a name="-apache--mod--expires--expires_default"></a>`expires_default`

Data type: `Optional[String]`

Specifies the default algorithm for calculating expiration time using ExpiresByType syntax or interval syntax.

Default value: `undef`

##### <a name="-apache--mod--expires--expires_by_type"></a>`expires_by_type`

Data type: `Optional[Array[Hash]]`

Describes a set of [MIME content-types](https://www.iana.org/assignments/media-types/media-types.xhtml) and their expiration
times. This should be used as an array of Hashes, with each Hash's key a valid MIME content-type (i.e. 'text/json') and its
value following valid interval syntax.

Default value: `undef`

### <a name="apache--mod--ext_filter"></a>`apache::mod::ext_filter`

Installs and configures `mod_ext_filter`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_ext_filter.html
    * for additional documentation.

#### Examples

##### 

```puppet
class { 'apache::mod::ext_filter':
  ext_filter_define => {
    'slowdown'       => 'mode=output cmd=/bin/cat preservescontentlength',
    'puppetdb-strip' => 'mode=output outtype=application/json cmd="pdb-resource-filter"',
  },
}
```

#### Parameters

The following parameters are available in the `apache::mod::ext_filter` class:

* [`ext_filter_define`](#-apache--mod--ext_filter--ext_filter_define)

##### <a name="-apache--mod--ext_filter--ext_filter_define"></a>`ext_filter_define`

Data type: `Optional[Hash]`

Hash of filter names and their parameters.

Default value: `undef`

### <a name="apache--mod--fcgid"></a>`apache::mod::fcgid`

loaded first; Puppet will not automatically enable it if you set the fcgiwrapper parameter in apache::vhost.
  include apache::mod::fcgid

  apache::vhost { 'example.org':
    docroot     => '/var/www/html',
    directories => {
      path        => '/var/www/html',
      fcgiwrapper => {
        command => '/usr/local/bin/fcgiwrapper',
      }
    },
  }

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_fcgid.html
    * for additional documentation.

#### Examples

##### The class does not individually parameterize all available options. Instead, configure mod_fcgid using the options hash.

```puppet
class { 'apache::mod::fcgid':
  options => {
    'FcgidIPCDir'  => '/var/run/fcgidsock',
    'SharememPath' => '/var/run/fcgid_shm',
    'AddHandler'   => 'fcgid-script .fcgi',
  },
}
```

##### If you include apache::mod::fcgid, you can set the [FcgidWrapper][] per directory, per virtual host. The module must be

```puppet

```

#### Parameters

The following parameters are available in the `apache::mod::fcgid` class:

* [`options`](#-apache--mod--fcgid--options)

##### <a name="-apache--mod--fcgid--options"></a>`options`

Data type: `Hash`

A hash used to parameterize the availible options:
expires_active
  Enables generation of Expires headers.
expires_default
  Default algorithm for calculating expiration time.
expires_by_type
  Value of the Expires header configured by MIME type.

Default value: `{}`

### <a name="apache--mod--filter"></a>`apache::mod::filter`

Installs `mod_filter`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_filter.html
    * for additional documentation.

### <a name="apache--mod--geoip"></a>`apache::mod::geoip`

Installs and configures `mod_geoip`.

* **See also**
  * https://dev.maxmind.com/geoip/legacy/mod_geoip2
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::geoip` class:

* [`enable`](#-apache--mod--geoip--enable)
* [`db_file`](#-apache--mod--geoip--db_file)
* [`flag`](#-apache--mod--geoip--flag)
* [`output`](#-apache--mod--geoip--output)
* [`enable_utf8`](#-apache--mod--geoip--enable_utf8)
* [`scan_proxy_headers`](#-apache--mod--geoip--scan_proxy_headers)
* [`scan_proxy_header_field`](#-apache--mod--geoip--scan_proxy_header_field)
* [`use_last_xforwarededfor_ip`](#-apache--mod--geoip--use_last_xforwarededfor_ip)

##### <a name="-apache--mod--geoip--enable"></a>`enable`

Data type: `Boolean`

Toggles whether to enable geoip.

Default value: `false`

##### <a name="-apache--mod--geoip--db_file"></a>`db_file`

Data type: `Stdlib::Absolutepath`

Path to database for GeoIP to use.

Default value: `'/usr/share/GeoIP/GeoIP.dat'`

##### <a name="-apache--mod--geoip--flag"></a>`flag`

Data type: `String`

Caching directive to use. Values: 'CheckCache', 'IndexCache', 'MemoryCache', 'Standard'.

Default value: `'Standard'`

##### <a name="-apache--mod--geoip--output"></a>`output`

Data type: `String`

Output variable locations. Values: 'All', 'Env', 'Request', 'Notes'.

Default value: `'All'`

##### <a name="-apache--mod--geoip--enable_utf8"></a>`enable_utf8`

Data type: `Optional[String]`

Changes the output from ISO88591 (Latin1) to UTF8.

Default value: `undef`

##### <a name="-apache--mod--geoip--scan_proxy_headers"></a>`scan_proxy_headers`

Data type: `Optional[String]`

Enables the GeoIPScanProxyHeaders option.

Default value: `undef`

##### <a name="-apache--mod--geoip--scan_proxy_header_field"></a>`scan_proxy_header_field`

Data type: `Optional[String]`

Specifies the header mod_geoip uses to determine the client's IP address.

Default value: `undef`

##### <a name="-apache--mod--geoip--use_last_xforwarededfor_ip"></a>`use_last_xforwarededfor_ip`

Data type: `Optional[String]`

Determines whether to use the first or last IP address for the client's IP in a comma-separated list of IP addresses is found.

Default value: `undef`

### <a name="apache--mod--headers"></a>`apache::mod::headers`

Installs and configures `mod_headers`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_headers.html
    * for additional documentation.

### <a name="apache--mod--http2"></a>`apache::mod::http2`

Installs and configures `mod_http2`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_http2.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::http2` class:

* [`h2_copy_files`](#-apache--mod--http2--h2_copy_files)
* [`h2_direct`](#-apache--mod--http2--h2_direct)
* [`h2_early_hints`](#-apache--mod--http2--h2_early_hints)
* [`h2_max_session_streams`](#-apache--mod--http2--h2_max_session_streams)
* [`h2_max_worker_idle_seconds`](#-apache--mod--http2--h2_max_worker_idle_seconds)
* [`h2_max_workers`](#-apache--mod--http2--h2_max_workers)
* [`h2_min_workers`](#-apache--mod--http2--h2_min_workers)
* [`h2_modern_tls_only`](#-apache--mod--http2--h2_modern_tls_only)
* [`h2_push`](#-apache--mod--http2--h2_push)
* [`h2_push_diary_size`](#-apache--mod--http2--h2_push_diary_size)
* [`h2_push_priority`](#-apache--mod--http2--h2_push_priority)
* [`h2_push_resource`](#-apache--mod--http2--h2_push_resource)
* [`h2_serialize_headers`](#-apache--mod--http2--h2_serialize_headers)
* [`h2_stream_max_mem_size`](#-apache--mod--http2--h2_stream_max_mem_size)
* [`h2_tls_cool_down_secs`](#-apache--mod--http2--h2_tls_cool_down_secs)
* [`h2_tls_warm_up_size`](#-apache--mod--http2--h2_tls_warm_up_size)
* [`h2_upgrade`](#-apache--mod--http2--h2_upgrade)
* [`h2_window_size`](#-apache--mod--http2--h2_window_size)

##### <a name="-apache--mod--http2--h2_copy_files"></a>`h2_copy_files`

Data type: `Optional[Boolean]`

Determine file handling in responses.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_direct"></a>`h2_direct`

Data type: `Optional[Boolean]`

H2 Direct Protocol Switch.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_early_hints"></a>`h2_early_hints`

Data type: `Optional[Boolean]`

Determine sending of 103 status codes.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_max_session_streams"></a>`h2_max_session_streams`

Data type: `Optional[Integer]`

Sets maximum number of active streams per HTTP/2 session.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_max_worker_idle_seconds"></a>`h2_max_worker_idle_seconds`

Data type: `Optional[Integer]`

Sets maximum number of seconds h2 workers remain idle until shut down.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_max_workers"></a>`h2_max_workers`

Data type: `Optional[Integer]`

Sets maximum number of worker threads to use per child process.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_min_workers"></a>`h2_min_workers`

Data type: `Optional[Integer]`

Sets minimal number of worker threads to use per child process.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_modern_tls_only"></a>`h2_modern_tls_only`

Data type: `Optional[Boolean]`

Toggles the security checks on HTTP/2 connections in TLS mode

Default value: `undef`

##### <a name="-apache--mod--http2--h2_push"></a>`h2_push`

Data type: `Optional[Boolean]`

Toggles the usage of the HTTP/2 server push protocol feature.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_push_diary_size"></a>`h2_push_diary_size`

Data type: `Optional[Integer]`

Sets maximum number of HTTP/2 server pushes that are remembered per HTTP/2 connection.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_push_priority"></a>`h2_push_priority`

Data type: `Array[String]`

Require HTTP/2 connections to be "modern TLS" only

Default value: `[]`

##### <a name="-apache--mod--http2--h2_push_resource"></a>`h2_push_resource`

Data type: `Array[String]`

When added to a directory/location, HTTP/2 PUSHes will be attempted for all paths added
via this directive

Default value: `[]`

##### <a name="-apache--mod--http2--h2_serialize_headers"></a>`h2_serialize_headers`

Data type: `Optional[Boolean]`

Toggles if HTTP/2 requests shall be serialized in HTTP/1.1 format for processing by httpd
core or if received binary data shall be passed into the request_recs directly.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_stream_max_mem_size"></a>`h2_stream_max_mem_size`

Data type: `Optional[Integer]`

Sets the maximum number of outgoing data bytes buffered in memory for an active streams.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_tls_cool_down_secs"></a>`h2_tls_cool_down_secs`

Data type: `Optional[Integer]`

Sets the number of seconds of idle time on a TLS connection before the TLS write size falls
back to small (~1300 bytes) length.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_tls_warm_up_size"></a>`h2_tls_warm_up_size`

Data type: `Optional[Integer]`

Sets the number of bytes to be sent in small TLS records (~1300 bytes) until doing maximum
sized writes (16k) on https: HTTP/2 connections.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_upgrade"></a>`h2_upgrade`

Data type: `Optional[Boolean]`

Toggles the usage of the HTTP/1.1 Upgrade method for switching to HTTP/2.

Default value: `undef`

##### <a name="-apache--mod--http2--h2_window_size"></a>`h2_window_size`

Data type: `Optional[Integer]`

Sets the size of the window that is used for flow control from client to server and limits
the amount of data the server has to buffer.

Default value: `undef`

### <a name="apache--mod--include"></a>`apache::mod::include`

Installs `mod_include`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_include.html
    * for additional documentation.

### <a name="apache--mod--info"></a>`apache::mod::info`

Installs and configures `mod_info`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_info.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::info` class:

* [`allow_from`](#-apache--mod--info--allow_from)
* [`restrict_access`](#-apache--mod--info--restrict_access)
* [`info_path`](#-apache--mod--info--info_path)

##### <a name="-apache--mod--info--allow_from"></a>`allow_from`

Data type: `Array[Stdlib::IP::Address]`

Allowlist of IPv4 or IPv6 addresses or ranges that can access the info path.

Default value: `['127.0.0.1', '::1']`

##### <a name="-apache--mod--info--restrict_access"></a>`restrict_access`

Data type: `Boolean`

Toggles whether to restrict access to info path. If `false`, the `allow_from` allowlist is ignored and any IP address can
access the info path.

Default value: `true`

##### <a name="-apache--mod--info--info_path"></a>`info_path`

Data type: `Stdlib::Unixpath`

Path on server to file containing server configuration information.

Default value: `'/server-info'`

### <a name="apache--mod--intercept_form_submit"></a>`apache::mod::intercept_form_submit`

Installs `mod_intercept_form_submit`.

* **See also**
  * https://www.adelton.com/apache/mod_intercept_form_submit
    * for additional documentation.

### <a name="apache--mod--itk"></a>`apache::mod::itk`

Installs MPM `mod_itk`.

* **Note** Unsupported platforms: CentOS: 8; RedHat: 8, 9; SLES: all

* **See also**
  * http://mpm-itk.sesse.net
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::itk` class:

* [`startservers`](#-apache--mod--itk--startservers)
* [`minspareservers`](#-apache--mod--itk--minspareservers)
* [`maxspareservers`](#-apache--mod--itk--maxspareservers)
* [`serverlimit`](#-apache--mod--itk--serverlimit)
* [`maxclients`](#-apache--mod--itk--maxclients)
* [`maxrequestsperchild`](#-apache--mod--itk--maxrequestsperchild)
* [`enablecapabilities`](#-apache--mod--itk--enablecapabilities)

##### <a name="-apache--mod--itk--startservers"></a>`startservers`

Data type: `Integer`

Number of child server processes created on startup.

Default value: `8`

##### <a name="-apache--mod--itk--minspareservers"></a>`minspareservers`

Data type: `Integer`

Minimum number of idle child server processes.

Default value: `5`

##### <a name="-apache--mod--itk--maxspareservers"></a>`maxspareservers`

Data type: `Integer`

Maximum number of idle child server processes.

Default value: `20`

##### <a name="-apache--mod--itk--serverlimit"></a>`serverlimit`

Data type: `Integer`

Maximum configured value for `MaxRequestWorkers` for the lifetime of the Apache httpd process.

Default value: `256`

##### <a name="-apache--mod--itk--maxclients"></a>`maxclients`

Data type: `Integer`

Limit on the number of simultaneous requests that will be served.

Default value: `256`

##### <a name="-apache--mod--itk--maxrequestsperchild"></a>`maxrequestsperchild`

Data type: `Integer`

Limit on the number of connections that an individual child server process will handle.

Default value: `4000`

##### <a name="-apache--mod--itk--enablecapabilities"></a>`enablecapabilities`

Data type: `Optional[Variant[Boolean, String]]`

Drop most root capabilities in the parent process, and instead run as the user given by the User/Group directives with some extra
capabilities (in particular setuid). Somewhat more secure, but can cause problems when serving from filesystems that do not honor
capabilities, such as NFS.

Default value: `undef`

### <a name="apache--mod--jk"></a>`apache::mod::jk`

Installs `mod_jk`.

* **Note** shm_file and log_file
Depending on how these files are specified, the class creates their final path differently:

Relative path: prepends supplied path with logroot (see below)
Absolute path or pipe: uses supplied path as-is

```
shm_file => 'shm_file'
# Ends up in
$shm_path = '/var/log/httpd/shm_file'

shm_file => '/run/shm_file'
# Ends up in
$shm_path = '/run/shm_file'

shm_file => '"|rotatelogs /var/log/httpd/mod_jk.log.%Y%m%d 86400 -180"'
# Ends up in
$shm_path = '"|rotatelogs /var/log/httpd/mod_jk.log.%Y%m%d 86400 -180"'
```

* **See also**
  * https://tomcat.apache.org/connectors-doc/reference/apache.html
    * for additional documentation.

#### Examples

##### 

```puppet
class { '::apache::mod::jk':
  ip                   => '192.168.2.15',
  workers_file         => 'conf/workers.properties',
  mount_file           => 'conf/uriworkermap.properties',
  shm_file             => 'run/jk.shm',
  shm_size             => '50M',
  workers_file_content => {
    <Content>
  },
}
```

#### Parameters

The following parameters are available in the `apache::mod::jk` class:

* [`ip`](#-apache--mod--jk--ip)
* [`port`](#-apache--mod--jk--port)
* [`add_listen`](#-apache--mod--jk--add_listen)
* [`workers_file`](#-apache--mod--jk--workers_file)
* [`worker_property`](#-apache--mod--jk--worker_property)
* [`logroot`](#-apache--mod--jk--logroot)
* [`shm_file`](#-apache--mod--jk--shm_file)
* [`shm_size`](#-apache--mod--jk--shm_size)
* [`mount_file`](#-apache--mod--jk--mount_file)
* [`mount_file_reload`](#-apache--mod--jk--mount_file_reload)
* [`mount`](#-apache--mod--jk--mount)
* [`un_mount`](#-apache--mod--jk--un_mount)
* [`auto_alias`](#-apache--mod--jk--auto_alias)
* [`mount_copy`](#-apache--mod--jk--mount_copy)
* [`worker_indicator`](#-apache--mod--jk--worker_indicator)
* [`watchdog_interval`](#-apache--mod--jk--watchdog_interval)
* [`log_file`](#-apache--mod--jk--log_file)
* [`log_level`](#-apache--mod--jk--log_level)
* [`log_stamp_format`](#-apache--mod--jk--log_stamp_format)
* [`request_log_format`](#-apache--mod--jk--request_log_format)
* [`extract_ssl`](#-apache--mod--jk--extract_ssl)
* [`https_indicator`](#-apache--mod--jk--https_indicator)
* [`sslprotocol_indicator`](#-apache--mod--jk--sslprotocol_indicator)
* [`certs_indicator`](#-apache--mod--jk--certs_indicator)
* [`cipher_indicator`](#-apache--mod--jk--cipher_indicator)
* [`certchain_prefix`](#-apache--mod--jk--certchain_prefix)
* [`session_indicator`](#-apache--mod--jk--session_indicator)
* [`keysize_indicator`](#-apache--mod--jk--keysize_indicator)
* [`local_name_indicator`](#-apache--mod--jk--local_name_indicator)
* [`ignore_cl_indicator`](#-apache--mod--jk--ignore_cl_indicator)
* [`local_addr_indicator`](#-apache--mod--jk--local_addr_indicator)
* [`local_port_indicator`](#-apache--mod--jk--local_port_indicator)
* [`remote_host_indicator`](#-apache--mod--jk--remote_host_indicator)
* [`remote_addr_indicator`](#-apache--mod--jk--remote_addr_indicator)
* [`remote_port_indicator`](#-apache--mod--jk--remote_port_indicator)
* [`remote_user_indicator`](#-apache--mod--jk--remote_user_indicator)
* [`auth_type_indicator`](#-apache--mod--jk--auth_type_indicator)
* [`options`](#-apache--mod--jk--options)
* [`env_var`](#-apache--mod--jk--env_var)
* [`strip_session`](#-apache--mod--jk--strip_session)
* [`location_list`](#-apache--mod--jk--location_list)
* [`workers_file_content`](#-apache--mod--jk--workers_file_content)
* [`mount_file_content`](#-apache--mod--jk--mount_file_content)

##### <a name="-apache--mod--jk--ip"></a>`ip`

Data type: `Optional[Stdlib::IP::Address]`

IP for binding to mod_jk. Useful when the binding address is not the primary network interface IP.

Default value: `undef`

##### <a name="-apache--mod--jk--port"></a>`port`

Data type: `Stdlib::Port`

Port for binding to mod_jk. Useful when something else, like a reverse proxy or cache, is receiving requests at port 80, then
needs to forward them to Apache at a different port.

Default value: `80`

##### <a name="-apache--mod--jk--add_listen"></a>`add_listen`

Data type: `Boolean`

Defines if a Listen directive according to parameters ip and port (see below), so that Apache listens to the IP/port combination
and redirect to mod_jk. Useful when another Listen directive, like Listen *:<Port> or Listen <Port>, can conflict with the one
necessary for mod_jk binding.

Default value: `true`

##### <a name="-apache--mod--jk--workers_file"></a>`workers_file`

Data type: `Optional[String]`

The name of a worker file for the Tomcat servlet containers.

Default value: `undef`

##### <a name="-apache--mod--jk--worker_property"></a>`worker_property`

Data type: `Hash`

Enables setting worker properties inside Apache configuration file.

Default value: `{}`

##### <a name="-apache--mod--jk--logroot"></a>`logroot`

Data type: `Optional[Stdlib::Absolutepath]`

The base directory for shm_file and log_file is determined by the logroot parameter. If unspecified, defaults to
apache::params::logroot. The default logroot is sane enough therefore it is not recommended to override it.

Default value: `undef`

##### <a name="-apache--mod--jk--shm_file"></a>`shm_file`

Data type: `String`

Shared memory file name.

Default value: `'jk-runtime-status'`

##### <a name="-apache--mod--jk--shm_size"></a>`shm_size`

Data type: `Optional[String]`

Size of the shared memory file name.

Default value: `undef`

##### <a name="-apache--mod--jk--mount_file"></a>`mount_file`

Data type: `Optional[String]`

File containing multiple mappings from a context to a Tomcat worker.

Default value: `undef`

##### <a name="-apache--mod--jk--mount_file_reload"></a>`mount_file_reload`

Data type: `Optional[String]`

This directive configures the reload check interval in seconds.

Default value: `undef`

##### <a name="-apache--mod--jk--mount"></a>`mount`

Data type: `Hash`

A mount point from a context to a Tomcat worker.

Default value: `{}`

##### <a name="-apache--mod--jk--un_mount"></a>`un_mount`

Data type: `Hash`

An exclusion mount point from a context to a Tomcat worker.

Default value: `{}`

##### <a name="-apache--mod--jk--auto_alias"></a>`auto_alias`

Data type: `Optional[String]`

Automatically Alias webapp context directories into the Apache document space

Default value: `undef`

##### <a name="-apache--mod--jk--mount_copy"></a>`mount_copy`

Data type: `Optional[String]`

If this directive is set to "On" in some virtual server, the mounts from the global server will be copied
to this virtual server, more precisely all mounts defined by JkMount or JkUnMount.

Default value: `undef`

##### <a name="-apache--mod--jk--worker_indicator"></a>`worker_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable that can be used to set worker names in combination with SetHandler
jakarta-servlet.

Default value: `undef`

##### <a name="-apache--mod--jk--watchdog_interval"></a>`watchdog_interval`

Data type: `Optional[Integer]`

This directive configures the watchdog thread interval in seconds.

Default value: `undef`

##### <a name="-apache--mod--jk--log_file"></a>`log_file`

Data type: `String`

Full or server relative path to the mod_jk log file.

Default value: `'mod_jk.log'`

##### <a name="-apache--mod--jk--log_level"></a>`log_level`

Data type: `Optional[String]`

The mod_jk log level, can be debug, info, warn error or trace.

Default value: `undef`

##### <a name="-apache--mod--jk--log_stamp_format"></a>`log_stamp_format`

Data type: `Optional[String]`

The mod_jk date log format, using an extended strftime syntax.

Default value: `undef`

##### <a name="-apache--mod--jk--request_log_format"></a>`request_log_format`

Data type: `Optional[String]`

Request log format string.

Default value: `undef`

##### <a name="-apache--mod--jk--extract_ssl"></a>`extract_ssl`

Data type: `Optional[String]`

Turns on SSL processing and information gathering by mod_jk.

Default value: `undef`

##### <a name="-apache--mod--jk--https_indicator"></a>`https_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable that contains SSL indication.

Default value: `undef`

##### <a name="-apache--mod--jk--sslprotocol_indicator"></a>`sslprotocol_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable that contains the SSL protocol name.

Default value: `undef`

##### <a name="-apache--mod--jk--certs_indicator"></a>`certs_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable that contains SSL client certificates.

Default value: `undef`

##### <a name="-apache--mod--jk--cipher_indicator"></a>`cipher_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable that contains SSL client cipher.

Default value: `undef`

##### <a name="-apache--mod--jk--certchain_prefix"></a>`certchain_prefix`

Data type: `Optional[String]`

Name of the Apache environment (prefix) that contains SSL client chain certificates.

Default value: `undef`

##### <a name="-apache--mod--jk--session_indicator"></a>`session_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable that contains SSL session.

Default value: `undef`

##### <a name="-apache--mod--jk--keysize_indicator"></a>`keysize_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable that contains SSL key size in use.

Default value: `undef`

##### <a name="-apache--mod--jk--local_name_indicator"></a>`local_name_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable which can be used to overwrite the forwarded local name.

Default value: `undef`

##### <a name="-apache--mod--jk--ignore_cl_indicator"></a>`ignore_cl_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable which forces to ignore an existing Content-Length request header.

Default value: `undef`

##### <a name="-apache--mod--jk--local_addr_indicator"></a>`local_addr_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable which can be used to overwrite the forwarded local IP address.

Default value: `undef`

##### <a name="-apache--mod--jk--local_port_indicator"></a>`local_port_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable which can be used to overwrite the forwarded local port.

Default value: `undef`

##### <a name="-apache--mod--jk--remote_host_indicator"></a>`remote_host_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable which can be used to overwrite the forwarded remote (client) host name.

Default value: `undef`

##### <a name="-apache--mod--jk--remote_addr_indicator"></a>`remote_addr_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable which can be used to overwrite the forwarded remote (client) IP address.

Default value: `undef`

##### <a name="-apache--mod--jk--remote_port_indicator"></a>`remote_port_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable which can be used to overwrite the forwarded remote (client) IP address.

Default value: `undef`

##### <a name="-apache--mod--jk--remote_user_indicator"></a>`remote_user_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable which can be used to overwrite the forwarded user name.

Default value: `undef`

##### <a name="-apache--mod--jk--auth_type_indicator"></a>`auth_type_indicator`

Data type: `Optional[String]`

Name of the Apache environment variable which can be used to overwrite the forwarded authentication type.

Default value: `undef`

##### <a name="-apache--mod--jk--options"></a>`options`

Data type: `Array`

Set one of more options to configure the mod_jk module.

Default value: `[]`

##### <a name="-apache--mod--jk--env_var"></a>`env_var`

Data type: `Hash`

Adds a name and an optional default value of environment variable that should be sent to servlet-engine as a request attribute.

Default value: `{}`

##### <a name="-apache--mod--jk--strip_session"></a>`strip_session`

Data type: `Optional[String]`

If this directive is set to On in some virtual server, the session IDs ;jsessionid=... will be removed for URLs which are not
forwarded but instead are handled by the local server.

Default value: `undef`

##### <a name="-apache--mod--jk--location_list"></a>`location_list`

Data type: `Array`

Global locations for mod_jk are defined in array location_list.
Each array item is a hash with quoted* property name as key and value as value itself.
You can define a comment in a special 'comment' key

Example:
<Location /jkstatus/>
  # Configures jkstatus
  JkMount status
  Order deny,allow
  Deny from all
  Allow from 127.0.0.1
</Location>

Is defined as:
location_list = [
  {
    'Location'   => '/jkstatus/',
    'Comment'    => 'Configures jkstatus',
    'JkMount'    => 'status',
    'Order'      => 'deny,allow',
    'Deny from'  => 'all',
    'Allow from' => '127.0.0.1',
  },
]
* Keys must be quoted to allow arbitrary case and/or multi-word keys
(BTW, note the case of 'Location' and 'Comment' keys)

Default value: `[]`

##### <a name="-apache--mod--jk--workers_file_content"></a>`workers_file_content`

Data type: `Hash`

Each directive has the format worker.<Worker name>.<Property>=<Value>. This maps as a hash of hashes, where the outer hash specifies
workers, and each inner hash specifies each worker properties and values. Plus, there are two global directives, 'worker.list' and
'worker.maintain' For example, the workers file below should be parameterized as follows:

Worker file:
```
worker.list = status
worker.list = some_name,other_name

worker.maintain = 60

# Optional comment
worker.some_name.type=ajp13
worker.some_name.socket_keepalive=true

# I just like comments
worker.other_name.type=ajp12 (why would you?)
worker.other_name.socket_keepalive=false
```

Puppet file:
```
$workers_file_content = {
  worker_lists    => ['status', 'some_name, other_name'],
  worker_maintain => 60,
  some_name       => {
    comment          => 'Optional comment',
    type             => 'ajp13',
    socket_keepalive => 'true',
  },
  other_name      => {
    comment          => 'I just like comments',
    type             => 'ajp12',
    socket_keepalive => 'false',
  },
}
```

Default value: `{}`

##### <a name="-apache--mod--jk--mount_file_content"></a>`mount_file_content`

Data type: `Hash`

Each directive has the format <URI> = <Worker name>. This maps as a hash of hashes, where the outer hash specifies workers, and
each inner hash contains two items:
- uri_list-an array with URIs to be mapped to the worker
- comment-an optional string with a comment for the worker. For example, the mount file below should be parameterized as Figure 2:

Worker file:
```
# Worker 1
/context_1/ = worker_1
/context_1/* = worker_1

# Worker 2
/ = worker_2
/context_2/ = worker_2
/context_2/* = worker_2
```

Puppet file:
```
$mount_file_content = {
  worker_1 => {
    uri_list => ['/context_1/', '/context_1/*'],
    comment  => 'Worker 1',
  },
  worker_2 => {
    uri_list => ['/context_2/', '/context_2/*'],
    comment  => 'Worker 2',
  },
},
```

Default value: `{}`

### <a name="apache--mod--lbmethod_bybusyness"></a>`apache::mod::lbmethod_bybusyness`

Installs `lbmethod_bybusyness`.

* **See also**
  * https://httpd.apache.org/docs/2.4/mod/mod_lbmethod_bybusyness.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::lbmethod_bybusyness` class:

* [`apache_version`](#-apache--mod--lbmethod_bybusyness--apache_version)

##### <a name="-apache--mod--lbmethod_bybusyness--apache_version"></a>`apache_version`

Data type: `Optional[String]`

Version of Apache to install module on.

Default value: `$apache::apache_version`

### <a name="apache--mod--lbmethod_byrequests"></a>`apache::mod::lbmethod_byrequests`

Installs `lbmethod_byrequests`.

* **See also**
  * https://httpd.apache.org/docs/2.4/mod/mod_lbmethod_byrequests.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::lbmethod_byrequests` class:

* [`apache_version`](#-apache--mod--lbmethod_byrequests--apache_version)

##### <a name="-apache--mod--lbmethod_byrequests--apache_version"></a>`apache_version`

Data type: `Optional[String]`

Version of Apache to install module on.

Default value: `$apache::apache_version`

### <a name="apache--mod--lbmethod_bytraffic"></a>`apache::mod::lbmethod_bytraffic`

Installs `lbmethod_bytraffic`.

* **See also**
  * https://httpd.apache.org/docs/2.4/mod/mod_lbmethod_bytraffic.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::lbmethod_bytraffic` class:

* [`apache_version`](#-apache--mod--lbmethod_bytraffic--apache_version)

##### <a name="-apache--mod--lbmethod_bytraffic--apache_version"></a>`apache_version`

Data type: `Optional[String]`

Version of Apache to install module on.

Default value: `$apache::apache_version`

### <a name="apache--mod--lbmethod_heartbeat"></a>`apache::mod::lbmethod_heartbeat`

Installs `lbmethod_heartbeat`.

* **See also**
  * https://httpd.apache.org/docs/2.4/mod/mod_lbmethod_heartbeat.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::lbmethod_heartbeat` class:

* [`apache_version`](#-apache--mod--lbmethod_heartbeat--apache_version)

##### <a name="-apache--mod--lbmethod_heartbeat--apache_version"></a>`apache_version`

Data type: `Optional[String]`

Version of Apache to install module on.

Default value: `$apache::apache_version`

### <a name="apache--mod--ldap"></a>`apache::mod::ldap`

Installs and configures `mod_ldap`.

* **Note** Unsupported platforms: CentOS: 8; RedHat: 8, 9

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_ldap.html
    * for additional documentation.

#### Examples

##### 

```puppet
class { 'apache::mod::ldap':
  ldap_trusted_global_cert_file => '/etc/pki/tls/certs/ldap-trust.crt',
  ldap_trusted_global_cert_type => 'CA_DER',
  ldap_trusted_mode             => 'TLS',
  ldap_shared_cache_size        => 500000,
  ldap_cache_entries            => 1024,
  ldap_cache_ttl                => 600,
  ldap_opcache_entries          => 1024,
  ldap_opcache_ttl              => 600,
}
```

#### Parameters

The following parameters are available in the `apache::mod::ldap` class:

* [`package_name`](#-apache--mod--ldap--package_name)
* [`ldap_trusted_global_cert_file`](#-apache--mod--ldap--ldap_trusted_global_cert_file)
* [`ldap_trusted_global_cert_type`](#-apache--mod--ldap--ldap_trusted_global_cert_type)
* [`ldap_shared_cache_size`](#-apache--mod--ldap--ldap_shared_cache_size)
* [`ldap_cache_entries`](#-apache--mod--ldap--ldap_cache_entries)
* [`ldap_cache_ttl`](#-apache--mod--ldap--ldap_cache_ttl)
* [`ldap_opcache_entries`](#-apache--mod--ldap--ldap_opcache_entries)
* [`ldap_opcache_ttl`](#-apache--mod--ldap--ldap_opcache_ttl)
* [`ldap_trusted_mode`](#-apache--mod--ldap--ldap_trusted_mode)
* [`ldap_path`](#-apache--mod--ldap--ldap_path)

##### <a name="-apache--mod--ldap--package_name"></a>`package_name`

Data type: `Optional[String]`

Specifies the custom package name.

Default value: `undef`

##### <a name="-apache--mod--ldap--ldap_trusted_global_cert_file"></a>`ldap_trusted_global_cert_file`

Data type: `Optional[String]`

Sets the file or database containing global trusted Certificate Authority or global client certificates.

Default value: `undef`

##### <a name="-apache--mod--ldap--ldap_trusted_global_cert_type"></a>`ldap_trusted_global_cert_type`

Data type: `String`

Sets the certificate parameter of the global trusted Certificate Authority or global client certificates.

Default value: `'CA_BASE64'`

##### <a name="-apache--mod--ldap--ldap_shared_cache_size"></a>`ldap_shared_cache_size`

Data type: `Optional[Integer]`

Size in bytes of the shared-memory cache

Default value: `undef`

##### <a name="-apache--mod--ldap--ldap_cache_entries"></a>`ldap_cache_entries`

Data type: `Optional[Integer]`

Maximum number of entries in the primary LDAP cache

Default value: `undef`

##### <a name="-apache--mod--ldap--ldap_cache_ttl"></a>`ldap_cache_ttl`

Data type: `Optional[Integer]`

Time that cached items remain valid (in seconds).

Default value: `undef`

##### <a name="-apache--mod--ldap--ldap_opcache_entries"></a>`ldap_opcache_entries`

Data type: `Optional[Integer]`

Number of entries used to cache LDAP compare operations

Default value: `undef`

##### <a name="-apache--mod--ldap--ldap_opcache_ttl"></a>`ldap_opcache_ttl`

Data type: `Optional[Integer]`

Time that entries in the operation cache remain valid (in seconds).

Default value: `undef`

##### <a name="-apache--mod--ldap--ldap_trusted_mode"></a>`ldap_trusted_mode`

Data type: `Optional[String]`

Specifies the SSL/TLS mode to be used when connecting to an LDAP server.

Default value: `undef`

##### <a name="-apache--mod--ldap--ldap_path"></a>`ldap_path`

Data type: `String`

The server location of the ldap status page.

Default value: `'/ldap-status'`

### <a name="apache--mod--log_forensic"></a>`apache::mod::log_forensic`

Installs `mod_log_forensic`

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_log_forensic.html
    * for additional documentation.

### <a name="apache--mod--lookup_identity"></a>`apache::mod::lookup_identity`

Installs `mod_lookup_identity`

* **See also**
  * https://www.adelton.com/apache/mod_lookup_identity
    * for additional documentation.

### <a name="apache--mod--macro"></a>`apache::mod::macro`

Installs `mod_macro`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_macro.html
    * for additional documentation.

### <a name="apache--mod--md"></a>`apache::mod::md`

Installs and configures `mod_md`.

* **Note** Unsupported platforms: CentOS: 6, 7; OracleLinux: all; RedHat: 6, 7; Scientific: all; SLES: all; Ubuntu: 18

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_md.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::md` class:

* [`md_activation_delay`](#-apache--mod--md--md_activation_delay)
* [`md_base_server`](#-apache--mod--md--md_base_server)
* [`md_ca_challenges`](#-apache--mod--md--md_ca_challenges)
* [`md_certificate_agreement`](#-apache--mod--md--md_certificate_agreement)
* [`md_certificate_authority`](#-apache--mod--md--md_certificate_authority)
* [`md_certificate_check`](#-apache--mod--md--md_certificate_check)
* [`md_certificate_monitor`](#-apache--mod--md--md_certificate_monitor)
* [`md_certificate_protocol`](#-apache--mod--md--md_certificate_protocol)
* [`md_certificate_status`](#-apache--mod--md--md_certificate_status)
* [`md_challenge_dns01`](#-apache--mod--md--md_challenge_dns01)
* [`md_contact_email`](#-apache--mod--md--md_contact_email)
* [`md_http_proxy`](#-apache--mod--md--md_http_proxy)
* [`md_members`](#-apache--mod--md--md_members)
* [`md_message_cmd`](#-apache--mod--md--md_message_cmd)
* [`md_must_staple`](#-apache--mod--md--md_must_staple)
* [`md_notify_cmd`](#-apache--mod--md--md_notify_cmd)
* [`md_port_map`](#-apache--mod--md--md_port_map)
* [`md_private_keys`](#-apache--mod--md--md_private_keys)
* [`md_renew_mode`](#-apache--mod--md--md_renew_mode)
* [`md_renew_window`](#-apache--mod--md--md_renew_window)
* [`md_require_https`](#-apache--mod--md--md_require_https)
* [`md_server_status`](#-apache--mod--md--md_server_status)
* [`md_staple_others`](#-apache--mod--md--md_staple_others)
* [`md_stapling`](#-apache--mod--md--md_stapling)
* [`md_stapling_keep_response`](#-apache--mod--md--md_stapling_keep_response)
* [`md_stapling_renew_window`](#-apache--mod--md--md_stapling_renew_window)
* [`md_store_dir`](#-apache--mod--md--md_store_dir)
* [`md_warn_window`](#-apache--mod--md--md_warn_window)

##### <a name="-apache--mod--md--md_activation_delay"></a>`md_activation_delay`

Data type: `Optional[String]`

-

Default value: `undef`

##### <a name="-apache--mod--md--md_base_server"></a>`md_base_server`

Data type: `Optional[Apache::OnOff]`

Control if base server may be managed or only virtual hosts.

Default value: `undef`

##### <a name="-apache--mod--md--md_ca_challenges"></a>`md_ca_challenges`

Data type: `Optional[Array[Enum['dns-01', 'http-01', 'tls-alpn-01']]]`

Type of ACME challenge used to prove domain ownership.

Default value: `undef`

##### <a name="-apache--mod--md--md_certificate_agreement"></a>`md_certificate_agreement`

Data type: `Optional[Enum['accepted']]`

You confirm that you accepted the Terms of Service of the Certificate
Authority.

Default value: `undef`

##### <a name="-apache--mod--md--md_certificate_authority"></a>`md_certificate_authority`

Data type: `Optional[Stdlib::HTTPUrl]`

The URL of the ACME Certificate Authority service.

Default value: `undef`

##### <a name="-apache--mod--md--md_certificate_check"></a>`md_certificate_check`

Data type: `Optional[String]`

-

Default value: `undef`

##### <a name="-apache--mod--md--md_certificate_monitor"></a>`md_certificate_monitor`

Data type: `Optional[String]`

The URL of a certificate log monitor.

Default value: `undef`

##### <a name="-apache--mod--md--md_certificate_protocol"></a>`md_certificate_protocol`

Data type: `Optional[Enum['ACME']]`

The protocol to use with the Certificate Authority.

Default value: `undef`

##### <a name="-apache--mod--md--md_certificate_status"></a>`md_certificate_status`

Data type: `Optional[Apache::OnOff]`

Exposes public certificate information in JSON.

Default value: `undef`

##### <a name="-apache--mod--md--md_challenge_dns01"></a>`md_challenge_dns01`

Data type: `Optional[Stdlib::Absolutepath]`

Define a program to be called when the `dns-01` challenge needs to be
setup/torn down.

Default value: `undef`

##### <a name="-apache--mod--md--md_contact_email"></a>`md_contact_email`

Data type: `Optional[String]`

The ACME protocol requires you to give a contact url when you sign up.

Default value: `undef`

##### <a name="-apache--mod--md--md_http_proxy"></a>`md_http_proxy`

Data type: `Optional[Stdlib::HTTPUrl]`

Define a proxy for outgoing connections.

Default value: `undef`

##### <a name="-apache--mod--md--md_members"></a>`md_members`

Data type: `Optional[Enum['auto', 'manual']]`

Control if the alias domain names are automatically added.

Default value: `undef`

##### <a name="-apache--mod--md--md_message_cmd"></a>`md_message_cmd`

Data type: `Optional[Stdlib::Absolutepath]`

Handle events for Manage Domains.

Default value: `undef`

##### <a name="-apache--mod--md--md_must_staple"></a>`md_must_staple`

Data type: `Optional[Apache::OnOff]`

Control if new certificates carry the OCSP Must Staple flag.

Default value: `undef`

##### <a name="-apache--mod--md--md_notify_cmd"></a>`md_notify_cmd`

Data type: `Optional[Stdlib::Absolutepath]`

Run a program when a Managed Domain is ready.

Default value: `undef`

##### <a name="-apache--mod--md--md_port_map"></a>`md_port_map`

Data type: `Optional[String]`

Map external to internal ports for domain ownership verification.

Default value: `undef`

##### <a name="-apache--mod--md--md_private_keys"></a>`md_private_keys`

Data type: `Optional[String]`

Set type and size of the private keys generated.

Default value: `undef`

##### <a name="-apache--mod--md--md_renew_mode"></a>`md_renew_mode`

Data type: `Optional[Enum['always', 'auto', 'manual']]`

Controls if certificates shall be renewed.

Default value: `undef`

##### <a name="-apache--mod--md--md_renew_window"></a>`md_renew_window`

Data type: `Optional[String]`

Control when a certificate will be renewed.

Default value: `undef`

##### <a name="-apache--mod--md--md_require_https"></a>`md_require_https`

Data type: `Optional[Enum['off', 'permanent', 'temporary']]`

Redirects http: traffic to https: for Managed Domains.
An http: Virtual Host must nevertheless be setup for that domain.

Default value: `undef`

##### <a name="-apache--mod--md--md_server_status"></a>`md_server_status`

Data type: `Optional[Apache::OnOff]`

Control if Managed Domain information is added to server-status.

Default value: `undef`

##### <a name="-apache--mod--md--md_staple_others"></a>`md_staple_others`

Data type: `Optional[Apache::OnOff]`

Enable stapling for certificates not managed by mod_md.

Default value: `undef`

##### <a name="-apache--mod--md--md_stapling"></a>`md_stapling`

Data type: `Optional[Apache::OnOff]`

Enable stapling for all or a particular MDomain.

Default value: `undef`

##### <a name="-apache--mod--md--md_stapling_keep_response"></a>`md_stapling_keep_response`

Data type: `Optional[String]`

Controls when old responses should be removed.

Default value: `undef`

##### <a name="-apache--mod--md--md_stapling_renew_window"></a>`md_stapling_renew_window`

Data type: `Optional[String]`

Control when the stapling responses will be renewed.

Default value: `undef`

##### <a name="-apache--mod--md--md_store_dir"></a>`md_store_dir`

Data type: `Optional[Stdlib::Absolutepath]`

Path on the local file system to store the Managed Domains data.

Default value: `undef`

##### <a name="-apache--mod--md--md_warn_window"></a>`md_warn_window`

Data type: `Optional[String]`

Define the time window when you want to be warned about an expiring
certificate.

Default value: `undef`

### <a name="apache--mod--mime"></a>`apache::mod::mime`

Installs and configures `mod_mime`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_mime.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::mime` class:

* [`mime_support_package`](#-apache--mod--mime--mime_support_package)
* [`mime_types_config`](#-apache--mod--mime--mime_types_config)
* [`mime_types_additional`](#-apache--mod--mime--mime_types_additional)

##### <a name="-apache--mod--mime--mime_support_package"></a>`mime_support_package`

Data type: `String`

Name of the MIME package to be installed.

Default value: `$apache::params::mime_support_package`

##### <a name="-apache--mod--mime--mime_types_config"></a>`mime_types_config`

Data type: `String`

The location of the mime.types file.

Default value: `$apache::params::mime_types_config`

##### <a name="-apache--mod--mime--mime_types_additional"></a>`mime_types_additional`

Data type: `Optional[Hash]`

List of additional MIME types to include.

Default value: `undef`

### <a name="apache--mod--mime_magic"></a>`apache::mod::mime_magic`

Installs and configures `mod_mime_magic`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_mime_magic.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::mime_magic` class:

* [`magic_file`](#-apache--mod--mime_magic--magic_file)

##### <a name="-apache--mod--mime_magic--magic_file"></a>`magic_file`

Data type: `Optional[String]`

Enable MIME-type determination based on file contents using the specified magic file.

Default value: `undef`

### <a name="apache--mod--negotiation"></a>`apache::mod::negotiation`

Installs and configures `mod_negotiation`.

* **See also**
  * [https://httpd.apache.org/docs/current/mod/mod_negotiation.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::negotiation` class:

* [`force_language_priority`](#-apache--mod--negotiation--force_language_priority)
* [`language_priority`](#-apache--mod--negotiation--language_priority)

##### <a name="-apache--mod--negotiation--force_language_priority"></a>`force_language_priority`

Data type: `Variant[Array[String], String]`

Action to take if a single acceptable document is not found.

Default value: `'Prefer Fallback'`

##### <a name="-apache--mod--negotiation--language_priority"></a>`language_priority`

Data type: `Variant[Array[String], String]`

The precedence of language variants for cases where the client does not express a preference.

Default value:

```puppet
['en', 'ca', 'cs', 'da', 'de', 'el', 'eo', 'es', 'et',
    'fr', 'he', 'hr', 'it', 'ja', 'ko', 'ltz', 'nl', 'nn',
    'no', 'pl', 'pt', 'pt-BR', 'ru', 'sv', 'zh-CN',
  'zh-TW']
```

### <a name="apache--mod--nss"></a>`apache::mod::nss`

Installs and configures `mod_nss`.

* **See also**
  * https://pagure.io/mod_nss
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::nss` class:

* [`transfer_log`](#-apache--mod--nss--transfer_log)
* [`error_log`](#-apache--mod--nss--error_log)
* [`passwd_file`](#-apache--mod--nss--passwd_file)
* [`port`](#-apache--mod--nss--port)

##### <a name="-apache--mod--nss--transfer_log"></a>`transfer_log`

Data type: `Stdlib::Absolutepath`

Path to `access.log`.

Default value: `"${apache::params::logroot}/access.log"`

##### <a name="-apache--mod--nss--error_log"></a>`error_log`

Data type: `Stdlib::Absolutepath`

Path to `error.log`

Default value: `"${apache::params::logroot}/error.log"`

##### <a name="-apache--mod--nss--passwd_file"></a>`passwd_file`

Data type: `Optional[String]`

Path to file containing token passwords used for NSSPassPhraseDialog.

Default value: `undef`

##### <a name="-apache--mod--nss--port"></a>`port`

Data type: `Stdlib::Port`

Sets the SSL port that should be used by mod_nss.

Default value: `8443`

### <a name="apache--mod--pagespeed"></a>`apache::mod::pagespeed`

Installs and manages mod_pagespeed, which is a Google module that rewrites web pages to reduce latency and bandwidth.

This module does *not* manage the software repositories needed to automatically install the
mod-pagespeed-stable package. The module does however require that the package be installed,
or be installable using the system's default package provider.  You should ensure that this
pre-requisite is met or declaring `apache::mod::pagespeed` will cause the puppet run to fail.

* **Note** Verify that your system is compatible with the latest Google Pagespeed requirements.

Although this apache module requires the mod-pagespeed-stable package, Puppet does not manage the software repositories required to
automatically install the package. If you declare this class when the package is either not installed or not available to your
package manager, your Puppet run will fail.

* **See also**
  * https://developers.google.com/speed/pagespeed/module/
    * for additional documentation.

#### Examples

##### 

```puppet
class { 'apache::mod::pagespeed':
  inherit_vhost_config          => 'on',
  filter_xhtml                  => false,
  cache_path                    => '/var/cache/mod_pagespeed/',
  log_dir                       => '/var/log/pagespeed',
  memache_servers               => [],
  rewrite_level                 => 'CoreFilters',
  disable_filters               => [],
  enable_filters                => [],
  forbid_filters                => [],
  rewrite_deadline_per_flush_ms => 10,
  additional_domains            => undef,
  file_cache_size_kb            => 102400,
  file_cache_clean_interval_ms  => 3600000,
  lru_cache_per_process         => 1024,
  lru_cache_byte_limit          => 16384,
  css_flatten_max_bytes         => 2048,
  css_inline_max_bytes          => 2048,
  css_image_inline_max_bytes    => 2048,
  image_inline_max_bytes        => 2048,
  js_inline_max_bytes           => 2048,
  css_outline_min_bytes         => 3000,
  js_outline_min_bytes          => 3000,
  inode_limit                   => 500000,
  image_max_rewrites_at_once    => 8,
  num_rewrite_threads           => 4,
  num_expensive_rewrite_threads => 4,
  collect_statistics            => 'on',
  statistics_logging            => 'on',
  allow_view_stats              => [],
  allow_pagespeed_console       => [],
  allow_pagespeed_message       => [],
  message_buffer_size           => 100000,
  additional_configuration      => { }
}
```

#### Parameters

The following parameters are available in the `apache::mod::pagespeed` class:

* [`inherit_vhost_config`](#-apache--mod--pagespeed--inherit_vhost_config)
* [`filter_xhtml`](#-apache--mod--pagespeed--filter_xhtml)
* [`cache_path`](#-apache--mod--pagespeed--cache_path)
* [`log_dir`](#-apache--mod--pagespeed--log_dir)
* [`memcache_servers`](#-apache--mod--pagespeed--memcache_servers)
* [`rewrite_level`](#-apache--mod--pagespeed--rewrite_level)
* [`disable_filters`](#-apache--mod--pagespeed--disable_filters)
* [`enable_filters`](#-apache--mod--pagespeed--enable_filters)
* [`forbid_filters`](#-apache--mod--pagespeed--forbid_filters)
* [`rewrite_deadline_per_flush_ms`](#-apache--mod--pagespeed--rewrite_deadline_per_flush_ms)
* [`additional_domains`](#-apache--mod--pagespeed--additional_domains)
* [`file_cache_size_kb`](#-apache--mod--pagespeed--file_cache_size_kb)
* [`file_cache_clean_interval_ms`](#-apache--mod--pagespeed--file_cache_clean_interval_ms)
* [`lru_cache_per_process`](#-apache--mod--pagespeed--lru_cache_per_process)
* [`lru_cache_byte_limit`](#-apache--mod--pagespeed--lru_cache_byte_limit)
* [`css_flatten_max_bytes`](#-apache--mod--pagespeed--css_flatten_max_bytes)
* [`css_inline_max_bytes`](#-apache--mod--pagespeed--css_inline_max_bytes)
* [`css_image_inline_max_bytes`](#-apache--mod--pagespeed--css_image_inline_max_bytes)
* [`image_inline_max_bytes`](#-apache--mod--pagespeed--image_inline_max_bytes)
* [`js_inline_max_bytes`](#-apache--mod--pagespeed--js_inline_max_bytes)
* [`css_outline_min_bytes`](#-apache--mod--pagespeed--css_outline_min_bytes)
* [`js_outline_min_bytes`](#-apache--mod--pagespeed--js_outline_min_bytes)
* [`inode_limit`](#-apache--mod--pagespeed--inode_limit)
* [`image_max_rewrites_at_once`](#-apache--mod--pagespeed--image_max_rewrites_at_once)
* [`num_rewrite_threads`](#-apache--mod--pagespeed--num_rewrite_threads)
* [`num_expensive_rewrite_threads`](#-apache--mod--pagespeed--num_expensive_rewrite_threads)
* [`collect_statistics`](#-apache--mod--pagespeed--collect_statistics)
* [`statistics_logging`](#-apache--mod--pagespeed--statistics_logging)
* [`allow_view_stats`](#-apache--mod--pagespeed--allow_view_stats)
* [`allow_pagespeed_console`](#-apache--mod--pagespeed--allow_pagespeed_console)
* [`allow_pagespeed_message`](#-apache--mod--pagespeed--allow_pagespeed_message)
* [`message_buffer_size`](#-apache--mod--pagespeed--message_buffer_size)
* [`additional_configuration`](#-apache--mod--pagespeed--additional_configuration)
* [`package_ensure`](#-apache--mod--pagespeed--package_ensure)

##### <a name="-apache--mod--pagespeed--inherit_vhost_config"></a>`inherit_vhost_config`

Data type: `String`

Whether or not to inherit the vhost config

Default value: `'on'`

##### <a name="-apache--mod--pagespeed--filter_xhtml"></a>`filter_xhtml`

Data type: `Boolean`

Whether to filter by xhtml

Default value: `false`

##### <a name="-apache--mod--pagespeed--cache_path"></a>`cache_path`

Data type: `Stdlib::Absolutepath`

Where to cache any files

Default value: `'/var/cache/mod_pagespeed/'`

##### <a name="-apache--mod--pagespeed--log_dir"></a>`log_dir`

Data type: `Stdlib::Absolutepath`

The log directory

Default value: `'/var/log/pagespeed'`

##### <a name="-apache--mod--pagespeed--memcache_servers"></a>`memcache_servers`

Data type: `Array`



Default value: `[]`

##### <a name="-apache--mod--pagespeed--rewrite_level"></a>`rewrite_level`

Data type: `String`

The inbuilt filter level to be used.
Can be `PassThrough`, `CoreFilters` or `OptimizeForBandwidth`.

Default value: `'CoreFilters'`

##### <a name="-apache--mod--pagespeed--disable_filters"></a>`disable_filters`

Data type: `Array`

An array of filters that you wish to disable

Default value: `[]`

##### <a name="-apache--mod--pagespeed--enable_filters"></a>`enable_filters`

Data type: `Array`

An array of filters that you wish to enable

Default value: `[]`

##### <a name="-apache--mod--pagespeed--forbid_filters"></a>`forbid_filters`

Data type: `Array`

An array of filters that you wish to forbid

Default value: `[]`

##### <a name="-apache--mod--pagespeed--rewrite_deadline_per_flush_ms"></a>`rewrite_deadline_per_flush_ms`

Data type: `Integer`

How long to wait after attempting to rewrite an uncache/expired resource.

Default value: `10`

##### <a name="-apache--mod--pagespeed--additional_domains"></a>`additional_domains`

Data type: `Optional[String]`

Any additional domains that PageSpeed should optimize resources from.

Default value: `undef`

##### <a name="-apache--mod--pagespeed--file_cache_size_kb"></a>`file_cache_size_kb`

Data type: `Integer`

The maximum size of the cache

Default value: `102400`

##### <a name="-apache--mod--pagespeed--file_cache_clean_interval_ms"></a>`file_cache_clean_interval_ms`

Data type: `Integer`

The interval between which the cache is cleaned

Default value: `3600000`

##### <a name="-apache--mod--pagespeed--lru_cache_per_process"></a>`lru_cache_per_process`

Data type: `Integer`

The amount of memory dedcated to each process

Default value: `1024`

##### <a name="-apache--mod--pagespeed--lru_cache_byte_limit"></a>`lru_cache_byte_limit`

Data type: `Integer`

How large a cache entry the cache will accept

Default value: `16384`

##### <a name="-apache--mod--pagespeed--css_flatten_max_bytes"></a>`css_flatten_max_bytes`

Data type: `Integer`

The maximum size in bytes of the flattened CSS

Default value: `2048`

##### <a name="-apache--mod--pagespeed--css_inline_max_bytes"></a>`css_inline_max_bytes`

Data type: `Integer`

The maximum size in bytes of any image that will be inlined into CSS

Default value: `2048`

##### <a name="-apache--mod--pagespeed--css_image_inline_max_bytes"></a>`css_image_inline_max_bytes`

Data type: `Integer`

The maximum size in bytes of any image that will be inlined into an HTML file

Default value: `2048`

##### <a name="-apache--mod--pagespeed--image_inline_max_bytes"></a>`image_inline_max_bytes`

Data type: `Integer`

The maximum size in bytes of any inlined CSS file

Default value: `2048`

##### <a name="-apache--mod--pagespeed--js_inline_max_bytes"></a>`js_inline_max_bytes`

Data type: `Integer`

The maximum size in bytes of any inlined JavaScript file

Default value: `2048`

##### <a name="-apache--mod--pagespeed--css_outline_min_bytes"></a>`css_outline_min_bytes`

Data type: `Integer`

The minimum size in bytes for a CSS file to qualify as an outline

Default value: `3000`

##### <a name="-apache--mod--pagespeed--js_outline_min_bytes"></a>`js_outline_min_bytes`

Data type: `Integer`

The minimum size in bytes for a JavaScript file to qualify as an outline

Default value: `3000`

##### <a name="-apache--mod--pagespeed--inode_limit"></a>`inode_limit`

Data type: `Integer`

The file cache inode limit

Default value: `500000`

##### <a name="-apache--mod--pagespeed--image_max_rewrites_at_once"></a>`image_max_rewrites_at_once`

Data type: `Integer`

The maximum number of images to optimize concurrently

Default value: `8`

##### <a name="-apache--mod--pagespeed--num_rewrite_threads"></a>`num_rewrite_threads`

Data type: `Integer`

The amount of threads to use for rewrite at one time
These threads are used for short, latency-sensitive work.

Default value: `4`

##### <a name="-apache--mod--pagespeed--num_expensive_rewrite_threads"></a>`num_expensive_rewrite_threads`

Data type: `Integer`

The amount of threads to use for rewrite at one time
These threads are used for full optimization.

Default value: `4`

##### <a name="-apache--mod--pagespeed--collect_statistics"></a>`collect_statistics`

Data type: `String`

Whether to collect cross-process statistics

Default value: `'on'`

##### <a name="-apache--mod--pagespeed--statistics_logging"></a>`statistics_logging`

Data type: `String`

Whether graphs should be drawn from collected statistics

Default value: `'on'`

##### <a name="-apache--mod--pagespeed--allow_view_stats"></a>`allow_view_stats`

Data type: `Array`

What sources should be allowed to view the resultant graph

Default value: `[]`

##### <a name="-apache--mod--pagespeed--allow_pagespeed_console"></a>`allow_pagespeed_console`

Data type: `Array`

What sources to draw the graphs from

Default value: `[]`

##### <a name="-apache--mod--pagespeed--allow_pagespeed_message"></a>`allow_pagespeed_message`

Data type: `Array`



Default value: `[]`

##### <a name="-apache--mod--pagespeed--message_buffer_size"></a>`message_buffer_size`

Data type: `Integer`

The amount of bytes to allocate as a buffer to hold recent log messages

Default value: `100000`

##### <a name="-apache--mod--pagespeed--additional_configuration"></a>`additional_configuration`

Data type: `Variant[Array, Hash]`

Any additional configuration no included as it's own option

Default value: `{}`

##### <a name="-apache--mod--pagespeed--package_ensure"></a>`package_ensure`

Data type: `Optional[String]`



Default value: `undef`

### <a name="apache--mod--passenger"></a>`apache::mod::passenger`

The current set of server configurations settings were taken directly from the Passenger Reference. To enable deprecation warnings
and removal failure messages, set the passenger_installed_version to the version number installed on the server.

Change Log:
  - As of 08/13/2017 there are 84 available/deprecated/removed settings.
  - Around 08/20/2017 UnionStation was discontinued options were removed.
  - As of 08/20/2017 there are 77 available/deprecated/removed settings.

* **Note** In Passenger source code you can strip out what are all the available options by looking in
  - src/apache2_module/Configuration.cpp
  - src/apache2_module/ConfigurationCommands.cpp
There are also several undocumented settings.

* **See also**
  * https://www.phusionpassenger.com/docs/references/config_reference/apache/
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::passenger` class:

* [`manage_repo`](#-apache--mod--passenger--manage_repo)
* [`mod_id`](#-apache--mod--passenger--mod_id)
* [`mod_lib`](#-apache--mod--passenger--mod_lib)
* [`mod_lib_path`](#-apache--mod--passenger--mod_lib_path)
* [`mod_package`](#-apache--mod--passenger--mod_package)
* [`mod_package_ensure`](#-apache--mod--passenger--mod_package_ensure)
* [`mod_path`](#-apache--mod--passenger--mod_path)
* [`passenger_admin_panel_url`](#-apache--mod--passenger--passenger_admin_panel_url)
* [`passenger_admin_panel_auth_type`](#-apache--mod--passenger--passenger_admin_panel_auth_type)
* [`passenger_admin_panel_username`](#-apache--mod--passenger--passenger_admin_panel_username)
* [`passenger_admin_panel_password`](#-apache--mod--passenger--passenger_admin_panel_password)
* [`passenger_allow_encoded_slashes`](#-apache--mod--passenger--passenger_allow_encoded_slashes)
* [`passenger_anonymous_telemetry_proxy`](#-apache--mod--passenger--passenger_anonymous_telemetry_proxy)
* [`passenger_app_env`](#-apache--mod--passenger--passenger_app_env)
* [`passenger_app_group_name`](#-apache--mod--passenger--passenger_app_group_name)
* [`passenger_app_log_file`](#-apache--mod--passenger--passenger_app_log_file)
* [`passenger_app_root`](#-apache--mod--passenger--passenger_app_root)
* [`passenger_app_type`](#-apache--mod--passenger--passenger_app_type)
* [`passenger_base_uri`](#-apache--mod--passenger--passenger_base_uri)
* [`passenger_buffer_response`](#-apache--mod--passenger--passenger_buffer_response)
* [`passenger_buffer_upload`](#-apache--mod--passenger--passenger_buffer_upload)
* [`passenger_concurrency_model`](#-apache--mod--passenger--passenger_concurrency_model)
* [`passenger_conf_file`](#-apache--mod--passenger--passenger_conf_file)
* [`passenger_conf_package_file`](#-apache--mod--passenger--passenger_conf_package_file)
* [`passenger_data_buffer_dir`](#-apache--mod--passenger--passenger_data_buffer_dir)
* [`passenger_debug_log_file`](#-apache--mod--passenger--passenger_debug_log_file)
* [`passenger_debugger`](#-apache--mod--passenger--passenger_debugger)
* [`passenger_default_group`](#-apache--mod--passenger--passenger_default_group)
* [`passenger_default_ruby`](#-apache--mod--passenger--passenger_default_ruby)
* [`passenger_default_user`](#-apache--mod--passenger--passenger_default_user)
* [`passenger_disable_anonymous_telemetry`](#-apache--mod--passenger--passenger_disable_anonymous_telemetry)
* [`passenger_disable_log_prefix`](#-apache--mod--passenger--passenger_disable_log_prefix)
* [`passenger_disable_security_update_check`](#-apache--mod--passenger--passenger_disable_security_update_check)
* [`passenger_enabled`](#-apache--mod--passenger--passenger_enabled)
* [`passenger_dump_config_manifest`](#-apache--mod--passenger--passenger_dump_config_manifest)
* [`passenger_error_override`](#-apache--mod--passenger--passenger_error_override)
* [`passenger_file_descriptor_log_file`](#-apache--mod--passenger--passenger_file_descriptor_log_file)
* [`passenger_fly_with`](#-apache--mod--passenger--passenger_fly_with)
* [`passenger_force_max_concurrent_requests_per_process`](#-apache--mod--passenger--passenger_force_max_concurrent_requests_per_process)
* [`passenger_friendly_error_pages`](#-apache--mod--passenger--passenger_friendly_error_pages)
* [`passenger_group`](#-apache--mod--passenger--passenger_group)
* [`passenger_high_performance`](#-apache--mod--passenger--passenger_high_performance)
* [`passenger_installed_version`](#-apache--mod--passenger--passenger_installed_version)
* [`passenger_instance_registry_dir`](#-apache--mod--passenger--passenger_instance_registry_dir)
* [`passenger_load_shell_envvars`](#-apache--mod--passenger--passenger_load_shell_envvars)
* [`passenger_preload_bundler`](#-apache--mod--passenger--passenger_preload_bundler)
* [`passenger_log_file`](#-apache--mod--passenger--passenger_log_file)
* [`passenger_log_level`](#-apache--mod--passenger--passenger_log_level)
* [`passenger_lve_min_uid`](#-apache--mod--passenger--passenger_lve_min_uid)
* [`passenger_max_instances`](#-apache--mod--passenger--passenger_max_instances)
* [`passenger_max_instances_per_app`](#-apache--mod--passenger--passenger_max_instances_per_app)
* [`passenger_max_pool_size`](#-apache--mod--passenger--passenger_max_pool_size)
* [`passenger_max_preloader_idle_time`](#-apache--mod--passenger--passenger_max_preloader_idle_time)
* [`passenger_max_request_queue_size`](#-apache--mod--passenger--passenger_max_request_queue_size)
* [`passenger_max_request_time`](#-apache--mod--passenger--passenger_max_request_time)
* [`passenger_max_requests`](#-apache--mod--passenger--passenger_max_requests)
* [`passenger_max_request_queue_time`](#-apache--mod--passenger--passenger_max_request_queue_time)
* [`passenger_memory_limit`](#-apache--mod--passenger--passenger_memory_limit)
* [`passenger_meteor_app_settings`](#-apache--mod--passenger--passenger_meteor_app_settings)
* [`passenger_min_instances`](#-apache--mod--passenger--passenger_min_instances)
* [`passenger_nodejs`](#-apache--mod--passenger--passenger_nodejs)
* [`passenger_pool_idle_time`](#-apache--mod--passenger--passenger_pool_idle_time)
* [`passenger_pre_start`](#-apache--mod--passenger--passenger_pre_start)
* [`passenger_python`](#-apache--mod--passenger--passenger_python)
* [`passenger_resist_deployment_errors`](#-apache--mod--passenger--passenger_resist_deployment_errors)
* [`passenger_resolve_symlinks_in_document_root`](#-apache--mod--passenger--passenger_resolve_symlinks_in_document_root)
* [`passenger_response_buffer_high_watermark`](#-apache--mod--passenger--passenger_response_buffer_high_watermark)
* [`passenger_restart_dir`](#-apache--mod--passenger--passenger_restart_dir)
* [`passenger_rolling_restarts`](#-apache--mod--passenger--passenger_rolling_restarts)
* [`passenger_root`](#-apache--mod--passenger--passenger_root)
* [`passenger_ruby`](#-apache--mod--passenger--passenger_ruby)
* [`passenger_security_update_check_proxy`](#-apache--mod--passenger--passenger_security_update_check_proxy)
* [`passenger_show_version_in_header`](#-apache--mod--passenger--passenger_show_version_in_header)
* [`passenger_socket_backlog`](#-apache--mod--passenger--passenger_socket_backlog)
* [`passenger_spawn_dir`](#-apache--mod--passenger--passenger_spawn_dir)
* [`passenger_spawn_method`](#-apache--mod--passenger--passenger_spawn_method)
* [`passenger_start_timeout`](#-apache--mod--passenger--passenger_start_timeout)
* [`passenger_startup_file`](#-apache--mod--passenger--passenger_startup_file)
* [`passenger_stat_throttle_rate`](#-apache--mod--passenger--passenger_stat_throttle_rate)
* [`passenger_sticky_sessions`](#-apache--mod--passenger--passenger_sticky_sessions)
* [`passenger_sticky_sessions_cookie_name`](#-apache--mod--passenger--passenger_sticky_sessions_cookie_name)
* [`passenger_sticky_sessions_cookie_attributes`](#-apache--mod--passenger--passenger_sticky_sessions_cookie_attributes)
* [`passenger_thread_count`](#-apache--mod--passenger--passenger_thread_count)
* [`passenger_use_global_queue`](#-apache--mod--passenger--passenger_use_global_queue)
* [`passenger_user`](#-apache--mod--passenger--passenger_user)
* [`passenger_user_switching`](#-apache--mod--passenger--passenger_user_switching)
* [`rack_env`](#-apache--mod--passenger--rack_env)
* [`rails_env`](#-apache--mod--passenger--rails_env)
* [`rails_framework_spawner_idle_time`](#-apache--mod--passenger--rails_framework_spawner_idle_time)

##### <a name="-apache--mod--passenger--manage_repo"></a>`manage_repo`

Data type: `Boolean`

Toggle whether to manage yum repo if on a RedHat node.

Default value: `true`

##### <a name="-apache--mod--passenger--mod_id"></a>`mod_id`

Data type: `Optional[String]`

Specifies the package id.

Default value: `undef`

##### <a name="-apache--mod--passenger--mod_lib"></a>`mod_lib`

Data type: `Optional[String]`

Defines the module's shared object name. Do not configure manually without special reason.

Default value: `undef`

##### <a name="-apache--mod--passenger--mod_lib_path"></a>`mod_lib_path`

Data type: `Optional[String]`

Specifies a path to the module's libraries. Do not manually set this parameter without special reason. The `path` parameter overrides
this value.

Default value: `undef`

##### <a name="-apache--mod--passenger--mod_package"></a>`mod_package`

Data type: `Optional[String]`

Name of the module package to install.

Default value: `undef`

##### <a name="-apache--mod--passenger--mod_package_ensure"></a>`mod_package_ensure`

Data type: `Optional[String]`

Determines whether Puppet ensures the module should be installed.

Default value: `undef`

##### <a name="-apache--mod--passenger--mod_path"></a>`mod_path`

Data type: `Optional[String]`

Specifies a path to the module. Do not manually set this parameter without a special reason.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_admin_panel_url"></a>`passenger_admin_panel_url`

Data type: `Optional[String]`

Specifies a Fuse Panel URL that the Passenger to to enable monitoring, administering, analysis and troubleshooting of this Passenger instance and apps.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_admin_panel_auth_type"></a>`passenger_admin_panel_auth_type`

Data type: `Optional[Enum['basic']]`

Specifies the authentication type to use for the Fuse Panel. Currently it support only basic type of authentiction.
Ref : https://www.phusionpassenger.com/library/config/apache/reference/#passengeradminpanelauthtype

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_admin_panel_username"></a>`passenger_admin_panel_username`

Data type: `Optional[String]`

The username that Passenger should use when connecting to the Fuse Panel with basic authentication.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_admin_panel_password"></a>`passenger_admin_panel_password`

Data type: `Optional[String]`

The password that Passenger should use when connecting to the Fuse Panel with basic authentication.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_allow_encoded_slashes"></a>`passenger_allow_encoded_slashes`

Data type: `Optional[Apache::OnOff]`

Toggle whether URLs with encoded slashes (%2f) can be used (by default Apache does not support this).

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_anonymous_telemetry_proxy"></a>`passenger_anonymous_telemetry_proxy`

Data type: `Optional[String]`

Set an intermediate proxy for the Passenger anonymous telemetry reporting.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_app_env"></a>`passenger_app_env`

Data type: `Optional[String]`

This option sets, for the current application, the value of the following environment variables:
- RAILS_ENV
- RACK_ENV
- WSGI_ENV
- NODE_ENV
- PASSENGER_APP_ENV

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_app_group_name"></a>`passenger_app_group_name`

Data type: `Optional[String]`

Sets the name of the application group that the current application should belong to.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_app_log_file"></a>`passenger_app_log_file`

Data type: `Optional[String]`

File path to application specifile log file. By default passenger will write all application log messages to the Passenger log file.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_app_root"></a>`passenger_app_root`

Data type: `Optional[String]`

Path to the application root which allows access independent from the DocumentRoot.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_app_type"></a>`passenger_app_type`

Data type: `Optional[String]`

Specifies the type of the application. If you set this option, then you must also set PassengerAppRoot, otherwise Passenger will
not properly recognize your application.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_base_uri"></a>`passenger_base_uri`

Data type: `Optional[String]`

Used to specify that the given URI is an distinct application that should be served by Passenger.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_buffer_response"></a>`passenger_buffer_response`

Data type: `Optional[Apache::OnOff]`

Toggle whether application-generated responses are buffered by Apache. Buffering will happen in memory.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_buffer_upload"></a>`passenger_buffer_upload`

Data type: `Optional[Apache::OnOff]`

Toggle whether HTTP client request bodies are buffered before they are sent to the application.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_concurrency_model"></a>`passenger_concurrency_model`

Data type: `Optional[String]`

Specifies the I/O concurrency model that should be used for Ruby application processes.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_conf_file"></a>`passenger_conf_file`

Data type: `String`



Default value: `$apache::params::passenger_conf_file`

##### <a name="-apache--mod--passenger--passenger_conf_package_file"></a>`passenger_conf_package_file`

Data type: `Optional[String]`



Default value: `$apache::params::passenger_conf_package_file`

##### <a name="-apache--mod--passenger--passenger_data_buffer_dir"></a>`passenger_data_buffer_dir`

Data type: `Optional[Stdlib::Absolutepath]`

Specifies the directory in which to store data buffers.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_debug_log_file"></a>`passenger_debug_log_file`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_debugger"></a>`passenger_debugger`

Data type: `Optional[Apache::OnOff]`

Turns support for Ruby application debugging on or off.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_default_group"></a>`passenger_default_group`

Data type: `Optional[String]`

Allows you to specify the group that applications must run as, if user switching fails or is disabled.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_default_ruby"></a>`passenger_default_ruby`

Data type: `Optional[String]`

File path to desired ruby interpreter to use by default.

Default value: `$apache::params::passenger_default_ruby`

##### <a name="-apache--mod--passenger--passenger_default_user"></a>`passenger_default_user`

Data type: `Optional[String]`

Allows you to specify the user that applications must run as, if user switching fails or is disabled.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_disable_anonymous_telemetry"></a>`passenger_disable_anonymous_telemetry`

Data type: `Optional[Boolean]`

Whether or not to disable the Passenger anonymous telemetry reporting.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_disable_log_prefix"></a>`passenger_disable_log_prefix`

Data type: `Optional[Boolean]`

Whether to stop Passenger from prefixing logs when they are written to a log file.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_disable_security_update_check"></a>`passenger_disable_security_update_check`

Data type: `Optional[Apache::OnOff]`

Allows disabling the Passenger security update check, a daily check with https://securitycheck.phusionpassenger.com for important
security updates that might be available.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_enabled"></a>`passenger_enabled`

Data type: `Optional[Apache::OnOff]`

Toggles whether Passenger should be enabled for that particular context.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_dump_config_manifest"></a>`passenger_dump_config_manifest`

Data type: `Optional[String]`

Dumps the configuration manifest to the given file.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_error_override"></a>`passenger_error_override`

Data type: `Optional[Apache::OnOff]`

Toggles whether Apache will intercept and handle responses with HTTP status codes of 400 and higher.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_file_descriptor_log_file"></a>`passenger_file_descriptor_log_file`

Data type: `Optional[String]`

Log file descriptor debug tracing messages to the given file.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_fly_with"></a>`passenger_fly_with`

Data type: `Optional[String]`

Enables the Flying Passenger mode, and configures Apache to connect to the Flying Passenger daemon that's listening on the
given socket filename.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_force_max_concurrent_requests_per_process"></a>`passenger_force_max_concurrent_requests_per_process`

Data type: `Optional[Variant[Integer, String]]`

Use this option to tell Passenger how many concurrent requests the application can handle per process.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_friendly_error_pages"></a>`passenger_friendly_error_pages`

Data type: `Optional[Apache::OnOff]`

Toggles whether Passenger should display friendly error pages whenever an application fails to start.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_group"></a>`passenger_group`

Data type: `Optional[String]`

Allows you to override that behavior and explicitly set a group to run the web application as, regardless of the ownership of the
startup file.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_high_performance"></a>`passenger_high_performance`

Data type: `Optional[Apache::OnOff]`

Toggles whether to enable PassengerHighPerformance which will make Passenger will be a little faster, in return for reduced
compatibility with other Apache modules.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_installed_version"></a>`passenger_installed_version`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_instance_registry_dir"></a>`passenger_instance_registry_dir`

Data type: `Optional[String]`

Specifies the directory that Passenger should use for registering its current instance.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_load_shell_envvars"></a>`passenger_load_shell_envvars`

Data type: `Optional[Apache::OnOff]`

Enables or disables the loading of shell environment variables before spawning the application.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_preload_bundler"></a>`passenger_preload_bundler`

Data type: `Optional[Boolean]`

Enables or disables loading bundler before loading your Ruby app.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_log_file"></a>`passenger_log_file`

Data type: `Optional[Stdlib::Absolutepath]`

File path to log file. By default Passenger log messages are written to the Apache global error log.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_log_level"></a>`passenger_log_level`

Data type: `Optional[Integer]`

Specifies how much information Passenger should log to its log file. A higher log level value means that more
information will be logged.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_lve_min_uid"></a>`passenger_lve_min_uid`

Data type: `Optional[Integer]`

When using Passenger on a LVE-enabled kernel, a security check (enter) is run for spawning application processes. This options
tells the check to only allow processes with UIDs equal to, or higher than, the specified value.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_max_instances"></a>`passenger_max_instances`

Data type: `Optional[Integer]`

The maximum number of application processes that may simultaneously exist for an application.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_max_instances_per_app"></a>`passenger_max_instances_per_app`

Data type: `Optional[Integer]`

The maximum number of application processes that may simultaneously exist for a single application.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_max_pool_size"></a>`passenger_max_pool_size`

Data type: `Optional[Integer]`

The maximum number of application processes that may simultaneously exist.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_max_preloader_idle_time"></a>`passenger_max_preloader_idle_time`

Data type: `Optional[Integer]`

Set the preloader's idle timeout, in seconds. A value of 0 means that it should never idle timeout.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_max_request_queue_size"></a>`passenger_max_request_queue_size`

Data type: `Optional[Integer]`

Specifies the maximum size for the queue of all incoming requests.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_max_request_time"></a>`passenger_max_request_time`

Data type: `Optional[Integer]`

The maximum amount of time, in seconds, that an application process may take to process a request.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_max_requests"></a>`passenger_max_requests`

Data type: `Optional[Integer]`

The maximum number of requests an application process will process.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_max_request_queue_time"></a>`passenger_max_request_queue_time`

Data type: `Optional[Integer]`

The maximum amount of time, in seconds, that a request may be queued before Passenger will return an error.
This option specifies the maximum time a request may spend in that queue. If a request in the queue reaches this specified limit, then Passenger will send a "504 Gateway Timeout" error for that request.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_memory_limit"></a>`passenger_memory_limit`

Data type: `Optional[Integer]`

The maximum amount of memory that an application process may use, in megabytes.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_meteor_app_settings"></a>`passenger_meteor_app_settings`

Data type: `Optional[String]`

When using a Meteor application in non-bundled mode, use this option to specify a JSON file with settings for the application.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_min_instances"></a>`passenger_min_instances`

Data type: `Optional[Integer]`

Specifies the minimum number of application processes that should exist for a given application.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_nodejs"></a>`passenger_nodejs`

Data type: `Optional[String]`

Specifies the Node.js command to use for serving Node.js web applications.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_pool_idle_time"></a>`passenger_pool_idle_time`

Data type: `Optional[Integer]`

The maximum number of seconds that an application process may be idle.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_pre_start"></a>`passenger_pre_start`

Data type: `Optional[Variant[String, Array[String]]]`

URL of the web application you want to pre-start.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_python"></a>`passenger_python`

Data type: `Optional[String]`

Specifies the Python interpreter to use for serving Python web applications.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_resist_deployment_errors"></a>`passenger_resist_deployment_errors`

Data type: `Optional[Apache::OnOff]`

Enables or disables resistance against deployment errors.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_resolve_symlinks_in_document_root"></a>`passenger_resolve_symlinks_in_document_root`

Data type: `Optional[Apache::OnOff]`

This option is no longer available in version 5.2.0. Switch to PassengerAppRoot if you are setting the application root via a
document root containing symlinks.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_response_buffer_high_watermark"></a>`passenger_response_buffer_high_watermark`

Data type: `Optional[Variant[Integer, String]]`

Configures the maximum size of the real-time disk-backed response buffering system.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_restart_dir"></a>`passenger_restart_dir`

Data type: `Optional[String]`

Path to directory containing restart.txt file. Can be either absolute or relative.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_rolling_restarts"></a>`passenger_rolling_restarts`

Data type: `Optional[Apache::OnOff]`

Enables or disables support for zero-downtime application restarts through restart.txt.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_root"></a>`passenger_root`

Data type: `Optional[String]`

Refers to the location to the Passenger root directory, or to a location configuration file.

Default value: `$apache::params::passenger_root`

##### <a name="-apache--mod--passenger--passenger_ruby"></a>`passenger_ruby`

Data type: `Optional[String]`

Specifies the Ruby interpreter to use for serving Ruby web applications.

Default value: `$apache::params::passenger_ruby`

##### <a name="-apache--mod--passenger--passenger_security_update_check_proxy"></a>`passenger_security_update_check_proxy`

Data type: `Optional[String]`

Allows use of an intermediate proxy for the Passenger security update check.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_show_version_in_header"></a>`passenger_show_version_in_header`

Data type: `Optional[Apache::OnOff]`

Toggle whether Passenger will output its version number in the X-Powered-By header in all Passenger-served requests:

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_socket_backlog"></a>`passenger_socket_backlog`

Data type: `Optional[Variant[Integer, String]]`

This option can be raised if Apache manages to overflow the backlog queue.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_spawn_dir"></a>`passenger_spawn_dir`

Data type: `Optional[String]`

The directory in which Passenger will record progress during startup

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_spawn_method"></a>`passenger_spawn_method`

Data type: `Optional[Enum['smart', 'direct', 'smart-lv2', 'conservative']]`

Controls whether Passenger spawns applications directly, or using a prefork copy-on-write mechanism.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_start_timeout"></a>`passenger_start_timeout`

Data type: `Optional[Integer]`

Specifies a timeout for the startup of application processes.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_startup_file"></a>`passenger_startup_file`

Data type: `Optional[String]`

Specifies the startup file that Passenger should use when loading the application.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_stat_throttle_rate"></a>`passenger_stat_throttle_rate`

Data type: `Optional[Integer]`

Setting this option to a value of x means that certain filesystem checks will be performed at most once every x seconds.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_sticky_sessions"></a>`passenger_sticky_sessions`

Data type: `Optional[Apache::OnOff]`

Toggles whether all requests that a client sends will be routed to the same originating application process, whenever possible.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_sticky_sessions_cookie_name"></a>`passenger_sticky_sessions_cookie_name`

Data type: `Optional[String]`

Sets the name of the sticky sessions cookie.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_sticky_sessions_cookie_attributes"></a>`passenger_sticky_sessions_cookie_attributes`

Data type: `Optional[String]`

Sets the attributes of the sticky sessions cookie.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_thread_count"></a>`passenger_thread_count`

Data type: `Optional[Integer]`

Specifies the number of threads that Passenger should spawn per Ruby application process.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_use_global_queue"></a>`passenger_use_global_queue`

Data type: `Optional[String]`

N/A.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_user"></a>`passenger_user`

Data type: `Optional[String]`

Allows you to override that behavior and explicitly set a user to run the web application as, regardless of the ownership of the
startup file.

Default value: `undef`

##### <a name="-apache--mod--passenger--passenger_user_switching"></a>`passenger_user_switching`

Data type: `Optional[Apache::OnOff]`

Toggles whether to attempt to enable user account sandboxing, also known as user switching.

Default value: `undef`

##### <a name="-apache--mod--passenger--rack_env"></a>`rack_env`

Data type: `Optional[String]`

Alias for PassengerAppEnv.

Default value: `undef`

##### <a name="-apache--mod--passenger--rails_env"></a>`rails_env`

Data type: `Optional[String]`

Alias for PassengerAppEnv.

Default value: `undef`

##### <a name="-apache--mod--passenger--rails_framework_spawner_idle_time"></a>`rails_framework_spawner_idle_time`

Data type: `Optional[String]`

This option is no longer available in version 4.0.0. There is no alternative because framework spawning has been removed
altogether. You should use smart spawning instead.

Default value: `undef`

### <a name="apache--mod--perl"></a>`apache::mod::perl`

Installs `mod_perl`.

* **See also**
  * https://perl.apache.org
    * for additional documentation.

### <a name="apache--mod--peruser"></a>`apache::mod::peruser`

Installs `mod_peruser`.

#### Parameters

The following parameters are available in the `apache::mod::peruser` class:

* [`minspareprocessors`](#-apache--mod--peruser--minspareprocessors)
* [`minprocessors`](#-apache--mod--peruser--minprocessors)
* [`maxprocessors`](#-apache--mod--peruser--maxprocessors)
* [`maxclients`](#-apache--mod--peruser--maxclients)
* [`maxrequestsperchild`](#-apache--mod--peruser--maxrequestsperchild)
* [`idletimeout`](#-apache--mod--peruser--idletimeout)
* [`expiretimeout`](#-apache--mod--peruser--expiretimeout)
* [`keepalive`](#-apache--mod--peruser--keepalive)

##### <a name="-apache--mod--peruser--minspareprocessors"></a>`minspareprocessors`

Data type: `Integer`



Default value: `2`

##### <a name="-apache--mod--peruser--minprocessors"></a>`minprocessors`

Data type: `Integer`

The minimum amount of processors

Default value: `2`

##### <a name="-apache--mod--peruser--maxprocessors"></a>`maxprocessors`

Data type: `Integer`

The maximum amount of processors

Default value: `10`

##### <a name="-apache--mod--peruser--maxclients"></a>`maxclients`

Data type: `Integer`

The maximum amount of clients

Default value: `150`

##### <a name="-apache--mod--peruser--maxrequestsperchild"></a>`maxrequestsperchild`

Data type: `Integer`

The maximum amount of requests per child

Default value: `1000`

##### <a name="-apache--mod--peruser--idletimeout"></a>`idletimeout`

Data type: `Integer`



Default value: `120`

##### <a name="-apache--mod--peruser--expiretimeout"></a>`expiretimeout`

Data type: `Integer`



Default value: `120`

##### <a name="-apache--mod--peruser--keepalive"></a>`keepalive`

Data type: `Apache::OnOff`



Default value: `'Off'`

### <a name="apache--mod--php"></a>`apache::mod::php`

Installs `mod_php`.

* **Note** Unsupported platforms: RedHat: 9

#### Parameters

The following parameters are available in the `apache::mod::php` class:

* [`package_name`](#-apache--mod--php--package_name)
* [`package_ensure`](#-apache--mod--php--package_ensure)
* [`path`](#-apache--mod--php--path)
* [`extensions`](#-apache--mod--php--extensions)
* [`content`](#-apache--mod--php--content)
* [`template`](#-apache--mod--php--template)
* [`source`](#-apache--mod--php--source)
* [`root_group`](#-apache--mod--php--root_group)
* [`php_version`](#-apache--mod--php--php_version)
* [`libphp_prefix`](#-apache--mod--php--libphp_prefix)

##### <a name="-apache--mod--php--package_name"></a>`package_name`

Data type: `Optional[String]`

The package name

Default value: `undef`

##### <a name="-apache--mod--php--package_ensure"></a>`package_ensure`

Data type: `String`

Whether the package is `present` or `absent`

Default value: `'present'`

##### <a name="-apache--mod--php--path"></a>`path`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-apache--mod--php--extensions"></a>`extensions`

Data type: `Array`



Default value: `['.php']`

##### <a name="-apache--mod--php--content"></a>`content`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-apache--mod--php--template"></a>`template`

Data type: `String`



Default value: `'apache/mod/php.conf.erb'`

##### <a name="-apache--mod--php--source"></a>`source`

Data type: `Optional[String]`



Default value: `undef`

##### <a name="-apache--mod--php--root_group"></a>`root_group`

Data type: `Optional[String]`

UNIX group of the root user

Default value: `$apache::params::root_group`

##### <a name="-apache--mod--php--php_version"></a>`php_version`

Data type: `Optional[String]`

The php version. This is a required parameter, but optional allows showing a clear error message

Default value: `$apache::params::php_version`

##### <a name="-apache--mod--php--libphp_prefix"></a>`libphp_prefix`

Data type: `String`



Default value: `'libphp'`

### <a name="apache--mod--prefork"></a>`apache::mod::prefork`

Installs and configures MPM `prefork`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/prefork.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::prefork` class:

* [`startservers`](#-apache--mod--prefork--startservers)
* [`minspareservers`](#-apache--mod--prefork--minspareservers)
* [`maxspareservers`](#-apache--mod--prefork--maxspareservers)
* [`serverlimit`](#-apache--mod--prefork--serverlimit)
* [`maxclients`](#-apache--mod--prefork--maxclients)
* [`maxrequestworkers`](#-apache--mod--prefork--maxrequestworkers)
* [`maxrequestsperchild`](#-apache--mod--prefork--maxrequestsperchild)
* [`maxconnectionsperchild`](#-apache--mod--prefork--maxconnectionsperchild)
* [`listenbacklog`](#-apache--mod--prefork--listenbacklog)

##### <a name="-apache--mod--prefork--startservers"></a>`startservers`

Data type: `Integer`

Number of child server processes created at startup.

Default value: `8`

##### <a name="-apache--mod--prefork--minspareservers"></a>`minspareservers`

Data type: `Integer`

Minimum number of idle child server processes.

Default value: `5`

##### <a name="-apache--mod--prefork--maxspareservers"></a>`maxspareservers`

Data type: `Integer`

Maximum number of idle child server processes.

Default value: `20`

##### <a name="-apache--mod--prefork--serverlimit"></a>`serverlimit`

Data type: `Integer`

Upper limit on configurable number of processes.

Default value: `256`

##### <a name="-apache--mod--prefork--maxclients"></a>`maxclients`

Data type: `Integer`

Old alias for MaxRequestWorkers.

Default value: `256`

##### <a name="-apache--mod--prefork--maxrequestworkers"></a>`maxrequestworkers`

Data type: `Optional[Integer]`

Maximum number of connections that will be processed simultaneously.

Default value: `undef`

##### <a name="-apache--mod--prefork--maxrequestsperchild"></a>`maxrequestsperchild`

Data type: `Integer`

Old alias for MaxConnectionsPerChild.

Default value: `4000`

##### <a name="-apache--mod--prefork--maxconnectionsperchild"></a>`maxconnectionsperchild`

Data type: `Optional[Integer]`

Limit on the number of connections that an individual child server will handle during its life.

Default value: `undef`

##### <a name="-apache--mod--prefork--listenbacklog"></a>`listenbacklog`

Data type: `Integer`

Maximum length of the queue of pending connections.

Default value: `511`

### <a name="apache--mod--proxy"></a>`apache::mod::proxy`

Installs and configures `mod_proxy`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_proxy.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::proxy` class:

* [`proxy_requests`](#-apache--mod--proxy--proxy_requests)
* [`allow_from`](#-apache--mod--proxy--allow_from)
* [`package_name`](#-apache--mod--proxy--package_name)
* [`proxy_via`](#-apache--mod--proxy--proxy_via)
* [`proxy_timeout`](#-apache--mod--proxy--proxy_timeout)
* [`proxy_iobuffersize`](#-apache--mod--proxy--proxy_iobuffersize)

##### <a name="-apache--mod--proxy--proxy_requests"></a>`proxy_requests`

Data type: `String`

Enables forward (standard) proxy requests.

Default value: `'Off'`

##### <a name="-apache--mod--proxy--allow_from"></a>`allow_from`

Data type: `Optional[Variant[Stdlib::IP::Address, Array[Stdlib::IP::Address]]]`

IP address or list of IPs allowed to access proxy.

Default value: `undef`

##### <a name="-apache--mod--proxy--package_name"></a>`package_name`

Data type: `Optional[String]`

Name of the proxy package to install.

Default value: `undef`

##### <a name="-apache--mod--proxy--proxy_via"></a>`proxy_via`

Data type: `String`

Set local IP address for outgoing proxy connections.

Default value: `'On'`

##### <a name="-apache--mod--proxy--proxy_timeout"></a>`proxy_timeout`

Data type: `Optional[Integer[0]]`

Network timeout for proxied requests.

Default value: `undef`

##### <a name="-apache--mod--proxy--proxy_iobuffersize"></a>`proxy_iobuffersize`

Data type: `Optional[String]`

Set the size of internal data throughput buffer

Default value: `undef`

### <a name="apache--mod--proxy_ajp"></a>`apache::mod::proxy_ajp`

Installs `mod_proxy_ajp`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_proxy_ajp.html
    * for additional documentation.

### <a name="apache--mod--proxy_balancer"></a>`apache::mod::proxy_balancer`

Installs and configures `mod_proxy_balancer`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_proxy_balancer.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::proxy_balancer` class:

* [`manager`](#-apache--mod--proxy_balancer--manager)
* [`manager_path`](#-apache--mod--proxy_balancer--manager_path)
* [`allow_from`](#-apache--mod--proxy_balancer--allow_from)

##### <a name="-apache--mod--proxy_balancer--manager"></a>`manager`

Data type: `Boolean`

Toggle whether to enable balancer manager support.

Default value: `false`

##### <a name="-apache--mod--proxy_balancer--manager_path"></a>`manager_path`

Data type: `Stdlib::Unixpath`

Server relative path to balancer manager.

Default value: `'/balancer-manager'`

##### <a name="-apache--mod--proxy_balancer--allow_from"></a>`allow_from`

Data type: `Array[Stdlib::IP::Address]`

List of IPs from which the balancer manager can be accessed.

Default value: `['127.0.0.1', '::1']`

### <a name="apache--mod--proxy_connect"></a>`apache::mod::proxy_connect`

Installs `mod_proxy_connect`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_proxy_connect.html
    * for additional documentation.

### <a name="apache--mod--proxy_fcgi"></a>`apache::mod::proxy_fcgi`

Installs `mod_proxy_fcgi`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_proxy_fcgi.html
    * for additional documentation.

### <a name="apache--mod--proxy_html"></a>`apache::mod::proxy_html`

Installs `mod_proxy_html`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_proxy_html.html
    * for additional documentation.

### <a name="apache--mod--proxy_http"></a>`apache::mod::proxy_http`

Installs `mod_proxy_http`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_proxy_http.html
    * for additional documentation.

### <a name="apache--mod--proxy_http2"></a>`apache::mod::proxy_http2`

Installs `mod_proxy_http2`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_proxy_http2.html
    * for additional documentation.

### <a name="apache--mod--proxy_wstunnel"></a>`apache::mod::proxy_wstunnel`

Installs `mod_proxy_wstunnel`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_proxy_wstunnel.html
    * for additional documentation.

### <a name="apache--mod--python"></a>`apache::mod::python`

Installs and configures `mod_python`.

* **See also**
  * https://github.com/grisha/mod_python
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::python` class:

* [`loadfile_name`](#-apache--mod--python--loadfile_name)

##### <a name="-apache--mod--python--loadfile_name"></a>`loadfile_name`

Data type: `Optional[String]`

Sets the name of the configuration file that is used to load the python module.

Default value: `undef`

### <a name="apache--mod--remoteip"></a>`apache::mod::remoteip`

Installs and configures `mod_remoteip`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_remoteip.html
  * https://httpd.apache.org/docs/current/mod/mod_remoteip.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::remoteip` class:

* [`header`](#-apache--mod--remoteip--header)
* [`internal_proxy`](#-apache--mod--remoteip--internal_proxy)
* [`proxy_ips`](#-apache--mod--remoteip--proxy_ips)
* [`internal_proxy_list`](#-apache--mod--remoteip--internal_proxy_list)
* [`proxies_header`](#-apache--mod--remoteip--proxies_header)
* [`proxy_protocol`](#-apache--mod--remoteip--proxy_protocol)
* [`proxy_protocol_exceptions`](#-apache--mod--remoteip--proxy_protocol_exceptions)
* [`trusted_proxy`](#-apache--mod--remoteip--trusted_proxy)
* [`trusted_proxy_ips`](#-apache--mod--remoteip--trusted_proxy_ips)
* [`trusted_proxy_list`](#-apache--mod--remoteip--trusted_proxy_list)

##### <a name="-apache--mod--remoteip--header"></a>`header`

Data type: `String`

The header field in which `mod_remoteip` will look for the useragent IP.

Default value: `'X-Forwarded-For'`

##### <a name="-apache--mod--remoteip--internal_proxy"></a>`internal_proxy`

Data type: `Optional[Array[Stdlib::Host]]`

A list of IP addresses, IP blocks or hostname that are trusted to set a
valid value inside specified header. Unlike the `$trusted_proxy_ips`
parameter, any IP address (including private addresses) presented by these
proxies will trusted by `mod_remoteip`.

Default value: `undef`

##### <a name="-apache--mod--remoteip--proxy_ips"></a>`proxy_ips`

Data type: `Optional[Array[Stdlib::Host]]`

*Deprecated*: use `$internal_proxy` instead.

Default value: `undef`

##### <a name="-apache--mod--remoteip--internal_proxy_list"></a>`internal_proxy_list`

Data type: `Optional[Stdlib::Absolutepath]`

The path to a file containing a list of IP addresses, IP blocks or hostname
that are trusted to set a valid value inside the specified header. See
`$internal_proxy` for details.

Default value: `undef`

##### <a name="-apache--mod--remoteip--proxies_header"></a>`proxies_header`

Data type: `Optional[String]`

A header into which `mod_remoteip` will collect a list of all of the
intermediate client IP addresses trusted to resolve the useragent IP of the
request (e.g. `X-Forwarded-By`).

Default value: `undef`

##### <a name="-apache--mod--remoteip--proxy_protocol"></a>`proxy_protocol`

Data type: `Boolean`

Wether or not to enable the PROXY protocol header handling. If enabled
upstream clients must set the header every time they open a connection.

Default value: `false`

##### <a name="-apache--mod--remoteip--proxy_protocol_exceptions"></a>`proxy_protocol_exceptions`

Data type: `Optional[Array[Stdlib::Host]]`

A list of IP address or IP blocks that are not required to use the PROXY
protocol.

Default value: `undef`

##### <a name="-apache--mod--remoteip--trusted_proxy"></a>`trusted_proxy`

Data type: `Optional[Array[Stdlib::Host]]`

A list of IP addresses, IP blocks or hostname that are trusted to set a
valid value inside the specified header. Unlike the `$proxy_ips` parameter,
any private IP presented by these proxies will be disgarded by
`mod_remoteip`.

Default value: `undef`

##### <a name="-apache--mod--remoteip--trusted_proxy_ips"></a>`trusted_proxy_ips`

Data type: `Optional[Array[Stdlib::Host]]`

*Deprecated*: use `$trusted_proxy` instead.

Default value: `undef`

##### <a name="-apache--mod--remoteip--trusted_proxy_list"></a>`trusted_proxy_list`

Data type: `Optional[Stdlib::Absolutepath]`

The path to a file containing a list of IP addresses, IP blocks or hostname
that are trusted to set a valid value inside the specified header. See
`$trusted_proxy` for details.

Default value: `undef`

### <a name="apache--mod--reqtimeout"></a>`apache::mod::reqtimeout`

Installs and configures `mod_reqtimeout`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_reqtimeout.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::reqtimeout` class:

* [`timeouts`](#-apache--mod--reqtimeout--timeouts)

##### <a name="-apache--mod--reqtimeout--timeouts"></a>`timeouts`

Data type: `Variant[Array[String], String]`

List of timeouts and data rates for receiving requests.

Default value: `['header=20-40,minrate=500', 'body=10,minrate=500']`

### <a name="apache--mod--rewrite"></a>`apache::mod::rewrite`

Installs `mod_rewrite`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_rewrite.html
    * for additional documentation.

### <a name="apache--mod--rpaf"></a>`apache::mod::rpaf`

Installs and configures `mod_rpaf`.

* **See also**
  * https://github.com/gnif/mod_rpaf
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::rpaf` class:

* [`sethostname`](#-apache--mod--rpaf--sethostname)
* [`proxy_ips`](#-apache--mod--rpaf--proxy_ips)
* [`header`](#-apache--mod--rpaf--header)
* [`template`](#-apache--mod--rpaf--template)

##### <a name="-apache--mod--rpaf--sethostname"></a>`sethostname`

Data type: `Variant[Boolean, String]`

Toggles whether to update vhost name so ServerName and ServerAlias work.

Default value: `true`

##### <a name="-apache--mod--rpaf--proxy_ips"></a>`proxy_ips`

Data type: `Array[Stdlib::IP::Address]`

List of IPs & bitmasked subnets to adjust requests for

Default value: `['127.0.0.1']`

##### <a name="-apache--mod--rpaf--header"></a>`header`

Data type: `String`

Header to use for the real IP address.

Default value: `'X-Forwarded-For'`

##### <a name="-apache--mod--rpaf--template"></a>`template`

Data type: `String`

Path to template to use for configuring mod_rpaf.

Default value: `'apache/mod/rpaf.conf.epp'`

### <a name="apache--mod--security"></a>`apache::mod::security`

Installs and configures `mod_security`.

* **See also**
  * https://github.com/SpiderLabs/ModSecurity/wiki
    * for additional documentation.
  * https://coreruleset.org/docs/
    * for addional documentation

#### Parameters

The following parameters are available in the `apache::mod::security` class:

* [`version`](#-apache--mod--security--version)
* [`logroot`](#-apache--mod--security--logroot)
* [`crs_package`](#-apache--mod--security--crs_package)
* [`activated_rules`](#-apache--mod--security--activated_rules)
* [`custom_rules`](#-apache--mod--security--custom_rules)
* [`custom_rules_set`](#-apache--mod--security--custom_rules_set)
* [`modsec_dir`](#-apache--mod--security--modsec_dir)
* [`modsec_secruleengine`](#-apache--mod--security--modsec_secruleengine)
* [`audit_log_relevant_status`](#-apache--mod--security--audit_log_relevant_status)
* [`audit_log_parts`](#-apache--mod--security--audit_log_parts)
* [`audit_log_type`](#-apache--mod--security--audit_log_type)
* [`audit_log_storage_dir`](#-apache--mod--security--audit_log_storage_dir)
* [`secpcrematchlimit`](#-apache--mod--security--secpcrematchlimit)
* [`secpcrematchlimitrecursion`](#-apache--mod--security--secpcrematchlimitrecursion)
* [`allowed_methods`](#-apache--mod--security--allowed_methods)
* [`content_types`](#-apache--mod--security--content_types)
* [`restricted_extensions`](#-apache--mod--security--restricted_extensions)
* [`restricted_headers`](#-apache--mod--security--restricted_headers)
* [`secdefaultaction`](#-apache--mod--security--secdefaultaction)
* [`inbound_anomaly_threshold`](#-apache--mod--security--inbound_anomaly_threshold)
* [`outbound_anomaly_threshold`](#-apache--mod--security--outbound_anomaly_threshold)
* [`critical_anomaly_score`](#-apache--mod--security--critical_anomaly_score)
* [`error_anomaly_score`](#-apache--mod--security--error_anomaly_score)
* [`warning_anomaly_score`](#-apache--mod--security--warning_anomaly_score)
* [`notice_anomaly_score`](#-apache--mod--security--notice_anomaly_score)
* [`paranoia_level`](#-apache--mod--security--paranoia_level)
* [`executing_paranoia_level`](#-apache--mod--security--executing_paranoia_level)
* [`secrequestmaxnumargs`](#-apache--mod--security--secrequestmaxnumargs)
* [`secrequestbodylimit`](#-apache--mod--security--secrequestbodylimit)
* [`secrequestbodynofileslimit`](#-apache--mod--security--secrequestbodynofileslimit)
* [`secrequestbodyinmemorylimit`](#-apache--mod--security--secrequestbodyinmemorylimit)
* [`secrequestbodyaccess`](#-apache--mod--security--secrequestbodyaccess)
* [`secrequestbodylimitaction`](#-apache--mod--security--secrequestbodylimitaction)
* [`secresponsebodyaccess`](#-apache--mod--security--secresponsebodyaccess)
* [`secresponsebodylimitaction`](#-apache--mod--security--secresponsebodylimitaction)
* [`manage_security_crs`](#-apache--mod--security--manage_security_crs)
* [`enable_dos_protection`](#-apache--mod--security--enable_dos_protection)
* [`dos_burst_time_slice`](#-apache--mod--security--dos_burst_time_slice)
* [`dos_counter_threshold`](#-apache--mod--security--dos_counter_threshold)
* [`dos_block_timeout`](#-apache--mod--security--dos_block_timeout)

##### <a name="-apache--mod--security--version"></a>`version`

Data type: `Integer`

Manage mod_security or mod_security2

Default value: `$apache::params::modsec_version`

##### <a name="-apache--mod--security--logroot"></a>`logroot`

Data type: `Stdlib::Absolutepath`

Configures the location of audit and debug logs.

Default value: `$apache::params::logroot`

##### <a name="-apache--mod--security--crs_package"></a>`crs_package`

Data type: `Optional[String]`

Name of package that installs CRS rules.

Default value: `$apache::params::modsec_crs_package`

##### <a name="-apache--mod--security--activated_rules"></a>`activated_rules`

Data type: `Array[String]`

An array of rules from the modsec_crs_path or absolute to activate via symlinks.

Default value: `$apache::params::modsec_default_rules`

##### <a name="-apache--mod--security--custom_rules"></a>`custom_rules`

Data type: `Boolean`



Default value: `$apache::params::modsec_custom_rules`

##### <a name="-apache--mod--security--custom_rules_set"></a>`custom_rules_set`

Data type: `Optional[Array[String]]`



Default value: `$apache::params::modsec_custom_rules_set`

##### <a name="-apache--mod--security--modsec_dir"></a>`modsec_dir`

Data type: `Stdlib::Absolutepath`

Defines the path where Puppet installs the modsec configuration and activated rules links.

Default value: `$apache::params::modsec_dir`

##### <a name="-apache--mod--security--modsec_secruleengine"></a>`modsec_secruleengine`

Data type: `String`

Configures the rules engine.

Default value: `$apache::params::modsec_secruleengine`

##### <a name="-apache--mod--security--audit_log_relevant_status"></a>`audit_log_relevant_status`

Data type: `String`

Configures which response status code is to be considered relevant for the purpose of audit logging.

Default value: `'^(?:5|4(?!04))'`

##### <a name="-apache--mod--security--audit_log_parts"></a>`audit_log_parts`

Data type: `String`

Defines which parts of each transaction are going to be recorded in the audit log. Each part is assigned a single letter; when a
letter appears in the list then the equivalent part will be recorded.

Default value: `$apache::params::modsec_audit_log_parts`

##### <a name="-apache--mod--security--audit_log_type"></a>`audit_log_type`

Data type: `String`

Defines the type of audit logging mechanism to be used.

Default value: `$apache::params::modsec_audit_log_type`

##### <a name="-apache--mod--security--audit_log_storage_dir"></a>`audit_log_storage_dir`

Data type: `Optional[Stdlib::Absolutepath]`

Defines the directory where concurrent audit log entries are to be stored. This directive is only needed when concurrent audit logging is used.

Default value: `undef`

##### <a name="-apache--mod--security--secpcrematchlimit"></a>`secpcrematchlimit`

Data type: `Integer`

Sets the match limit in the PCRE library.

Default value: `$apache::params::secpcrematchlimit`

##### <a name="-apache--mod--security--secpcrematchlimitrecursion"></a>`secpcrematchlimitrecursion`

Data type: `Integer`

Sets the match limit recursion in the PCRE library.

Default value: `$apache::params::secpcrematchlimitrecursion`

##### <a name="-apache--mod--security--allowed_methods"></a>`allowed_methods`

Data type: `String`

A space-separated list of allowed HTTP methods.

Default value: `'GET HEAD POST OPTIONS'`

##### <a name="-apache--mod--security--content_types"></a>`content_types`

Data type: `String`

A list of one or more allowed MIME types.

Default value: `'application/x-www-form-urlencoded|multipart/form-data|text/xml|application/xml|application/x-amf'`

##### <a name="-apache--mod--security--restricted_extensions"></a>`restricted_extensions`

Data type: `String`

A space-sparated list of prohibited file extensions.

Default value: `'.asa/ .asax/ .ascx/ .axd/ .backup/ .bak/ .bat/ .cdx/ .cer/ .cfg/ .cmd/ .com/ .config/ .conf/ .cs/ .csproj/ .csr/ .dat/ .db/ .dbf/ .dll/ .dos/ .htr/ .htw/ .ida/ .idc/ .idq/ .inc/ .ini/ .key/ .licx/ .lnk/ .log/ .mdb/ .old/ .pass/ .pdb/ .pol/ .printer/ .pwd/ .resources/ .resx/ .sql/ .sys/ .vb/ .vbs/ .vbproj/ .vsdisco/ .webinfo/ .xsd/ .xsx/'`

##### <a name="-apache--mod--security--restricted_headers"></a>`restricted_headers`

Data type: `String`

A list of restricted headers separated by slashes and spaces.

Default value: `'/Proxy-Connection/ /Lock-Token/ /Content-Range/ /Translate/ /via/ /if/'`

##### <a name="-apache--mod--security--secdefaultaction"></a>`secdefaultaction`

Data type: `String`

Defines the default list of actions, which will be inherited by the rules in the same configuration context.

Default value: `'deny'`

##### <a name="-apache--mod--security--inbound_anomaly_threshold"></a>`inbound_anomaly_threshold`

Data type: `Integer`

Sets the scoring threshold level of the inbound blocking rules for the Collaborative Detection Mode in the OWASP ModSecurity Core Rule Set.

Default value: `5`

##### <a name="-apache--mod--security--outbound_anomaly_threshold"></a>`outbound_anomaly_threshold`

Data type: `Integer`

Sets the scoring threshold level of the outbound blocking rules for the Collaborative Detection Mode in the OWASP ModSecurity Core Rule Set.

Default value: `4`

##### <a name="-apache--mod--security--critical_anomaly_score"></a>`critical_anomaly_score`

Data type: `Integer`

Sets the Anomaly Score for rules assigned with a critical severity.

Default value: `5`

##### <a name="-apache--mod--security--error_anomaly_score"></a>`error_anomaly_score`

Data type: `Integer`

Sets the Anomaly Score for rules assigned with a error severity.

Default value: `4`

##### <a name="-apache--mod--security--warning_anomaly_score"></a>`warning_anomaly_score`

Data type: `Integer`

Sets the Anomaly Score for rules assigned with a warning severity.

Default value: `3`

##### <a name="-apache--mod--security--notice_anomaly_score"></a>`notice_anomaly_score`

Data type: `Integer`

Sets the Anomaly Score for rules assigned with a notice severity.

Default value: `2`

##### <a name="-apache--mod--security--paranoia_level"></a>`paranoia_level`

Data type: `Integer[1,4]`

Sets the paranoia level in the OWASP ModSecurity Core Rule Set.

Default value: `1`

##### <a name="-apache--mod--security--executing_paranoia_level"></a>`executing_paranoia_level`

Data type: `Integer[1,4]`

Sets the executing paranoia level in the OWASP ModSecurity Core Rule Set.
The default is equal to, and cannot be lower than, $paranoia_level.

Default value: `$paranoia_level`

##### <a name="-apache--mod--security--secrequestmaxnumargs"></a>`secrequestmaxnumargs`

Data type: `Integer`

Sets the maximum number of arguments in the request.

Default value: `255`

##### <a name="-apache--mod--security--secrequestbodylimit"></a>`secrequestbodylimit`

Data type: `Integer`

Sets the maximum request body size ModSecurity will accept for buffering.

Default value: `13107200`

##### <a name="-apache--mod--security--secrequestbodynofileslimit"></a>`secrequestbodynofileslimit`

Data type: `Integer`

Configures the maximum request body size ModSecurity will accept for buffering, excluding the size of any files being transported
in the request.

Default value: `131072`

##### <a name="-apache--mod--security--secrequestbodyinmemorylimit"></a>`secrequestbodyinmemorylimit`

Data type: `Integer`

Configures the maximum request body size that ModSecurity will store in memory.

Default value: `131072`

##### <a name="-apache--mod--security--secrequestbodyaccess"></a>`secrequestbodyaccess`

Data type: `Apache::OnOff`

Toggle SecRequestBodyAccess On or Off

Default value: `'On'`

##### <a name="-apache--mod--security--secrequestbodylimitaction"></a>`secrequestbodylimitaction`

Data type: `Enum['Reject', 'ProcessPartial']`

Controls what happens once a request body limit, configured with
SecRequestBodyLimit, is encountered

Default value: `'Reject'`

##### <a name="-apache--mod--security--secresponsebodyaccess"></a>`secresponsebodyaccess`

Data type: `Apache::OnOff`

Toggle SecResponseBodyAccess On or Off

Default value: `'Off'`

##### <a name="-apache--mod--security--secresponsebodylimitaction"></a>`secresponsebodylimitaction`

Data type: `Enum['Reject', 'ProcessPartial']`

Controls what happens once a response body limit, configured with
SecResponseBodyLimitAction, is encountered.

Default value: `'ProcessPartial'`

##### <a name="-apache--mod--security--manage_security_crs"></a>`manage_security_crs`

Data type: `Boolean`

Toggles whether to manage ModSecurity Core Rule Set

Default value: `true`

##### <a name="-apache--mod--security--enable_dos_protection"></a>`enable_dos_protection`

Data type: `Boolean`

Toggles the optional OWASP ModSecurity Core Rule Set DOS protection rule
(rule id 900700)

Default value: `true`

##### <a name="-apache--mod--security--dos_burst_time_slice"></a>`dos_burst_time_slice`

Data type: `Integer[1, default]`

Configures time in which a burst is measured for the OWASP ModSecurity Core Rule Set DOS protection rule
(rule id 900700)

Default value: `60`

##### <a name="-apache--mod--security--dos_counter_threshold"></a>`dos_counter_threshold`

Data type: `Integer[1, default]`

Configures the amount of requests that can be made within dos_burst_time_slice before it is considered a burst in
the OWASP ModSecurity Core Rule Set DOS protection rule (rule id 900700)

Default value: `100`

##### <a name="-apache--mod--security--dos_block_timeout"></a>`dos_block_timeout`

Data type: `Integer[1, default]`

Configures how long the client should be blocked when the dos_counter_threshold is exceeded in the OWASP
ModSecurity Core Rule Set DOS protection rule (rule id 900700)

Default value: `600`

### <a name="apache--mod--setenvif"></a>`apache::mod::setenvif`

Installs `mod_setenvif`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_setenvif.html
    * for additional documentation.

### <a name="apache--mod--shib"></a>`apache::mod::shib`

This class installs and configures only the Apache components of a web application that consumes Shibboleth SSO identities. You
can manage the Shibboleth configuration manually, with Puppet, or using a [Shibboleth Puppet Module](https://github.com/aethylred/puppet-shibboleth).

* **Note** The Shibboleth module isn't available on RH/CentOS without providing dependency packages provided by Shibboleth's repositories.
See the [Shibboleth Service Provider Installation Guide](http://wiki.aaf.edu.au/tech-info/sp-install-guide).

* **See also**
  * https://wiki.shibboleth.net/confluence/display/SHIB2/NativeSPApacheConfig
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::shib` class:

* [`suppress_warning`](#-apache--mod--shib--suppress_warning)
* [`mod_full_path`](#-apache--mod--shib--mod_full_path)
* [`package_name`](#-apache--mod--shib--package_name)
* [`mod_lib`](#-apache--mod--shib--mod_lib)

##### <a name="-apache--mod--shib--suppress_warning"></a>`suppress_warning`

Data type: `Boolean`

Toggles whether to trigger warning on RedHat nodes.

Default value: `false`

##### <a name="-apache--mod--shib--mod_full_path"></a>`mod_full_path`

Data type: `Optional[Stdlib::Absolutepath]`

Specifies a path to the module. Do not manually set this parameter without a special reason.

Default value: `undef`

##### <a name="-apache--mod--shib--package_name"></a>`package_name`

Data type: `Optional[String]`

Name of the Shibboleth package to be installed.

Default value: `undef`

##### <a name="-apache--mod--shib--mod_lib"></a>`mod_lib`

Data type: `Optional[String]`

Specifies a path to the module's libraries. Do not manually set this parameter without special reason. The `path` parameter
overrides this value.

Default value: `undef`

### <a name="apache--mod--socache_shmcb"></a>`apache::mod::socache_shmcb`

Installs `mod_socache_shmcb`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_socache_shmcb.html
    * for additional documentation.

### <a name="apache--mod--speling"></a>`apache::mod::speling`

Installs `mod_spelling`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_speling.html
    * for additional documentation.

### <a name="apache--mod--ssl"></a>`apache::mod::ssl`

On most operating systems, the ssl.conf is placed in the module configuration directory. On Red Hat based operating systems, this
file is placed in /etc/httpd/conf.d, the same location in which the RPM stores the configuration.

To use SSL with a virtual host, you must either set the default_ssl_vhost parameter in ::apache to true or the ssl parameter in
apache::vhost to true.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_ssl.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::ssl` class:

* [`ssl_compression`](#-apache--mod--ssl--ssl_compression)
* [`ssl_sessiontickets`](#-apache--mod--ssl--ssl_sessiontickets)
* [`ssl_cryptodevice`](#-apache--mod--ssl--ssl_cryptodevice)
* [`ssl_options`](#-apache--mod--ssl--ssl_options)
* [`ssl_openssl_conf_cmd`](#-apache--mod--ssl--ssl_openssl_conf_cmd)
* [`ssl_cert`](#-apache--mod--ssl--ssl_cert)
* [`ssl_key`](#-apache--mod--ssl--ssl_key)
* [`ssl_ca`](#-apache--mod--ssl--ssl_ca)
* [`ssl_cipher`](#-apache--mod--ssl--ssl_cipher)
* [`ssl_honorcipherorder`](#-apache--mod--ssl--ssl_honorcipherorder)
* [`ssl_protocol`](#-apache--mod--ssl--ssl_protocol)
* [`ssl_proxy_protocol`](#-apache--mod--ssl--ssl_proxy_protocol)
* [`ssl_proxy_cipher_suite`](#-apache--mod--ssl--ssl_proxy_cipher_suite)
* [`ssl_pass_phrase_dialog`](#-apache--mod--ssl--ssl_pass_phrase_dialog)
* [`ssl_random_seed_bytes`](#-apache--mod--ssl--ssl_random_seed_bytes)
* [`ssl_sessioncache`](#-apache--mod--ssl--ssl_sessioncache)
* [`ssl_sessioncachetimeout`](#-apache--mod--ssl--ssl_sessioncachetimeout)
* [`ssl_stapling`](#-apache--mod--ssl--ssl_stapling)
* [`stapling_cache`](#-apache--mod--ssl--stapling_cache)
* [`ssl_stapling_return_errors`](#-apache--mod--ssl--ssl_stapling_return_errors)
* [`ssl_mutex`](#-apache--mod--ssl--ssl_mutex)
* [`ssl_reload_on_change`](#-apache--mod--ssl--ssl_reload_on_change)
* [`package_name`](#-apache--mod--ssl--package_name)

##### <a name="-apache--mod--ssl--ssl_compression"></a>`ssl_compression`

Data type: `Boolean`

Enable compression on the SSL level.

Default value: `false`

##### <a name="-apache--mod--ssl--ssl_sessiontickets"></a>`ssl_sessiontickets`

Data type: `Optional[Boolean]`

Enable or disable use of TLS session tickets

Default value: `undef`

##### <a name="-apache--mod--ssl--ssl_cryptodevice"></a>`ssl_cryptodevice`

Data type: `String`

Enable use of a cryptographic hardware accelerator.

Default value: `'builtin'`

##### <a name="-apache--mod--ssl--ssl_options"></a>`ssl_options`

Data type: `Array[String]`

Configure various SSL engine run-time options.

Default value: `['StdEnvVars']`

##### <a name="-apache--mod--ssl--ssl_openssl_conf_cmd"></a>`ssl_openssl_conf_cmd`

Data type: `Optional[String]`

Configure OpenSSL parameters through its SSL_CONF API.

Default value: `undef`

##### <a name="-apache--mod--ssl--ssl_cert"></a>`ssl_cert`

Data type: `Optional[Stdlib::Absolutepath]`

Path to server PEM-encoded X.509 certificate data file.

Default value: `undef`

##### <a name="-apache--mod--ssl--ssl_key"></a>`ssl_key`

Data type: `Optional[Stdlib::Absolutepath]`

Path to server PEM-encoded private key file

Default value: `undef`

##### <a name="-apache--mod--ssl--ssl_ca"></a>`ssl_ca`

Data type: `Optional[Stdlib::Absolutepath]`

File of concatenated PEM-encoded CA Certificates for Client Auth.

Default value: `undef`

##### <a name="-apache--mod--ssl--ssl_cipher"></a>`ssl_cipher`

Data type: `Variant[String[1], Hash[String[1], String[1]]]`

Cipher Suite available for negotiation in SSL handshake.

Default value: `$apache::params::ssl_cipher`

##### <a name="-apache--mod--ssl--ssl_honorcipherorder"></a>`ssl_honorcipherorder`

Data type: `Variant[Boolean, Apache::OnOff]`

Option to prefer the server's cipher preference order.

Default value: `true`

##### <a name="-apache--mod--ssl--ssl_protocol"></a>`ssl_protocol`

Data type: `Array[String]`

Configure usable SSL/TLS protocol versions.
Default based on the OS:
- RedHat 8: [ 'all' ].
- Other Platforms: [ 'all', '-SSLv2', '-SSLv3' ].

Default value: `$apache::params::ssl_protocol`

##### <a name="-apache--mod--ssl--ssl_proxy_protocol"></a>`ssl_proxy_protocol`

Data type: `Array`

Configure usable SSL protocol flavors for proxy usage.

Default value: `[]`

##### <a name="-apache--mod--ssl--ssl_proxy_cipher_suite"></a>`ssl_proxy_cipher_suite`

Data type: `Optional[String[1]]`

Configure usable SSL ciphers for proxy usage. Equivalent to ssl_cipher but for proxy connections.

Default value: `$apache::params::ssl_proxy_cipher_suite`

##### <a name="-apache--mod--ssl--ssl_pass_phrase_dialog"></a>`ssl_pass_phrase_dialog`

Data type: `String`

Type of pass phrase dialog for encrypted private keys.

Default value: `'builtin'`

##### <a name="-apache--mod--ssl--ssl_random_seed_bytes"></a>`ssl_random_seed_bytes`

Data type: `Integer`

Pseudo Random Number Generator (PRNG) seeding source.

Default value: `512`

##### <a name="-apache--mod--ssl--ssl_sessioncache"></a>`ssl_sessioncache`

Data type: `String`

Configures the storage type of the global/inter-process SSL Session Cache

Default value: `$apache::params::ssl_sessioncache`

##### <a name="-apache--mod--ssl--ssl_sessioncachetimeout"></a>`ssl_sessioncachetimeout`

Data type: `Integer`

Number of seconds before an SSL session expires in the Session Cache.

Default value: `300`

##### <a name="-apache--mod--ssl--ssl_stapling"></a>`ssl_stapling`

Data type: `Boolean`

Enable stapling of OCSP responses in the TLS handshake.

Default value: `false`

##### <a name="-apache--mod--ssl--stapling_cache"></a>`stapling_cache`

Data type: `Optional[String]`

Configures the cache used to store OCSP responses which get included in
the TLS handshake if SSLUseStapling is enabled.

Default value: `undef`

##### <a name="-apache--mod--ssl--ssl_stapling_return_errors"></a>`ssl_stapling_return_errors`

Data type: `Optional[Boolean]`

Pass stapling related OCSP errors on to client.

Default value: `undef`

##### <a name="-apache--mod--ssl--ssl_mutex"></a>`ssl_mutex`

Data type: `String`

Configures mutex mechanism and lock file directory for all or specified mutexes.

Default value: `'default'`

##### <a name="-apache--mod--ssl--ssl_reload_on_change"></a>`ssl_reload_on_change`

Data type: `Boolean`

Enable reloading of apache if the content of ssl files have changed. It only affects ssl files configured here and not vhost ones.

Default value: `false`

##### <a name="-apache--mod--ssl--package_name"></a>`package_name`

Data type: `Optional[String]`

Name of ssl package to install.

Default value: `undef`

### <a name="apache--mod--status"></a>`apache::mod::status`

Installs and configures `mod_status`.

* **See also**
  * http://httpd.apache.org/docs/current/mod/mod_status.html
    * for additional documentation.

#### Examples

##### 

```puppet
# Simple usage allowing access from localhost and a private subnet
class { 'apache::mod::status':
  requires => 'ip 127.0.0.1 ::1 10.10.10.10/24',
}
```

#### Parameters

The following parameters are available in the `apache::mod::status` class:

* [`requires`](#-apache--mod--status--requires)
* [`extended_status`](#-apache--mod--status--extended_status)
* [`status_path`](#-apache--mod--status--status_path)

##### <a name="-apache--mod--status--requires"></a>`requires`

Data type: `Optional[Variant[String, Array, Hash]]`

A Variant type that can be:
- String with:
  - '' or 'unmanaged' - Host auth control done elsewhere
  - 'ip <List of IPs>' - Allowed IPs/ranges
  - 'host <List of names>' - Allowed names/domains
  - 'all [granted|denied]'
- Array of strings with ip or host as above
- Hash with following keys:
  - 'requires' - Value => Array as above
  - 'enforce' - Value => String 'Any', 'All' or 'None'
    This encloses "Require" directives in "<Require(Any|All|None)>" block
    Optional - If unspecified, "Require" directives follow current flow

Default value: `undef`

##### <a name="-apache--mod--status--extended_status"></a>`extended_status`

Data type: `Apache::OnOff`

Determines whether to track extended status information for each request, via the ExtendedStatus directive.

Default value: `'On'`

##### <a name="-apache--mod--status--status_path"></a>`status_path`

Data type: `String`

Path assigned to the Location directive which defines the URL to access the server status.

Default value: `'/server-status'`

### <a name="apache--mod--suexec"></a>`apache::mod::suexec`

Installs `mod_suexec`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_suexec.html
    * for additional documentation.

### <a name="apache--mod--userdir"></a>`apache::mod::userdir`

Installs and configures `mod_userdir`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_userdir.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::userdir` class:

* [`userdir`](#-apache--mod--userdir--userdir)
* [`disable_root`](#-apache--mod--userdir--disable_root)
* [`path`](#-apache--mod--userdir--path)
* [`overrides`](#-apache--mod--userdir--overrides)
* [`options`](#-apache--mod--userdir--options)
* [`unmanaged_path`](#-apache--mod--userdir--unmanaged_path)
* [`custom_fragment`](#-apache--mod--userdir--custom_fragment)

##### <a name="-apache--mod--userdir--userdir"></a>`userdir`

Data type: `Optional[String[1]]`

Path or directory name to be used as the UserDir.

Default value: `undef`

##### <a name="-apache--mod--userdir--disable_root"></a>`disable_root`

Data type: `Boolean`

Toggles whether to allow use of root directory.

Default value: `true`

##### <a name="-apache--mod--userdir--path"></a>`path`

Data type: `String`

Path to directory or pattern from which to find user-specific directories.

Default value: `'/home/*/public_html'`

##### <a name="-apache--mod--userdir--overrides"></a>`overrides`

Data type: `Array[String]`

Array of directives that are allowed in .htaccess files.

Default value: `['FileInfo', 'AuthConfig', 'Limit', 'Indexes']`

##### <a name="-apache--mod--userdir--options"></a>`options`

Data type: `Array[String]`

Configures what features are available in a particular directory.

Default value: `['MultiViews', 'Indexes', 'SymLinksIfOwnerMatch', 'IncludesNoExec']`

##### <a name="-apache--mod--userdir--unmanaged_path"></a>`unmanaged_path`

Data type: `Boolean`

Toggles whether to manage path in userdir.conf

Default value: `false`

##### <a name="-apache--mod--userdir--custom_fragment"></a>`custom_fragment`

Data type: `Optional[String]`

Custom configuration to be added to userdir.conf

Default value: `undef`

### <a name="apache--mod--version"></a>`apache::mod::version`

Installs `mod_version`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_version.html
    * for additional documentation.

### <a name="apache--mod--vhost_alias"></a>`apache::mod::vhost_alias`

Installs Apache `mod_vhost_alias`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_vhost_alias.html
    * for additional documentation.

### <a name="apache--mod--watchdog"></a>`apache::mod::watchdog`

Installs and configures `mod_watchdog`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_watchdog.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::watchdog` class:

* [`watchdog_interval`](#-apache--mod--watchdog--watchdog_interval)

##### <a name="-apache--mod--watchdog--watchdog_interval"></a>`watchdog_interval`

Data type: `Optional[Integer]`

Sets the interval at which the watchdog_step hook runs.

Default value: `undef`

### <a name="apache--mod--worker"></a>`apache::mod::worker`

Installs and manages the MPM `worker`.

* **See also**
  * https://httpd.apache.org/docs/current/mod/worker.html
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::worker` class:

* [`startservers`](#-apache--mod--worker--startservers)
* [`minsparethreads`](#-apache--mod--worker--minsparethreads)
* [`maxsparethreads`](#-apache--mod--worker--maxsparethreads)
* [`threadsperchild`](#-apache--mod--worker--threadsperchild)
* [`maxrequestsperchild`](#-apache--mod--worker--maxrequestsperchild)
* [`serverlimit`](#-apache--mod--worker--serverlimit)
* [`threadlimit`](#-apache--mod--worker--threadlimit)
* [`listenbacklog`](#-apache--mod--worker--listenbacklog)
* [`maxrequestworkers`](#-apache--mod--worker--maxrequestworkers)

##### <a name="-apache--mod--worker--startservers"></a>`startservers`

Data type: `Integer`

The number of child server processes created on startup

Default value: `2`

##### <a name="-apache--mod--worker--minsparethreads"></a>`minsparethreads`

Data type: `Integer`

Minimum number of idle threads to handle request spikes.

Default value: `25`

##### <a name="-apache--mod--worker--maxsparethreads"></a>`maxsparethreads`

Data type: `Integer`

Maximum number of idle threads.

Default value: `75`

##### <a name="-apache--mod--worker--threadsperchild"></a>`threadsperchild`

Data type: `Integer`

The number of threads created by each child process.

Default value: `25`

##### <a name="-apache--mod--worker--maxrequestsperchild"></a>`maxrequestsperchild`

Data type: `Integer`

Limit on the number of connectiojns an individual child server
process will handle. This is the old name and is still supported. The new
name is MaxConnectionsPerChild as of 2.3.9+.

Default value: `0`

##### <a name="-apache--mod--worker--serverlimit"></a>`serverlimit`

Data type: `Integer`

With worker, use this directive only if your MaxRequestWorkers
and ThreadsPerChild settings require more than 16 server processes
(default). Do not set the value of this directive any higher than the
number of server processes required by what you may want for
MaxRequestWorkers and ThreadsPerChild.

Default value: `25`

##### <a name="-apache--mod--worker--threadlimit"></a>`threadlimit`

Data type: `Integer`

This directive sets the maximum configured value for
ThreadsPerChild for the lifetime of the Apache httpd process.

Default value: `64`

##### <a name="-apache--mod--worker--listenbacklog"></a>`listenbacklog`

Data type: `Integer`

Maximum length of the queue of pending connections.

Default value: `511`

##### <a name="-apache--mod--worker--maxrequestworkers"></a>`maxrequestworkers`

Data type: `Integer`

Maximum number of connections that will be processed simultaneously

Default value: `150`

### <a name="apache--mod--wsgi"></a>`apache::mod::wsgi`

Installs and configures `mod_wsgi`.

* **Note** Unsupported platforms: SLES: all; RedHat: all; CentOS: all; OracleLinux: all; Scientific: all

* **See also**
  * https://github.com/GrahamDumpleton/mod_wsgi
    * for additional documentation.

#### Parameters

The following parameters are available in the `apache::mod::wsgi` class:

* [`wsgi_restrict_embedded`](#-apache--mod--wsgi--wsgi_restrict_embedded)
* [`wsgi_socket_prefix`](#-apache--mod--wsgi--wsgi_socket_prefix)
* [`wsgi_python_path`](#-apache--mod--wsgi--wsgi_python_path)
* [`wsgi_python_home`](#-apache--mod--wsgi--wsgi_python_home)
* [`wsgi_python_optimize`](#-apache--mod--wsgi--wsgi_python_optimize)
* [`wsgi_application_group`](#-apache--mod--wsgi--wsgi_application_group)
* [`package_name`](#-apache--mod--wsgi--package_name)
* [`mod_path`](#-apache--mod--wsgi--mod_path)

##### <a name="-apache--mod--wsgi--wsgi_restrict_embedded"></a>`wsgi_restrict_embedded`

Data type: `Optional[String]`

Enable restrictions on use of embedded mode.

Default value: `undef`

##### <a name="-apache--mod--wsgi--wsgi_socket_prefix"></a>`wsgi_socket_prefix`

Data type: `Optional[String]`

Configure directory to use for daemon sockets.

Default value: `$apache::params::wsgi_socket_prefix`

##### <a name="-apache--mod--wsgi--wsgi_python_path"></a>`wsgi_python_path`

Data type: `Optional[Stdlib::Absolutepath]`

Additional directories to search for Python modules.

Default value: `undef`

##### <a name="-apache--mod--wsgi--wsgi_python_home"></a>`wsgi_python_home`

Data type: `Optional[Stdlib::Absolutepath]`

Absolute path to Python prefix/exec_prefix directories.

Default value: `undef`

##### <a name="-apache--mod--wsgi--wsgi_python_optimize"></a>`wsgi_python_optimize`

Data type: `Optional[Integer]`

Enables basic Python optimisation features.

Default value: `undef`

##### <a name="-apache--mod--wsgi--wsgi_application_group"></a>`wsgi_application_group`

Data type: `Optional[String]`

Sets which application group WSGI application belongs to.

Default value: `undef`

##### <a name="-apache--mod--wsgi--package_name"></a>`package_name`

Data type: `Optional[String]`

Names of package that installs mod_wsgi.

Default value: `undef`

##### <a name="-apache--mod--wsgi--mod_path"></a>`mod_path`

Data type: `Optional[String]`

Defines the path to the mod_wsgi shared object (.so) file.

Default value: `undef`

### <a name="apache--mod--xsendfile"></a>`apache::mod::xsendfile`

Installs `mod_xsendfile`.

* **See also**
  * https://tn123.org/mod_xsendfile/
    * for additional documentation.

### <a name="apache--mpm--disable_mpm_event"></a>`apache::mpm::disable_mpm_event`

disable Apache-Module event

### <a name="apache--mpm--disable_mpm_prefork"></a>`apache::mpm::disable_mpm_prefork`

disable Apache-Module prefork

### <a name="apache--mpm--disable_mpm_worker"></a>`apache::mpm::disable_mpm_worker`

disable Apache-Module worker

### <a name="apache--vhosts"></a>`apache::vhosts`

host parameters or Configuring virtual hosts in the README section.

* **Note** See the `apache::vhost` defined type's reference for a list of all virtual

#### Examples

##### To create a [name-based virtual host](https://httpd.apache.org/docs/current/vhosts/name-based.html) `custom_vhost_1`

```puppet
class { 'apache::vhosts':
  vhosts => {
    'custom_vhost_1' => {
      'docroot' => '/var/www/custom_vhost_1',
      'port'    => 81,
    },
  },
}
```

#### Parameters

The following parameters are available in the `apache::vhosts` class:

* [`vhosts`](#-apache--vhosts--vhosts)

##### <a name="-apache--vhosts--vhosts"></a>`vhosts`

Data type: `Hash`

A hash, where the key represents the name and the value represents a hash of
`apache::vhost` defined type's parameters.

Default value: `{}`

## Defined types

### <a name="apache--balancer"></a>`apache::balancer`

Each balancer cluster needs one or more balancer members (that can
be declared with the apache::balancermember defined resource type). Using
storeconfigs, you can export the apache::balancermember resources on all
balancer members, and then collect them on a single apache load balancer
server.

* **Note** Currently requires the puppetlabs/concat module on the Puppet Forge and uses
storeconfigs on the Puppet Server to export/collect resources from all
balancer members.

#### Examples

##### 

```puppet
apache::balancer { 'puppet00': }
```

#### Parameters

The following parameters are available in the `apache::balancer` defined type:

* [`name`](#-apache--balancer--name)
* [`proxy_set`](#-apache--balancer--proxy_set)
* [`target`](#-apache--balancer--target)
* [`collect_exported`](#-apache--balancer--collect_exported)
* [`options`](#-apache--balancer--options)

##### <a name="-apache--balancer--name"></a>`name`

The namevar of the defined resource type is the balancer clusters name.<br />
This name is also used in the name of the conf.d file

##### <a name="-apache--balancer--proxy_set"></a>`proxy_set`

Data type: `Hash`

Configures key-value pairs to be used as a ProxySet lines in the configuration.

Default value: `{}`

##### <a name="-apache--balancer--target"></a>`target`

Data type: `Optional[String]`

The path to the file the balancer definition will be written in.

Default value: `undef`

##### <a name="-apache--balancer--collect_exported"></a>`collect_exported`

Data type: `Boolean`

Determines whether to use exported resources.<br />
If you statically declare all of your backend servers, set this parameter to false to rely
on existing, declared balancer member resources. Also, use apache::balancermember with array
arguments.<br />
To dynamically declare backend servers via exported resources collected on a central node,
set this parameter to true to collect the balancer member resources exported by the balancer
member nodes.<br />
If you don't use exported resources, a single Puppet run configures all balancer members. If
you use exported resources, Puppet has to run on the balanced nodes first, then run on the
balancer.

Default value: `true`

##### <a name="-apache--balancer--options"></a>`options`

Data type: `Array[Pattern[/=/]]`

Specifies an array of [options](https://httpd.apache.org/docs/current/mod/mod_proxy.html#balancermember)
after the balancer URL, and accepts any key-value pairs available to `ProxyPass`.

Default value: `[]`

### <a name="apache--balancermember"></a>`apache::balancermember`

Sets up a balancer member inside a listening service configuration block in
the load balancer's `apache.cfg`.

This type will setup a balancer member inside a listening service
configuration block in /etc/apache/apache.cfg on the load balancer.
Currently it only has the ability to specify the instance name, url and an
array of options. More features can be added as needed. The best way to
implement this is to export this resource for all apache balancer member
servers, and then collect them on the main apache load balancer.

* **Note** Currently requires the puppetlabs/concat module on the Puppet Forge and
uses storeconfigs on the Puppet Server to export/collect resources
from all balancer members.

#### Examples

##### 

```puppet
@@apache::balancermember { 'apache':
  balancer_cluster => 'puppet00',
  url              => "ajp://${::fqdn}:8009"
  options          => ['ping=5', 'disablereuse=on', 'retry=5', 'ttl=120'],
}
```

#### Parameters

The following parameters are available in the `apache::balancermember` defined type:

* [`name`](#-apache--balancermember--name)
* [`balancer_cluster`](#-apache--balancermember--balancer_cluster)
* [`url`](#-apache--balancermember--url)
* [`options`](#-apache--balancermember--options)

##### <a name="-apache--balancermember--name"></a>`name`

The title of the resource is arbitrary and only utilized in the concat
fragment name.

##### <a name="-apache--balancermember--balancer_cluster"></a>`balancer_cluster`

Data type: `String`

The apache service's instance name (or, the title of the apache::balancer
resource). This must match up with a declared apache::balancer resource.

##### <a name="-apache--balancermember--url"></a>`url`

Data type: `Apache::ModProxyProtocol`

The url used to contact the balancer member server.

Default value: `"http://${$facts['networking']['fqdn']}/"`

##### <a name="-apache--balancermember--options"></a>`options`

Data type: `Array`

Specifies an array of [options](https://httpd.apache.org/docs/current/mod/mod_proxy.html#balancermember)
after the URL, and accepts any key-value pairs available to `ProxyPass`.

Default value: `[]`

### <a name="apache--custom_config"></a>`apache::custom_config`

If the file is invalid and this defined type's `verify_config` parameter's value is
`true`, Puppet throws an error during a Puppet run.

#### Parameters

The following parameters are available in the `apache::custom_config` defined type:

* [`ensure`](#-apache--custom_config--ensure)
* [`confdir`](#-apache--custom_config--confdir)
* [`content`](#-apache--custom_config--content)
* [`filename`](#-apache--custom_config--filename)
* [`priority`](#-apache--custom_config--priority)
* [`source`](#-apache--custom_config--source)
* [`verify_command`](#-apache--custom_config--verify_command)
* [`verify_config`](#-apache--custom_config--verify_config)
* [`owner`](#-apache--custom_config--owner)
* [`group`](#-apache--custom_config--group)
* [`file_mode`](#-apache--custom_config--file_mode)
* [`show_diff`](#-apache--custom_config--show_diff)

##### <a name="-apache--custom_config--ensure"></a>`ensure`

Data type: `Enum['absent', 'present']`

Specifies whether the configuration file should be present.

Default value: `'present'`

##### <a name="-apache--custom_config--confdir"></a>`confdir`

Data type: `Stdlib::Absolutepath`

Sets the directory in which Puppet places configuration files.

Default value: `$apache::confd_dir`

##### <a name="-apache--custom_config--content"></a>`content`

Data type: `Optional[Variant[Sensitive, String]]`

Sets the configuration file's content. The `content` and `source` parameters are exclusive
of each other.

Default value: `undef`

##### <a name="-apache--custom_config--filename"></a>`filename`

Data type: `Optional[String]`

Sets the name of the file under `confdir` in which Puppet stores the configuration.

Default value: `undef`

##### <a name="-apache--custom_config--priority"></a>`priority`

Data type: `Apache::Vhost::Priority`

Sets the configuration file's priority by prefixing its filename with this parameter's
numeric value, as Apache processes configuration files in alphanumeric order.<br />
To omit the priority prefix in the configuration file's name, set this parameter to `false`.

Default value: `25`

##### <a name="-apache--custom_config--source"></a>`source`

Data type: `Optional[String]`

Points to the configuration file's source. The `content` and `source` parameters are
exclusive of each other.

Default value: `undef`

##### <a name="-apache--custom_config--verify_command"></a>`verify_command`

Data type: `Variant[String, Array[String], Array[Array[String]]]`

Specifies the command Puppet uses to verify the configuration file. Use a fully qualified
command.<br />
This parameter is used only if the `verify_config` parameter's value is `true`. If the
`verify_command` fails, the Puppet run deletes the configuration file and raises an error,
but does not notify the Apache service.
Command can be passed through as either a String, i.e. `'/usr/sbin/apache2ctl -t'`
An array, i.e. `['/usr/sbin/apache2ctl', '-t']`
Or an array of arrays with each one having to pass succesfully, i.e. `[['/usr/sbin/apache2ctl', '-t'], '/usr/sbin/apache2ctl -t']`

Default value: `$apache::params::verify_command`

##### <a name="-apache--custom_config--verify_config"></a>`verify_config`

Data type: `Boolean`

Specifies whether to validate the configuration file before notifying the Apache service.

Default value: `true`

##### <a name="-apache--custom_config--owner"></a>`owner`

Data type: `Optional[String]`

File owner of configuration file

Default value: `undef`

##### <a name="-apache--custom_config--group"></a>`group`

Data type: `Optional[String]`

File group of configuration file

Default value: `undef`

##### <a name="-apache--custom_config--file_mode"></a>`file_mode`

Data type: `Optional[Stdlib::Filemode]`

File mode of configuration file

Default value: `undef`

##### <a name="-apache--custom_config--show_diff"></a>`show_diff`

Data type: `Boolean`

show_diff property for configuration file resource

Default value: `true`

### <a name="apache--fastcgi--server"></a>`apache::fastcgi::server`

Defines one or more external FastCGI servers to handle specific file types. Use this
defined type with `mod_fastcgi`.

#### Parameters

The following parameters are available in the `apache::fastcgi::server` defined type:

* [`host`](#-apache--fastcgi--server--host)
* [`timeout`](#-apache--fastcgi--server--timeout)
* [`flush`](#-apache--fastcgi--server--flush)
* [`faux_path`](#-apache--fastcgi--server--faux_path)
* [`fcgi_alias`](#-apache--fastcgi--server--fcgi_alias)
* [`file_type`](#-apache--fastcgi--server--file_type)
* [`pass_header`](#-apache--fastcgi--server--pass_header)

##### <a name="-apache--fastcgi--server--host"></a>`host`

Data type: `String`

Determines the FastCGI's hostname or IP address and TCP port number (1-65535).

Default value: `'127.0.0.1:9000'`

##### <a name="-apache--fastcgi--server--timeout"></a>`timeout`

Data type: `Integer`

Sets the number of seconds a [FastCGI](http://www.fastcgi.com/) application can be inactive before aborting the
request and logging the event at the error LogLevel. The inactivity timer applies only as
long as a connection is pending with the FastCGI application. If a request is queued to an
application, but the application doesn't respond by writing and flushing within this period,
the request is aborted. If communication is complete with the application but incomplete with
the client (the response is buffered), the timeout does not apply.

Default value: `15`

##### <a name="-apache--fastcgi--server--flush"></a>`flush`

Data type: `Boolean`

Forces `mod_fastcgi` to write to the client as data is received from the
application. By default, `mod_fastcgi` buffers data in order to free the application
as quickly as possible.

Default value: `false`

##### <a name="-apache--fastcgi--server--faux_path"></a>`faux_path`

Data type: `Stdlib::Absolutepath`

Apache has FastCGI handle URIs that resolve to this filename. The path set in this
parameter does not have to exist in the local filesystem.

Default value: `"/var/www/${name}.fcgi"`

##### <a name="-apache--fastcgi--server--fcgi_alias"></a>`fcgi_alias`

Data type: `Stdlib::Unixpath`

Internally links actions with the FastCGI server. This alias must be unique.

Default value: `"/${name}.fcgi"`

##### <a name="-apache--fastcgi--server--file_type"></a>`file_type`

Data type: `String`

Sets the MIME `content-type` of the file to be processed by the FastCGI server.

Default value: `'application/x-httpd-php'`

##### <a name="-apache--fastcgi--server--pass_header"></a>`pass_header`

Data type: `Optional[String]`

Sets a header for the server

Default value: `undef`

### <a name="apache--listen"></a>`apache::listen`

The `apache::vhost` class uses this defined type, and titles take the form
`<PORT>`, `<IPV4>:<PORT>`, or `<IPV6>:<PORT>`.

### <a name="apache--mod"></a>`apache::mod`

Checks for or places the module's default configuration files in the Apache server's
`module` and `enable` directories. The default locations depend on your operating system.

#### Parameters

The following parameters are available in the `apache::mod` defined type:

* [`package`](#-apache--mod--package)
* [`package_ensure`](#-apache--mod--package_ensure)
* [`lib`](#-apache--mod--lib)
* [`lib_path`](#-apache--mod--lib_path)
* [`loadfile_name`](#-apache--mod--loadfile_name)
* [`id`](#-apache--mod--id)
* [`loadfiles`](#-apache--mod--loadfiles)
* [`path`](#-apache--mod--path)

##### <a name="-apache--mod--package"></a>`package`

Data type: `Optional[String]`

**Required**.<br />
Names the package Puppet uses to install the Apache module.

Default value: `undef`

##### <a name="-apache--mod--package_ensure"></a>`package_ensure`

Data type: `String`

Determines whether Puppet ensures the Apache module should be installed.

Default value: `'present'`

##### <a name="-apache--mod--lib"></a>`lib`

Data type: `Optional[String]`

Defines the module's shared object name. Do not configure manually without special reason.

Default value: `undef`

##### <a name="-apache--mod--lib_path"></a>`lib_path`

Data type: `String`

Specifies a path to the module's libraries. Do not manually set this parameter
without special reason. The `path` parameter overrides this value.

Default value: `$apache::lib_path`

##### <a name="-apache--mod--loadfile_name"></a>`loadfile_name`

Data type: `Optional[String]`

Sets the filename for the module's `LoadFile` directive, which can also set
the module load order as Apache processes them in alphanumeric order.

Default value: `undef`

##### <a name="-apache--mod--id"></a>`id`

Data type: `Optional[String]`

Specifies the package id

Default value: `undef`

##### <a name="-apache--mod--loadfiles"></a>`loadfiles`

Data type: `Optional[Array]`

Specifies an array of `LoadFile` directives.

Default value: `undef`

##### <a name="-apache--mod--path"></a>`path`

Data type: `Optional[String]`

Specifies a path to the module. Do not manually set this parameter without a special reason.

Default value: `undef`

### <a name="apache--namevirtualhost"></a>`apache::namevirtualhost`

Adds all related directives to the `ports.conf` file in the Apache HTTPD configuration
directory. Titles can take the forms `\*`, `\*:\<PORT\>`, `\_default\_:\<PORT\>`,
`\<IP\>`, or `\<IP\>:\<PORT\>`.

### <a name="apache--vhost"></a>`apache::vhost`

The apache module allows a lot of flexibility in the setup and configuration of virtual hosts.
This flexibility is due, in part, to `vhost` being a defined resource type, which allows Apache
to evaluate it multiple times with different parameters.<br />
The `apache::vhost` defined type allows you to have specialized configurations for virtual hosts
that have requirements outside the defaults. You can set up a default virtual host within
the base `::apache` class, as well as set a customized virtual host as the default.
Customized virtual hosts have a lower numeric `priority` than the base class's, causing
Apache to process the customized virtual host first.<br />
The `apache::vhost` defined type uses `concat::fragment` to build the configuration file. To
inject custom fragments for pieces of the configuration that the defined type doesn't
inherently support, add a custom fragment.<br />
For the custom fragment's `order` parameter, the `apache::vhost` defined type uses multiples
of 10, so any `order` that isn't a multiple of 10 should work.<br />
> **Note:** When creating an `apache::vhost`, it cannot be named `default` or `default-ssl`,
because vhosts with these titles are always managed by the module. This means that you cannot
override `Apache::Vhost['default']`  or `Apache::Vhost['default-ssl]` resources. An optional
workaround is to create a vhost named something else, such as `my default`, and ensure that the
`default` and `default_ssl` vhosts are set to `false`:

#### Examples

##### 

```puppet
class { 'apache':
  default_vhost     => false,
  default_ssl_vhost => false,
}
```

#### Parameters

The following parameters are available in the `apache::vhost` defined type:

* [`access_log`](#-apache--vhost--access_log)
* [`access_log_env_var`](#-apache--vhost--access_log_env_var)
* [`access_log_file`](#-apache--vhost--access_log_file)
* [`access_log_format`](#-apache--vhost--access_log_format)
* [`access_log_pipe`](#-apache--vhost--access_log_pipe)
* [`access_log_syslog`](#-apache--vhost--access_log_syslog)
* [`access_logs`](#-apache--vhost--access_logs)
* [`add_default_charset`](#-apache--vhost--add_default_charset)
* [`add_listen`](#-apache--vhost--add_listen)
* [`use_optional_includes`](#-apache--vhost--use_optional_includes)
* [`aliases`](#-apache--vhost--aliases)
* [`allow_encoded_slashes`](#-apache--vhost--allow_encoded_slashes)
* [`block`](#-apache--vhost--block)
* [`cas_attribute_prefix`](#-apache--vhost--cas_attribute_prefix)
* [`cas_attribute_delimiter`](#-apache--vhost--cas_attribute_delimiter)
* [`cas_login_url`](#-apache--vhost--cas_login_url)
* [`cas_root_proxied_as`](#-apache--vhost--cas_root_proxied_as)
* [`cas_scrub_request_headers`](#-apache--vhost--cas_scrub_request_headers)
* [`cas_sso_enabled`](#-apache--vhost--cas_sso_enabled)
* [`cas_validate_saml`](#-apache--vhost--cas_validate_saml)
* [`cas_validate_url`](#-apache--vhost--cas_validate_url)
* [`cas_cookie_path`](#-apache--vhost--cas_cookie_path)
* [`comment`](#-apache--vhost--comment)
* [`default_vhost`](#-apache--vhost--default_vhost)
* [`directoryindex`](#-apache--vhost--directoryindex)
* [`docroot`](#-apache--vhost--docroot)
* [`docroot_group`](#-apache--vhost--docroot_group)
* [`docroot_owner`](#-apache--vhost--docroot_owner)
* [`docroot_mode`](#-apache--vhost--docroot_mode)
* [`manage_docroot`](#-apache--vhost--manage_docroot)
* [`error_log`](#-apache--vhost--error_log)
* [`error_log_file`](#-apache--vhost--error_log_file)
* [`error_log_pipe`](#-apache--vhost--error_log_pipe)
* [`error_log_syslog`](#-apache--vhost--error_log_syslog)
* [`error_log_format`](#-apache--vhost--error_log_format)
* [`error_documents`](#-apache--vhost--error_documents)
* [`ensure`](#-apache--vhost--ensure)
* [`fallbackresource`](#-apache--vhost--fallbackresource)
* [`filters`](#-apache--vhost--filters)
* [`h2_copy_files`](#-apache--vhost--h2_copy_files)
* [`h2_direct`](#-apache--vhost--h2_direct)
* [`h2_early_hints`](#-apache--vhost--h2_early_hints)
* [`h2_max_session_streams`](#-apache--vhost--h2_max_session_streams)
* [`h2_modern_tls_only`](#-apache--vhost--h2_modern_tls_only)
* [`h2_push`](#-apache--vhost--h2_push)
* [`h2_push_diary_size`](#-apache--vhost--h2_push_diary_size)
* [`h2_push_priority`](#-apache--vhost--h2_push_priority)
* [`h2_push_resource`](#-apache--vhost--h2_push_resource)
* [`h2_serialize_headers`](#-apache--vhost--h2_serialize_headers)
* [`h2_stream_max_mem_size`](#-apache--vhost--h2_stream_max_mem_size)
* [`h2_tls_cool_down_secs`](#-apache--vhost--h2_tls_cool_down_secs)
* [`h2_tls_warm_up_size`](#-apache--vhost--h2_tls_warm_up_size)
* [`h2_upgrade`](#-apache--vhost--h2_upgrade)
* [`h2_window_size`](#-apache--vhost--h2_window_size)
* [`ip`](#-apache--vhost--ip)
* [`ip_based`](#-apache--vhost--ip_based)
* [`itk`](#-apache--vhost--itk)
* [`action`](#-apache--vhost--action)
* [`jk_mounts`](#-apache--vhost--jk_mounts)
* [`http_protocol_options`](#-apache--vhost--http_protocol_options)
* [`keepalive`](#-apache--vhost--keepalive)
* [`keepalive_timeout`](#-apache--vhost--keepalive_timeout)
* [`max_keepalive_requests`](#-apache--vhost--max_keepalive_requests)
* [`auth_kerb`](#-apache--vhost--auth_kerb)
* [`krb_method_negotiate`](#-apache--vhost--krb_method_negotiate)
* [`krb_method_k5passwd`](#-apache--vhost--krb_method_k5passwd)
* [`krb_authoritative`](#-apache--vhost--krb_authoritative)
* [`krb_auth_realms`](#-apache--vhost--krb_auth_realms)
* [`krb_5keytab`](#-apache--vhost--krb_5keytab)
* [`krb_local_user_mapping`](#-apache--vhost--krb_local_user_mapping)
* [`krb_verify_kdc`](#-apache--vhost--krb_verify_kdc)
* [`krb_servicename`](#-apache--vhost--krb_servicename)
* [`krb_save_credentials`](#-apache--vhost--krb_save_credentials)
* [`logroot`](#-apache--vhost--logroot)
* [`logroot_ensure`](#-apache--vhost--logroot_ensure)
* [`logroot_mode`](#-apache--vhost--logroot_mode)
* [`logroot_owner`](#-apache--vhost--logroot_owner)
* [`logroot_group`](#-apache--vhost--logroot_group)
* [`log_level`](#-apache--vhost--log_level)
* [`modsec_body_limit`](#-apache--vhost--modsec_body_limit)
* [`modsec_disable_vhost`](#-apache--vhost--modsec_disable_vhost)
* [`modsec_disable_ids`](#-apache--vhost--modsec_disable_ids)
* [`modsec_disable_ips`](#-apache--vhost--modsec_disable_ips)
* [`modsec_disable_msgs`](#-apache--vhost--modsec_disable_msgs)
* [`modsec_disable_tags`](#-apache--vhost--modsec_disable_tags)
* [`modsec_audit_log_file`](#-apache--vhost--modsec_audit_log_file)
* [`modsec_audit_log_pipe`](#-apache--vhost--modsec_audit_log_pipe)
* [`modsec_audit_log`](#-apache--vhost--modsec_audit_log)
* [`modsec_inbound_anomaly_threshold`](#-apache--vhost--modsec_inbound_anomaly_threshold)
* [`modsec_outbound_anomaly_threshold`](#-apache--vhost--modsec_outbound_anomaly_threshold)
* [`modsec_allowed_methods`](#-apache--vhost--modsec_allowed_methods)
* [`no_proxy_uris`](#-apache--vhost--no_proxy_uris)
* [`no_proxy_uris_match`](#-apache--vhost--no_proxy_uris_match)
* [`proxy_preserve_host`](#-apache--vhost--proxy_preserve_host)
* [`proxy_add_headers`](#-apache--vhost--proxy_add_headers)
* [`proxy_error_override`](#-apache--vhost--proxy_error_override)
* [`options`](#-apache--vhost--options)
* [`override`](#-apache--vhost--override)
* [`passenger_enabled`](#-apache--vhost--passenger_enabled)
* [`passenger_base_uri`](#-apache--vhost--passenger_base_uri)
* [`passenger_ruby`](#-apache--vhost--passenger_ruby)
* [`passenger_python`](#-apache--vhost--passenger_python)
* [`passenger_nodejs`](#-apache--vhost--passenger_nodejs)
* [`passenger_meteor_app_settings`](#-apache--vhost--passenger_meteor_app_settings)
* [`passenger_app_env`](#-apache--vhost--passenger_app_env)
* [`passenger_app_root`](#-apache--vhost--passenger_app_root)
* [`passenger_app_group_name`](#-apache--vhost--passenger_app_group_name)
* [`passenger_app_start_command`](#-apache--vhost--passenger_app_start_command)
* [`passenger_app_type`](#-apache--vhost--passenger_app_type)
* [`passenger_startup_file`](#-apache--vhost--passenger_startup_file)
* [`passenger_restart_dir`](#-apache--vhost--passenger_restart_dir)
* [`passenger_spawn_method`](#-apache--vhost--passenger_spawn_method)
* [`passenger_load_shell_envvars`](#-apache--vhost--passenger_load_shell_envvars)
* [`passenger_preload_bundler`](#-apache--vhost--passenger_preload_bundler)
* [`passenger_rolling_restarts`](#-apache--vhost--passenger_rolling_restarts)
* [`passenger_resist_deployment_errors`](#-apache--vhost--passenger_resist_deployment_errors)
* [`passenger_user`](#-apache--vhost--passenger_user)
* [`passenger_group`](#-apache--vhost--passenger_group)
* [`passenger_friendly_error_pages`](#-apache--vhost--passenger_friendly_error_pages)
* [`passenger_min_instances`](#-apache--vhost--passenger_min_instances)
* [`passenger_max_instances`](#-apache--vhost--passenger_max_instances)
* [`passenger_max_preloader_idle_time`](#-apache--vhost--passenger_max_preloader_idle_time)
* [`passenger_force_max_concurrent_requests_per_process`](#-apache--vhost--passenger_force_max_concurrent_requests_per_process)
* [`passenger_start_timeout`](#-apache--vhost--passenger_start_timeout)
* [`passenger_concurrency_model`](#-apache--vhost--passenger_concurrency_model)
* [`passenger_thread_count`](#-apache--vhost--passenger_thread_count)
* [`passenger_max_requests`](#-apache--vhost--passenger_max_requests)
* [`passenger_max_request_time`](#-apache--vhost--passenger_max_request_time)
* [`passenger_memory_limit`](#-apache--vhost--passenger_memory_limit)
* [`passenger_stat_throttle_rate`](#-apache--vhost--passenger_stat_throttle_rate)
* [`passenger_pre_start`](#-apache--vhost--passenger_pre_start)
* [`passenger_high_performance`](#-apache--vhost--passenger_high_performance)
* [`passenger_buffer_upload`](#-apache--vhost--passenger_buffer_upload)
* [`passenger_buffer_response`](#-apache--vhost--passenger_buffer_response)
* [`passenger_error_override`](#-apache--vhost--passenger_error_override)
* [`passenger_max_request_queue_size`](#-apache--vhost--passenger_max_request_queue_size)
* [`passenger_max_request_queue_time`](#-apache--vhost--passenger_max_request_queue_time)
* [`passenger_sticky_sessions`](#-apache--vhost--passenger_sticky_sessions)
* [`passenger_sticky_sessions_cookie_name`](#-apache--vhost--passenger_sticky_sessions_cookie_name)
* [`passenger_sticky_sessions_cookie_attributes`](#-apache--vhost--passenger_sticky_sessions_cookie_attributes)
* [`passenger_allow_encoded_slashes`](#-apache--vhost--passenger_allow_encoded_slashes)
* [`passenger_app_log_file`](#-apache--vhost--passenger_app_log_file)
* [`passenger_debugger`](#-apache--vhost--passenger_debugger)
* [`passenger_lve_min_uid`](#-apache--vhost--passenger_lve_min_uid)
* [`passenger_dump_config_manifest`](#-apache--vhost--passenger_dump_config_manifest)
* [`passenger_admin_panel_url`](#-apache--vhost--passenger_admin_panel_url)
* [`passenger_admin_panel_auth_type`](#-apache--vhost--passenger_admin_panel_auth_type)
* [`passenger_admin_panel_username`](#-apache--vhost--passenger_admin_panel_username)
* [`passenger_admin_panel_password`](#-apache--vhost--passenger_admin_panel_password)
* [`php_values`](#-apache--vhost--php_values)
* [`php_flags`](#-apache--vhost--php_flags)
* [`php_admin_values`](#-apache--vhost--php_admin_values)
* [`php_admin_flags`](#-apache--vhost--php_admin_flags)
* [`port`](#-apache--vhost--port)
* [`priority`](#-apache--vhost--priority)
* [`protocols`](#-apache--vhost--protocols)
* [`protocols_honor_order`](#-apache--vhost--protocols_honor_order)
* [`proxy_dest`](#-apache--vhost--proxy_dest)
* [`proxy_pass`](#-apache--vhost--proxy_pass)
* [`proxy_dest_match`](#-apache--vhost--proxy_dest_match)
* [`proxy_dest_reverse_match`](#-apache--vhost--proxy_dest_reverse_match)
* [`proxy_pass_match`](#-apache--vhost--proxy_pass_match)
* [`redirect_dest`](#-apache--vhost--redirect_dest)
* [`redirect_source`](#-apache--vhost--redirect_source)
* [`redirect_status`](#-apache--vhost--redirect_status)
* [`redirectmatch_regexp`](#-apache--vhost--redirectmatch_regexp)
* [`redirectmatch_status`](#-apache--vhost--redirectmatch_status)
* [`redirectmatch_dest`](#-apache--vhost--redirectmatch_dest)
* [`request_headers`](#-apache--vhost--request_headers)
* [`rewrites`](#-apache--vhost--rewrites)
* [`rewrite_base`](#-apache--vhost--rewrite_base)
* [`rewrite_rule`](#-apache--vhost--rewrite_rule)
* [`rewrite_cond`](#-apache--vhost--rewrite_cond)
* [`rewrite_inherit`](#-apache--vhost--rewrite_inherit)
* [`scriptalias`](#-apache--vhost--scriptalias)
* [`serveradmin`](#-apache--vhost--serveradmin)
* [`serveraliases`](#-apache--vhost--serveraliases)
* [`servername`](#-apache--vhost--servername)
* [`setenv`](#-apache--vhost--setenv)
* [`setenvif`](#-apache--vhost--setenvif)
* [`setenvifnocase`](#-apache--vhost--setenvifnocase)
* [`suexec_user_group`](#-apache--vhost--suexec_user_group)
* [`vhost_name`](#-apache--vhost--vhost_name)
* [`virtual_docroot`](#-apache--vhost--virtual_docroot)
* [`virtual_use_default_docroot`](#-apache--vhost--virtual_use_default_docroot)
* [`wsgi_daemon_process`](#-apache--vhost--wsgi_daemon_process)
* [`wsgi_daemon_process_options`](#-apache--vhost--wsgi_daemon_process_options)
* [`wsgi_application_group`](#-apache--vhost--wsgi_application_group)
* [`wsgi_import_script`](#-apache--vhost--wsgi_import_script)
* [`wsgi_import_script_options`](#-apache--vhost--wsgi_import_script_options)
* [`wsgi_chunked_request`](#-apache--vhost--wsgi_chunked_request)
* [`wsgi_process_group`](#-apache--vhost--wsgi_process_group)
* [`wsgi_script_aliases`](#-apache--vhost--wsgi_script_aliases)
* [`wsgi_script_aliases_match`](#-apache--vhost--wsgi_script_aliases_match)
* [`wsgi_pass_authorization`](#-apache--vhost--wsgi_pass_authorization)
* [`directories`](#-apache--vhost--directories)
* [`custom_fragment`](#-apache--vhost--custom_fragment)
* [`headers`](#-apache--vhost--headers)
* [`shib_compat_valid_user`](#-apache--vhost--shib_compat_valid_user)
* [`ssl_options`](#-apache--vhost--ssl_options)
* [`additional_includes`](#-apache--vhost--additional_includes)
* [`ssl`](#-apache--vhost--ssl)
* [`ssl_ca`](#-apache--vhost--ssl_ca)
* [`ssl_cert`](#-apache--vhost--ssl_cert)
* [`ssl_protocol`](#-apache--vhost--ssl_protocol)
* [`ssl_cipher`](#-apache--vhost--ssl_cipher)
* [`ssl_honorcipherorder`](#-apache--vhost--ssl_honorcipherorder)
* [`ssl_certs_dir`](#-apache--vhost--ssl_certs_dir)
* [`ssl_chain`](#-apache--vhost--ssl_chain)
* [`ssl_crl`](#-apache--vhost--ssl_crl)
* [`ssl_crl_path`](#-apache--vhost--ssl_crl_path)
* [`ssl_crl_check`](#-apache--vhost--ssl_crl_check)
* [`ssl_key`](#-apache--vhost--ssl_key)
* [`ssl_verify_client`](#-apache--vhost--ssl_verify_client)
* [`ssl_verify_depth`](#-apache--vhost--ssl_verify_depth)
* [`ssl_proxy_protocol`](#-apache--vhost--ssl_proxy_protocol)
* [`ssl_proxy_verify`](#-apache--vhost--ssl_proxy_verify)
* [`ssl_proxy_verify_depth`](#-apache--vhost--ssl_proxy_verify_depth)
* [`ssl_proxy_cipher_suite`](#-apache--vhost--ssl_proxy_cipher_suite)
* [`ssl_proxy_ca_cert`](#-apache--vhost--ssl_proxy_ca_cert)
* [`ssl_proxy_machine_cert`](#-apache--vhost--ssl_proxy_machine_cert)
* [`ssl_proxy_machine_cert_chain`](#-apache--vhost--ssl_proxy_machine_cert_chain)
* [`ssl_proxy_check_peer_cn`](#-apache--vhost--ssl_proxy_check_peer_cn)
* [`ssl_proxy_check_peer_name`](#-apache--vhost--ssl_proxy_check_peer_name)
* [`ssl_proxy_check_peer_expire`](#-apache--vhost--ssl_proxy_check_peer_expire)
* [`ssl_openssl_conf_cmd`](#-apache--vhost--ssl_openssl_conf_cmd)
* [`ssl_proxyengine`](#-apache--vhost--ssl_proxyengine)
* [`ssl_stapling`](#-apache--vhost--ssl_stapling)
* [`ssl_stapling_timeout`](#-apache--vhost--ssl_stapling_timeout)
* [`ssl_stapling_return_errors`](#-apache--vhost--ssl_stapling_return_errors)
* [`ssl_user_name`](#-apache--vhost--ssl_user_name)
* [`ssl_reload_on_change`](#-apache--vhost--ssl_reload_on_change)
* [`use_canonical_name`](#-apache--vhost--use_canonical_name)
* [`define`](#-apache--vhost--define)
* [`auth_oidc`](#-apache--vhost--auth_oidc)
* [`oidc_settings`](#-apache--vhost--oidc_settings)
* [`limitreqfields`](#-apache--vhost--limitreqfields)
* [`limitreqfieldsize`](#-apache--vhost--limitreqfieldsize)
* [`limitreqline`](#-apache--vhost--limitreqline)
* [`limitreqbody`](#-apache--vhost--limitreqbody)
* [`use_servername_for_filenames`](#-apache--vhost--use_servername_for_filenames)
* [`use_port_for_filenames`](#-apache--vhost--use_port_for_filenames)
* [`mdomain`](#-apache--vhost--mdomain)
* [`proxy_requests`](#-apache--vhost--proxy_requests)
* [`userdir`](#-apache--vhost--userdir)

##### <a name="-apache--vhost--access_log"></a>`access_log`

Data type: `Boolean`

Determines whether to configure `*_access.log` directives (`*_file`, `*_pipe`, or `*_syslog`).

Default value: `true`

##### <a name="-apache--vhost--access_log_env_var"></a>`access_log_env_var`

Data type: `Optional[Variant[Boolean, String]]`

Specifies that only requests with particular environment variables be logged.

Default value: `undef`

##### <a name="-apache--vhost--access_log_file"></a>`access_log_file`

Data type: `Optional[String[1]]`

Sets the filename of the `*_access.log` placed in `logroot`. Given a virtual host ---for
instance, example.com--- it defaults to 'example.com_ssl.log' for
[SSL-encrypted](https://httpd.apache.org/docs/current/ssl/index.html) virtual hosts and
`example.com_access.log` for unencrypted virtual hosts.

Default value: `undef`

##### <a name="-apache--vhost--access_log_format"></a>`access_log_format`

Data type: `Optional[String[1]]`

Specifies the use of either a `LogFormat` nickname or a custom-formatted string for the
access log.

Default value: `undef`

##### <a name="-apache--vhost--access_log_pipe"></a>`access_log_pipe`

Data type: `Optional[String[1]]`

Specifies a pipe where Apache sends access log messages.

Default value: `undef`

##### <a name="-apache--vhost--access_log_syslog"></a>`access_log_syslog`

Data type: `Optional[Variant[String, Boolean]]`

Sends all access log messages to syslog.

Default value: `undef`

##### <a name="-apache--vhost--access_logs"></a>`access_logs`

Data type: `Optional[Array[Hash]]`

Allows you to give a hash that specifies the state of each of the `access_log_*`
directives shown above, i.e. `access_log_pipe` and `access_log_syslog`.

Default value: `undef`

##### <a name="-apache--vhost--add_default_charset"></a>`add_default_charset`

Data type: `Optional[String]`

Sets a default media charset value for the `AddDefaultCharset` directive, which is
added to `text/plain` and `text/html` responses.

Default value: `undef`

##### <a name="-apache--vhost--add_listen"></a>`add_listen`

Data type: `Boolean`

Determines whether the virtual host creates a `Listen` statement.<br />
Setting `add_listen` to `false` prevents the virtual host from creating a `Listen`
statement. This is important when combining virtual hosts that aren't passed an `ip`
parameter with those that are.

Default value: `true`

##### <a name="-apache--vhost--use_optional_includes"></a>`use_optional_includes`

Data type: `Boolean`

Specifies whether Apache uses the `IncludeOptional` directive instead of `Include` for
`additional_includes` in Apache 2.4 or newer.

Default value: `$apache::use_optional_includes`

##### <a name="-apache--vhost--aliases"></a>`aliases`

Data type: `Array[Hash[String[1], String[1]]]`

Passes a list of [hashes][hash] to the virtual host to create `Alias`, `AliasMatch`,
`ScriptAlias` or `ScriptAliasMatch` directives as per the `mod_alias` documentation.<br />
For example:
``` puppet
aliases => [
  { aliasmatch       => '^/image/(.*)\.jpg$',
    path             => '/files/jpg.images/$1.jpg',
  },
  { alias            => '/image',
    path             => '/ftp/pub/image',
  },
  { scriptaliasmatch => '^/cgi-bin(.*)',
    path             => '/usr/local/share/cgi-bin$1',
  },
  { scriptalias      => '/nagios/cgi-bin/',
    path             => '/usr/lib/nagios/cgi-bin/',
  },
  { alias            => '/nagios',
    path             => '/usr/share/nagios/html',
  },
],
```
For the `alias`, `aliasmatch`, `scriptalias` and `scriptaliasmatch` keys to work, each needs
a corresponding context, such as `<Directory /path/to/directory>` or
`<Location /some/location/here>`. Puppet creates the directives in the order specified in
the `aliases` parameter. As described in the `mod_alias` documentation, add more specific
`alias`, `aliasmatch`, `scriptalias` or `scriptaliasmatch` parameters before the more
general ones to avoid shadowing.<BR />
If `apache::mod::passenger` is loaded and `PassengerHighPerformance` is `true`, the `Alias`
directive might not be able to honor the `PassengerEnabled => off` statement. See
[this article](http://www.conandalton.net/2010/06/passengerenabled-off-not-working.html) for details.

Default value: `[]`

##### <a name="-apache--vhost--allow_encoded_slashes"></a>`allow_encoded_slashes`

Data type: `Optional[Variant[Apache::OnOff, Enum['nodecode']]]`

Sets the `AllowEncodedSlashes` declaration for the virtual host, overriding the server
default. This modifies the virtual host responses to URLs with `\` and `/` characters. The
default setting omits the declaration from the server configuration and selects the
Apache default setting of `Off`.

Default value: `undef`

##### <a name="-apache--vhost--block"></a>`block`

Data type: `Variant[Array[String], String]`

Specifies the list of things to which Apache blocks access. Valid options are: `scm` (which
blocks web access to `.svn`), `.git`, and `.bzr` directories.

Default value: `[]`

##### <a name="-apache--vhost--cas_attribute_prefix"></a>`cas_attribute_prefix`

Data type: `Optional[String]`

Adds a header with the value of this header being the attribute values when SAML
validation is enabled.

Default value: `undef`

##### <a name="-apache--vhost--cas_attribute_delimiter"></a>`cas_attribute_delimiter`

Data type: `Optional[String]`

Sets the delimiter between attribute values in the header created by `cas_attribute_prefix`.

Default value: `undef`

##### <a name="-apache--vhost--cas_login_url"></a>`cas_login_url`

Data type: `Optional[String]`

Sets the URL to which the module redirects users when they attempt to access a
CAS-protected resource and don't have an active session.

Default value: `undef`

##### <a name="-apache--vhost--cas_root_proxied_as"></a>`cas_root_proxied_as`

Data type: `Optional[String]`

Sets the URL end users see when access to this Apache server is proxied per vhost.
This URL should not include a trailing slash.

Default value: `undef`

##### <a name="-apache--vhost--cas_scrub_request_headers"></a>`cas_scrub_request_headers`

Data type: `Boolean`

Remove inbound request headers that may have special meaning within mod_auth_cas.

Default value: `false`

##### <a name="-apache--vhost--cas_sso_enabled"></a>`cas_sso_enabled`

Data type: `Boolean`

Enables experimental support for single sign out (may mangle POST data).

Default value: `false`

##### <a name="-apache--vhost--cas_validate_saml"></a>`cas_validate_saml`

Data type: `Boolean`

Parse response from CAS server for SAML.

Default value: `false`

##### <a name="-apache--vhost--cas_validate_url"></a>`cas_validate_url`

Data type: `Optional[String]`

Sets the URL to use when validating a client-presented ticket in an HTTP query string.

Default value: `undef`

##### <a name="-apache--vhost--cas_cookie_path"></a>`cas_cookie_path`

Data type: `Optional[String]`

Sets the location where information on the current session should be stored. This should
be writable by the web server only.

Default value: `undef`

##### <a name="-apache--vhost--comment"></a>`comment`

Data type: `Optional[Variant[String, Array[String]]]`

Adds comments to the header of the configuration file. Pass as string or an array of strings.
For example:
``` puppet
comment => "Account number: 123B",
```
Or:
``` puppet
comment => [
  "Customer: X",
  "Frontend domain: x.example.org",
]
```

Default value: `undef`

##### <a name="-apache--vhost--default_vhost"></a>`default_vhost`

Data type: `Boolean`

Sets a given `apache::vhost` defined type as the default to serve requests that do not
match any other `apache::vhost` defined types.

Default value: `false`

##### <a name="-apache--vhost--directoryindex"></a>`directoryindex`

Data type: `Optional[String]`

Sets the list of resources to look for when a client requests an index of the directory
by specifying a '/' at the end of the directory name. See the `DirectoryIndex` directive
documentation for details.

Default value: `undef`

##### <a name="-apache--vhost--docroot"></a>`docroot`

Data type: `Variant[Stdlib::Absolutepath, Boolean]`

**Required**.<br />
Sets the `DocumentRoot` location, from which Apache serves files.<br />
If `docroot` and `manage_docroot` are both set to `false`, no `DocumentRoot` will be set
and the accompanying `<Directory /path/to/directory>` block will not be created.

##### <a name="-apache--vhost--docroot_group"></a>`docroot_group`

Data type: `String`

Sets group access to the `docroot` directory.

Default value: `$apache::params::root_group`

##### <a name="-apache--vhost--docroot_owner"></a>`docroot_owner`

Data type: `String`

Sets individual user access to the `docroot` directory.

Default value: `'root'`

##### <a name="-apache--vhost--docroot_mode"></a>`docroot_mode`

Data type: `Optional[Stdlib::Filemode]`

Sets access permissions for the `docroot` directory, in numeric notation.

Default value: `undef`

##### <a name="-apache--vhost--manage_docroot"></a>`manage_docroot`

Data type: `Boolean`

Determines whether Puppet manages the `docroot` directory.

Default value: `true`

##### <a name="-apache--vhost--error_log"></a>`error_log`

Data type: `Boolean`

Specifies whether `*_error.log` directives should be configured.

Default value: `true`

##### <a name="-apache--vhost--error_log_file"></a>`error_log_file`

Data type: `Optional[String]`

Points the virtual host's error logs to a `*_error.log` file. If this parameter is
undefined, Puppet checks for values in `error_log_pipe`, then `error_log_syslog`.<br />
If none of these parameters is set, given a virtual host `example.com`, Puppet defaults
to `$logroot/example.com_error_ssl.log` for SSL virtual hosts and
`$logroot/example.com_error.log` for non-SSL virtual hosts.

Default value: `undef`

##### <a name="-apache--vhost--error_log_pipe"></a>`error_log_pipe`

Data type: `Optional[String]`

Specifies a pipe to send error log messages to.<br />
This parameter has no effect if the `error_log_file` parameter has a value. If neither
this parameter nor `error_log_file` has a value, Puppet then checks `error_log_syslog`.

Default value: `undef`

##### <a name="-apache--vhost--error_log_syslog"></a>`error_log_syslog`

Data type: `Optional[Variant[String, Boolean]]`

Determines whether to send all error log messages to syslog.
This parameter has no effect if either of the `error_log_file` or `error_log_pipe`
parameters has a value. If none of these parameters has a value, given a virtual host
`example.com`, Puppet defaults to `$logroot/example.com_error_ssl.log` for SSL virtual
hosts and `$logroot/example.com_error.log` for non-SSL virtual hosts.

Default value: `undef`

##### <a name="-apache--vhost--error_log_format"></a>`error_log_format`

Data type:

```puppet
Optional[
    Array[
      Variant[
        String,
        Hash[String, Enum['connection', 'request']]
      ]
    ]
  ]
```

Sets the [ErrorLogFormat](https://httpd.apache.org/docs/current/mod/core.html#errorlogformat)
format specification for error log entries inside virtual host
For example:
``` puppet
apache::vhost { 'site.name.fdqn':
  ...
  error_log_format => [
    '[%{uc}t] [%-m:%-l] [R:%L] [C:%{C}L] %7F: %E: %M',
    { '[%{uc}t] [R:%L] Request %k on C:%{c}L pid:%P tid:%T' => 'request' },
    { "[%{uc}t] [R:%L] UA:'%+{User-Agent}i'" => 'request' },
    { "[%{uc}t] [R:%L] Referer:'%+{Referer}i'" => 'request' },
    { '[%{uc}t] [C:%{c}L] local\ %a remote\ %A' => 'connection' },
  ],
}
```

Default value: `undef`

##### <a name="-apache--vhost--error_documents"></a>`error_documents`

Data type: `Variant[Array[Hash], String]`

A list of hashes which can be used to override the
[ErrorDocument](https://httpd.apache.org/docs/current/mod/core.html#errordocument)
settings for this virtual host.<br />
For example:
``` puppet
apache::vhost { 'sample.example.net':
  error_documents => [
    { 'error_code' => '503', 'document' => '/service-unavail' },
    { 'error_code' => '407', 'document' => 'https://example.com/proxy/login' },
  ],
}
```

Default value: `[]`

##### <a name="-apache--vhost--ensure"></a>`ensure`

Data type: `Enum['absent', 'present']`

Specifies if the virtual host is present or absent.<br />

Default value: `'present'`

##### <a name="-apache--vhost--fallbackresource"></a>`fallbackresource`

Data type: `Optional[Variant[Stdlib::Absolutepath, Enum['disabled']]]`

Sets the [FallbackResource](https://httpd.apache.org/docs/current/mod/mod_dir.html#fallbackresource)
directive, which specifies an action to take for any URL that doesn't map to anything in
your filesystem and would otherwise return 'HTTP 404 (Not Found)'. Values must either begin
with a `/` or be `disabled`.

Default value: `undef`

##### <a name="-apache--vhost--filters"></a>`filters`

Data type: `Array[String[1]]`

[Filters](https://httpd.apache.org/docs/current/mod/mod_filter.html) enable smart,
context-sensitive configuration of output content filters.
``` puppet
apache::vhost { "$::fqdn":
  filters => [
    'FilterDeclare   COMPRESS',
    'FilterProvider  COMPRESS DEFLATE resp=Content-Type $text/html',
    'FilterChain     COMPRESS',
    'FilterProtocol  COMPRESS DEFLATE change=yes;byteranges=no',
  ],
}
```

Default value: `[]`

##### <a name="-apache--vhost--h2_copy_files"></a>`h2_copy_files`

Data type: `Optional[Boolean]`

Sets the [H2CopyFiles](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2copyfiles)
directive which influences how the requestion process pass files to the main connection.

Default value: `undef`

##### <a name="-apache--vhost--h2_direct"></a>`h2_direct`

Data type: `Optional[Boolean]`

Sets the [H2Direct](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2direct)
directive which toggles the usage of the HTTP/2 Direct Mode.

Default value: `undef`

##### <a name="-apache--vhost--h2_early_hints"></a>`h2_early_hints`

Data type: `Optional[Boolean]`

Sets the [H2EarlyHints](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2earlyhints)
directive which controls if HTTP status 103 interim responses are forwarded to
the client or not.

Default value: `undef`

##### <a name="-apache--vhost--h2_max_session_streams"></a>`h2_max_session_streams`

Data type: `Optional[Integer]`

Sets the [H2MaxSessionStreams](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2maxsessionstreams)
directive which sets the maximum number of active streams per HTTP/2 session
that the server allows.

Default value: `undef`

##### <a name="-apache--vhost--h2_modern_tls_only"></a>`h2_modern_tls_only`

Data type: `Optional[Boolean]`

Sets the [H2ModernTLSOnly](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2moderntlsonly)
directive which toggles the security checks on HTTP/2 connections in TLS mode.

Default value: `undef`

##### <a name="-apache--vhost--h2_push"></a>`h2_push`

Data type: `Optional[Boolean]`

Sets the [H2Push](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2push)
directive which toggles the usage of the HTTP/2 server push protocol feature.

Default value: `undef`

##### <a name="-apache--vhost--h2_push_diary_size"></a>`h2_push_diary_size`

Data type: `Optional[Integer]`

Sets the [H2PushDiarySize](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2pushdiarysize)
directive which toggles the maximum number of HTTP/2 server pushes that are
remembered per HTTP/2 connection.

Default value: `undef`

##### <a name="-apache--vhost--h2_push_priority"></a>`h2_push_priority`

Data type: `Array[String]`

Sets the [H2PushPriority](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2pushpriority)
directive which defines the priority handling of pushed responses based on the
content-type of the response.

Default value: `[]`

##### <a name="-apache--vhost--h2_push_resource"></a>`h2_push_resource`

Data type: `Array[String]`

Sets the [H2PushResource](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2pushresource)
directive which declares resources for early pushing to the client.

Default value: `[]`

##### <a name="-apache--vhost--h2_serialize_headers"></a>`h2_serialize_headers`

Data type: `Optional[Boolean]`

Sets the [H2SerializeHeaders](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2serializeheaders)
directive which toggles if HTTP/2 requests are serialized in HTTP/1.1
format for processing by httpd core.

Default value: `undef`

##### <a name="-apache--vhost--h2_stream_max_mem_size"></a>`h2_stream_max_mem_size`

Data type: `Optional[Integer]`

Sets the [H2StreamMaxMemSize](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2streammaxmemsize)
directive which sets the maximum number of outgoing data bytes buffered in
memory for an active stream.

Default value: `undef`

##### <a name="-apache--vhost--h2_tls_cool_down_secs"></a>`h2_tls_cool_down_secs`

Data type: `Optional[Integer]`

Sets the [H2TLSCoolDownSecs](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2tlscooldownsecs)
directive which sets the number of seconds of idle time on a TLS connection
before the TLS write size falls back to a small (~1300 bytes) length.

Default value: `undef`

##### <a name="-apache--vhost--h2_tls_warm_up_size"></a>`h2_tls_warm_up_size`

Data type: `Optional[Integer]`

Sets the [H2TLSWarmUpSize](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2tlswarmupsize)
directive which sets the number of bytes to be sent in small TLS records (~1300
bytes) until doing maximum sized writes (16k) on https: HTTP/2 connections.

Default value: `undef`

##### <a name="-apache--vhost--h2_upgrade"></a>`h2_upgrade`

Data type: `Optional[Boolean]`

Sets the [H2Upgrade](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2upgrade)
directive which toggles the usage of the HTTP/1.1 Upgrade method for switching
to HTTP/2.

Default value: `undef`

##### <a name="-apache--vhost--h2_window_size"></a>`h2_window_size`

Data type: `Optional[Integer]`

Sets the [H2WindowSize](https://httpd.apache.org/docs/current/mod/mod_http2.html#h2windowsize)
directive which sets the size of the window that is used for flow control from
client to server and limits the amount of data the server has to buffer.

Default value: `undef`

##### <a name="-apache--vhost--ip"></a>`ip`

Data type:

```puppet
Optional[
    Variant[
      Array[Variant[Stdlib::IP::Address, Enum['*']]],
      Variant[Stdlib::IP::Address, Enum['*']]
    ]
  ]
```

Sets the IP address the virtual host listens on. By default, uses Apache's default behavior
of listening on all IPs.

Default value: `undef`

##### <a name="-apache--vhost--ip_based"></a>`ip_based`

Data type: `Boolean`

Enables an [IP-based](https://httpd.apache.org/docs/current/vhosts/ip-based.html) virtual
host. This parameter inhibits the creation of a NameVirtualHost directive, since those are
used to funnel requests to name-based virtual hosts.

Default value: `false`

##### <a name="-apache--vhost--itk"></a>`itk`

Data type: `Optional[Hash]`

Configures [ITK](http://mpm-itk.sesse.net/) in a hash.<br />
Usage typically looks something like:
``` puppet
apache::vhost { 'sample.example.net':
  docroot => '/path/to/directory',
  itk     => {
    user  => 'someuser',
    group => 'somegroup',
  },
}
```
Valid values are: a hash, which can include the keys:
* `user` + `group`
* `assignuseridexpr`
* `assigngroupidexpr`
* `maxclientvhost`
* `nice`
* `limituidrange` (Linux 3.5.0 or newer)
* `limitgidrange` (Linux 3.5.0 or newer)

Default value: `undef`

##### <a name="-apache--vhost--action"></a>`action`

Data type: `Optional[String]`

Specifies whether you wish to configure mod_actions action directive which will
activate cgi-script when triggered by a request.

Default value: `undef`

##### <a name="-apache--vhost--jk_mounts"></a>`jk_mounts`

Data type: `Array[Hash]`

Sets up a virtual host with `JkMount` and `JkUnMount` directives to handle the paths
for URL mapping between Tomcat and Apache.<br />
The parameter must be an array of hashes where each hash must contain the `worker`
and either the `mount` or `unmount` keys.<br />
Usage typically looks like:
``` puppet
apache::vhost { 'sample.example.net':
  jk_mounts => [
    { mount   => '/*',     worker => 'tcnode1', },
    { unmount => '/*.jpg', worker => 'tcnode1', },
  ],
}
```

Default value: `[]`

##### <a name="-apache--vhost--http_protocol_options"></a>`http_protocol_options`

Data type: `Optional[Pattern[/^((Strict|Unsafe)?\s*(\b(Registered|Lenient)Methods)?\s*(\b(Allow0\.9|Require1\.0))?)$/]]`

Specifies the strictness of HTTP protocol checks.

Default value: `undef`

##### <a name="-apache--vhost--keepalive"></a>`keepalive`

Data type: `Optional[Apache::OnOff]`

Determines whether to enable persistent HTTP connections with the `KeepAlive` directive
for the virtual host. By default, the global, server-wide `KeepAlive` setting is in effect.<br />
Use the `keepalive_timeout` and `max_keepalive_requests` parameters to set relevant options
for the virtual host.

Default value: `undef`

##### <a name="-apache--vhost--keepalive_timeout"></a>`keepalive_timeout`

Data type: `Optional[Variant[Integer, String]]`

Sets the `KeepAliveTimeout` directive for the virtual host, which determines the amount
of time to wait for subsequent requests on a persistent HTTP connection. By default, the
global, server-wide `KeepAlive` setting is in effect.<br />
This parameter is only relevant if either the global, server-wide `keepalive` parameter or
the per-vhost `keepalive` parameter is enabled.

Default value: `undef`

##### <a name="-apache--vhost--max_keepalive_requests"></a>`max_keepalive_requests`

Data type: `Optional[Variant[Integer, String]]`

Limits the number of requests allowed per connection to the virtual host. By default,
the global, server-wide `KeepAlive` setting is in effect.<br />
This parameter is only relevant if either the global, server-wide `keepalive` parameter or
the per-vhost `keepalive` parameter is enabled.

Default value: `undef`

##### <a name="-apache--vhost--auth_kerb"></a>`auth_kerb`

Data type: `Boolean`

Enable `mod_auth_kerb` parameters for a virtual host.<br />
Usage typically looks like:
``` puppet
apache::vhost { 'sample.example.net':
  auth_kerb              => `true`,
  krb_method_negotiate   => 'on',
  krb_auth_realms        => ['EXAMPLE.ORG'],
  krb_local_user_mapping => 'on',
  directories            => [
    {
      path         => '/var/www/html',
      auth_name    => 'Kerberos Login',
      auth_type    => 'Kerberos',
      auth_require => 'valid-user',
    },
  ],
}
```

Default value: `false`

##### <a name="-apache--vhost--krb_method_negotiate"></a>`krb_method_negotiate`

Data type: `Apache::OnOff`

Determines whether to use the Negotiate method.

Default value: `'on'`

##### <a name="-apache--vhost--krb_method_k5passwd"></a>`krb_method_k5passwd`

Data type: `Apache::OnOff`

Determines whether to use password-based authentication for Kerberos v5.

Default value: `'on'`

##### <a name="-apache--vhost--krb_authoritative"></a>`krb_authoritative`

Data type: `Apache::OnOff`

If set to `off`, authentication controls can be passed on to another module.

Default value: `'on'`

##### <a name="-apache--vhost--krb_auth_realms"></a>`krb_auth_realms`

Data type: `Array[String]`

Specifies an array of Kerberos realms to use for authentication.

Default value: `[]`

##### <a name="-apache--vhost--krb_5keytab"></a>`krb_5keytab`

Data type: `Optional[String]`

Specifies the Kerberos v5 keytab file's location.

Default value: `undef`

##### <a name="-apache--vhost--krb_local_user_mapping"></a>`krb_local_user_mapping`

Data type: `Optional[Apache::OnOff]`

Strips @REALM from usernames for further use.

Default value: `undef`

##### <a name="-apache--vhost--krb_verify_kdc"></a>`krb_verify_kdc`

Data type: `Apache::OnOff`

This option can be used to disable the verification tickets against local keytab to prevent
KDC spoofing attacks.

Default value: `'on'`

##### <a name="-apache--vhost--krb_servicename"></a>`krb_servicename`

Data type: `String`

Specifies the service name that will be used by Apache for authentication. Corresponding
key of this name must be stored in the keytab.

Default value: `'HTTP'`

##### <a name="-apache--vhost--krb_save_credentials"></a>`krb_save_credentials`

Data type: `Apache::OnOff`

This option enables credential saving functionality.

Default value: `'off'`

##### <a name="-apache--vhost--logroot"></a>`logroot`

Data type: `Stdlib::Absolutepath`

Specifies the location of the virtual host's logfiles.

Default value: `$apache::logroot`

##### <a name="-apache--vhost--logroot_ensure"></a>`logroot_ensure`

Data type: `Enum['directory', 'absent']`

Determines whether or not to remove the logroot directory for a virtual host.

Default value: `'directory'`

##### <a name="-apache--vhost--logroot_mode"></a>`logroot_mode`

Data type: `Optional[Stdlib::Filemode]`

Overrides the mode the logroot directory is set to. Do *not* grant write access to the
directory the logs are stored in without being aware of the consequences; for more
information, see [Apache's log security documentation](https://httpd.apache.org/docs/2.4/logs.html#security).

Default value: `undef`

##### <a name="-apache--vhost--logroot_owner"></a>`logroot_owner`

Data type: `Optional[String]`

Sets individual user access to the logroot directory.

Default value: `undef`

##### <a name="-apache--vhost--logroot_group"></a>`logroot_group`

Data type: `Optional[String]`

Sets group access to the `logroot` directory.

Default value: `undef`

##### <a name="-apache--vhost--log_level"></a>`log_level`

Data type: `Optional[Apache::LogLevel]`

Specifies the verbosity of the error log.

Default value: `undef`

##### <a name="-apache--vhost--modsec_body_limit"></a>`modsec_body_limit`

Data type: `Optional[String]`

Configures the maximum request body size (in bytes) ModSecurity accepts for buffering.

Default value: `undef`

##### <a name="-apache--vhost--modsec_disable_vhost"></a>`modsec_disable_vhost`

Data type: `Boolean`

Disables `mod_security` on a virtual host. Only valid if `apache::mod::security` is included.

Default value: `false`

##### <a name="-apache--vhost--modsec_disable_ids"></a>`modsec_disable_ids`

Data type: `Optional[Variant[Hash, Array]]`

Removes `mod_security` IDs from the virtual host.<br />
Also takes a hash allowing removal of an ID from a specific location.
``` puppet
apache::vhost { 'sample.example.net':
  modsec_disable_ids => [ 90015, 90016 ],
}
```

``` puppet
apache::vhost { 'sample.example.net':
  modsec_disable_ids => { '/location1' => [ 90015, 90016 ] },
}
```

Default value: `undef`

##### <a name="-apache--vhost--modsec_disable_ips"></a>`modsec_disable_ips`

Data type: `Array[String[1]]`

Specifies an array of IP addresses to exclude from `mod_security` rule matching.

Default value: `[]`

##### <a name="-apache--vhost--modsec_disable_msgs"></a>`modsec_disable_msgs`

Data type: `Optional[Variant[Hash, Array]]`

Array of mod_security Msgs to remove from the virtual host. Also takes a hash allowing
removal of an Msg from a specific location.
``` puppet
apache::vhost { 'sample.example.net':
  modsec_disable_msgs => ['Blind SQL Injection Attack', 'Session Fixation Attack'],
}
```
``` puppet
apache::vhost { 'sample.example.net':
  modsec_disable_msgs => { '/location1' => ['Blind SQL Injection Attack', 'Session Fixation Attack'] },
}
```

Default value: `undef`

##### <a name="-apache--vhost--modsec_disable_tags"></a>`modsec_disable_tags`

Data type: `Optional[Variant[Hash, Array]]`

Array of mod_security Tags to remove from the virtual host. Also takes a hash allowing
removal of an Tag from a specific location.
``` puppet
apache::vhost { 'sample.example.net':
  modsec_disable_tags => ['WEB_ATTACK/SQL_INJECTION', 'WEB_ATTACK/XSS'],
}
```
``` puppet
apache::vhost { 'sample.example.net':
  modsec_disable_tags => { '/location1' => ['WEB_ATTACK/SQL_INJECTION', 'WEB_ATTACK/XSS'] },
}
```

Default value: `undef`

##### <a name="-apache--vhost--modsec_audit_log_file"></a>`modsec_audit_log_file`

Data type: `Optional[String]`

If set, it is relative to `logroot`.<br />
One of the parameters that determines how to send `mod_security` audit
log ([SecAuditLog](https://github.com/SpiderLabs/ModSecurity/wiki/Reference-Manual#SecAuditLog)).
If none of those parameters are set, the global audit log is used
(`/var/log/httpd/modsec\_audit.log`; Debian and derivatives: `/var/log/apache2/modsec\_audit.log`; others: ).

Default value: `undef`

##### <a name="-apache--vhost--modsec_audit_log_pipe"></a>`modsec_audit_log_pipe`

Data type: `Optional[String]`

If `modsec_audit_log_pipe` is set, it should start with a pipe. Example
`|/path/to/mlogc /path/to/mlogc.conf`.<br />
One of the parameters that determines how to send `mod_security` audit
log ([SecAuditLog](https://github.com/SpiderLabs/ModSecurity/wiki/Reference-Manual#SecAuditLog)).
If none of those parameters are set, the global audit log is used
(`/var/log/httpd/modsec\_audit.log`; Debian and derivatives: `/var/log/apache2/modsec\_audit.log`; others: ).

Default value: `undef`

##### <a name="-apache--vhost--modsec_audit_log"></a>`modsec_audit_log`

Data type: `Optional[Variant[String, Boolean]]`

If `modsec_audit_log` is `true`, given a virtual host ---for instance, example.com--- it
defaults to `example.com\_security\_ssl.log` for SSL-encrypted virtual hosts
and `example.com\_security.log` for unencrypted virtual hosts.<br />
One of the parameters that determines how to send `mod_security` audit
log ([SecAuditLog](https://github.com/SpiderLabs/ModSecurity/wiki/Reference-Manual#SecAuditLog)).<br />
If none of those parameters are set, the global audit log is used
(`/var/log/httpd/modsec\_audit.log`; Debian and derivatives: `/var/log/apache2/modsec\_audit.log`; others: ).

Default value: `undef`

##### <a name="-apache--vhost--modsec_inbound_anomaly_threshold"></a>`modsec_inbound_anomaly_threshold`

Data type: `Optional[Integer[1, default]]`

Override the global scoring threshold level of the inbound blocking rules
for the Collaborative Detection Mode in the OWASP ModSecurity Core Rule
Set.

Default value: `undef`

##### <a name="-apache--vhost--modsec_outbound_anomaly_threshold"></a>`modsec_outbound_anomaly_threshold`

Data type: `Optional[Integer[1, default]]`

Override the global scoring threshold level of the outbound blocking rules
for the Collaborative Detection Mode in the OWASP ModSecurity Core Rule
Set.

Default value: `undef`

##### <a name="-apache--vhost--modsec_allowed_methods"></a>`modsec_allowed_methods`

Data type: `Optional[String]`

Override global allowed methods. A space-separated list of allowed HTTP methods.

Default value: `undef`

##### <a name="-apache--vhost--no_proxy_uris"></a>`no_proxy_uris`

Data type: `Variant[Array[String], String]`

Specifies URLs you do not want to proxy. This parameter is meant to be used in combination
with [`proxy_dest`](#proxy_dest).

Default value: `[]`

##### <a name="-apache--vhost--no_proxy_uris_match"></a>`no_proxy_uris_match`

Data type: `Variant[Array[String], String]`

This directive is equivalent to `no_proxy_uris`, but takes regular expressions.

Default value: `[]`

##### <a name="-apache--vhost--proxy_preserve_host"></a>`proxy_preserve_host`

Data type: `Boolean`

Sets the [ProxyPreserveHost Directive](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypreservehost).<br />
Setting this parameter to `true` enables the `Host:` line from an incoming request to be
proxied to the host instead of hostname. Setting it to `false` sets this directive to 'Off'.

Default value: `false`

##### <a name="-apache--vhost--proxy_add_headers"></a>`proxy_add_headers`

Data type: `Optional[Variant[String, Boolean]]`

Sets the [ProxyAddHeaders Directive](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxyaddheaders).<br />
This parameter controlls whether proxy-related HTTP headers (X-Forwarded-For,
X-Forwarded-Host and X-Forwarded-Server) get sent to the backend server.

Default value: `undef`

##### <a name="-apache--vhost--proxy_error_override"></a>`proxy_error_override`

Data type: `Boolean`

Sets the [ProxyErrorOverride Directive](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxyerroroverride).
This directive controls whether Apache should override error pages for proxied content.

Default value: `false`

##### <a name="-apache--vhost--options"></a>`options`

Data type: `Array[String]`

Sets the [`Options`](https://httpd.apache.org/docs/current/mod/core.html#options) for the specified virtual host. For example:
``` puppet
apache::vhost { 'site.name.fdqn':
  ...
  options => ['Indexes', 'FollowSymLinks', 'MultiViews'],
}
```
> **Note**: If you use the `directories` parameter of `apache::vhost`, 'Options',
'Override', and 'DirectoryIndex' are ignored because they are parameters within `directories`.

Default value: `['Indexes', 'FollowSymLinks', 'MultiViews']`

##### <a name="-apache--vhost--override"></a>`override`

Data type: `Array[String]`

Sets the overrides for the specified virtual host. Accepts an array of
[AllowOverride](https://httpd.apache.org/docs/current/mod/core.html#allowoverride) arguments.

Default value: `['None']`

##### <a name="-apache--vhost--passenger_enabled"></a>`passenger_enabled`

Data type: `Optional[Boolean]`

Sets the value for the [PassengerEnabled](http://www.modrails.com/documentation/Users%20guide%20Apache.html#PassengerEnabled)
directive to `on` or `off`. Requires `apache::mod::passenger` to be included.
``` puppet
apache::vhost { 'sample.example.net':
  docroot     => '/path/to/directory',
  directories => [
    { path              => '/path/to/directory',
      passenger_enabled => 'on',
    },
  ],
}
```
> **Note:** There is an [issue](http://www.conandalton.net/2010/06/passengerenabled-off-not-working.html)
using the PassengerEnabled directive with the PassengerHighPerformance directive.

Default value: `undef`

##### <a name="-apache--vhost--passenger_base_uri"></a>`passenger_base_uri`

Data type: `Optional[String]`

Sets [PassengerBaseURI](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerbase_rui),
 to specify that the given URI is a distinct application served by Passenger.

Default value: `undef`

##### <a name="-apache--vhost--passenger_ruby"></a>`passenger_ruby`

Data type: `Optional[Stdlib::Absolutepath]`

Sets [PassengerRuby](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerruby),
specifying the Ruby interpreter to use when serving the relevant web applications.

Default value: `undef`

##### <a name="-apache--vhost--passenger_python"></a>`passenger_python`

Data type: `Optional[Stdlib::Absolutepath]`

Sets [PassengerPython](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerpython),
specifying the Python interpreter to use when serving the relevant web applications.

Default value: `undef`

##### <a name="-apache--vhost--passenger_nodejs"></a>`passenger_nodejs`

Data type: `Optional[Stdlib::Absolutepath]`

Sets the [`PassengerNodejs`](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengernodejs),
specifying Node.js command to use when serving the relevant web applications.

Default value: `undef`

##### <a name="-apache--vhost--passenger_meteor_app_settings"></a>`passenger_meteor_app_settings`

Data type: `Optional[String]`

Sets [PassengerMeteorAppSettings](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengermeteorappsettings),
specifying a JSON file with settings for the application when using a Meteor
application in non-bundled mode.

Default value: `undef`

##### <a name="-apache--vhost--passenger_app_env"></a>`passenger_app_env`

Data type: `Optional[String]`

Sets [PassengerAppEnv](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerappenv),
the environment for the Passenger application. If not specified, defaults to the global
setting or 'production'.

Default value: `undef`

##### <a name="-apache--vhost--passenger_app_root"></a>`passenger_app_root`

Data type: `Optional[Stdlib::Absolutepath]`

Sets [PassengerRoot](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerapproot),
the location of the Passenger application root if different from the DocumentRoot.

Default value: `undef`

##### <a name="-apache--vhost--passenger_app_group_name"></a>`passenger_app_group_name`

Data type: `Optional[String]`

Sets [PassengerAppGroupName](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerappgroupname),
 the name of the application group that the current application should belong to.

Default value: `undef`

##### <a name="-apache--vhost--passenger_app_start_command"></a>`passenger_app_start_command`

Data type: `Optional[String]`

Sets [PassengerAppStartCommand](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerappstartcommand),
 how Passenger should start your app on a specific port.

Default value: `undef`

##### <a name="-apache--vhost--passenger_app_type"></a>`passenger_app_type`

Data type: `Optional[Enum['meteor', 'node', 'rack', 'wsgi']]`

Sets [PassengerAppType](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerapptype),
 to force Passenger to recognize the application as a specific type.

Default value: `undef`

##### <a name="-apache--vhost--passenger_startup_file"></a>`passenger_startup_file`

Data type: `Optional[String]`

Sets the [PassengerStartupFile](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerstartupfile),
path. This path is relative to the application root.

Default value: `undef`

##### <a name="-apache--vhost--passenger_restart_dir"></a>`passenger_restart_dir`

Data type: `Optional[String]`

Sets the [PassengerRestartDir](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerrestartdir),
 to customize the directory in which `restart.txt` is searched for.

Default value: `undef`

##### <a name="-apache--vhost--passenger_spawn_method"></a>`passenger_spawn_method`

Data type: `Optional[Enum['direct', 'smart']]`

Sets [PassengerSpawnMethod](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerspawnmethod),
whether Passenger spawns applications directly, or using a prefork copy-on-write mechanism.

Default value: `undef`

##### <a name="-apache--vhost--passenger_load_shell_envvars"></a>`passenger_load_shell_envvars`

Data type: `Optional[Boolean]`

Sets [PassengerLoadShellEnvvars](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerloadshellenvvars),
to enable or disable the loading of shell environment variables before spawning the application.

Default value: `undef`

##### <a name="-apache--vhost--passenger_preload_bundler"></a>`passenger_preload_bundler`

Data type: `Optional[Boolean]`

Sets [PassengerPreloadBundler](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerpreloadbundler),
to enable or disable the loading of bundler before loading the application.

Default value: `undef`

##### <a name="-apache--vhost--passenger_rolling_restarts"></a>`passenger_rolling_restarts`

Data type: `Optional[Boolean]`

Sets [PassengerRollingRestarts](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerrollingrestarts),
to enable or disable support for zero-downtime application restarts through `restart.txt`.

Default value: `undef`

##### <a name="-apache--vhost--passenger_resist_deployment_errors"></a>`passenger_resist_deployment_errors`

Data type: `Optional[Boolean]`

Sets [PassengerResistDeploymentErrors](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerresistdeploymenterrors),
to enable or disable resistance against deployment errors.

Default value: `undef`

##### <a name="-apache--vhost--passenger_user"></a>`passenger_user`

Data type: `Optional[String]`

Sets [PassengerUser](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengeruser),
the running user for sandboxing applications.

Default value: `undef`

##### <a name="-apache--vhost--passenger_group"></a>`passenger_group`

Data type: `Optional[String]`

Sets [PassengerGroup](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengergroup),
the running group for sandboxing applications.

Default value: `undef`

##### <a name="-apache--vhost--passenger_friendly_error_pages"></a>`passenger_friendly_error_pages`

Data type: `Optional[Boolean]`

Sets [PassengerFriendlyErrorPages](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerfriendlyerrorpages),
which can display friendly error pages whenever an application fails to start. This
friendly error page presents the startup error message, some suggestions for solving
the problem, a backtrace and a dump of the environment variables.

Default value: `undef`

##### <a name="-apache--vhost--passenger_min_instances"></a>`passenger_min_instances`

Data type: `Optional[Integer]`

Sets [PassengerMinInstances](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengermininstances),
the minimum number of application processes to run.

Default value: `undef`

##### <a name="-apache--vhost--passenger_max_instances"></a>`passenger_max_instances`

Data type: `Optional[Integer]`

Sets [PassengerMaxInstances](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengermaxinstances),
the maximum number of application processes to run.

Default value: `undef`

##### <a name="-apache--vhost--passenger_max_preloader_idle_time"></a>`passenger_max_preloader_idle_time`

Data type: `Optional[Integer]`

Sets [PassengerMaxPreloaderIdleTime](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengermaxpreloaderidletime),
the maximum amount of time the preloader waits before shutting down an idle process.

Default value: `undef`

##### <a name="-apache--vhost--passenger_force_max_concurrent_requests_per_process"></a>`passenger_force_max_concurrent_requests_per_process`

Data type: `Optional[Integer]`

Sets [PassengerForceMaxConcurrentRequestsPerProcess](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerforcemaxconcurrentrequestsperprocess),
the maximum amount of concurrent requests the application can handle per process.

Default value: `undef`

##### <a name="-apache--vhost--passenger_start_timeout"></a>`passenger_start_timeout`

Data type: `Optional[Integer]`

Sets [PassengerStartTimeout](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerstarttimeout),
the timeout for the application startup.

Default value: `undef`

##### <a name="-apache--vhost--passenger_concurrency_model"></a>`passenger_concurrency_model`

Data type: `Optional[Enum['process', 'thread']]`

Sets [PassengerConcurrencyModel](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerconcurrencyodel),
to specify the I/O concurrency model that should be used for Ruby application processes.
Passenger supports two concurrency models:<br />
* `process` - single-threaded, multi-processed I/O concurrency.
* `thread` - multi-threaded, multi-processed I/O concurrency.

Default value: `undef`

##### <a name="-apache--vhost--passenger_thread_count"></a>`passenger_thread_count`

Data type: `Optional[Integer]`

Sets [PassengerThreadCount](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerthreadcount),
the number of threads that Passenger should spawn per Ruby application process.<br />
This option only has effect if PassengerConcurrencyModel is `thread`.

Default value: `undef`

##### <a name="-apache--vhost--passenger_max_requests"></a>`passenger_max_requests`

Data type: `Optional[Integer]`

Sets [PassengerMaxRequests](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengermaxrequests),
the maximum number of requests an application process will process.

Default value: `undef`

##### <a name="-apache--vhost--passenger_max_request_time"></a>`passenger_max_request_time`

Data type: `Optional[Integer]`

Sets [PassengerMaxRequestTime](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengermaxrequesttime),
the maximum amount of time, in seconds, that an application process may take to
process a request.

Default value: `undef`

##### <a name="-apache--vhost--passenger_memory_limit"></a>`passenger_memory_limit`

Data type: `Optional[Integer]`

Sets [PassengerMemoryLimit](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengermemorylimit),
the maximum amount of memory that an application process may use, in megabytes.

Default value: `undef`

##### <a name="-apache--vhost--passenger_stat_throttle_rate"></a>`passenger_stat_throttle_rate`

Data type: `Optional[Integer]`

Sets [PassengerStatThrottleRate](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerstatthrottlerate),
to set a limit, in seconds, on how often Passenger will perform it's filesystem checks.

Default value: `undef`

##### <a name="-apache--vhost--passenger_pre_start"></a>`passenger_pre_start`

Data type: `Optional[Variant[String, Array[String]]]`

Sets [PassengerPreStart](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerprestart),
the URL of the application if pre-starting is required.

Default value: `undef`

##### <a name="-apache--vhost--passenger_high_performance"></a>`passenger_high_performance`

Data type: `Optional[Boolean]`

Sets [PassengerHighPerformance](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerhighperformance),
to enhance performance in return for reduced compatibility.

Default value: `undef`

##### <a name="-apache--vhost--passenger_buffer_upload"></a>`passenger_buffer_upload`

Data type: `Optional[Boolean]`

Sets [PassengerBufferUpload](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerbufferupload),
to buffer HTTP client request bodies before they are sent to the application.

Default value: `undef`

##### <a name="-apache--vhost--passenger_buffer_response"></a>`passenger_buffer_response`

Data type: `Optional[Boolean]`

Sets [PassengerBufferResponse](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerbufferresponse),
to buffer Happlication-generated responses.

Default value: `undef`

##### <a name="-apache--vhost--passenger_error_override"></a>`passenger_error_override`

Data type: `Optional[Boolean]`

Sets [PassengerErrorOverride](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengererroroverride),
to specify whether Apache will intercept and handle response with HTTP status codes of
400 and higher.

Default value: `undef`

##### <a name="-apache--vhost--passenger_max_request_queue_size"></a>`passenger_max_request_queue_size`

Data type: `Optional[Integer]`

Sets [PassengerMaxRequestQueueSize](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengermaxrequestqueuesize),
to specify the maximum amount of requests that are allowed to queue whenever the maximum
concurrent request limit is reached. If the queue is already at this specified limit, then
Passenger immediately sends a "503 Service Unavailable" error to any incoming requests.<br />
A value of 0 means that the queue size is unbounded.

Default value: `undef`

##### <a name="-apache--vhost--passenger_max_request_queue_time"></a>`passenger_max_request_queue_time`

Data type: `Optional[Integer]`

Sets [PassengerMaxRequestQueueTime](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengermaxrequestqueuetime),
to specify the maximum amount of time that requests are allowed to stay in the queue
whenever the maximum concurrent request limit is reached. If a request reaches this specified
limit, then Passenger immeaditly sends a "504 Gateway Timeout" error for that request.<br />
A value of 0 means that the queue time is unbounded.

Default value: `undef`

##### <a name="-apache--vhost--passenger_sticky_sessions"></a>`passenger_sticky_sessions`

Data type: `Optional[Boolean]`

Sets [PassengerStickySessions](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerstickysessions),
to specify that, whenever possible, all requests sent by a client will be routed to the same
originating application process.

Default value: `undef`

##### <a name="-apache--vhost--passenger_sticky_sessions_cookie_name"></a>`passenger_sticky_sessions_cookie_name`

Data type: `Optional[String]`

Sets [PassengerStickySessionsCookieName](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerstickysessionscookiename),
to specify the name of the sticky sessions cookie.

Default value: `undef`

##### <a name="-apache--vhost--passenger_sticky_sessions_cookie_attributes"></a>`passenger_sticky_sessions_cookie_attributes`

Data type: `Optional[String]`

Sets [PassengerStickySessionsCookieAttributes](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerstickysessionscookieattributes),
the attributes of the sticky sessions cookie.

Default value: `undef`

##### <a name="-apache--vhost--passenger_allow_encoded_slashes"></a>`passenger_allow_encoded_slashes`

Data type: `Optional[Boolean]`

Sets [PassengerAllowEncodedSlashes](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerallowencodedslashes),
to allow URLs with encoded slashes. Please note that this feature will not work properly
unless Apache's `AllowEncodedSlashes` is also enabled.

Default value: `undef`

##### <a name="-apache--vhost--passenger_app_log_file"></a>`passenger_app_log_file`

Data type: `Optional[String]`

Sets [PassengerAppLogFile](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerapplogfile),
app specific messages logged to a different file in addition to Passenger log file.

Default value: `undef`

##### <a name="-apache--vhost--passenger_debugger"></a>`passenger_debugger`

Data type: `Optional[Boolean]`

Sets [PassengerDebugger](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerdebugger),
to turn support for Ruby application debugging on or off.

Default value: `undef`

##### <a name="-apache--vhost--passenger_lve_min_uid"></a>`passenger_lve_min_uid`

Data type: `Optional[Integer]`

Sets [PassengerLveMinUid](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerlveminuid),
to only allow the spawning of application processes with UIDs equal to, or higher than, this
specified value on LVE-enabled kernels.

Default value: `undef`

##### <a name="-apache--vhost--passenger_dump_config_manifest"></a>`passenger_dump_config_manifest`

Data type: `Optional[String]`

Sets [PassengerLveMinUid](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengerlveminuid),
to dump the configuration manifest to a file.

Default value: `undef`

##### <a name="-apache--vhost--passenger_admin_panel_url"></a>`passenger_admin_panel_url`

Data type: `Optional[String]`

Sets [PassengerAdminPanelUrl](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengeradminpanelurl),
to specify the URL of the Passenger admin panel.

Default value: `undef`

##### <a name="-apache--vhost--passenger_admin_panel_auth_type"></a>`passenger_admin_panel_auth_type`

Data type: `Optional[Enum['basic']]`

Sets [PassengerAdminPanelAuthType](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengeradminpanelauthtype),
to specify the authentication type for the Passenger admin panel.

Default value: `undef`

##### <a name="-apache--vhost--passenger_admin_panel_username"></a>`passenger_admin_panel_username`

Data type: `Optional[String]`

Sets [PassengerAdminPanelUsername](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengeradminpanelusername),
to specify the username for the Passenger admin panel.

Default value: `undef`

##### <a name="-apache--vhost--passenger_admin_panel_password"></a>`passenger_admin_panel_password`

Data type: `Optional[String]`

Sets [PassengerAdminPanelPassword](https://www.phusionpassenger.com/docs/references/config_reference/apache/#passengeradminpanelpassword),
to specify the password for the Passenger admin panel.

Default value: `undef`

##### <a name="-apache--vhost--php_values"></a>`php_values`

Data type: `Hash`

Allows per-virtual host setting [`php_value`s](http://php.net/manual/en/configuration.changes.php).
These flags or values can be overwritten by a user or an application.
Within a vhost declaration:
``` puppet
  php_values    => { 'include_path' => '.:/usr/local/example-app/include' },
```

Default value: `{}`

##### <a name="-apache--vhost--php_flags"></a>`php_flags`

Data type: `Hash`

Allows per-virtual host setting [`php_flags\``](http://php.net/manual/en/configuration.changes.php).
These flags or values can be overwritten by a user or an application.

Default value: `{}`

##### <a name="-apache--vhost--php_admin_values"></a>`php_admin_values`

Data type: `Variant[Array[String], Hash]`

Allows per-virtual host setting [`php_admin_value`](http://php.net/manual/en/configuration.changes.php).
These flags or values cannot be overwritten by a user or an application.

Default value: `{}`

##### <a name="-apache--vhost--php_admin_flags"></a>`php_admin_flags`

Data type: `Variant[Array[String], Hash]`

Allows per-virtual host setting [`php_admin_flag`](http://php.net/manual/en/configuration.changes.php).
These flags or values cannot be overwritten by a user or an application.

Default value: `{}`

##### <a name="-apache--vhost--port"></a>`port`

Data type: `Optional[Variant[Array[Stdlib::Port], Stdlib::Port]]`

Sets the port the host is configured on. The module's defaults ensure the host listens
on port 80 for non-SSL virtual hosts and port 443 for SSL virtual hosts. The host only
listens on the port set in this parameter.

Default value: `undef`

##### <a name="-apache--vhost--priority"></a>`priority`

Data type: `Optional[Apache::Vhost::Priority]`

Sets the relative load-order for Apache HTTPD VirtualHost configuration files.<br />
If nothing matches the priority, the first name-based virtual host is used. Likewise,
passing a higher priority causes the alphabetically first name-based virtual host to be
used if no other names match.<br />
> **Note:** You should not need to use this parameter. However, if you do use it, be
aware that the `default_vhost` parameter for `apache::vhost` passes a priority of 15.<br />
To omit the priority prefix in file names, pass a priority of `false`.

Default value: `undef`

##### <a name="-apache--vhost--protocols"></a>`protocols`

Data type: `Array[Enum['h2', 'h2c', 'http/1.1']]`

Sets the [Protocols](https://httpd.apache.org/docs/current/en/mod/core.html#protocols)
directive, which lists available protocols for the virutal host.

Default value: `[]`

##### <a name="-apache--vhost--protocols_honor_order"></a>`protocols_honor_order`

Data type: `Optional[Boolean]`

Sets the [ProtocolsHonorOrder](https://httpd.apache.org/docs/current/en/mod/core.html#protocolshonororder)
directive which determines wether the order of Protocols sets precedence during negotiation.

Default value: `undef`

##### <a name="-apache--vhost--proxy_dest"></a>`proxy_dest`

Data type: `Optional[String]`

Specifies the destination address of a [ProxyPass](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypass) configuration.

Default value: `undef`

##### <a name="-apache--vhost--proxy_pass"></a>`proxy_pass`

Data type: `Optional[Variant[Array[Hash], Hash]]`

Specifies an array of `path => URI` values for a [ProxyPass](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypass)
configuration. Optionally, parameters can be added as an array.
``` puppet
apache::vhost { 'site.name.fdqn':
  ...
  proxy_pass => [
    { 'path' => '/a', 'url' => 'http://backend-a/' },
    { 'path' => '/b', 'url' => 'http://backend-b/' },
    { 'path' => '/c', 'url' => 'http://backend-a/c', 'params' => {'max'=>20, 'ttl'=>120, 'retry'=>300}},
    { 'path' => '/l', 'url' => 'http://backend-xy',
      'reverse_urls' => ['http://backend-x', 'http://backend-y'] },
    { 'path' => '/d', 'url' => 'http://backend-a/d',
      'params' => { 'retry' => 0, 'timeout' => 5 }, },
    { 'path' => '/e', 'url' => 'http://backend-a/e',
      'keywords' => ['nocanon', 'interpolate'] },
    { 'path' => '/f', 'url' => 'http://backend-f/',
      'setenv' => ['proxy-nokeepalive 1', 'force-proxy-request-1.0 1']},
    { 'path' => '/g', 'url' => 'http://backend-g/',
      'reverse_cookies' => [{'path' => '/g', 'url' => 'http://backend-g/',}, {'domain' => 'http://backend-g', 'url' => 'http:://backend-g',},], },
    { 'path' => '/h', 'url' => 'http://backend-h/h',
      'no_proxy_uris' => ['/h/admin', '/h/server-status'] },
  ],
}
```
* `reverse_urls`. *Optional.* This setting is useful when used with `mod_proxy_balancer`. Values: an array or string.
* `reverse_cookies`. *Optional.* Sets `ProxyPassReverseCookiePath` and `ProxyPassReverseCookieDomain`.
* `params`. *Optional.* Allows for ProxyPass key-value parameters, such as connection settings.
* `setenv`. *Optional.* Sets [environment variables](https://httpd.apache.org/docs/current/mod/mod_proxy.html#envsettings) for the proxy directive. Values: array.

Default value: `undef`

##### <a name="-apache--vhost--proxy_dest_match"></a>`proxy_dest_match`

Data type: `Optional[String]`

This directive is equivalent to `proxy_dest`, but takes regular expressions, see
[ProxyPassMatch](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassmatch)
for details.

Default value: `undef`

##### <a name="-apache--vhost--proxy_dest_reverse_match"></a>`proxy_dest_reverse_match`

Data type: `Optional[String]`

Allows you to pass a ProxyPassReverse if `proxy_dest_match` is specified. See
[ProxyPassReverse](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassreverse)
for details.

Default value: `undef`

##### <a name="-apache--vhost--proxy_pass_match"></a>`proxy_pass_match`

Data type: `Optional[Variant[Array[Hash], Hash]]`

This directive is equivalent to `proxy_pass`, but takes regular expressions, see
[ProxyPassMatch](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassmatch)
for details.

Default value: `undef`

##### <a name="-apache--vhost--redirect_dest"></a>`redirect_dest`

Data type: `Optional[Variant[Array[String], String]]`

Specifies the address to redirect to.

Default value: `undef`

##### <a name="-apache--vhost--redirect_source"></a>`redirect_source`

Data type: `Variant[String, Array[String]]`

Specifies the source URIs that redirect to the destination specified in `redirect_dest`.
If more than one item for redirect is supplied, the source and destination must be the same
length, and the items are order-dependent.
``` puppet
apache::vhost { 'site.name.fdqn':
  ...
  redirect_source => ['/images', '/downloads'],
  redirect_dest   => ['http://img.example.com/', 'http://downloads.example.com/'],
}
```

Default value: `'/'`

##### <a name="-apache--vhost--redirect_status"></a>`redirect_status`

Data type: `Optional[Variant[Array[String], String]]`

Specifies the status to append to the redirect.
``` puppet
  apache::vhost { 'site.name.fdqn':
  ...
  redirect_status => ['temp', 'permanent'],
}
```

Default value: `undef`

##### <a name="-apache--vhost--redirectmatch_regexp"></a>`redirectmatch_regexp`

Data type: `Optional[Variant[Array[String], String]]`

Determines which server status should be raised for a given regular expression
and where to forward the user to. Entered as an array alongside redirectmatch_status
and redirectmatch_dest.
``` puppet
apache::vhost { 'site.name.fdqn':
  ...
  redirectmatch_status => ['404', '404'],
  redirectmatch_regexp => ['\.git(/.*|$)/', '\.svn(/.*|$)'],
  redirectmatch_dest => ['http://www.example.com/$1', 'http://www.example.com/$2'],
}
```

Default value: `undef`

##### <a name="-apache--vhost--redirectmatch_status"></a>`redirectmatch_status`

Data type: `Optional[Variant[Array[String], String]]`

Determines which server status should be raised for a given regular expression
and where to forward the user to. Entered as an array alongside redirectmatch_regexp
and redirectmatch_dest.
``` puppet
apache::vhost { 'site.name.fdqn':
  ...
  redirectmatch_status => ['404', '404'],
  redirectmatch_regexp => ['\.git(/.*|$)/', '\.svn(/.*|$)'],
  redirectmatch_dest => ['http://www.example.com/$1', 'http://www.example.com/$2'],
}
```

Default value: `undef`

##### <a name="-apache--vhost--redirectmatch_dest"></a>`redirectmatch_dest`

Data type: `Optional[Variant[Array[String], String]]`

Determines which server status should be raised for a given regular expression
and where to forward the user to. Entered as an array alongside redirectmatch_status
and redirectmatch_regexp.
``` puppet
apache::vhost { 'site.name.fdqn':
  ...
  redirectmatch_status => ['404', '404'],
  redirectmatch_regexp => ['\.git(/.*|$)/', '\.svn(/.*|$)'],
  redirectmatch_dest => ['http://www.example.com/$1', 'http://www.example.com/$2'],
}
```

Default value: `undef`

##### <a name="-apache--vhost--request_headers"></a>`request_headers`

Data type: `Array[String[1]]`

Modifies collected [request headers](https://httpd.apache.org/docs/current/mod/mod_headers.html#requestheader)
in various ways, including adding additional request headers, removing request headers,
and so on.
``` puppet
apache::vhost { 'site.name.fdqn':
  ...
  request_headers => [
    'append MirrorID "mirror 12"',
    'unset MirrorID',
  ],
}
```

Default value: `[]`

##### <a name="-apache--vhost--rewrites"></a>`rewrites`

Data type: `Array[Hash]`

Creates URL rewrite rules. Expects an array of hashes.<br />
Valid Hash keys include `comment`, `rewrite_base`, `rewrite_cond`, `rewrite_rule`
or `rewrite_map`.<br />
For example, you can specify that anyone trying to access index.html is served welcome.html
``` puppet
apache::vhost { 'site.name.fdqn':
  ...
  rewrites => [ { rewrite_rule => ['^index\.html$ welcome.html'] } ]
}
```
The parameter allows rewrite conditions that, when `true`, execute the associated rule.
For instance, if you wanted to rewrite URLs only if the visitor is using IE
``` puppet
apache::vhost { 'site.name.fdqn':
  ...
  rewrites => [
    {
      comment      => 'redirect IE',
      rewrite_cond => ['%{HTTP_USER_AGENT} ^MSIE'],
      rewrite_rule => ['^index\.html$ welcome.html'],
    },
  ],
}
```
You can also apply multiple conditions. For instance, rewrite index.html to welcome.html
only when the browser is Lynx or Mozilla (version 1 or 2)
``` puppet
apache::vhost { 'site.name.fdqn':
  ...
  rewrites => [
    {
      comment      => 'Lynx or Mozilla v1/2',
      rewrite_cond => ['%{HTTP_USER_AGENT} ^Lynx/ [OR]', '%{HTTP_USER_AGENT} ^Mozilla/[12]'],
      rewrite_rule => ['^index\.html$ welcome.html'],
    },
  ],
}
```
Multiple rewrites and conditions are also possible
``` puppet
apache::vhost { 'site.name.fdqn':
  ...
  rewrites => [
    {
      comment      => 'Lynx or Mozilla v1/2',
      rewrite_cond => ['%{HTTP_USER_AGENT} ^Lynx/ [OR]', '%{HTTP_USER_AGENT} ^Mozilla/[12]'],
      rewrite_rule => ['^index\.html$ welcome.html'],
    },
    {
      comment      => 'Internet Explorer',
      rewrite_cond => ['%{HTTP_USER_AGENT} ^MSIE'],
      rewrite_rule => ['^index\.html$ /index.IE.html [L]'],
    },
    {
      rewrite_base => /apps/,
      rewrite_rule => ['^index\.cgi$ index.php', '^index\.html$ index.php', '^index\.asp$ index.html'],
    },
    { comment      => 'Rewrite to lower case',
      rewrite_cond => ['%{REQUEST_URI} [A-Z]'],
      rewrite_map  => ['lc int:tolower'],
      rewrite_rule => ['(.*) ${lc:$1} [R=301,L]'],
    },
  ],
}
```
Refer to the [`mod_rewrite` documentation](https://httpd.apache.org/docs/2.4/mod/mod_rewrite.html)
for more details on what is possible with rewrite rules and conditions.<br />
> **Note**: If you include rewrites in your directories, also include `apache::mod::rewrite`
and consider setting the rewrites using the `rewrites` parameter in `apache::vhost` rather
than setting the rewrites in the virtual host's directories.

Default value: `[]`

##### <a name="-apache--vhost--rewrite_base"></a>`rewrite_base`

Data type: `Optional[String[1]]`

The parameter [`rewrite_base`](https://httpd.apache.org/docs/current/mod/mod_rewrite.html#rewritebase)
specifies the URL prefix to be used for per-directory (htaccess) RewriteRule directives
that substitue a relative path.

Default value: `undef`

##### <a name="-apache--vhost--rewrite_rule"></a>`rewrite_rule`

Data type: `Optional[Variant[Array[String[1]], String[1]]]`

The parameter [`rewrite_rile`](https://httpd.apache.org/docs/current/mod/mod_rewrite.html#rewriterule)
allows the user to define the rules that will be used by the rewrite engine.

Default value: `undef`

##### <a name="-apache--vhost--rewrite_cond"></a>`rewrite_cond`

Data type: `Array[String[1]]`

The parameter [`rewrite_cond`](https://httpd.apache.org/docs/current/mod/mod_rewrite.html#rewritecond)
defines a rule condition, that when satisfied will implement that rule within the
rewrite engine.

Default value: `[]`

##### <a name="-apache--vhost--rewrite_inherit"></a>`rewrite_inherit`

Data type: `Boolean`

Determines whether the virtual host inherits global rewrite rules.<br />
Rewrite rules may be specified globally (in `$conf_file` or `$confd_dir`) or
inside the virtual host `.conf` file. By default, virtual hosts do not inherit
global settings. To activate inheritance, specify the `rewrites` parameter and set
`rewrite_inherit` parameter to `true`:
``` puppet
apache::vhost { 'site.name.fdqn':
  ...
  rewrites => [
    <rules>,
  ],
  rewrite_inherit => `true`,
}
```
> **Note**: The `rewrites` parameter is **required** for this to have effect<br />
Apache activates global `Rewrite` rules inheritance if the virtual host files contains
the following directives:
``` ApacheConf
RewriteEngine On
RewriteOptions Inherit
```
Refer to the official [`mod_rewrite`](https://httpd.apache.org/docs/2.2/mod/mod_rewrite.html)
documentation, section "Rewriting in Virtual Hosts".

Default value: `false`

##### <a name="-apache--vhost--scriptalias"></a>`scriptalias`

Data type: `Optional[String]`

Defines a directory of CGI scripts to be aliased to the path '/cgi-bin', such as
'/usr/scripts'.

Default value: `undef`

##### <a name="-apache--vhost--serveradmin"></a>`serveradmin`

Data type: `Optional[String]`

Specifies the email address Apache displays when it renders one of its error pages.

Default value: `undef`

##### <a name="-apache--vhost--serveraliases"></a>`serveraliases`

Data type: `Variant[Array[String], String]`

Sets the [ServerAliases](https://httpd.apache.org/docs/current/mod/core.html#serveralias)
of the site.

Default value: `[]`

##### <a name="-apache--vhost--servername"></a>`servername`

Data type: `Optional[String]`

Sets the servername corresponding to the hostname you connect to the virtual host at.

Default value: `$name`

##### <a name="-apache--vhost--setenv"></a>`setenv`

Data type: `Variant[Array[String], String]`

Used by HTTPD to set environment variables for virtual hosts.<br />
Example:
``` puppet
apache::vhost { 'setenv.example.com':
  setenv => ['SPECIAL_PATH /foo/bin'],
}
```

Default value: `[]`

##### <a name="-apache--vhost--setenvif"></a>`setenvif`

Data type: `Variant[Array[String], String]`

Used by HTTPD to conditionally set environment variables for virtual hosts.

Default value: `[]`

##### <a name="-apache--vhost--setenvifnocase"></a>`setenvifnocase`

Data type: `Variant[Array[String], String]`

Used by HTTPD to conditionally set environment variables for virtual hosts (caseless matching).

Default value: `[]`

##### <a name="-apache--vhost--suexec_user_group"></a>`suexec_user_group`

Data type: `Optional[Pattern[/^[\w-]+ [\w-]+$/]]`

Allows the spcification of user and group execution privileges for CGI programs through
inclusion of the `mod_suexec` module.

Default value: `undef`

##### <a name="-apache--vhost--vhost_name"></a>`vhost_name`

Data type: `String`

Enables name-based virtual hosting. If no IP is passed to the virtual host, but the
virtual host is assigned a port, then the virtual host name is `vhost_name:port`.
If the virtual host has no assigned IP or port, the virtual host name is set to the
title of the resource.

Default value: `'*'`

##### <a name="-apache--vhost--virtual_docroot"></a>`virtual_docroot`

Data type: `Variant[Stdlib::Absolutepath, Boolean]`

Sets up a virtual host with a wildcard alias subdomain mapped to a directory with the
same name. For example, `http://example.com` would map to `/var/www/example.com`.
Note that the `DocumentRoot` directive will not be present even though there is a value
set for `docroot` in the manifest. See [`virtual_use_default_docroot`](#virtual_use_default_docroot) to change this behavior.
``` puppet
apache::vhost { 'subdomain.loc':
  vhost_name      => '*',
  port            => 80,
  virtual_docroot => '/var/www/%-2+',
  docroot         => '/var/www',
  serveraliases   => ['*.loc',],
}
```

Default value: `false`

##### <a name="-apache--vhost--virtual_use_default_docroot"></a>`virtual_use_default_docroot`

Data type: `Boolean`

By default, when using `virtual_docroot`, the value of `docroot` is ignored. Setting this
to `true` will mean both directives will be added to the configuration.
``` puppet
apache::vhost { 'subdomain.loc':
  vhost_name                  => '*',
  port                        => 80,
  virtual_docroot             => '/var/www/%-2+',
  docroot                     => '/var/www',
  virtual_use_default_docroot => true,
  serveraliases               => ['*.loc',],
}
```

Default value: `false`

##### <a name="-apache--vhost--wsgi_daemon_process"></a>`wsgi_daemon_process`

Data type: `Optional[Variant[String, Hash]]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process_options, wsgi_process_group,
wsgi_script_aliases and wsgi_pass_authorization.<br />
A hash that sets the name of the WSGI daemon, accepting
[certain keys](http://modwsgi.readthedocs.org/en/latest/configuration-directives/WSGIDaemonProcess.html).<br />
An example virtual host configuration with WSGI:
``` puppet
apache::vhost { 'wsgi.example.com':
  port                        => 80,
  docroot                     => '/var/www/pythonapp',
  wsgi_daemon_process         => 'wsgi',
  wsgi_daemon_process_options =>
    { processes    => 2,
      threads      => 15,
      display-name => '%{GROUP}',
    },
  wsgi_process_group          => 'wsgi',
  wsgi_script_aliases         => { '/' => '/var/www/demo.wsgi' },
  wsgi_chunked_request        => 'On',
}
```

Default value: `undef`

##### <a name="-apache--vhost--wsgi_daemon_process_options"></a>`wsgi_daemon_process_options`

Data type: `Optional[Hash]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_process_group,
wsgi_script_aliases and wsgi_pass_authorization.<br />
Sets the group ID that the virtual host runs under.

Default value: `undef`

##### <a name="-apache--vhost--wsgi_application_group"></a>`wsgi_application_group`

Data type: `Optional[String]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group,
and wsgi_pass_authorization.<br />
This parameter defines the [`WSGIApplicationGroup directive`](https://modwsgi.readthedocs.io/en/develop/configuration-directives/WSGIApplicationGroup.html),
thus allowing you to specify which application group the WSGI application belongs to,
with all WSGI applications within the same group executing within the context of the
same Python sub interpreter.

Default value: `undef`

##### <a name="-apache--vhost--wsgi_import_script"></a>`wsgi_import_script`

Data type: `Optional[String]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group,
and wsgi_pass_authorization.<br />
This parameter defines the [`WSGIImportScript directive`](https://modwsgi.readthedocs.io/en/develop/configuration-directives/WSGIImportScript.html),
which can be used in order to specify a script file to be loaded upon a process starting.

Default value: `undef`

##### <a name="-apache--vhost--wsgi_import_script_options"></a>`wsgi_import_script_options`

Data type: `Optional[Hash]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group,
and wsgi_pass_authorization.<br />
This parameter defines the [`WSGIImportScript directive`](https://modwsgi.readthedocs.io/en/develop/configuration-directives/WSGIImportScript.html),
which can be used in order to specify a script file to be loaded upon a process starting.<br />
Specifies the process and aplication groups of the script.

Default value: `undef`

##### <a name="-apache--vhost--wsgi_chunked_request"></a>`wsgi_chunked_request`

Data type: `Optional[Apache::OnOff]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group,
and wsgi_pass_authorization.<br />
This parameter defines the [`WSGIChunkedRequest directive`](https://modwsgi.readthedocs.io/en/develop/configuration-directives/WSGIChunkedRequest.html),
allowing you to enable support for chunked request content.<br />
WSGI is technically incapable of supporting chunked request content without all chunked
request content having first been read in and buffered.

Default value: `undef`

##### <a name="-apache--vhost--wsgi_process_group"></a>`wsgi_process_group`

Data type: `Optional[String]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options,
wsgi_script_aliases and wsgi_pass_authorization.<br />
Requires a hash of web paths to filesystem `.wsgi paths/`.

Default value: `undef`

##### <a name="-apache--vhost--wsgi_script_aliases"></a>`wsgi_script_aliases`

Data type: `Optional[Hash]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group,
and wsgi_pass_authorization.<br />
Uses the WSGI application to handle authorization instead of Apache when set to `On`.<br />
For more information, see mod_wsgi's [WSGIPassAuthorization documentation](https://modwsgi.readthedocs.org/en/latest/configuration-directives/WSGIPassAuthorization.html).

Default value: `undef`

##### <a name="-apache--vhost--wsgi_script_aliases_match"></a>`wsgi_script_aliases_match`

Data type: `Optional[Hash]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group,
and wsgi_pass_authorization.<br />
Uses the WSGI application to handle authorization instead of Apache when set to `On`.<br />
This directive is similar to `wsgi_script_aliases`, but makes use of regular expressions
in place of simple prefix matching.<br />
For more information, see mod_wsgi's [WSGIPassAuthorization documentation](https://modwsgi.readthedocs.org/en/latest/configuration-directives/WSGIPassAuthorization.html).

Default value: `undef`

##### <a name="-apache--vhost--wsgi_pass_authorization"></a>`wsgi_pass_authorization`

Data type: `Optional[Apache::OnOff]`

Sets up a virtual host with [WSGI](https://github.com/GrahamDumpleton/mod_wsgi) alongside
wsgi_daemon_process, wsgi_daemon_process_options, wsgi_process_group and
wsgi_script_aliases.<br />
Enables support for chunked requests.

Default value: `undef`

##### <a name="-apache--vhost--directories"></a>`directories`

Data type: `Array[Hash]`

The `directories` parameter within the `apache::vhost` class passes an array of hashes
to the virtual host to create [Directory](https://httpd.apache.org/docs/current/mod/core.html#directory),
[File](https://httpd.apache.org/docs/current/mod/core.html#files), and
[Location](https://httpd.apache.org/docs/current/mod/core.html#location) directive blocks.
These blocks take the form, `< Directory /path/to/directory>...< /Directory>`.<br />
The `path` key sets the path for the directory, files, and location blocks. Its value
must be a path for the `directory`, `files`, and `location` providers, or a regex for
the `directorymatch`, `filesmatch`, or `locationmatch` providers. Each hash passed to
`directories` **must** contain `path` as one of the keys.<br />
The `provider` key is optional. If missing, this key defaults to `directory`.
 Values: `directory`, `files`, `proxy`, `location`, `directorymatch`, `filesmatch`,
`proxymatch` or `locationmatch`. If you set `provider` to `directorymatch`, it
uses the keyword `DirectoryMatch` in the Apache config file.<br />
proxy_pass and proxy_pass_match are supported like their parameters to apache::vhost, and will
be rendered without their path parameter as this will be inherited from the Location/LocationMatch container.
An example use of `directories`:
``` puppet
apache::vhost { 'files.example.net':
  docroot     => '/var/www/files',
  directories => [
    { 'path'     => '/var/www/files',
      'provider' => 'files',
      'deny'     => 'from all',
    },
    { 'path'           => '/var/www/html',
      'provider'       => 'directory',
      'options'        => ['-Indexes'],
      'allow_override' => ['All'],
    },
  ],
}
```
> **Note:** At least one directory should match the `docroot` parameter. After you
start declaring directories, `apache::vhost` assumes that all required Directory blocks
will be declared. If not defined, a single default Directory block is created that matches
the `docroot` parameter.<br />
Available handlers, represented as keys, should be placed within the `directory`,
`files`, or `location` hashes. This looks like
``` puppet
apache::vhost { 'sample.example.net':
  docroot     => '/path/to/directory',
  directories => [ { path => '/path/to/directory', handler => value } ],
}
```
Any handlers you do not set in these hashes are considered `undefined` within Puppet and
are not added to the virtual host, resulting in the module using their default values.

The `directories` param can accepts the different authentication ways, including `gssapi`, `Basic (authz_core)`,
and others.

  * `gssapi` - Specifies mod_auth_gssapi parameters for particular directories in a virtual host directory
    TODO: check, if this Documentation is obsolete

    ```puppet
    apache::vhost { 'sample.example.net':
      docroot     => '/path/to/directory',
      directories => [
        { path   => '/path/to/different/dir',
          gssapi => {
            acceptor_name            => '{HOSTNAME}',
            allowed_mech             => ['krb5', 'iakerb', 'ntlmssp'],
            authname                 => 'Kerberos 5',
            authtype                 => 'GSSAPI',
            basic_auth               => true,
            basic_auth_mech          => ['krb5', 'iakerb', 'ntlmssp'],
            basic_ticket_timeout     => 300,
            connection_bound         => true,
            cred_store               => {
              ccache        => ['/path/to/directory'],
              client_keytab => ['/path/to/example.keytab'],
              keytab        => ['/path/to/example.keytab'],
            },
            deleg_ccache_dir         => '/path/to/directory',
            deleg_ccache_env_var     => 'KRB5CCNAME',
            deleg_ccache_perms       => {
              mode => '0600',
              uid  => 'example-user',
              gid  => 'example-group',
            },
            deleg_ccache_unique      => true,
            impersonate              => true,
            local_name               => true,
            name_attributes          => 'json',
            negotiate_once           => true,
            publish_errors           => true,
            publish_mech             => true,
            required_name_attributes =>	'auth-indicators=high',
            session_key              => 'file:/path/to/example.key',
            signal_persistent_auth   => true,
            ssl_only                 => true,
            use_s4u2_proxy           => true,
            use_sessions             => true,
          }
        },
      ],
    }
    ```

  * `Basic` - Specifies mod_authz_core parameters for particular directories in a virtual host directory
    ```puppet
    apache::vhost { 'sample.example.net':
      docroot     => '/path/to/directory',
      directories => [
        {
          path        => '/path/to/different/dir',
          auth_type => 'Basic',
          authz_core  => {
            require_all => {
              'require_any' => {
                'require' => ['user superadmin'],
                'require_all' => {
                  'require' => ['group admins', 'ldap-group "cn=Administrators,o=Airius"'],
                },
              },
              'require_none' => {
                'require' => ['group temps', 'ldap-group "cn=Temporary Employees,o=Airius"']
              }
            }
          }
        },
      ],
    }
    ```

Default value: `[]`

##### <a name="-apache--vhost--custom_fragment"></a>`custom_fragment`

Data type: `Optional[String]`

Pass a string of custom configuration directives to be placed at the end of the directory
configuration.
``` puppet
apache::vhost { 'monitor':
  ...
  directories => [
    {
      path => '/path/to/directory',
      custom_fragment => '
<Location /balancer-manager>
  SetHandler balancer-manager
  Order allow,deny
  Allow from all
</Location>
<Location /server-status>
  SetHandler server-status
  Order allow,deny
  Allow from all
</Location>
ProxyStatus On',
    },
  ]
}
```

Default value: `undef`

##### <a name="-apache--vhost--headers"></a>`headers`

Data type: `Array[String[1]]`

Adds lines for [Header](https://httpd.apache.org/docs/current/mod/mod_headers.html#header) directives.
``` puppet
apache::vhost { 'sample.example.net':
  docroot     => '/path/to/directory',
  directories => [
    {
      path    => '/path/to/directory',
      headers => 'Set X-Robots-Tag "noindex, noarchive, nosnippet"',
    },
  ],
}
```

Default value: `[]`

##### <a name="-apache--vhost--shib_compat_valid_user"></a>`shib_compat_valid_user`

Data type: `Optional[String]`

Default is Off, matching the behavior prior to this command's existence. Addresses a conflict
when using Shibboleth in conjunction with other auth/auth modules by restoring `standard`
Apache behavior when processing the `valid-user` and `user` Require rules. See the
[`mod_shib`documentation](https://wiki.shibboleth.net/confluence/display/SHIB2/NativeSPApacheConfig#NativeSPApacheConfig-Server/VirtualHostOptions),
and [NativeSPhtaccess](https://wiki.shibboleth.net/confluence/display/SHIB2/NativeSPhtaccess)
topic for more details. This key is disabled if `apache::mod::shib` is not defined.

Default value: `undef`

##### <a name="-apache--vhost--ssl_options"></a>`ssl_options`

Data type: `Optional[Variant[Array[String], String]]`

String or list of [SSLOptions](https://httpd.apache.org/docs/current/mod/mod_ssl.html#ssloptions),
which configure SSL engine run-time options. This handler takes precedence over SSLOptions
set in the parent block of the virtual host.
``` puppet
apache::vhost { 'secure.example.net':
  docroot     => '/path/to/directory',
  directories => [
    { path        => '/path/to/directory',
      ssl_options => '+ExportCertData',
    },
    { path        => '/path/to/different/dir',
      ssl_options => ['-StdEnvVars', '+ExportCertData'],
    },
  ],
}
```

Default value: `undef`

##### <a name="-apache--vhost--additional_includes"></a>`additional_includes`

Data type: `Variant[Array[String], String]`

Specifies paths to additional static, specific Apache configuration files in virtual
host directories.
``` puppet
apache::vhost { 'sample.example.net':
  docroot     => '/path/to/directory',
  directories => [
    { path  => '/path/to/different/dir',
      additional_includes => ['/custom/path/includes', '/custom/path/another_includes',],
    },
  ],
}
```

Default value: `[]`

##### <a name="-apache--vhost--ssl"></a>`ssl`

Data type: `Boolean`

Enables SSL for the virtual host. SSL virtual hosts only respond to HTTPS queries.

Default value: `false`

##### <a name="-apache--vhost--ssl_ca"></a>`ssl_ca`

Data type: `Optional[Stdlib::Absolutepath]`

Specifies the SSL certificate authority to be used to verify client certificates used
for authentication.

Default value: `$apache::default_ssl_ca`

##### <a name="-apache--vhost--ssl_cert"></a>`ssl_cert`

Data type: `Optional[Stdlib::Absolutepath]`

Specifies the SSL certification.

Default value: `$apache::default_ssl_cert`

##### <a name="-apache--vhost--ssl_protocol"></a>`ssl_protocol`

Data type: `Optional[Variant[Array[String], String]]`

Specifies [SSLProtocol](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslprotocol).
Expects an array or space separated string of accepted protocols.

Default value: `undef`

##### <a name="-apache--vhost--ssl_cipher"></a>`ssl_cipher`

Data type: `Optional[Variant[Array[String[1]], String[1], Hash[String[1], String[1]]]]`

Specifies [SSLCipherSuite](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslciphersuite).

Default value: `undef`

##### <a name="-apache--vhost--ssl_honorcipherorder"></a>`ssl_honorcipherorder`

Data type: `Variant[Boolean, Apache::OnOff, Undef]`

Sets [SSLHonorCipherOrder](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslhonorcipherorder),
to cause Apache to use the server's preferred order of ciphers rather than the client's
preferred order.

Default value: `undef`

##### <a name="-apache--vhost--ssl_certs_dir"></a>`ssl_certs_dir`

Data type: `Optional[Stdlib::Absolutepath]`

Specifies the location of the SSL certification directory to verify client certs.

Default value: `$apache::params::ssl_certs_dir`

##### <a name="-apache--vhost--ssl_chain"></a>`ssl_chain`

Data type: `Optional[Stdlib::Absolutepath]`

Specifies the SSL chain. This default works out of the box, but it must be updated in
the base `apache` class with your specific certificate information before being used in
production.

Default value: `$apache::default_ssl_chain`

##### <a name="-apache--vhost--ssl_crl"></a>`ssl_crl`

Data type: `Optional[Stdlib::Absolutepath]`

Specifies the certificate revocation list to use. (This default works out of the box but
must be updated in the base `apache` class with your specific certificate information
before being used in production.)

Default value: `$apache::default_ssl_crl`

##### <a name="-apache--vhost--ssl_crl_path"></a>`ssl_crl_path`

Data type: `Optional[Stdlib::Absolutepath]`

Specifies the location of the certificate revocation list to verify certificates for
client authentication with. (This default works out of the box but must be updated in
the base `apache` class with your specific certificate information before being used in
production.)

Default value: `$apache::default_ssl_crl_path`

##### <a name="-apache--vhost--ssl_crl_check"></a>`ssl_crl_check`

Data type: `Optional[String]`

Sets the certificate revocation check level via the [SSLCARevocationCheck directive](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslcarevocationcheck)
for ssl client authentication. The default works out of the box but must be specified when
using CRLs in production. Only applicable to Apache 2.4 or higher; the value is ignored on
older versions.

Default value: `$apache::default_ssl_crl_check`

##### <a name="-apache--vhost--ssl_key"></a>`ssl_key`

Data type: `Optional[Stdlib::Absolutepath]`

Specifies the SSL key.<br />
Defaults are based on your operating system. Default work out of the box but must be
updated in the base `apache` class with your specific certificate information before
being used in production.

Default value: `$apache::default_ssl_key`

##### <a name="-apache--vhost--ssl_verify_client"></a>`ssl_verify_client`

Data type: `Optional[Enum['none', 'optional', 'require', 'optional_no_ca']]`

Sets the [SSLVerifyClient](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslverifyclient)
directive, which sets the certificate verification level for client authentication.
``` puppet
apache::vhost { 'sample.example.net':
  ...
  ssl_verify_client => 'optional',
}
```

Default value: `undef`

##### <a name="-apache--vhost--ssl_verify_depth"></a>`ssl_verify_depth`

Data type: `Optional[Integer]`

Sets the [SSLVerifyDepth](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslverifydepth)
directive, which specifies the maximum depth of CA certificates in client certificate
verification. You must set `ssl_verify_client` for it to take effect.
``` puppet
apache::vhost { 'sample.example.net':
  ...
  ssl_verify_client => 'require',
  ssl_verify_depth => 1,
}
```

Default value: `undef`

##### <a name="-apache--vhost--ssl_proxy_protocol"></a>`ssl_proxy_protocol`

Data type: `Optional[String]`

Sets the [SSLProxyProtocol](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxyprotocol)
directive, which controls which SSL protocol flavors `mod_ssl` should use when establishing
its server environment for proxy. It connects to servers using only one of the provided
protocols.

Default value: `undef`

##### <a name="-apache--vhost--ssl_proxy_verify"></a>`ssl_proxy_verify`

Data type: `Optional[Enum['none', 'optional', 'require', 'optional_no_ca']]`

Sets the [SSLProxyVerify](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxyverify)
directive, which configures certificate verification of the remote server when a proxy is
configured to forward requests to a remote SSL server.

Default value: `undef`

##### <a name="-apache--vhost--ssl_proxy_verify_depth"></a>`ssl_proxy_verify_depth`

Data type: `Optional[Integer[0]]`

Sets the [SSLProxyVerifyDepth](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxyverifydepth)
directive, which configures how deeply mod_ssl should verify before deciding that the
remote server does not have a valid certificate.<br />
A depth of 0 means that only self-signed remote server certificates are accepted,
the default depth of 1 means the remote server certificate can be self-signed or
signed by a CA that is directly known to the server.

Default value: `undef`

##### <a name="-apache--vhost--ssl_proxy_cipher_suite"></a>`ssl_proxy_cipher_suite`

Data type: `Optional[String]`

Sets the [SSLProxyCipherSuite](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxyciphersuite)
directive, which controls cipher suites supported for ssl proxy traffic.

Default value: `undef`

##### <a name="-apache--vhost--ssl_proxy_ca_cert"></a>`ssl_proxy_ca_cert`

Data type: `Optional[Stdlib::Absolutepath]`

Sets the [SSLProxyCACertificateFile](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxycacertificatefile)
directive, which specifies an all-in-one file where you can assemble the Certificates
of Certification Authorities (CA) whose remote servers you deal with. These are used
for Remote Server Authentication. This file should be a concatenation of the PEM-encoded
certificate files in order of preference.

Default value: `undef`

##### <a name="-apache--vhost--ssl_proxy_machine_cert"></a>`ssl_proxy_machine_cert`

Data type: `Optional[Stdlib::Absolutepath]`

Sets the [SSLProxyMachineCertificateFile](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxymachinecertificatefile)
directive, which specifies an all-in-one file where you keep the certs and keys used
for this server to authenticate itself to remote servers. This file should be a
concatenation of the PEM-encoded certificate files in order of preference.
``` puppet
apache::vhost { 'sample.example.net':
  ...
  ssl_proxy_machine_cert => '/etc/httpd/ssl/client_certificate.pem',
}
```

Default value: `undef`

##### <a name="-apache--vhost--ssl_proxy_machine_cert_chain"></a>`ssl_proxy_machine_cert_chain`

Data type: `Optional[Stdlib::Absolutepath]`

Sets the [SSLProxyMachineCertificateChainFile](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxymachinecertificatechainfile)
directive, which specifies an all-in-one file where you keep the certificate chain for
all of the client certs in use. This directive will be needed if the remote server
presents a list of CA certificates that are not direct signers of one of the configured
client certificates. This referenced file is simply the concatenation of the various
PEM-encoded certificate files. Upon startup, each client certificate configured will be
examined and a chain of trust will be constructed.

Default value: `undef`

##### <a name="-apache--vhost--ssl_proxy_check_peer_cn"></a>`ssl_proxy_check_peer_cn`

Data type: `Optional[Apache::OnOff]`

Sets the [SSLProxyCheckPeerCN](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxycheckpeercn)
directive, which specifies whether the remote server certificate's CN field is compared
against the hostname of the request URL.

Default value: `undef`

##### <a name="-apache--vhost--ssl_proxy_check_peer_name"></a>`ssl_proxy_check_peer_name`

Data type: `Optional[Apache::OnOff]`

Sets the [SSLProxyCheckPeerName](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxycheckpeername)
directive, which specifies whether the remote server certificate's CN field is compared
against the hostname of the request URL.

Default value: `undef`

##### <a name="-apache--vhost--ssl_proxy_check_peer_expire"></a>`ssl_proxy_check_peer_expire`

Data type: `Optional[Apache::OnOff]`

Sets the [SSLProxyCheckPeerExpire](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxycheckpeerexpire)
directive, which specifies whether the remote server certificate is checked for expiration
or not.

Default value: `undef`

##### <a name="-apache--vhost--ssl_openssl_conf_cmd"></a>`ssl_openssl_conf_cmd`

Data type: `Optional[String]`

Sets the [SSLOpenSSLConfCmd](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslopensslconfcmd)
directive, which provides direct configuration of OpenSSL parameters.

Default value: `undef`

##### <a name="-apache--vhost--ssl_proxyengine"></a>`ssl_proxyengine`

Data type: `Boolean`

Specifies whether or not to use [SSLProxyEngine](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslproxyengine).

Default value: `false`

##### <a name="-apache--vhost--ssl_stapling"></a>`ssl_stapling`

Data type: `Optional[Boolean]`

Specifies whether or not to use [SSLUseStapling](http://httpd.apache.org/docs/current/mod/mod_ssl.html#sslusestapling).
By default, uses what is set globally.<br />
This parameter only applies to Apache 2.4 or higher and is ignored on older versions.

Default value: `undef`

##### <a name="-apache--vhost--ssl_stapling_timeout"></a>`ssl_stapling_timeout`

Data type: `Optional[Integer]`

Can be used to set the [SSLStaplingResponderTimeout](http://httpd.apache.org/docs/current/mod/mod_ssl.html#sslstaplingrespondertimeout) directive.<br />
This parameter only applies to Apache 2.4 or higher and is ignored on older versions.

Default value: `undef`

##### <a name="-apache--vhost--ssl_stapling_return_errors"></a>`ssl_stapling_return_errors`

Data type: `Optional[Apache::OnOff]`

Can be used to set the [SSLStaplingReturnResponderErrors](http://httpd.apache.org/docs/current/mod/mod_ssl.html#sslstaplingreturnrespondererrors) directive.<br />
This parameter only applies to Apache 2.4 or higher and is ignored on older versions.

Default value: `undef`

##### <a name="-apache--vhost--ssl_user_name"></a>`ssl_user_name`

Data type: `Optional[String]`

Sets the [SSLUserName](https://httpd.apache.org/docs/current/mod/mod_ssl.html#sslusername) directive.

Default value: `undef`

##### <a name="-apache--vhost--ssl_reload_on_change"></a>`ssl_reload_on_change`

Data type: `Boolean`

Enable reloading of apache if the content of ssl files have changed.

Default value: `$apache::default_ssl_reload_on_change`

##### <a name="-apache--vhost--use_canonical_name"></a>`use_canonical_name`

Data type: `Optional[Variant[Apache::OnOff, Enum['DNS', 'dns']]]`

Specifies whether to use the [`UseCanonicalName directive`](https://httpd.apache.org/docs/2.4/mod/core.html#usecanonicalname),
which allows you to configure how the server determines it's own name and port.

Default value: `undef`

##### <a name="-apache--vhost--define"></a>`define`

Data type: `Hash`

this lets you define configuration variables inside a vhost using [`Define`](https://httpd.apache.org/docs/2.4/mod/core.html#define),
these can then be used to replace configuration values. All Defines are Undefined at the end of the VirtualHost.

Default value: `{}`

##### <a name="-apache--vhost--auth_oidc"></a>`auth_oidc`

Data type: `Boolean`

Enable `mod_auth_openidc` parameters for OpenID Connect authentication.

Default value: `false`

##### <a name="-apache--vhost--oidc_settings"></a>`oidc_settings`

Data type: `Apache::OIDCSettings`

An Apache::OIDCSettings Struct containing (mod_auth_openidc settings)[https://github.com/zmartzone/mod_auth_openidc/blob/master/auth_openidc.conf].

Default value: `{}`

##### <a name="-apache--vhost--limitreqfields"></a>`limitreqfields`

Data type: `Optional[Integer]`

The `limitreqfields` parameter sets the maximum number of request header fields in
an HTTP request. This directive gives the server administrator greater control over
abnormal client request behavior, which may be useful for avoiding some forms of
denial-of-service attacks. The value should be increased if normal clients see an error
response from the server that indicates too many fields were sent in the request.

Default value: `undef`

##### <a name="-apache--vhost--limitreqfieldsize"></a>`limitreqfieldsize`

Data type: `Optional[Integer]`

The `limitreqfieldsize` parameter sets the maximum ammount of _bytes_ that will
be allowed within a request header.

Default value: `undef`

##### <a name="-apache--vhost--limitreqline"></a>`limitreqline`

Data type: `Optional[Integer]`

Limit the size of the HTTP request line that will be accepted from the client
This directive sets the number of bytes that will be allowed on the HTTP
request-line. The LimitRequestLine directive allows the server administrator
to set the limit on the allowed size of a client's HTTP request-line. Since
the request-line consists of the HTTP method, URI, and protocol version, the
LimitRequestLine directive places a restriction on the length of a request-URI
allowed for a request on the server. A server needs this value to be large
enough to hold any of its resource names, including any information that might
be passed in the query part of a GET request.

Default value: `undef`

##### <a name="-apache--vhost--limitreqbody"></a>`limitreqbody`

Data type: `Optional[Integer]`

Restricts the total size of the HTTP request body sent from the client
The LimitRequestBody directive allows the user to set a limit on the allowed
size of an HTTP request message body within the context in which the
directive is given (server, per-directory, per-file or per-location). If the
client request exceeds that limit, the server will return an error response
instead of servicing the request.

Default value: `undef`

##### <a name="-apache--vhost--use_servername_for_filenames"></a>`use_servername_for_filenames`

Data type: `Boolean`

When set to true, default log / config file names will be derived from the sanitized
value of the $servername parameter.
When set to false (default), the existing behaviour of using the $name parameter
will remain.

Default value: `false`

##### <a name="-apache--vhost--use_port_for_filenames"></a>`use_port_for_filenames`

Data type: `Boolean`

When set to true and use_servername_for_filenames is also set to true, default log /
config file names will be derived from the sanitized value of both the $servername and
$port parameters.
When set to false (default), the port is not included in the file names and may lead to
duplicate declarations if two virtual hosts use the same domain.

Default value: `false`

##### <a name="-apache--vhost--mdomain"></a>`mdomain`

Data type: `Optional[Variant[Boolean, String]]`

All the names in the list are managed as one Managed Domain (MD). mod_md will request
one single certificate that is valid for all these names.

Default value: `undef`

##### <a name="-apache--vhost--proxy_requests"></a>`proxy_requests`

Data type: `Boolean`

Whether to accept proxy requests

Default value: `false`

##### <a name="-apache--vhost--userdir"></a>`userdir`

Data type: `Optional[Variant[String[1], Array[String[1]]]]`

Instances of apache::mod::userdir

Default value: `undef`

### <a name="apache--vhost--custom"></a>`apache::vhost::custom`

The `apache::vhost::custom` defined type is a thin wrapper around the `apache::custom_config` defined type, and simply overrides some of its default settings specific to the virtual host directory in Apache.

#### Parameters

The following parameters are available in the `apache::vhost::custom` defined type:

* [`content`](#-apache--vhost--custom--content)
* [`ensure`](#-apache--vhost--custom--ensure)
* [`priority`](#-apache--vhost--custom--priority)
* [`verify_config`](#-apache--vhost--custom--verify_config)

##### <a name="-apache--vhost--custom--content"></a>`content`

Data type: `String`

Sets the configuration file's content.

##### <a name="-apache--vhost--custom--ensure"></a>`ensure`

Data type: `String`

Specifies if the virtual host file is present or absent.

Default value: `'present'`

##### <a name="-apache--vhost--custom--priority"></a>`priority`

Data type: `Apache::Vhost::Priority`

Sets the relative load order for Apache HTTPD VirtualHost configuration files.

Default value: `25`

##### <a name="-apache--vhost--custom--verify_config"></a>`verify_config`

Data type: `Boolean`

Specifies whether to validate the configuration file before notifying the Apache service.

Default value: `true`

### <a name="apache--vhost--fragment"></a>`apache::vhost::fragment`

Define a fragment within a vhost

#### Examples

##### With a vhost without priority

```puppet
include apache
apache::vhost { 'myvhost':
}
apache::vhost::fragment { 'myfragment':
  vhost   => 'myvhost',
  content => '# Foo',
}
```

##### With a vhost with priority

```puppet
include apache
apache::vhost { 'myvhost':
  priority => 42,
}
apache::vhost::fragment { 'myfragment':
  vhost    => 'myvhost',
  priority => 42,
  content  => '# Foo',
}
```

##### With a vhost with default vhost

```puppet
include apache
apache::vhost { 'myvhost':
  default_vhost => true,
}
apache::vhost::fragment { 'myfragment':
  vhost    => 'myvhost',
  priority => 10, # default_vhost implies priority 10
  content  => '# Foo',
}
```

##### Adding a fragment to the built in default vhost

```puppet
include apache
apache::vhost::fragment { 'myfragment':
  vhost    => 'default',
  priority => 15,
  content  => '# Foo',
}
```

#### Parameters

The following parameters are available in the `apache::vhost::fragment` defined type:

* [`vhost`](#-apache--vhost--fragment--vhost)
* [`priority`](#-apache--vhost--fragment--priority)
* [`content`](#-apache--vhost--fragment--content)
* [`order`](#-apache--vhost--fragment--order)
* [`port`](#-apache--vhost--fragment--port)

##### <a name="-apache--vhost--fragment--vhost"></a>`vhost`

Data type: `String[1]`

The title of the vhost resource to append to

##### <a name="-apache--vhost--fragment--priority"></a>`priority`

Data type: `Optional[Apache::Vhost::Priority]`

Set the priority to match the one `apache::vhost` sets. This must match the
one `apache::vhost` sets or else the concat fragment won't be found.

Default value: `undef`

##### <a name="-apache--vhost--fragment--content"></a>`content`

Data type: `Optional[String]`

The content to put in the fragment. Only when it's non-empty the actual
fragment will be created.

Default value: `undef`

##### <a name="-apache--vhost--fragment--order"></a>`order`

Data type: `Integer[0]`

The order to insert the fragment at

Default value: `900`

##### <a name="-apache--vhost--fragment--port"></a>`port`

Data type: `Optional[Stdlib::Port]`

The port to use

Default value: `undef`

### <a name="apache--vhost--proxy"></a>`apache::vhost::proxy`

Configure a reverse proxy for a vhost

#### Examples

##### Simple configuration proxying "/" but not "/admin"

```puppet
include apache
apache::vhost { 'basic-proxy-vhost':
}
apache::vhost::proxy { 'proxy-to-backend-server':
  vhost => 'basic-proxy-vhost',
  proxy_dest => 'http://backend-server/',
  no_proxy_uris => '/admin',
}
```

##### Granular configuration using `Apache::Vhost::ProxyPass` data type

```puppet
include apache
apache::vhost { 'myvhost':
}
apache::vhost::proxy { 'myvhost-proxy':
  vhost      => 'myvhost',
  proxy_pass => [
    { 'path' => '/a', 'url' => 'http://backend-a/' },
    { 'path' => '/b', 'url' => 'http://backend-b/' },
    { 'path' => '/c', 'url' => 'http://backend-a/c', 'params' => {'max'=>20, 'ttl'=>120, 'retry'=>300}},
    { 'path' => '/l', 'url' => 'http://backend-xy',
      'reverse_urls' => ['http://backend-x', 'http://backend-y'] },
    { 'path' => '/d', 'url' => 'http://backend-a/d',
      'params' => { 'retry' => 0, 'timeout' => 5 }, },
    { 'path' => '/e', 'url' => 'http://backend-a/e',
      'keywords' => ['nocanon', 'interpolate'] },
    { 'path' => '/f', 'url' => 'http://backend-f/',
      'setenv' => ['proxy-nokeepalive 1', 'force-proxy-request-1.0 1']},
    { 'path' => '/g', 'url' => 'http://backend-g/',
      'reverse_cookies' => [{'path' => '/g', 'url' => 'http://backend-g/',}, {'domain' => 'http://backend-g', 'url' => 'http:://backend-g',},], },
    { 'path' => '/h', 'url' => 'http://backend-h/h',
      'no_proxy_uris' => ['/h/admin', '/h/server-status'] },
  ],
}
```

#### Parameters

The following parameters are available in the `apache::vhost::proxy` defined type:

* [`vhost`](#-apache--vhost--proxy--vhost)
* [`priority`](#-apache--vhost--proxy--priority)
* [`order`](#-apache--vhost--proxy--order)
* [`port`](#-apache--vhost--proxy--port)
* [`proxy_dest`](#-apache--vhost--proxy--proxy_dest)
* [`proxy_dest_match`](#-apache--vhost--proxy--proxy_dest_match)
* [`proxy_dest_reverse_match`](#-apache--vhost--proxy--proxy_dest_reverse_match)
* [`no_proxy_uris`](#-apache--vhost--proxy--no_proxy_uris)
* [`no_proxy_uris_match`](#-apache--vhost--proxy--no_proxy_uris_match)
* [`proxy_pass`](#-apache--vhost--proxy--proxy_pass)
* [`proxy_pass_match`](#-apache--vhost--proxy--proxy_pass_match)
* [`proxy_requests`](#-apache--vhost--proxy--proxy_requests)
* [`proxy_preserve_host`](#-apache--vhost--proxy--proxy_preserve_host)
* [`proxy_add_headers`](#-apache--vhost--proxy--proxy_add_headers)
* [`proxy_error_override`](#-apache--vhost--proxy--proxy_error_override)

##### <a name="-apache--vhost--proxy--vhost"></a>`vhost`

Data type: `String[1]`

The title of the vhost resource to which reverse proxy configuration will
be appended.

##### <a name="-apache--vhost--proxy--priority"></a>`priority`

Data type: `Optional[Apache::Vhost::Priority]`

Set the priority to match the one `apache::vhost` sets. This must match the
one `apache::vhost` sets or else the vhost's `concat` resource won't be found.

Default value: `undef`

##### <a name="-apache--vhost--proxy--order"></a>`order`

Data type: `Integer[0]`

The order in which the `concat::fragment` containing the proxy configuration
will be inserted. Useful when multiple fragments will be attached to a single
vhost's configuration.

Default value: `170`

##### <a name="-apache--vhost--proxy--port"></a>`port`

Data type: `Optional[Stdlib::Port]`

Set the port to match the one `apache::vhost` sets. This must match the one
`apache::vhost` sets or else the vhost's `concat` resource won't be found.

Default value: `undef`

##### <a name="-apache--vhost--proxy--proxy_dest"></a>`proxy_dest`

Data type: `Optional[String[1]]`

Specifies the destination address of a [ProxyPass](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypass) configuration for the `/` path.

Default value: `undef`

##### <a name="-apache--vhost--proxy--proxy_dest_match"></a>`proxy_dest_match`

Data type: `Optional[String[1]]`

This directive is equivalent to `proxy_dest`, but takes regular expressions, see
[ProxyPassMatch](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassmatch)
for details.

Default value: `undef`

##### <a name="-apache--vhost--proxy--proxy_dest_reverse_match"></a>`proxy_dest_reverse_match`

Data type: `Optional[String[1]]`

Allows you to pass a ProxyPassReverse if `proxy_dest_match` is specified. See
[ProxyPassReverse](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassreverse)
for details.

Default value: `undef`

##### <a name="-apache--vhost--proxy--no_proxy_uris"></a>`no_proxy_uris`

Data type: `Variant[Array[String[1]], String[1]]`

Paths to be excluded from reverse proxying. Only valid when already using `proxy_dest`
or `proxy_dest_match` to map the `/` path, otherwise it will be absent in the final
vhost configuration file. In that case, instead add `no_proxy_uris => [uri1, uri2, ...]`
to the `Apache::Vhost::ProxyPass` definitions passed via the `proxy_pass` parameter.
See examples for this class, or refer to documentation for the `Apache::Vhost::ProxyPass`
data type. This configuration uses the [ProxyPass](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypass) directive with `!`.

Default value: `[]`

##### <a name="-apache--vhost--proxy--no_proxy_uris_match"></a>`no_proxy_uris_match`

Data type: `Variant[Array[String[1]], String[1]]`

This directive is equivalent to `no_proxy_uris` but takes regular expressions,
as it instead uses [ProxyPassMatch](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassmatch).

Default value: `[]`

##### <a name="-apache--vhost--proxy--proxy_pass"></a>`proxy_pass`

Data type: `Optional[Array[Apache::Vhost::ProxyPass]]`

Specifies an array of `path => URI` values for a [ProxyPass](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypass)
configuration.
See the documentation for the Apache::Vhost::ProxyPass data type for a detailed
description of the structure including optional parameters.

Default value: `undef`

##### <a name="-apache--vhost--proxy--proxy_pass_match"></a>`proxy_pass_match`

Data type: `Optional[Array[Apache::Vhost::ProxyPass]]`

This directive is equivalent to `proxy_pass`, but takes regular expressions, see
[ProxyPassMatch](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassmatch)
for details.

Default value: `undef`

##### <a name="-apache--vhost--proxy--proxy_requests"></a>`proxy_requests`

Data type: `Boolean`

Enables forward (standard) proxy requests. See [ProxyRequests](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxyrequests) for details.

Default value: `false`

##### <a name="-apache--vhost--proxy--proxy_preserve_host"></a>`proxy_preserve_host`

Data type: `Boolean`

When enabled, pass the `Host:` line from the incoming request to the proxied host.
See [ProxyPreserveHost](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypreservehost) for details.

Default value: `false`

##### <a name="-apache--vhost--proxy--proxy_add_headers"></a>`proxy_add_headers`

Data type: `Optional[Boolean]`

Add X-Forwarded-For, X-Forwarded-Host, and X-Forwarded-Server HTTP headers.
See [ProxyAddHeaders](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxyaddheaders) for details.

Default value: `undef`

##### <a name="-apache--vhost--proxy--proxy_error_override"></a>`proxy_error_override`

Data type: `Boolean`

Override error pages from the proxied host. The current Puppet implementation
supports enabling or disabling the directive, but not specifying a custom list
of status codes. See [ProxyErrorOverride](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxyerroroverride) for details.

Default value: `false`

## Functions

### <a name="apache--apache_pw_hash"></a>`apache::apache_pw_hash`

Type: Ruby 4.x API

DEPRECATED.  Use the function [`apache::pw_hash`](#apachepw_hash) instead.

#### `apache::apache_pw_hash(Any *$args)`

The apache::apache_pw_hash function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="apache--authz_core_config"></a>`apache::authz_core_config`

Type: Ruby 4.x API

Function to generate the authz_core configuration directives.

#### Examples

##### 

```puppet

arg = {
  require_all => {
   'require_any' => {
     'require' => ['user superadmin'],
     'require_all' => {
       'require' => ['group admins'],
     },
    },
   'require_none' => {
     'require' => ['group temps']
   }
  }
}

apache::bool2httpd(arg)
returns :
[
  "  <RequireAll>",
  "    <RequireAny>",
  "      Require user superadmin",
  "      <RequireAll>",
  "        Require group admins",
  "        Require ldap-group \"cn=Administrators,o=Airius\"",
  "      </RequireAll>",
  "    </RequireAny>",
  "    <RequireNone>",
  "      Require group temps",
  "      Require ldap-group \"cn=Temporary Employees,o=Airius\"",
  "    </RequireNone>",
  "  </RequireAll>"
]
```

#### `apache::authz_core_config(Hash $config)`

The apache::authz_core_config function.

Returns: `Array` Returns the authz_core config directives in array.

##### Examples

###### 

```puppet

arg = {
  require_all => {
   'require_any' => {
     'require' => ['user superadmin'],
     'require_all' => {
       'require' => ['group admins'],
     },
    },
   'require_none' => {
     'require' => ['group temps']
   }
  }
}

apache::bool2httpd(arg)
returns :
[
  "  <RequireAll>",
  "    <RequireAny>",
  "      Require user superadmin",
  "      <RequireAll>",
  "        Require group admins",
  "        Require ldap-group \"cn=Administrators,o=Airius\"",
  "      </RequireAll>",
  "    </RequireAny>",
  "    <RequireNone>",
  "      Require group temps",
  "      Require ldap-group \"cn=Temporary Employees,o=Airius\"",
  "    </RequireNone>",
  "  </RequireAll>"
]
```

##### `config`

Data type: `Hash`

The input as JSON format.

### <a name="apache--bool2httpd"></a>`apache::bool2httpd`

Type: Ruby 4.x API

Transform a supposed boolean to On or Off. Passes all other values through.

#### Examples

##### 

```puppet
$trace_enable     = false
$server_signature = 'mail'

apache::bool2httpd($trace_enable) # returns 'Off'
apache::bool2httpd($server_signature) # returns 'mail'
apache::bool2httpd(undef) # returns 'Off'
```

#### `apache::bool2httpd(Any $arg)`

The apache::bool2httpd function.

Returns: `Any` Will return either `On` or `Off` if given a boolean value. Returns a string of any
other given value.

##### Examples

###### 

```puppet
$trace_enable     = false
$server_signature = 'mail'

apache::bool2httpd($trace_enable) # returns 'Off'
apache::bool2httpd($server_signature) # returns 'mail'
apache::bool2httpd(undef) # returns 'Off'
```

##### `arg`

Data type: `Any`

The value to be converted into a string.

### <a name="apache--pw_hash"></a>`apache::pw_hash`

Type: Ruby 4.x API

Currently uses SHA-hashes, because although this format is considered insecure, it's the
most secure format supported by the most platforms.

#### `apache::pw_hash(String[1] $password)`

Currently uses SHA-hashes, because although this format is considered insecure, it's the
most secure format supported by the most platforms.

Returns: `String` Returns the hash of the input that was given.

##### `password`

Data type: `String[1]`

The input that is to be hashed.

### <a name="apache_pw_hash"></a>`apache_pw_hash`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`apache::pw_hash`](#apachepw_hash) instead.

#### `apache_pw_hash(Any *$args)`

The apache_pw_hash function.

Returns: `Any`

##### `*args`

Data type: `Any`



### <a name="bool2httpd"></a>`bool2httpd`

Type: Ruby 4.x API

DEPRECATED.  Use the namespaced function [`apache::bool2httpd`](#apachebool2httpd) instead.

#### `bool2httpd(Any *$args)`

The bool2httpd function.

Returns: `Any`

##### `*args`

Data type: `Any`



## Data types

### <a name="Apache--LogLevel"></a>`Apache::LogLevel`

A string that conforms to the Apache `LogLevel` syntax.
Different levels can be specified for individual apache modules.

ie. `[module:]level [module:level] ...`

The levels are (in order of decreasing significance):
* `emerg`
* `alert`
* `crit`
* `error`
* `warn`
* `notice`
* `info`
* `debug`
* `trace1`
* `trace2`
* `trace3`
* `trace4`
* `trace5`
* `trace6`
* `trace7`
* `trace8`

* **See also**
  * https://httpd.apache.org/docs/current/mod/core.html#loglevel

Alias of `Pattern[/\A([a-z_\.]+:)?(emerg|alert|crit|error|warn|notice|info|debug|trace[1-8])(\s+([a-z_\.]+:)?(emerg|alert|crit|error|warn|notice|info|debug|trace[1-8]))*\Z/]`

### <a name="Apache--ModProxyProtocol"></a>`Apache::ModProxyProtocol`

Supported protocols / schemes by mod_proxy

* **See also**
  * https://httpd.apache.org/docs/2.4/mod/mod_proxy.html

Alias of `Pattern[/(\A(ajp|fcgi|ftp|h2c?|https?|scgi|uwsgi|wss?):\/\/.+\z)/, /(\Aunix:\/([^\n\/\0]+\/*)*\z)/]`

### <a name="Apache--OIDCSettings"></a>`Apache::OIDCSettings`

https://github.com/zmartzone/mod_auth_openidc/blob/master/auth_openidc.conf

Alias of

```puppet
Struct[{
    Optional['RedirectURI']                             => Variant[Stdlib::HTTPSUrl, Stdlib::HttpUrl, Pattern[/^\/[A-Za-z0-9\-\._%\/]*$/]],
    Optional['CryptoPassphrase']                        => String,
    Optional['MetadataDir']                             => String,
    Optional['ProviderMetadataURL']                     => Stdlib::HTTPSUrl,
    Optional['ProviderIssuer']                          => String,
    Optional['ProviderAuthorizationEndpoint']           => Stdlib::HTTPSUrl,
    Optional['ProviderJwksUri']                         => Stdlib::HTTPSUrl,
    Optional['ProviderTokenEndpoint']                   => Stdlib::HTTPSUrl,
    Optional['ProviderTokenEndpointAuth']               => Enum['client_secret_basic', 'client_secret_post', 'client_secret_jwt', 'private_key_jwt', 'none'],
    Optional['ProviderTokenEndpointParams']             => Pattern[/^[A-Za-z0-9\-\._%]+=[A-Za-z0-9\-\._%]+(&[A-Za-z0-9\-\._%]+=[A-Za-z0-9\-\._%]+)*$/],
    Optional['ProviderUserInfoEndpoint']                => Stdlib::HTTPSUrl,
    Optional['ProviderCheckSessionIFrame']              => Stdlib::HTTPSUrl,
    Optional['ProviderEndSessionEndpoint']              => Stdlib::HTTPSUrl,
    Optional['ProviderRevocationEndpoint']              => Stdlib::HTTPSUrl,
    Optional['ProviderBackChannelLogoutSupported']      => Enum['On', 'Off'],
    Optional['ProviderRegistrationEndpointJson']        => String,
    Optional['Scope']                                   => Pattern[/^\"?[A-Za-z0-9\-\._\s]+\"?$/],
    Optional['AuthRequestParams']                       => Pattern[/^[A-Za-z0-9\-\._%]+=[A-Za-z0-9\-\._%]+(&[A-Za-z0-9\-\._%]+=[A-Za-z0-9\-\._%]+)*$/],
    Optional['SSLValidateServer']                       => Enum['On', 'Off'],
    Optional['UserInfoRefreshInterval']                 => Integer,
    Optional['JWKSRefreshInterval']                     => Integer,
    Optional['UserInfoTokenMethod']                     => Enum['authz_header', 'post_param'],
    Optional['ProviderAuthRequestMethod']               => Enum['GET', 'POST'],
    Optional['PublicKeyFiles']                          => String,
    Optional['ResponseType']                            => Enum['code', 'id_token', 'id_token token', 'code id_token', 'code token', 'code id_token token'],
    Optional['ResponseMode']                            => Enum['fragment', 'query', 'form_post'],
    Optional['ClientID']                                => String,
    Optional['ClientSecret']                            => String,
    Optional['ClientTokenEndpointCert']                 => String,
    Optional['ClientTokenEndpointKey']                  => String,
    Optional['ClientName']                              => String,
    Optional['ClientContact']                           => String,
    Optional['PKCDMethod']                              => Enum['plain', 'S256', 'referred_tb'],
    Optional['TokenBindingPolicy']                      => Enum['disabled', 'optional', 'required', 'enforced'],
    Optional['ClientJwksUri']                           => Stdlib::HTTPSUrl,
    Optional['IDTokenSignedResponseAlg']                => Enum['RS256', 'RS384', 'RS512', 'PS256', 'PS384', 'PS512', 'HS256', 'HS384', 'HS512', 'ES256', 'ES384', 'ES512'],
    Optional['IDTokenEncryptedResponseAlg']             => Enum['RSA1_5', 'A128KW', 'A256KW', 'RSA-OAEP'],
    Optional['IDTokenEncryptedResponseAlg']             => Enum['A128CBC-HS256', 'A256CBC-HS512', 'A256GCM'],
    Optional['UserInfoSignedResposeAlg']                => Enum['RS256', 'RS384', 'RS512', 'PS256', 'PS384', 'PS512', 'HS256', 'HS384', 'HS512', 'ES256', 'ES384', 'ES512'],
    Optional['UserInfoEncryptedResponseAlg']            => Enum['RSA1_5', 'A128KW', 'A256KW', 'RSA-OAEP'],
    Optional['UserInfoEncryptedResponseEnc']            => Enum['A128CBC-HS256', 'A256CBC-HS512', 'A256GCM'],
    Optional['OAuthServerMetadataURL']                  => Stdlib::HTTPSUrl,
    Optional['AuthIntrospectionEndpoint']               => Stdlib::HTTPSUrl,
    Optional['OAuthClientID']                           => String,
    Optional['OAuthClientSecret']                       => String,
    Optional['OAuthIntrospectionEndpointAuth']          => Enum['client_secret_basic', 'client_secret_post', 'client_secret_jwt', 'private_key_jwt', 'bearer_access_token', 'none'],
    Optional['OAuthIntrospectionClientAuthBearerToken'] => String,
    Optional['OAuthIntrospectionEndpointCert']          => String,
    Optional['OAuthIntrospectionEndpointKey']           => String,
    Optional['OAuthIntrospectionEndpointMethod']        => Enum['POST', 'GET'],
    Optional['OAuthIntrospectionEndpointParams']        => Pattern[/^[A-Za-z0-9\-\._%]+=[A-Za-z0-9\-\._%]+(&[A-Za-z0-9\-\._%]+=[A-Za-z0-9\-\._%]+)*$/],
    Optional['OAuthIntrospectionTokenParamName']        => String,
    Optional['OAuthTokenExpiryClaim']                   => Pattern[/^[A-Za-z0-9\-\._]+\s(absolute|relative)\s(mandatory|optional)$/],
    Optional['OAuthSSLValidateServer']                  => Enum['On', 'Off'],
    Optional['OAuthVerifySharedKeys']                   => String,
    Optional['OAuthVerifyCertFiles']                    => String,
    Optional['OAuthVerifyJwksUri']                      => Stdlib::HTTPSUrl,
    Optional['OAuthRemoteUserClaim']                    => String,
    Optional['OAuthAcceptTokenAs']                      => Pattern[/^((header|post|query|cookie\:[A-Za-z0-9\-\._]+|basic)\s?)+$/],
    Optional['OAuthAccessTokenBindingPolicy']           => Enum['disabled', 'optional', 'required', 'enforced'],
    Optional['Cookie']                                  => String,
    Optional['SessionCookieChunkSize']                  => Integer,
    Optional['CookieHTTPOnly']                          => Enum['On', 'Off'],
    Optional['CookieSameSite']                          => Enum['On', 'Off'],
    Optional['PassCookies']                             => String,
    Optional['StripCookies']                            => String,
    Optional['StateMaxNumberOfCookies']                 => Pattern[/^[0-9]+\s(false|true)$/],
    Optional['SessionInactivityTimeout']                => Integer,
    Optional['SessionMaxDuration']                      => Integer,
    Optional['SessionType']                             => Pattern[/^(server-cache(:persistent)?|client-cookie(:persistent)?)$/],
    Optional['SessionCacheFallbackToCookie']            => Enum['On', 'Off'],
    Optional['CacheType']                               => Enum['shm', 'memcache', 'file', 'redis'],
    Optional['CacheEncrypt']                            => Enum['On', 'Off'],
    Optional['CacheShmMax']                             => Integer,
    Optional['CacheShmEntrySizeMax']                    => Integer,
    Optional['CacheFileCleanInterval']                  => Integer,
    Optional['MemCacheServers']                         => String,
    Optional['RedisCacheServer']                        => String,
    Optional['RedisCachePassword']                      => String,
    Optional['DiscoverURL']                             => Variant[Stdlib::HTTPSUrl, Stdlib::HttpUrl],
    Optional['HTMLErrorTemplate']                       => String,
    Optional['DefaultURL']                              => Variant[Stdlib::HTTPSUrl, Stdlib::HttpUrl],
    Optional['PathScope']                               => Pattern[/^\"?[A-Za-z0-9\-\._\s]+\"?$/],
    Optional['PathAuthRequestParams']                   => Pattern[/^[A-Za-z0-9\-\._%]+=[A-Za-z0-9\-\._%]+(&[A-Za-z0-9\-\._%]+=[A-Za-z0-9\-\._%]+)*$/],
    Optional['IDTokenIatSlack']                         => Integer,
    Optional['ClaimPrefix']                             => String,
    Optional['ClaimDelimiter']                          => Pattern[/^.$/],
    Optional['RemoteUserClaim']                         => String,
    Optional['PassIDTokenAs']                           => Pattern[/^((claims|payload|serialized)\s?)+$/],
    Optional['PassUserInfoAs']                          => Pattern[/^((claims|json|jwt)\s?)+$/],
    Optional['PassClaimsAs']                            => Enum['none', 'headers', 'environment', 'both'],
    Optional['AuthNHeader']                             => String,
    Optional['HTTPTimeoutLong']                         => Integer,
    Optional['HTTPTimeoutShort']                        => Integer,
    Optional['StateTimeout']                            => Integer,
    Optional['ScrubRequestHeaders']                     => Enum['On', 'Off'],
    Optional['OutgoingProxy']                           => String,
    Optional['UnAuthAction']                            => Enum['auth', 'pass', '401', '410'],
    Optional['UnAuthzAction']                           => Enum['401', '403', 'auth'],
    Optional['PreservePost']                            => Enum['On', 'Off'],
    Optional['PassRefreshToken']                        => Enum['On', 'Off'],
    Optional['RequestObject']                           => String,
    Optional['ProviderMetadataRefreshInterval']         => Integer,
    Optional['InfoHook']                                => Pattern[/^((iat|access_token|access_token_expires|id_token|userinfo|refresh_token|session)\s?)+$/],
    Optional['BlackListedClaims']                       => String,
    Optional['WhiteListedClaims']                       => String,
    Optional['RefreshAccessTokenBeforeExpiry']          => Pattern[/^[0-9]+(\slogout_on_error)?$/],
  }]
```

### <a name="Apache--OnOff"></a>`Apache::OnOff`

A string that is accepted in Apache config to turn something on or off

Alias of `Enum['On', 'on', 'Off', 'off']`

### <a name="Apache--ServerTokens"></a>`Apache::ServerTokens`

A string that conforms to the Apache `ServerTokens` syntax.

* **See also**
  * https://httpd.apache.org/docs/2.4/mod/core.html#servertokens

Alias of `Enum['Major', 'Minor', 'Min', 'Minimal', 'Prod', 'ProductOnly', 'OS', 'Full']`

### <a name="Apache--Vhost--Priority"></a>`Apache::Vhost::Priority`

The priority on vhost

Alias of `Variant[Pattern[/^\d+$/], Integer, Boolean]`

### <a name="Apache--Vhost--ProxyPass"></a>`Apache::Vhost::ProxyPass`

host context. Because the implementation uses SetEnv, you must `include apache::mod::env`;
for the same reason, this cannot set the newer `no-proxy` environment variable, which
would require an implementation using SetEnvIf.

* **See also**
  * https://httpd.apache.org/docs/current/mod/mod_proxy.html
  * for additional documentation.

#### Examples

##### Basic example

```puppet
{ 'path' => '/a', 'url' => 'http://backend-a/', }
```

##### With parameters

```puppet
{ 'path' => '/b', 'url' => 'http://backend-a/b',
  'params' => {'max'=>20, 'ttl'=>120, 'retry'=>300,}, }
```

##### With ProxyPassReverse

```puppet
{ 'path' => '/l', 'url' => 'http://backend-xy',
  'reverse_urls' => ['http://backend-x', 'http://backend-y'], }
```

##### With additional keywords

```puppet
{ 'path' => '/e', 'url' => 'http://backend-a/e',
  'keywords' => ['nocanon', 'interpolate'], }
```

##### With mod_proxy environment variables

```puppet
{ 'path' => '/f', 'url' => 'http://backend-f/',
  'setenv' => ['proxy-nokeepalive 1', 'force-proxy-request-1.0 1'], }
```

##### With ProxyPassReverseCookieDomain and ProxyPassReverseCookiePath

```puppet
{ 'path' => '/g', 'url' => 'http://backend-g/',
  'reverse_cookies' => [{'path' => '/g', 'url' => 'http://backend-g/',}, {'domain' => 'http://backend-g', 'url' => 'http:://backend-g',}], }
```

##### With exclusions

```puppet
{ 'path' => '/h', 'url' => 'http://backend-h/h',
  'no_proxy_uris' => ['/h/admin', '/h/server-status'], }
```

Alias of

```puppet
Struct[{
    path                          => String[1],
    url                           => String[1],
    Optional[params]              => Hash[String[1], Variant[String[1], Integer]],
    Optional[keywords]            => Array[String[1]],
    Optional[reverse_cookies]     => Array[
      Struct[
        {
          url    => String[1],
          path   => Optional[String[1]],
          domain => Optional[String[1]],
        }
      ]
    ],
    Optional[reverse_urls]        => Array[String[1]],
    Optional[setenv]              => Array[String[1]],
    Optional[no_proxy_uris]       => Array[String[1]],
    Optional[no_proxy_uris_match] => Array[String[1]],
  }]
```

#### Parameters

The following parameters are available in the `Apache::Vhost::ProxyPass` data type:

* [`path`](#-Apache--Vhost--ProxyPass--path)
* [`url`](#-Apache--Vhost--ProxyPass--url)
* [`params`](#-Apache--Vhost--ProxyPass--params)
* [`reverse_urls`](#-Apache--Vhost--ProxyPass--reverse_urls)
* [`reverse_cookies`](#-Apache--Vhost--ProxyPass--reverse_cookies)
* [`keywords`](#-Apache--Vhost--ProxyPass--keywords)
* [`setenv`](#-Apache--Vhost--ProxyPass--setenv)
* [`no_proxy_uris`](#-Apache--Vhost--ProxyPass--no_proxy_uris)
* [`no_proxy_uris_match`](#-Apache--Vhost--ProxyPass--no_proxy_uris_match)

##### <a name="-Apache--Vhost--ProxyPass--path"></a>`path`

Data type: `String[1]`

The virtual path on the local server to map.

##### <a name="-Apache--Vhost--ProxyPass--url"></a>`url`

Data type: `String[1]`

The URL to which the path and its children will be mapped.

##### <a name="-Apache--Vhost--ProxyPass--params"></a>`params`

Data type: `Optional[Hash]`

Optional [ProxyPass](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypass) key-value parameters, such as connection settings.

##### <a name="-Apache--Vhost--ProxyPass--reverse_urls"></a>`reverse_urls`

Data type: `Array[String[1]]`

Optional (but usually recommended) URLs for [ProxyPassReverse](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassreverse) configuration.
Allows Apache to adjust certain headers on HTTP redirect responses, to prevent
redirects on the back-end from bypassing the reverse proxy.

##### <a name="-Apache--Vhost--ProxyPass--reverse_cookies"></a>`reverse_cookies`

Data type: `Optional[Array[Hash]]`

Optional Array of Hashes, each representing a ProxyPassReverseCookieDomain or
ProxyPassReverseCookiePath configuration. These are similar to ProxyPassReverse but
operate on Domain or Path strings respectively in Set-Cookie headers. Each Hash
must contain one `url => value` pair, and exactly one `path => value` or `domain => value`
pair, representing the internal domain or internal path.

Options:

* **:url** `String[1]`: Required partial URL representing public domain or public path.
* **:path** `Optional[String[1]]`: Internal path for [ProxyPassReverseCookiePath](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassreversecookiepath) configuration.
* **:domain** `Optional[String[1]]`: Internal domain for [ProxyPassReverseCookieDomain](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassreversecookiedomain) configuration.

##### <a name="-Apache--Vhost--ProxyPass--keywords"></a>`keywords`

Data type: `Optional[Array[String[1]]]`

Array of optional keywords such as `nocanon`, `interpolate`, or `noquery` supported
by [ProxyPass](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypass) (refer
to subsection under heading "Additional ProxyPass Keywords").

##### <a name="-Apache--Vhost--ProxyPass--setenv"></a>`setenv`

Data type: `Optional[Array[String[1]]]`

Optional Array of Strings of the form "${env_var_name} ${value}".
Uses [SetEnv](https://httpd.apache.org/docs/current/mod/mod_env.html#setenv) to make [Protocol Adjustments](https://httpd.apache.org/docs/current/mod/mod_proxy.html#envsettings) to mod_proxy in the virtual

##### <a name="-Apache--Vhost--ProxyPass--no_proxy_uris"></a>`no_proxy_uris`

Data type: `Optional[Array[String[1]]]`

Optional Array of paths to exclude from proxying, using the `!` directive to [ProxyPass](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypass).

##### <a name="-Apache--Vhost--ProxyPass--no_proxy_uris_match"></a>`no_proxy_uris_match`

Data type: `Optional[Array[String[1]]]`

Similar to `no_proxy_uris` but uses [ProxyPassMatch](https://httpd.apache.org/docs/current/mod/mod_proxy.html#proxypassmatch) to allow regular
expressions.

## Tasks

### <a name="init"></a>`init`

Allows you to perform apache service functions

**Supports noop?** false

#### Parameters

##### `action`

Data type: `Enum[reload]`

Action to perform 

##### `service_name`

Data type: `Optional[String[1]]`

The name of the apache service 

