/*
 * @BEGIN LICENSE
 *
 * Psi4: an open-source quantum chemistry software package
 *
 * Copyright (c) 2007-2019 The Psi4 Developers.
 *
 * The copyrights for code used from other parties are included in
 * the corresponding files.
 *
 * This file is part of Psi4.
 *
 * Psi4 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, version 3.
 *
 * Psi4 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along
 * with Psi4; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * @END LICENSE
 */

#pragma once

#include "psi4/pybind11.h"
#include "psi4/pragma.h"

#include "psi4/liboptions/liboptions.h"

namespace psi {

class PythonDataType : public DataType {
    py::object python_object_;

   public:
    PythonDataType();
    PythonDataType(const py::object& p);
    ~PythonDataType() override;

    std::string type() const override;

    const py::object& to_python() const;

    PRAGMA_WARNING_PUSH
    PRAGMA_WARNING_IGNORE_OVERLOADED_VIRTUAL
    void assign(const py::object& p);
    PRAGMA_WARNING_POP
};

}  // namespace psi
