/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import weka.classifiers.UpdateableClassifier;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.Classifier;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;
import weka.gui.beans.Messages;

public class ClassifierCustomizer
extends JPanel
implements Customizer,
CustomizerClosingListener,
CustomizerCloseRequester {
    private static final long serialVersionUID = -6688000820160821429L;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private Classifier m_dsClassifier;
    private PropertySheetPanel m_ClassifierEditor = new PropertySheetPanel();
    private JPanel m_incrementalPanel = new JPanel();
    private JCheckBox m_updateIncrementalClassifier;
    private boolean m_panelVisible;
    private JPanel m_holderPanel;
    private JTextField m_executionSlotsText;
    private JFrame m_parentFrame;
    protected weka.classifiers.Classifier m_backup;

    public ClassifierCustomizer() {
        Messages.getInstance();
        this.m_updateIncrementalClassifier = new JCheckBox(Messages.getString("ClassifierCustomizer_UpdateIncrementalClassifier_JCheckBox_Text"));
        this.m_panelVisible = false;
        this.m_holderPanel = new JPanel();
        this.m_executionSlotsText = new JTextField();
        Messages.getInstance();
        this.m_ClassifierEditor.setBorder(BorderFactory.createTitledBorder(Messages.getString("ClassifierCustomizer_ClassifierEditor_SetBorder_BorderFactory_CreateTitledBorder_Text")));
        Messages.getInstance();
        this.m_updateIncrementalClassifier.setToolTipText(Messages.getString("ClassifierCustomizer_UpdateIncrementalClassifier_SetToolTipText_Text"));
        this.m_updateIncrementalClassifier.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassifierCustomizer.this.m_dsClassifier != null) {
                    ClassifierCustomizer.this.m_dsClassifier.setUpdateIncrementalClassifier(ClassifierCustomizer.this.m_updateIncrementalClassifier.isSelected());
                }
            }
        });
        this.m_incrementalPanel.add(this.m_updateIncrementalClassifier);
        this.m_executionSlotsText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassifierCustomizer.this.m_dsClassifier != null && ClassifierCustomizer.this.m_executionSlotsText.getText().length() > 0) {
                    int newSlots = Integer.parseInt(ClassifierCustomizer.this.m_executionSlotsText.getText());
                    ClassifierCustomizer.this.m_dsClassifier.setExecutionSlots(newSlots);
                }
            }
        });
        this.m_executionSlotsText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ClassifierCustomizer.this.m_dsClassifier != null && ClassifierCustomizer.this.m_executionSlotsText.getText().length() > 0) {
                    int newSlots = Integer.parseInt(ClassifierCustomizer.this.m_executionSlotsText.getText());
                    ClassifierCustomizer.this.m_dsClassifier.setExecutionSlots(newSlots);
                }
            }
        });
        JPanel executionSlotsPanel = new JPanel();
        executionSlotsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Messages.getInstance();
        JLabel executionSlotsLabel = new JLabel(Messages.getString("ClassifierCustomizer_ExecutionSlotsLabel_JLabel_Text"));
        executionSlotsPanel.setLayout(new BorderLayout());
        executionSlotsPanel.add((Component)executionSlotsLabel, "West");
        executionSlotsPanel.add((Component)this.m_executionSlotsText, "Center");
        Messages.getInstance();
        this.m_holderPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ClassifierCustomizer_HolderPanel_SetBorder_BorderFactory_CreateTitledBorder_Text")));
        this.m_holderPanel.setLayout(new BorderLayout());
        this.m_holderPanel.add((Component)executionSlotsPanel, "North");
        JPanel holder2 = new JPanel();
        holder2.setLayout(new BorderLayout());
        holder2.add((Component)this.m_holderPanel, "North");
        Messages.getInstance();
        JButton OKBut = new JButton(Messages.getString("ClassifierCustomizer_OKBut_JButton_Text"));
        Messages.getInstance();
        JButton CancelBut = new JButton(Messages.getString("ClassifierCustomizer_CancelBut_JButton_Text"));
        OKBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierCustomizer.this.m_parentFrame.dispose();
            }
        });
        CancelBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassifierCustomizer.this.m_backup != null) {
                    ClassifierCustomizer.this.m_dsClassifier.setClassifierTemplate(ClassifierCustomizer.this.m_backup);
                }
                ClassifierCustomizer.this.m_parentFrame.dispose();
            }
        });
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(OKBut);
        butHolder.add(CancelBut);
        holder2.add((Component)butHolder, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_ClassifierEditor, "Center");
        this.add((Component)holder2, "South");
    }

    private void checkOnClassifierType() {
        weka.classifiers.Classifier editedC = this.m_dsClassifier.getClassifierTemplate();
        if (editedC instanceof UpdateableClassifier && this.m_dsClassifier.hasIncomingStreamInstances()) {
            if (!this.m_panelVisible) {
                this.m_holderPanel.add((Component)this.m_incrementalPanel, "South");
                this.m_panelVisible = true;
                this.m_executionSlotsText.setEnabled(false);
            }
        } else if (this.m_panelVisible) {
            this.m_holderPanel.remove(this.m_incrementalPanel);
            this.m_executionSlotsText.setEnabled(true);
            this.m_panelVisible = false;
        }
    }

    public void setObject(Object object) {
        this.m_dsClassifier = (Classifier)object;
        try {
            this.m_backup = (weka.classifiers.Classifier)GenericObjectEditor.makeCopy(this.m_dsClassifier.getClassifierTemplate());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_ClassifierEditor.setTarget(this.m_dsClassifier.getClassifierTemplate());
        this.m_updateIncrementalClassifier.setSelected(this.m_dsClassifier.getUpdateIncrementalClassifier());
        this.m_executionSlotsText.setText("" + this.m_dsClassifier.getExecutionSlots());
        this.checkOnClassifierType();
    }

    public void customizerClosing() {
        if (this.m_executionSlotsText.getText().length() > 0) {
            int newSlots = Integer.parseInt(this.m_executionSlotsText.getText());
            this.m_dsClassifier.setExecutionSlots(newSlots);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }

    public void setParentFrame(JFrame parent) {
        this.m_parentFrame = parent;
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

