------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--               PORTABLEINTERCEPTOR.IORINTERCEPTOR_3_0.IMPL                --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--         Copyright (C) 2004-2012, Free Software Foundation, Inc.          --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.                                               --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with PortableInterceptor.Interceptor;

package body PortableInterceptor.IORInterceptor_3_0.Impl is

   -----------------------------------
   -- Adapter_Manager_State_Changed --
   -----------------------------------

   procedure Adapter_Manager_State_Changed
     (Self  : access Object;
      Id    : AdapterManagerId;
      State : AdapterState)
   is
      pragma Unreferenced (Self);
      pragma Unreferenced (Id);
      pragma Unreferenced (State);
   begin
      null;
   end Adapter_Manager_State_Changed;

--   ---------------------------
--   -- Adapter_State_Changed --
--   ---------------------------
--
--   procedure Adapter_State_Changed
--     (Self      : access Object;
--      Templates : ObjectReferenceTemplate.Abstract_Value_Ref;
--      State     : AdapterState)
--   is
--      pragma Unreferenced (Self);
--      pragma Unreferenced (Templates);
--      pragma Unreferenced (State);
--   begin
--      null;
--   end Adapter_State_Changed;

   ----------------------------
   -- Components_Established --
   ----------------------------

   procedure Components_Established
     (Self : access Object;
      Info : PortableInterceptor.IORInfo.Local_Ref)
   is
      pragma Unreferenced (Self);
      pragma Unreferenced (Info);
   begin
      null;
   end Components_Established;

   ----------
   -- Is_A --
   ----------

   function Is_A
     (Self            : not null access Object;
      Logical_Type_Id : Standard.String) return Boolean
   is
      pragma Unreferenced (Self);
   begin
      return CORBA.Is_Equivalent
        (Logical_Type_Id, PortableInterceptor.IORInterceptor_3_0.Repository_Id)
        or else CORBA.Is_Equivalent
           (Logical_Type_Id, PortableInterceptor.IORInterceptor.Repository_Id)
        or else CORBA.Is_Equivalent
           (Logical_Type_Id, PortableInterceptor.Interceptor.Repository_Id)
        or else CORBA.Is_Equivalent
          (Logical_Type_Id, "IDL:omg.org/CORBA/Object:1.0");
   end Is_A;

end PortableInterceptor.IORInterceptor_3_0.Impl;
