/***************************************************************************
 *   Copyright (C) 2009 by Mathias Rabe <masterunderlined [at] web.de>     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/
#ifndef URLGENERATOR_H
#define URLGENERATOR_H

#include <KUrl>

class UrlGenerator : public QObject
{
    Q_OBJECT
    public:
        UrlGenerator();
        ~UrlGenerator();

        QString dummyUrl();
        QStringList generateUrlList(const QStringList &urlList);

    private:
        void usableUrl();
        void generateDummyUrl();

    public slots:
        void setProtocol(const QString &newProtocol);
        void setUrl(const KUrl &newUrl);
        void setUrl(const QString &newUrl);
        void setSyntax(const QString &newSuffix);

    signals:
        void dummyUrlGenerated(QString newUrl);

    private:
        QString protocol;
        KUrl url;
        QString syntax;
        QString newUrl;
};

#endif
