/* ColorEdit widget for KDE Display color scheme setup module
 * Copyright (C) 2016 Olivier Churlaud <olivier@churlaud.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __SCMEDITORDIALOG_H__
#define __SCMEDITORDIALOG_H__

#include <KColorScheme>
#include <KSharedConfig>

#include <QFrame>
#include <QPalette>
#include <QDialog>

#include "ui_scmeditordialog.h"

class SchemeEditorOptions;
class SchemeEditorColors;
class SchemeEditorEffects;
class KColorCm;

class SchemeEditorDialog : public QDialog, public Ui::ScmEditorDialog
{
    Q_OBJECT

public:
    SchemeEditorDialog(const QString &path, KColorCm *parent = Q_NULLPTR);
    SchemeEditorDialog(KSharedConfigPtr config, KColorCm *parent = Q_NULLPTR);

Q_SIGNALS:
    void changed(bool);
    void applied();

private Q_SLOTS:

    /** slot called when the upload scheme button is clicked */
    void on_schemeKnsUploadButton_clicked();

    void on_buttonBox_clicked(QAbstractButton *button);

    void updateTabs(bool byUser=false);

private:
    void init();
    void applyScheme();
    /** save the current scheme */
    void saveScheme();
    void setUnsavedChanges(bool changes);

    const QString m_filePath;
    QString m_schemeName;
    KSharedConfigPtr m_config;
    bool m_disableUpdates;
    bool m_unsavedChanges;

    SchemeEditorOptions *m_optionTab;
    SchemeEditorColors *m_colorTab;
    SchemeEditorEffects *m_disabledTab;
    SchemeEditorEffects *m_inactiveTab;
    KColorCm *m_kcm;
};

#endif
