/*	test_Streams

PIRL CVS ID: test_Streams.java,v 1.4 2012/04/16 06:18:24 castalia Exp

Copyright (C) 2006-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Utilities.Streams;

import	java.io.InputStream;


public class test_Streams
{

public static void main
	(
	String[] arguments
	)
{
System.out.println
	("*** test_Streams: " + Streams.ID);

InputStream
	stream = null;
try
	{
	System.out.println ("--- Streams.Get_Stream (\"test_Streams.java\")");
	stream = Streams.Get_Stream ("test_Streams.java");
	if (stream == null)
		System.out.println ("!!! FAIL");
	else
		System.out.println ("*** PASS");

	System.out.println
		("--- Streams.Get_Stream (\"ftp://pirlftp.lpl.arizona.edu/pub/Java/PIRL.tar.gz\")");
	stream = Streams.Get_Stream ("ftp://pirlftp.lpl.arizona.edu/pub/Java/PIRL.tar.gz");
	if (stream == null)
		System.out.println ("!!! FAIL");
	else
		System.out.println ("*** PASS");

	System.out.println ("--- Streams.Get_Stream (\"no_such_file\")");
	stream = Streams.Get_Stream ("no_such_file");
	if (stream == null)
		System.out.println ("*** PASS");
	else
		System.out.println ("!!! FAIL");

	}
catch (Exception exception)
	{
	System.out.println
		("\n"
		+"Exception: " + exception + '\n'
		+"    " + exception.getMessage ());
	}
}

}
