##########################################################################
##                                                                      ##
## Copyright (C) 2011-2025 Lukas Spies                                  ##
## Contact: https://photoqt.org                                         ##
##                                                                      ##
## This file is part of PhotoQt.                                        ##
##                                                                      ##
## PhotoQt is free software: you can redistribute it and/or modify      ##
## it under the terms of the GNU General Public License as published by ##
## the Free Software Foundation, either version 2 of the License, or    ##
## (at your option) any later version.                                  ##
##                                                                      ##
## PhotoQt is distributed in the hope that it will be useful,           ##
## but WITHOUT ANY WARRANTY; without even the implied warranty of       ##
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        ##
## GNU General Public License for more details.                         ##
##                                                                      ##
## You should have received a copy of the GNU General Public License    ##
## along with PhotoQt. If not, see <http://www.gnu.org/licenses/>.      ##
##                                                                      ##
##########################################################################

import numpy as np
import sys
import sqlite3

import os

def get():

    conn = sqlite3.connect('../defaultsettings.db')

    dbtables = ['filedialog',
            'filetypes',
            'general',
            'imageview',
            'interface',
            'mainmenu',
            'mapview',
            'metadata',
            'slideshow',
            'thumbnails']

    cont_SOURCE = """/**************************************************************************
**                                                                      **
** Copyright (C) 2011-2025 Lukas Spies                                  **
** Contact: https://photoqt.org                                         **
**                                                                      **
** This file is part of PhotoQt.                                        **
**                                                                      **
** PhotoQt is free software: you can redistribute it and/or modify      **
** it under the terms of the GNU General Public License as published by **
** the Free Software Foundation, either version 2 of the License, or    **
** (at your option) any later version.                                  **
**                                                                      **
** PhotoQt is distributed in the hope that it will be useful,           **
** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with PhotoQt. If not, see <http://www.gnu.org/licenses/>.      **
**                                                                      **
**************************************************************************/

/**//**//**//**//**//**//**//**//**//**//**//**//**//**//**/
//
// WARNING
// THIS FILE IS AUTO GENERATED BY `misc/pqc_settings.py`.
// ANY CHANGES HERE WILL BE OVERWRITTEN AT SOME POINT!
//
/**//**//**//**//**//**//**//**//**//**//**//**//**//**//**/

#include <QJSValue>
#include <QMessageBox>
#include <qlogging.h>   // needed in this form to compile with Qt 6.2
#include <pqc_settings.h>
#include <pqc_settingscpp.h>
#include <pqc_configfiles.h>
#include <pqc_notify.h>
#include <pqc_extensionshandler.h>

#include <scripts/pqc_scriptsother.h>

PQCSettings::PQCSettings(bool validateonly) {
    if(validateonly) {
        dbCommitTimer = nullptr;
        qDebug() << "THIS INSTANCE SHOULD ONLY BE USED FOR VALIDATING!";
    } else
        PQCSettings();
}

PQCSettings::PQCSettings() {

    // create and connect to default database
    if(QSqlDatabase::isDriverAvailable("QSQLITE3"))
        dbDefault = QSqlDatabase::addDatabase("QSQLITE3", "defaultsettings");
    else if(QSqlDatabase::isDriverAvailable("QSQLITE"))
        dbDefault = QSqlDatabase::addDatabase("QSQLITE", "defaultsettings");
    QFile::remove(PQCConfigFiles::get().DEFAULTSETTINGS_DB());
    QFile::copy(":/defaultsettings.db", PQCConfigFiles::get().DEFAULTSETTINGS_DB());
    dbDefault.setDatabaseName(PQCConfigFiles::get().DEFAULTSETTINGS_DB());
    if(!dbDefault.open()) {
        qCritical() << "ERROR opening default database:" << (PQCConfigFiles::get().DEFAULTSETTINGS_DB());
        QMessageBox::critical(0, QCoreApplication::translate("PQSettings", "ERROR opening database with default settings"),
                            QCoreApplication::translate("PQSettings", "I tried hard, but I just cannot open the database of default settings.") + QCoreApplication::translate("PQSettings", "Something went terribly wrong somewhere!"));
        return;
    }

    // connect to user database
    if(QSqlDatabase::isDriverAvailable("QSQLITE3"))
        db = QSqlDatabase::addDatabase("QSQLITE3", "settings");
    else if(QSqlDatabase::isDriverAvailable("QSQLITE"))
        db = QSqlDatabase::addDatabase("QSQLITE", "settings");

    dbtables = QStringList() << "general"
                            << "interface"
                            << "imageview"
                            << "thumbnails"
                            << "mainmenu"
                            << "metadata"
                            << "filetypes"
                            << "filedialog"
                            << "slideshow"
                            << "mapview"
                            << "extensions";

    readonly = false;

    QFileInfo infodb(PQCConfigFiles::get().USERSETTINGS_DB());

    // the db does not exist -> create it
    if(!infodb.exists()) {
        if(!QFile::copy(":/usersettings.db", PQCConfigFiles::get().USERSETTINGS_DB()))
            qWarning() << "Unable to (re-)create default user settings database";
        else {
            QFile file(PQCConfigFiles::get().USERSETTINGS_DB());
            file.setPermissions(file.permissions()|QFileDevice::WriteOwner);
        }
    }

    db.setDatabaseName(PQCConfigFiles::get().USERSETTINGS_DB());

    if(!db.open()) {

        qWarning() << "ERROR opening database:" << db.lastError().text();
        qWarning() << "Will load read-only database of default settings";

        readonly = true;
        db.setConnectOptions("QSQLITE_OPEN_READONLY");

        QString tmppath = QStandardPaths::writableLocation(QStandardPaths::TempLocation)+"/usersettings.db";

        if(QFile::exists(tmppath))
            QFile::remove(tmppath);

        if(!QFile::copy(":/usersettings.db", tmppath)) {
            qCritical() << "ERROR copying read-only default database!";
            //: This is the window title of an error message box
            QMessageBox::critical(0, QCoreApplication::translate("PQSettings", "ERROR getting database with default settings"),
                                    QCoreApplication::translate("PQSettings", "I tried hard, but I just cannot open even a read-only version of the settings database.") + QCoreApplication::translate("PQSettings", "Something went terribly wrong somewhere!"));
            return;
        }

        QFile f(tmppath);
        f.setPermissions(f.permissions()|QFileDevice::WriteOwner);

        db.setDatabaseName(tmppath);

        if(!db.open()) {
            qCritical() << "ERROR opening read-only default database!";
            QMessageBox::critical(0, QCoreApplication::translate("PQSettings", "ERROR opening database with default settings"),
                                    QCoreApplication::translate("PQSettings", "I tried hard, but I just cannot open the database of default settings.") + QCoreApplication::translate("PQSettings", "Something went terribly wrong somewhere!"));
            return;
        }

    } else {

        readonly = false;
        if(!infodb.permission(QFileDevice::WriteOwner))
            readonly = true;

    }

    dbIsTransaction = false;
    dbCommitTimer = new QTimer();
    dbCommitTimer->setSingleShot(true);
    dbCommitTimer->setInterval(400);
    connect(dbCommitTimer, &QTimer::timeout, this, [=](){
        db.commit();
        dbIsTransaction = false;
        if(db.lastError().text().trimmed().length())
            qWarning() << "ERROR committing database:" << db.lastError().text();
    });

    /******************************************************/

    m_extensions = new QQmlPropertyMap();

    /******************************************************/

    // set up with all defaults
    setupFresh();

    /******************************************************/

    // then update with user settings (if applicable)
    QFileInfo info(PQCConfigFiles::get().USERSETTINGS_DB());
    if(!info.exists()) {
        if(!QFile::copy(":/usersettings.db", PQCConfigFiles::get().USERSETTINGS_DB()))
            qWarning() << "Unable to (re-)create default settings database";
        else {
            QFile file(PQCConfigFiles::get().USERSETTINGS_DB());
            file.setPermissions(file.permissions()|QFileDevice::WriteOwner);
        }
    } else {
        readDB();
        QString curver = PQMVERSION;
        if(curver != m_generalVersion)
            migrate(m_generalVersion);
    }

    /******************************************************/
    """

    ########################################
    # CHANGED SIGNAL CONNECTIONS
    ########################################

    for tab in dbtables:

        c = conn.cursor()
        c.execute(f"SELECT `name`,`datatype` FROM {tab} ORDER BY `name`")
        data = c.fetchall()

        cont_SOURCE += f"""
    // table: {tab}"""
        for row in data:

            name = row[0]
            datatype = row[1]

            qtdatatpe = "QString"
            if datatype == "bool":
                qtdatatpe = "bool"
            elif datatype == "int":
                qtdatatpe = "int"
            elif datatype == "double":
                qtdatatpe = "double"
            elif datatype == "list":
                qtdatatpe = "QStringList"
            elif datatype == "point":
                qtdatatpe = "QPoint"
            elif datatype == "size":
                qtdatatpe = "QSize"

            cont_SOURCE += f"""
    connect(this, &PQCSettings::{tab}{name}Changed, this, [=]() {{ saveChangedValue(\"{tab}{name}\", m_{tab}{name}); }});"""



    cont_SOURCE += """

    /******************************************************/

    connect(m_extensions, &QQmlPropertyMap::valueChanged, this, &PQCSettings::saveChangedExtensionValue);

    /******************************************************/

    connect(&PQCNotify::get(), &PQCNotify::settingUpdateChanged, this, &PQCSettings::updateFromCommandLine);
    connect(&PQCNotify::get(), &PQCNotify::resetSettingsToDefault, this, &PQCSettings::resetToDefault);
    connect(&PQCNotify::get(), &PQCNotify::disableColorSpaceSupport, this, [=]() {{ setImageviewColorSpaceEnable(false); }});

}

PQCSettings::~PQCSettings() {{
    if(dbCommitTimer != nullptr) {{
        delete dbCommitTimer;
        delete m_extensions;
    }}
}}
"""

    return cont_SOURCE;
