
DROP TABLE IF EXISTS orders CASCADE;
DROP TABLE IF EXISTS vehicles CASCADE;
DROP TABLE IF EXISTS dist_matrix CASCADE;

-- table vehicles start

CREATE TABLE vehicles (
  id BIGINT PRIMARY KEY,
  start_node_id BIGINT,
  start_x FLOAT,
  start_y FLOAT,
  start_open FLOAT,
  start_close FLOAT,
  capacity FLOAT
);

INSERT INTO vehicles (id, start_node_id, start_x,  start_y,  start_open,  start_close, capacity)
WITH
v_info AS (SELECT 101, 40,  50,  0,  1236,  200),
set_of_v AS (SELECT generate_series(1, 25), * FROM v_info)
SELECT *
FROM set_of_v;

-- table vehicles end

-- table orders start

CREATE TABLE orders (
  id BIGINT PRIMARY KEY,
  demand FLOAT,
  p_node_id BIGINT,
  p_x FLOAT,
  p_y FLOAT,
  p_open FLOAT,
  p_close FLOAT,
  p_service FLOAT,
  d_node_id BIGINT,
  d_x FLOAT,
  d_y FLOAT,
  d_open FLOAT,
  d_close FLOAT,
  d_service FLOAT
);


INSERT INTO orders (id,  demand,
p_node_id, p_x, p_y, p_open, p_close, p_service,
d_node_id, d_x, d_y, d_open, d_close, d_service)
VALUES
 (3, 10, 81,  42,  66,  65, 146, 90, 89,  45,  65,  997, 1068, 90),
 (5, 10, 39,  42,  65,  15,  67, 90, 25,  40,  66,  170,  225, 90),
 (6, 20, 14,  40,  69, 621, 702, 90, 68,  45,  70,  825,  870, 90),
 (8, 20,  9,  38,  68, 255, 324, 90, 86,  35,  66,  357,  410, 90),
 (9, 10, 78,  38,  70, 534, 605, 90, 82,  42,  68,  727,  782, 90),
(11, 10, 84,  35,  69, 448, 505, 90, 10,  45,  68,  912,  967, 90),
(13, 30,  6,  22,  75,  30,  92, 90, 80,  18,  75,   99,  148, 90),
(16, 40, 70,  20,  85, 475, 528, 90, 52,  22,  85,  567,  620, 90),
(18, 20, 26,  15,  75, 179, 254, 90, 74,  25,  85,  652,  721, 90),
(19, 10, 35,  15,  80, 278, 345, 90, 94,  20,  80,  384,  429, 90),
(20, 10, 54,  30,  50,  10,  73, 90, 76,  25,  50,   65,  144, 90),
(23, 10, 60,  28,  55, 732, 777,  0, 60,  28,  55,  732,  777, 90),
(25, 40, 64,  25,  52, 169, 224, 90, 40,  23,  52,  261,  316, 90),
(28, 20, 15,  23,  55, 546, 593, 90, 72,  28,  52,  812,  883, 90),
(29, 10, 98,  20,  50, 358, 405, 90, 46,  25,  55,  622,  701, 90),
(30, 10, 44,  20,  55, 449, 504, 90, 51,  30,  52,  914,  965, 90),
(32, 30, 83,  10,  40,  31, 100, 90, 93,  10,  35,  200,  237, 90),
(33, 40, 22,   8,  40,  87, 158, 90, 42,   2,  40,  383,  434, 90),
(35, 10, 95,   5,  35, 283, 344, 90, 43,   0,  45,  567,  624, 90),
(36, 10,  2,   5,  45, 665, 716,  0,  2,   5,  45,  665,  716, 90),
(38, 30,100,   0,  40, 479, 522, 90, 17,   8,  45,  751,  816, 90),
(42, 20, 67,  33,  32,  68, 149, 90,  4,  35,  30,  264,  321, 90),
(43, 10, 38,  33,  35,  16,  80, 90,  8,  35,  32,  166,  235, 90),
(44, 10, 33,  32,  30, 359, 412, 90, 45,  30,  32,  448,  509, 90),
(45, 10, 63,  30,  30, 541, 600, 90, 41,  28,  30,  632,  693, 90),
(49, 10, 12,  28,  35, 1001, 1066, 90, 1, 30,  35, 1054, 1127, 90),
(50, 10, 79,  26,  32, 815, 880, 90, 77,  25,  35,  912,  969, 90),
(51, 10, 57,  25,  30, 725, 786,  0, 57,  25,  30,  725,  786, 90),
(53, 20, 71,  44,   5, 286, 347, 90, 49,  38,   5,  471,  534, 90),
(54, 40, 69,  42,  10, 186, 257, 90, 11,  35,   5,  562,  629, 90),
(56, 30, 32,  40,   5, 385, 436, 90,  7,  38,  15,  651,  740, 90),
(57, 40, 88,  40,  15,  35,  87, 90, 34,  42,  15,   95,  158, 90),
(62, 20, 31,  50,  35, 262, 317, 90, 13,  45,  30,  734,  777, 90),
(63, 50, 99,  50,  40, 171, 218, 90, 29,  53,  35,  353,  412, 90),
(64, 10, 91,  48,  30, 632, 693,  0, 91,  48,  30,  632,  693, 90),
(65, 10, 66,  48,  40,  76, 129, 90, 30,  53,  30,  450,  505, 90),
(66, 10, 47,  47,  35, 826, 875, 90, 92,  45,  35,  916,  969, 90),
(67, 10, 90,  47,  40,  12,  77, 90, 19,  50,  30,  531,  610, 90),
(71, 20, 61,  95,  35, 293, 360, 90, 96,  88,  30,  574,  643, 90),
(76, 10, 48,  90,  35, 203, 260, 90, 62,  92,  30,  478,  551, 90),
(78, 20, 18,  88,  35, 109, 170,  0, 18,  88,  35,  109,  170, 90),
(79, 10, 65,  87,  30, 668, 731, 90, 24,  85,  25,  769,  820, 90),
(81, 30, 75,  85,  35,  47, 124, 90, 50,  95,  30,  387,  456, 90),
(82, 20,  3,  75,  55, 369, 420, 90, 21,  68,  60,  555,  612, 90),
(84, 20, 27,  70,  58, 458, 523, 90, 58,  63,  58,  737,  802, 90),
(86, 10, 23,  66,  55, 173, 238, 90, 73,  60,  60,  836,  889, 90),
(87, 20, 37,  65,  55,  85, 144, 90, 59,  72,  55,  265,  338, 90),
(90, 10, 20,  60,  55,  20,  84, 90, 56,  65,  60,  645,  708, 90),
(92, 20, 53,  67,  85, 368, 441, 90, 55,  65,  85,  475,  518, 90),
(96, 10, 28,  60,  80,  95, 156, 90, 87,  65,  82,  285,  336, 90),
(97, 30, 85,  60,  85, 561, 622,  0, 85,  60,  85,  561,  622, 90),
(98, 20, 36,  58,  75,  30,  84, 90, 16,  62,  80,  196,  239, 90),
(100, 20, 97,  55, 85, 647, 726, 90,  5,  55,  80,  743,  820, 90);

-- table orders end

