; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!
; Created with Inno Setup (http://www.jrsoftware.org/isinfo.php)

#define MyAppName "pgModeler - PostgreSQL Database Modeler"
#define MyAppMenuGroup "pgModeler"
#define MyAppVersion "0.9.0-beta"
#define MyAppPublisher "pgModeler Project"
#define MyAppURL "http://www.pgmodeler.com.br/"
#define MyAppExeName "pgmodeler.exe"

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{8978809A-8AA1-4DE8-A4B8-058F2CE7B9E7}
AppName={#MyAppName}
AppVersion={#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={pf}\pgmodeler
DefaultGroupName={#MyAppMenuGroup}
AllowNoIcons=yes
LicenseFile=..\..\build\LICENSE
OutputDir=..\..\
OutputBaseFilename=pgmodeler
Compression=lzma
SolidCompression=yes
ChangesEnvironment=true
SetupIconFile=./installer_icon.ico
WizardImageFile=./left_image.bmp
WizardImageStretch=false
WizardSmallImageFile=./top_image.bmp
EnableDirDoesntExistWarning=true
ShowComponentSizes=true

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked
Name: "quicklaunchicon"; Description: "{cm:CreateQuickLaunchIcon}"; GroupDescription: "{cm:AdditionalIcons}"; Flags: unchecked; OnlyBelowVersion: 0,6.1

[Files]
Source: "..\..\build\pgmodeler.exe"; DestDir: "{app}"; Flags: ignoreversion
Source: "..\..\build\*"; DestDir: "{app}"; Flags: ignoreversion recursesubdirs createallsubdirs
; NOTE: Don't use "Flags: ignoreversion" on any shared system files

[Icons]
Name: "{group}\{#MyAppName}"; Filename: "{app}\{#MyAppExeName}"
Name: "{group}\{cm:ProgramOnTheWeb,{#MyAppMenuGroup}}"; Filename: "{#MyAppURL}"
Name: "{group}\{cm:UninstallProgram,{#MyAppMenuGroup}}"; Filename: "{uninstallexe}"
Name: "{commondesktop}\{#MyAppMenuGroup}"; Filename: "{app}\{#MyAppExeName}"; Tasks: desktopicon
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\{#MyAppMenuGroup}"; Filename: "{app}\{#MyAppExeName}"; Tasks: quicklaunchicon

[Run]
Filename: "{app}\pgmodeler-cli.exe"; Parameters:"-m install"; Description: "Associate .dbm files to pgModeler"; Flags: postinstall runhidden

[UninstallRun]
Filename: "{app}\pgmodeler-cli.exe"; Parameters:"-m uninstall"; Flags: runhidden


[code]
procedure SetEnv(EnvName, EnvValue: String; IsInstall: Boolean);
var
  OrgValue:String;
  OrgLen:Integer;
  EnvValuePos:Integer;
  EnvValueLen:Integer;
begin

  RegQueryStringValue(HKEY_LOCAL_MACHINE, 'SYSTEM\CurrentControlSet\Control\Session Manager\Environment', EnvName, OrgValue);

  OrgValue:=Trim(OrgValue);
  OrgLen:=length(OrgValue);
  EnvValuePos:=pos(Uppercase(EnvValue),Uppercase(OrgValue));
  EnvValueLen:=length(EnvValue);

  if IsInstall then
    begin
      if OrgLen>0 then EnvValue:=';'+EnvValue;
      if EnvValuePos=0 then Insert(EnvValue,OrgValue,OrgLen+1);
    end
  else
    begin
      if EnvValuePos>0 then Delete(OrgValue,EnvValuePos,EnvValueLen);
      if length(OrgValue)=0 then
      begin
        RegDeleteValue(HKEY_LOCAL_MACHINE, 'SYSTEM\CurrentControlSet\Control\Session Manager\Environment',EnvName);
        exit;
      end;
    end;

    StringChange(OrgValue,';;',';');
    RegWriteStringValue(HKEY_LOCAL_MACHINE, 'SYSTEM\CurrentControlSet\Control\Session Manager\Environment', EnvName, OrgValue);

end;

procedure CurStepChanged(CurStep: TSetupStep);
var
  ResultCode: Integer;
begin
  if CurStep=ssInstall then
    begin
      SetEnv('Path',ExpandConstant('{app}'),true);
      SetEnv('PGMODELER_LANG_DIR',ExpandConstant('{app}') + '\lang',true);
      SetEnv('PGMODELER_TMPL_CONF_DIR',ExpandConstant('{app}') + '\conf',true);
      SetEnv('PGMODELER_SCHEMAS_DIR',ExpandConstant('{app}') + '\schemas',true);
      SetEnv('PGMODELER_SAMPLES_DIR',ExpandConstant('{app}') + '\samples',true);
      SetEnv('PGMODELER_PLUGINS_DIR',ExpandConstant('{app}') + '\plugins',true);
      SetEnv('PGMODELER_CHANDLER_PATH',ExpandConstant('{app}') + '\pgmodeler-ch.exe',true);
      SetEnv('PGMODELER_CLI_PATH',ExpandConstant('{app}') + '\pgmodeler-cli.exe',true);      
      SetEnv('PGMODELER_APP_PATH',ExpandConstant('{app}') + '\pgmodeler.exe',true);    
    end
end;

procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
var
  ResultCode: Integer;
begin
if CurUninstallStep = usUninstall then
    begin
      SetEnv('Path',ExpandConstant('{app}'),false);
      SetEnv('PGMODELER_LANG_DIR',ExpandConstant('{app}') + '\lang',false);
      SetEnv('PGMODELER_TMPL_CONF_DIR',ExpandConstant('{app}') + '\conf',false);
      SetEnv('PGMODELER_SCHEMAS_DIR',ExpandConstant('{app}') + '\schemas',false);
      SetEnv('PGMODELER_SAMPLES_DIR',ExpandConstant('{app}') + '\samples',false);
      SetEnv('PGMODELER_PLUGINS_DIR',ExpandConstant('{app}') + '\plugins',false);
      SetEnv('PGMODELER_CHANDLER_PATH',ExpandConstant('{app}') + '\pgmodeler-ch.exe',false);
      SetEnv('PGMODELER_CLI_PATH',ExpandConstant('{app}') + '\pgmodeler-cli.exe',false);
      SetEnv('PGMODELER_APP_PATH',ExpandConstant('{app}') + '\pgmodeler.exe',false);
    end;
end;

procedure CurInstallProgressChanged(CurProgress, MaxProgress: Integer);
begin



end;
