package App::perlrdf::Command::StoreDescribe;

use 5.010;
use strict;
use warnings;
use utf8;

BEGIN {
	$App::perlrdf::Command::StoreDescribe::AUTHORITY = 'cpan:TOBYINK';
	$App::perlrdf::Command::StoreDescribe::VERSION   = '0.004';
}

use App::perlrdf -command;
use namespace::clean;

use constant abstract      => q (Describe RDF resource using an RDF::Trine::Store.);
use constant command_names => qw( store_describe desc );
use constant description   => <<'INTRO' . __PACKAGE__->store_help . <<'DESCRIPTION';
Retrieve a bounded description from an RDF::Trine::Store.
INTRO

Output files are specified the same way as for the 'translate' command. See
'filespec' for more details.
DESCRIPTION

use constant opt_spec => (
	__PACKAGE__->store_opt_spec,
	[]=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>=>,
	[ 'output|o=s@',       'Output filename or URL' ],
	[ 'output-spec|O=s@',  'Output file specification' ],
	[ 'output-format|s=s', 'Output format (mnemonic: serialise)' ],
);
use constant usage_desc   => '%c store_describe %o RESOURCE';

sub execute
{
	require RDF::Trine;
	require App::perlrdf::FileSpec::OutputRDF;
	
	my ($self, $opt, $arg) = @_;

	my $store = $self->get_store($opt);
	my $model = RDF::Trine::Model->new($store);

	my $resource = @$arg
		? RDF::Trine::iri(shift @$arg)
		: $self->usage_error("No resource to describe");

	my @outputs = $self->get_filespecs(
		'App::perlrdf::FileSpec::OutputRDF',
		output => $opt,
	);
	
	push @outputs, map {
		App::perlrdf::FileSpec::OutputRDF->new_from_filespec(
			$_,
			$opt->{output_format},
			$opt->{output_base},
		)
	} @$arg;
	
	push @outputs,
		App::perlrdf::FileSpec::OutputRDF->new_from_filespec(
			'-',
			($opt->{output_format} // 'NQuads'),
			$opt->{output_base},
		)
		unless @outputs;

	my $description = RDF::Trine::Model->new;
	$description->add_iterator( $model->bounded_description($resource) );

	for (@outputs)
	{
		printf STDERR "Writing %s\n", $_->uri;
		
		eval {
			local $@ = undef;
			$_->serialize_model($description);
			1;
		} or warn "$@\n";
	}
}

1;
