// Package models contains the types for schema 'public'.
package models

// Code generated by xo. DO NOT EDIT.

// GlobalWaitEvents represents a row from '[custom global_wait_events]'.
type GlobalWaitEvents struct {
	WaitEventType string // wait_event_type
	WaitEvent     string // wait_event
	Count         int64  // count
}

// GetGlobalWaitEvents runs a custom query, returning results as GlobalWaitEvents.
func GetGlobalWaitEvents(db XODB) ([]*GlobalWaitEvents, error) {
	var err error

	// sql query
	const sqlstr = `SELECT wait_event_type, wait_event, count(*) ` +
		`FROM pg_stat_activity ` +
		`WHERE wait_event_type IS NOT NULL ` +
		`OR wait_event IS NOT NULL ` +
		`GROUP BY 1,2`

	// run query
	XOLog(sqlstr)
	q, err := db.Query(sqlstr)
	if err != nil {
		return nil, err
	}
	defer q.Close()

	// load results
	res := []*GlobalWaitEvents{}
	for q.Next() {
		gwe := GlobalWaitEvents{}

		// scan
		err = q.Scan(&gwe.WaitEventType, &gwe.WaitEvent, &gwe.Count)
		if err != nil {
			return nil, err
		}

		res = append(res, &gwe)
	}

	return res, nil
}
