/* For information on usage and redistribution, and for a DISCLAIMER OF ALL
* WARRANTIES, see the file, "LICENSE.txt," in this distribution.

iem_dp written by IOhannes m zmoelnig, Thomas Musil, Copyright (c) IEM KUG Graz Austria 1999 - 2007 */
/* double precision library */

#include "m_pd.h"
#include "iemlib.h"
#include "iem_dp.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* -------------------------- dptosym ------------------------------ */
/* double float to symbol-string of a double value converter */

/* double float is only internal used */
/* to transfer this value, we divide this double value into use one float casted value */
/* and into the difference to the accurate double value. */

/* double float (sign_1 + exp_12 + mant_51) */

static t_class *dptosym_class;

typedef struct _dptosym
{
  t_object  x_obj;
  t_float   x_float_casted_value;
  t_float   x_residual;
  t_outlet  *x_out_sym;
  t_outlet  *x_out_any;
} t_dptosym;

static void dptosym_bang(t_dptosym *x)
{
  char buf[100];
  double d=iem_dp_calc_sum(x->x_float_casted_value, x->x_residual);
  t_atom at_dummy;
  
  sprintf(buf, "\"%.18g", d);
  outlet_anything(x->x_out_any, gensym(buf), 0, &at_dummy);
  outlet_symbol(x->x_out_sym, gensym(buf+1));
}

static void dptosym_float(t_dptosym *x, t_floatarg f)
{
  x->x_float_casted_value = f;
//  post("dptosym float float: %.12g + %.12g", x->x_float_casted_value, x->x_residual);
  dptosym_bang(x);
}

static void *dptosym_new(void)
{
  t_dptosym *x = (t_dptosym *)pd_new(dptosym_class);
  
  floatinlet_new(&x->x_obj, &x->x_residual);
  x->x_float_casted_value = 0.0f;
  x->x_residual = 0.0f;
  x->x_out_sym = outlet_new(&x->x_obj, &s_symbol);
  x->x_out_any = outlet_new(&x->x_obj, &s_list);
  return (x);
}

void dptosym_setup(void)
{
  dptosym_class = class_new(gensym("dptosym"),
    (t_newmethod)dptosym_new, 0, sizeof(t_dptosym), 0, 0);
  class_addbang(dptosym_class, dptosym_bang);
  class_addfloat(dptosym_class, dptosym_float);
}
