/* DLSyntaxParser.java */
/* Generated By:JavaCC: Do not edit this line. DLSyntaxParser.java */
/* This file is part of the OWL API.
 * The contents of this file are subject to the LGPL License, Version 3.0.
 * Copyright 2014, The University of Manchester
 * 
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 * Alternatively, the contents of this file may be used under the terms of the Apache License, Version 2.0 in which case, the provisions of the Apache License Version 2.0 are applicable instead of those above.
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License. */

package org.semanticweb.owlapi.dlsyntax.parser;

import java.util.Set;
import java.util.HashSet;
import java.util.*;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.semanticweb.owlapi.util.*;

import org.semanticweb.owlapi.model.*;

@SuppressWarnings("all")
public class DLSyntaxParser implements DLSyntaxParserConstants {
    private String defaultNamespace = IRI.getNextDocumentIRI("http://www.semanticweb.org/ontologies/Ontology").toString();
    private Map<String, String> namespaceMap = new HashMap<String, String>();
    private OWLDataFactory factory;
    private Map<String, IRI> iriMap = new HashMap<String, IRI>();
    private Map<String, IRI> qnameIRIMap = new HashMap<String, IRI>();
    private Set<OWLAxiom> axioms = new LinkedHashSet<OWLAxiom>();

    public void setOWLDataFactory(OWLDataFactory factory) {
        this.factory = factory;
    }

    public void setPrefixMapping(String prefix, String namespace) {
        namespaceMap.put(prefix, namespace);
    }

    public void setDefaultNamespace(String ns) {
        defaultNamespace = ns;
    }

    public IRI getIRI(String val) {
        IRI iri = iriMap.get(val);
        if(iri == null) {
            iri = IRI.create(val);
            iriMap.put(val, iri);
        }
        return iri;
    }

    public IRI getIRIFromId(String qname) {
        if(qname.equals("top") || qname.equals("\u22a4")) {
            return OWLRDFVocabulary.OWL_THING.getIRI();
        }
        if(qname.equals("bottom") || qname.equals("\u22a5")) {
            return OWLRDFVocabulary.OWL_NOTHING.getIRI();
        }
        IRI iri = qnameIRIMap.get(qname);
        if(iri == null) {
            iri = getIRI(defaultNamespace + "#" + qname);
            qnameIRIMap.put(qname, iri);
        }
        return iri;
    }
    private void addAxiom(OWLAxiom ax) {
        if (ax == null) {
          return;
        }
        axioms.add(ax);
    }

  final public OWLClassExpression parseDescription() throws ParseException {OWLClassExpression desc;
    desc = parseClassDescription();
    jj_consume_token(0);
return desc;
}

  final public Set<OWLAxiom> parseAxioms() throws ParseException {OWLAxiom ax;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OPENPAR:
      case OPENBRACE:
      case COLON:
      case NOT:
      case SOME:
      case ALL:
      case MIN:
      case MAX:
      case EXACT:
      case ID:
      case 30:{
        ;
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 30:{
        jj_consume_token(30);
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        ;
      }
      ax = parseAxiom();
addAxiom(ax);
    }
    jj_consume_token(0);
return axioms;
}

  final public OWLAxiom parseAxiom() throws ParseException {OWLAxiom ax;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      ax = parsePropertyAxiom();
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      if (jj_2_1(3)) {
        ax = parseClassAxiom();
      } else if (jj_2_2(3)) {
        ax = parseIndividualAxiom();
      } else if (jj_2_3(3)) {
        ax = parseObjectPropertyAssertion();
      } else if (jj_2_4(3)) {
        ax = parseDataPropertyAssertion();
      } else if (jj_2_5(2)) {
        ax = parseDifferentIndividualsAxiom();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return ax;
}

  final public OWLAxiom parseIndividualAxiom() throws ParseException {OWLAxiom ax;
    if (jj_2_6(2)) {
      ax = parseClassAssertion();
    } else if (jj_2_7(2)) {
      ax = parseSameIndividual();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return ax;
}

  final public OWLAxiom parseDifferentIndividualsAxiom() throws ParseException {Set<OWLIndividual> inds = new HashSet<OWLIndividual>();
    OWLIndividual ind;
    ind = parseIndividualId();
inds.add(ind);
    jj_consume_token(NEQ);
    ind = parseIndividualId();
inds.add(ind);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NEQ:{
        ;
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
      jj_consume_token(NEQ);
      ind = parseIndividualId();
inds.add(ind);
    }
return factory.getOWLDifferentIndividualsAxiom(inds);
}

  final public OWLAxiom parseObjectPropertyAssertion() throws ParseException {OWLIndividual subj, obj;
    OWLObjectPropertyExpression prop;
    prop = parseObjectPropertyId();
    jj_consume_token(OPENPAR);
    subj = parseIndividualId();
    jj_consume_token(31);
    obj = parseIndividualId();
    jj_consume_token(CLOSEPAR);
return factory.getOWLObjectPropertyAssertionAxiom(prop, subj, obj);
}

  final public OWLAxiom parseDataPropertyAssertion() throws ParseException {OWLIndividual subj;
    OWLDataPropertyExpression prop;
    OWLLiteral obj;
    prop = parseDataPropertyId();
    jj_consume_token(OPENPAR);
    subj = parseIndividualId();
    jj_consume_token(31);
    obj = parseLiteral();
    jj_consume_token(CLOSEPAR);
return factory.getOWLDataPropertyAssertionAxiom(prop, subj, obj);
}

  final public OWLAxiom parseSameIndividual() throws ParseException {OWLIndividual indA;
    OWLIndividual indB;
    indA = parseIndividualId();
    jj_consume_token(EXACT);
    indB = parseIndividualId();
return factory.getOWLSameIndividualAxiom(indA, indB);
}

  final public OWLAxiom parseClassAssertion() throws ParseException {OWLIndividual ind;
    OWLClassExpression desc;
    if (jj_2_8(3)) {
      jj_consume_token(OPENPAR);
      desc = parseDescription();
      jj_consume_token(CLOSEPAR);
    } else if (jj_2_9(3)) {
      desc = parseClassDescription();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(OPENPAR);
    ind = parseIndividualId();
    jj_consume_token(CLOSEPAR);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case 30:{
      jj_consume_token(30);
jj_input_stream.backup(1);
      break;
      }
    case 0:{
      jj_consume_token(0);
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return factory.getOWLClassAssertionAxiom(desc, ind);
}

  final public OWLAxiom parseClassAxiom() throws ParseException {OWLClassExpression lhs;
    OWLClassExpression rhs;
    boolean subClassAxiom = false;
    OWLAxiom ax = null;
    lhs = parseClassDescription();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SUBCLASSOF:{
      jj_consume_token(SUBCLASSOF);
      rhs = parseClassDescription();
if(lhs.isOWLThing()) {
             if(rhs instanceof OWLObjectAllValuesFrom) {
                 // Interpret as Range
                 OWLObjectAllValuesFrom r = (OWLObjectAllValuesFrom) rhs;
                 ax = factory.getOWLObjectPropertyRangeAxiom(r.getProperty(), r.getFiller());
             } else if(rhs instanceof OWLObjectMaxCardinality) {
                OWLObjectMaxCardinality r = (OWLObjectMaxCardinality) rhs;
                if(r.getCardinality() == 1 && r.getFiller().isOWLThing()) {
                    ax = factory.getOWLFunctionalObjectPropertyAxiom(r.getProperty());
                }
            }
        } else if(lhs instanceof OWLObjectSomeValuesFrom) {
            OWLObjectSomeValuesFrom restriction = (OWLObjectSomeValuesFrom) lhs;
            if(restriction.getFiller().isOWLThing()) {
                ax = factory.getOWLObjectPropertyDomainAxiom(restriction.getProperty(), rhs);
            }
        } else {
            if(rhs instanceof OWLObjectComplementOf && !rhs.isAnonymous()) {
                ax = factory.getOWLDisjointClassesAxiom(lhs, ((OWLObjectComplementOf) rhs).getOperand());
            } else {
                ax = factory.getOWLSubClassOfAxiom(lhs, rhs);
            }
         }
      break;
      }
    case EQUIVALENTTO:{
      jj_consume_token(EQUIVALENTTO);
      rhs = parseClassDescription();
ax = factory.getOWLEquivalentClassesAxiom(lhs, rhs);
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return ax;
}

  final public OWLAxiom parsePropertyChain() throws ParseException {OWLObjectPropertyExpression prop;
    OWLObjectPropertyExpression supProp;
    List<OWLObjectPropertyExpression> props = new ArrayList<OWLObjectPropertyExpression>();
    prop = parseObjectPropertyId();
props.add(prop);
    jj_consume_token(COMPOSE);
    prop = parseObjectPropertyId();
props.add(prop);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMPOSE:{
        ;
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMPOSE);
      prop = parseObjectPropertyId();
props.add(prop);
    }
    jj_consume_token(SUBCLASSOF);
    supProp = parseObjectPropertyId();
return factory.getOWLSubPropertyChainOfAxiom(props, supProp);
}

  final public OWLAxiom parsePropertyAxiom() throws ParseException {OWLObjectPropertyExpression lhs;
    OWLObjectPropertyExpression rhs;
    OWLAxiom ax;
    if (jj_2_10(3)) {
      lhs = parseObjectPropertyId();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SUBCLASSOF:{
        jj_consume_token(SUBCLASSOF);
        rhs = parseObjectPropertyId();
ax = factory.getOWLSubObjectPropertyOfAxiom(lhs, rhs);
        break;
        }
      case EQUIVALENTTO:{
        jj_consume_token(EQUIVALENTTO);
        rhs = parseObjectPropertyId();
if(rhs instanceof OWLObjectInverseOf) {
                OWLObjectInverseOf inv = (OWLObjectInverseOf) rhs;
                ax = factory.getOWLInverseObjectPropertiesAxiom(lhs, inv.getInverse());
            } else {
                ax = factory.getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet(lhs, rhs));
            }
        break;
        }
      case IN:{
        jj_consume_token(IN);
        jj_consume_token(TRANSITIVEROLES);
ax = factory.getOWLTransitiveObjectPropertyAxiom(lhs);
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else if (jj_2_11(3)) {
      ax = parsePropertyChain();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
return ax;
}

  final public OWLClassExpression parseClassDescription() throws ParseException {OWLClassExpression desc;
    desc = Or();
return desc;
}

  final public OWLClassExpression Or() throws ParseException {OWLClassExpression desc;
    Set<OWLClassExpression> operands = new HashSet<OWLClassExpression>();
    desc = And();
operands.add(desc);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_4;
      }
      jj_consume_token(OR);
      desc = And();
operands.add(desc);
    }
if(operands.size() == 1) { return desc; }
        return factory.getOWLObjectUnionOf(operands);
}

  final public OWLClassExpression And() throws ParseException {OWLClassExpression desc;
    Set<OWLClassExpression> operands = new HashSet<OWLClassExpression>();
    desc = NonNaryBooleanDescription();
operands.add(desc);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[9] = jj_gen;
        break label_5;
      }
      jj_consume_token(AND);
      desc = NonNaryBooleanDescription();
operands.add(desc);
    }
if(operands.size() == 1) { return desc; }
        return factory.getOWLObjectIntersectionOf(operands);
}

  final public OWLClassExpression NonNaryBooleanDescription() throws ParseException {OWLClassExpression desc;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SOME:
    case ALL:
    case MIN:
    case MAX:
    case EXACT:{
      desc = parseRestriction();
      break;
      }
    case NOT:{
      desc = parseObjectComplementOf();
      break;
      }
    case OPENPAR:
    case OPENBRACE:
    case ID:{
      desc = NamedClassOrNestedDescription();
      break;
      }
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return desc;
}

  final public OWLObjectPropertyExpression parseObjectPropertyId() throws ParseException {IRI iri;
    boolean inverse = false;
    iri = parseId();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INVERSE:{
      jj_consume_token(INVERSE);
inverse = true;
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      ;
    }
if(inverse) {
          return factory.getOWLObjectInverseOf(factory.getOWLObjectProperty(iri));
      }
      return factory.getOWLObjectProperty(iri);
}

  final public OWLDataPropertyExpression parseDataPropertyId() throws ParseException {IRI iri;
    iri = parseId();
return factory.getOWLDataProperty(iri);
}

  final public OWLClassExpression parseRestriction() throws ParseException {OWLClassExpression desc;
    if (jj_2_12(3)) {
      desc = parseSomeRestriction();
    } else if (jj_2_13(3)) {
      desc = parseDataSomeRestriction();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ALL:{
        desc = parseAllRestriction();
        break;
        }
      case MIN:
      case MAX:
      case EXACT:{
        desc = parseCardinalityRestriction();
        break;
        }
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
return desc;
}

  final public OWLClassExpression parseSomeRestriction() throws ParseException {OWLObjectPropertyExpression prop;
    OWLClassExpression filler;
    jj_consume_token(SOME);
    prop = parseObjectPropertyId();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      ;
    }
    filler = NamedClassOrNestedDescription();
return factory.getOWLObjectSomeValuesFrom(prop, filler);
}

  final public OWLClassExpression parseDataSomeRestriction() throws ParseException {OWLDataPropertyExpression prop;
    OWLDataRange filler;
    jj_consume_token(SOME);
    prop = parseDataPropertyId();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    filler = parseDataOneOf();
return factory.getOWLDataSomeValuesFrom(prop, filler);
}

  final public OWLClassExpression parseAllRestriction() throws ParseException {OWLObjectPropertyExpression prop;
    OWLClassExpression filler;
    jj_consume_token(ALL);
    prop = parseObjectPropertyId();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOT:{
      jj_consume_token(DOT);
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      ;
    }
    filler = NamedClassOrNestedDescription();
return factory.getOWLObjectAllValuesFrom(prop, filler);
}

  final public OWLClassExpression parseCardinalityRestriction() throws ParseException {OWLObjectPropertyExpression prop;
    OWLClassExpression filler = null;
    boolean min = false;
    boolean exactly = false;
    boolean max = false;
    Token t;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MIN:{
      jj_consume_token(MIN);
min=true;
      break;
      }
    case EXACT:{
      jj_consume_token(EXACT);
exactly=true;
      break;
      }
    case MAX:{
      jj_consume_token(MAX);
max=true;
      break;
      }
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    t = jj_consume_token(INT);
    prop = parseObjectPropertyId();
    if (jj_2_14(2)) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        ;
      }
      filler = NamedClassOrNestedDescription();
    } else {
      ;
    }
int card = Integer.parseInt(t.image);
        if(filler == null) { filler = factory.getOWLThing(); }
        if(min) { return factory.getOWLObjectMinCardinality(card, prop, filler); }
        else if(exactly) { return factory.getOWLObjectExactCardinality(card, prop, filler);}
        else { return factory.getOWLObjectMaxCardinality(card, prop, filler); }
}

  final public OWLIndividual parseIndividualId() throws ParseException {IRI iri;
    iri = parseId();
return factory.getOWLNamedIndividual(iri);
}

  final public OWLClassExpression parseObjectComplementOf() throws ParseException {OWLClassExpression op;
    jj_consume_token(NOT);
    op = NamedClassOrNestedDescription();
return factory.getOWLObjectComplementOf(op);
}

  final public OWLClassExpression parseObjectOneOf() throws ParseException {OWLIndividual ind;
    Set<OWLIndividual> inds = new HashSet<OWLIndividual>();
    jj_consume_token(OPENBRACE);
    ind = parseIndividualId();
inds.add(ind);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ID:{
        ;
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        break label_6;
      }
      ind = parseIndividualId();
inds.add(ind);
    }
    jj_consume_token(CLOSEBRACE);
return factory.getOWLObjectOneOf(inds);
}

  final public OWLDataRange parseDataOneOf() throws ParseException {OWLLiteral val;
    Set<OWLLiteral> values = new HashSet<OWLLiteral>();
    jj_consume_token(OPENBRACE);
    val = parseLiteral();
values.add(val);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case INT:
      case DOUBLE:{
        ;
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        break label_7;
      }
      val = parseLiteral();
values.add(val);
    }
    jj_consume_token(CLOSEBRACE);
return factory.getOWLDataOneOf(values);
}

  final public OWLClassExpression NamedClassOrNestedDescription() throws ParseException {OWLClassExpression desc;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ID:{
      desc = parseClassId();
      break;
      }
    case OPENPAR:
    case OPENBRACE:{
      desc = NestedClassDescription();
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return desc;
}

  final public OWLClass parseClassId() throws ParseException {IRI iri;
    iri = parseId();
return factory.getOWLClass(iri);
}

  final public OWLClassExpression NestedClassDescription() throws ParseException {OWLClassExpression desc;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case OPENPAR:{
      jj_consume_token(OPENPAR);
      desc = Or();
      jj_consume_token(CLOSEPAR);
      break;
      }
    case OPENBRACE:{
      desc = parseObjectOneOf();
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return desc;
}

  final public OWLLiteral parseLiteral() throws ParseException {Token t;
    OWLLiteral l;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case INT:{
      t = jj_consume_token(INT);
l= factory.getOWLLiteral(Integer.parseInt(t.image));
      break;
      }
    case DOUBLE:{
      t = jj_consume_token(DOUBLE);
l= factory.getOWLLiteral(Double.parseDouble(t.image));
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
return l;
}

  final public IRI parseId() throws ParseException {Token t;
    t = jj_consume_token(ID);
return getIRIFromId(t.image);
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_3_11()
 {
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3R_23()
 {
    if (jj_scan_token(SOME)) return true;
    if (jj_3R_28()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(8)) jj_scanpos = xsp;
    if (jj_3R_32()) return true;
    return false;
  }

  private boolean jj_3R_11()
 {
    if (jj_3R_28()) return true;
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_19()
 {
    if (jj_scan_token(EQUIVALENTTO)) return true;
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_30()
 {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_18()
 {
    if (jj_scan_token(SUBCLASSOF)) return true;
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_40()
 {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3R_34()
 {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_3R_17()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_22()
 {
    if (jj_scan_token(SOME)) return true;
    if (jj_3R_17()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(8)) jj_scanpos = xsp;
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_10()
 {
    if (jj_3R_17()) return true;
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_41()
 {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_3R_29()) return true;
    if (jj_scan_token(CLOSEPAR)) return true;
    return false;
  }

  private boolean jj_3R_38()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) return true;
    }
    return false;
  }

  private boolean jj_3R_50()
 {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_49()
 {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_23()) return true;
    return false;
  }

  private boolean jj_3R_12()
 {
    if (jj_3R_27()) return true;
    if (jj_scan_token(NEQ)) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_31()
 {
    if (jj_scan_token(INVERSE)) return true;
    return false;
  }

  private boolean jj_3R_21()
 {
    if (jj_3R_17()) return true;
    if (jj_scan_token(COMPOSE)) return true;
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_37()
 {
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3R_33()
 {
    if (jj_3R_37()) return true;
    return false;
  }

  private boolean jj_3R_24()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) return true;
    }
    return false;
  }

  private boolean jj_3R_28()
 {
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_3R_13()) return true;
    return false;
  }

  private boolean jj_3R_32()
 {
    if (jj_scan_token(OPENBRACE)) return true;
    return false;
  }

  private boolean jj_3R_9()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3_7()) return true;
    }
    return false;
  }

  private boolean jj_3R_26()
 {
    if (jj_scan_token(EQUIVALENTTO)) return true;
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_12()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3R_17()
 {
    if (jj_3R_30()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_31()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_36()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_35()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_9()) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_8()) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    if (jj_scan_token(OPENBRACE)) return true;
    if (jj_3R_27()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_56()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(CLOSEBRACE)) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_44()
 {
    if (jj_3R_48()) return true;
    return false;
  }

  private boolean jj_3R_43()
 {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3R_39()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_48()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_15()
 {
    if (jj_3R_16()) return true;
    if (jj_scan_token(0)) return true;
    return false;
  }

  private boolean jj_3R_27()
 {
    if (jj_3R_30()) return true;
    return false;
  }

  private boolean jj_3R_35()
 {
    if (jj_3R_39()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_40()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_25()
 {
    if (jj_scan_token(SUBCLASSOF)) return true;
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3R_8()
 {
    if (jj_3R_16()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) return true;
    }
    return false;
  }

  private boolean jj_3_14()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(8)) jj_scanpos = xsp;
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_55()
 {
    if (jj_scan_token(MAX)) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    if (jj_scan_token(EXACT)) return true;
    return false;
  }

  private boolean jj_3R_53()
 {
    if (jj_scan_token(MIN)) return true;
    return false;
  }

  private boolean jj_3R_52()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) return true;
    }
    }
    if (jj_scan_token(INT)) return true;
    if (jj_3R_17()) return true;
    return false;
  }

  private boolean jj_3R_29()
 {
    if (jj_3R_35()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_36()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_3R_46()) return true;
    return false;
  }

  private boolean jj_3R_13()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3_9()) return true;
    }
    if (jj_scan_token(OPENPAR)) return true;
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_16()
 {
    if (jj_3R_29()) return true;
    return false;
  }

  private boolean jj_3R_56()
 {
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_scan_token(ALL)) return true;
    if (jj_3R_17()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(8)) jj_scanpos = xsp;
    if (jj_3R_24()) return true;
    return false;
  }

  private boolean jj_3R_14()
 {
    if (jj_3R_27()) return true;
    if (jj_scan_token(EXACT)) return true;
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_20()
 {
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(TRANSITIVEROLES)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_14()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public DLSyntaxParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[23];
  static private int[] jj_la1_0;
  static {
	   jj_la1_init_0();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x61f94400,0x40000000,0x10000,0x40,0x40000001,0x30,0x80,0x2000030,0x40000,0x20000,0x21f84400,0x200,0x1e00000,0x100,0x100,0x100,0x1c00000,0x100,0x20000000,0x18000000,0x20004400,0x4400,0x18000000,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[14];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor. */
  public DLSyntaxParser(Provider stream) {
	 jj_input_stream = new JavaCharStream(stream, 1, 1);
	 token_source = new DLSyntaxParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 23; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public DLSyntaxParser(String dsl) throws ParseException, TokenMgrException {
	   this(new StringProvider(dsl));
  }

  public void ReInit(String s) {
	  ReInit(new StringProvider(s));
  }
  /** Reinitialise. */
  public void ReInit(Provider stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new JavaCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new DLSyntaxParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 23; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public DLSyntaxParser(DLSyntaxParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 23; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(DLSyntaxParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 23; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.RuntimeException { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[32];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 23; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 32; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage, token_source == null ? null : DLSyntaxParserTokenManager.lexStateNames[token_source.curLexState]);
  }

  private int trace_indent = 0;
  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 14; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			   case 9: jj_3_10(); break;
			   case 10: jj_3_11(); break;
			   case 11: jj_3_12(); break;
			   case 12: jj_3_13(); break;
			   case 13: jj_3_14(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
