'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\"
.TH DS2409 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2409
\- MicroLAN Coupler
.SH SYNOPSIS
1-wire network branch controller.
.PP
.B 1F
[.]XXXXXXXXXXXX[XX][/[
.B aux
|
.B branch.[0|1|ALL|BYTE]
|
.B control
|
.B discharge
|
.B event.[0|1|ALL|BYTE]
|
.B clearevent 
|
.B main
|
.B sensed.[0|1|ALL|BYTE]
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 1F
.SH SPECIAL PROPERTIES
.SS aux
.I directory
.br
This is the
.I aux
branch of the
.I DS2409
network branch. It is implicitly accessed (via the
.I aux smart-on
command) when it is listed or devices on this branch are addressed.
.SS branch.0 branch.1 branch.ALL branch.BYTE
.I read-write, yes-no
.br
Writing a value of
.I 1
to the branch properties explicitly selects the meant branch (
.I 0=main
or
.I 1=aux
). Writing 
.I 0
deselects the branch.
This is an addition to the directory branch selection scheme available by simply accessing the
.I main
and
.I aux
directories. Both ways to select a branch coexist nicely but the latest scheme used wins.
Attempting to select both branches, either by setting both bits at the same time or subsequently, fails.
Clearing both branch selection bits, either by clearing both bits at the same time or subsequently,
resets the event flags inside the
.I DS2409
as a side effect.
Reading the branch properties returns which branch (if any) is connected to the master bus.
.P
.B After using the directory branch selection scheme, both branches are deselected automatically.
.P
.I ALL
is an aggregate of the properties, comma separated. It is an atomic operation.
.br
.I BYTE
is an aggregate of the branches as a byte,
.I main
is bit 0. It is an atomic operation.
.SS control
.I read-write, unsigned integer
.br
Setting of the PIO
.I control
pin. There are 4 possible settings:
.TP
.B 0
Unconditionally off (non-conducting)
.TP
.B 1
Unconditionally on (conducting)
.TP
.B 2
Auto on when
.I main
branch switched in
.TP
.B 3
Auto on when
.I aux
branch switched in
.SS discharge
.I write-only, yes-no
.br
Writing a non-zero value to this property will electrically reset both the main and auxiliary branches of the 1-wire bus by dropping power for 100 milliseconds. All devices on those branches will lose parasitic power and reset to power-up defaults. As a side effect, both
.I event
flags and thus, the alarm state, are cleared, too.
.SS event.0 event.1 event.ALL event.BYTE
.I read-only, yes-no
.br
Has the
.I event
flag for the branch been triggered? A negative edge on the disconnected branch (
.I 0=main
or
.I 1=aux
) sets the flag. This is achieved by e.g. connecting an iButton to the branch. Value returned is 1 (yes) or 0 (no).
.P
After accessing the 
.I main
or
.I aux
directory, both branches are deselected automatically and thus, the event flags and alarm state are cleared.
.P
.I ALL
is an aggregate of the properties, comma separated. It is an atomic operation.
.br
.I BYTE
is an aggregate of the branches as a byte,
.I main
is bit 0. It is an atomic operation.
.SS clearevent
.I write-only, yes-no
.br
Writing a non-zero value to this property will reset both
.I event
flags and thus, clear the alarm state, too.
.br
.SS main
.I directory
.br
This is the
.I main
branch of the
.I DS2409
network branch. It is implicitly accessed (via the
.I main smart-on
command) when it is listed or devices on this branch are addressed.
.SS sensed.0 sensed.1 sensed.ALL sensed.BYTE
.I read-only, yes-no
.br
Voltage sensed at the
.I 0=main
or
.I 1=aux
branch pin. Valid only when the branch is switched out. Value returned is 0 (low) or 1 (high).
.P
.I ALL
is an aggregate of the properties, comma separated. It is an atomic operation.
.br
.I BYTE
is an aggregate of the branches as a byte,
.I main
is bit 0. It is an atomic operation.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
The
.I DS2409
will respond to a conditional search if the 
.I main
event flag is set.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2409
The
.B DS2409 (3)
allows complex 1-wire network topology. Each branch has it's power preserved, even when isolated from the master. A separate PIO pin can be configured to show branch switching, or controlled explicitly.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2409.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
