###############################################################################
# 
#  Copyright (2008) Alexander Stukowski
#
#  This file is part of OVITO (Open Visualization Tool).
#
#  OVITO is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  OVITO is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
###############################################################################

# Finds the GNU Scientific Library (GSL).

# This module defines
#  GSL_INCLUDE_DIR, where to find gsl/*.h.
#  GSL_LIBRARIES, libraries to link against to use GSL.
#  GSL_FOUND, If false, do not try to use GSL.
#
#  Also defined, but not for general use are
#  GSL_LIBRARY, where to find the GSL library.
#  GSL_CBLAS_LIBRARY, where to find the CBLAS library.

FIND_PATH(GSL_INCLUDE_DIR gsl/gsl_multifit.h
  /usr/local/include
  /usr/include
)

SET(GSL_NAMES ${GSL_NAMES} gsl)
FIND_LIBRARY(GSL_LIBRARY
  NAMES ${GSL_NAMES}
  PATHS /usr/lib /usr/local/lib
)

SET(GSL_CBLAS_NAMES ${GSL_CBLAS_NAMES} gslcblas)
FIND_LIBRARY(GSL_CBLAS_LIBRARY
  NAMES ${GSL_CBLAS_NAMES}
  PATHS /usr/lib /usr/local/lib
)

IF(GSL_INCLUDE_DIR)
  IF(GSL_LIBRARY AND GSL_CBLAS_LIBRARY)
    SET(GSL_FOUND "YES")
    SET(GSL_LIBRARIES ${GSL_LIBRARY} ${GSL_CBLAS_LIBRARY})
  ENDIF(GSL_LIBRARY AND GSL_CBLAS_LIBRARY)
ENDIF(GSL_INCLUDE_DIR)
