//----------------------------------------------------------------------------
//
// License:  See top level LICENSE.txt file.
//
// Author:  David Burken
//
// Description: Test app for ossimString class.
//
// $Id: ossimStringTest.cpp 9830 2006-10-31 12:52:15Z dburken $
//----------------------------------------------------------------------------

#include <iostream>
#include <iomanip>
using namespace std;

#include <ossim/base/ossimString.h>

void testString()
{
   std::cout << "Testing string" << std::endl;
   ossim_float64 d = 0.000012345678901234567;
   cout << "scientific: " << ossimString::toString(d, 15, false, true)
        << "\nfixed: " << ossimString::toString(d, 15, false, false)
        << endl;

   // ossimString os1("1.23456E-10");
   // ossim_float64 f1 = os1.toFloat64();
   ossim_float64 f1 = 1.12345678e-10;
   ossimString os2 = ossimString::toString(f1,
                                           10,     // precision
                                           true,  // trim flag
                                           true); // scientific flag
   cout << setiosflags(std::ios::scientific)
        << setprecision(10) 
        << "\nf1 = " << f1
        << "\nossimString::toString(f1,10,true,true): " << os2
        << endl;

   d = 0;
   cout << setiosflags(std::ios::fixed)
        << "\nd = 0"
        << "\nossimString::toString(d, 12, true):  "
        << ossimString::toString(d, 12, true)
        << std::endl;

   d = 0.123;
   cout << setiosflags(std::ios::fixed)
        << "\nd = 0.123"
        << "\nossimString::toString(d, 12, true):  "
        << ossimString::toString(d, 12, true)
        << std::endl;
   
   d = 123.0;
   cout << setiosflags(std::ios::fixed)
        << "\nd = 123.0"
        << "\nossimString::toString(d, 12, true):  "
        << ossimString::toString(d, 12, true)
        << std::endl;
   
   d = 123.456;
   cout << setiosflags(std::ios::fixed)
        << "\nd = 123.456"
        << "\nossimString::toString(d, 12, true):  "
        << ossimString::toString(d, 12, true)
        << "\n" << std::endl;

   ossimString os1 = "LE7116034000502150.H1";
   os2 = os1.substitute(ossimString("."), ossimString("_"), false);
   cout << "os1:  " << os1
        << "\ncommand:  ossimString os2 = os1.substitute(ossimString(\".\"), ossimString(\"_\"), false);"
        << "\nos2:  " << os2
        << endl;

   std::string s3 = "abc";
   ossimString os3(s3);
   cout << "ossimString constructed with std::string abc: " << os3 << endl;

   const char* nullCharStr = 0;
   ossimString os4(nullCharStr);
   cout << "ossimString constructed with null char string: " << os4 << endl;

   const char* abcCharStr = "abc";
   ossimString os5(abcCharStr);
   cout << "ossimString constructed with abc char string: " << os5 << endl;

   char a = 'a';
   ossimString os6(a);
   cout << "ossimString constructed with char a: " << os6 << endl;
     
   ossimString os7(5, a);
   cout << "ossimString constructed with 5 char a: " << os7 << endl;

   os7 = a;
   cout << "ossimString assigned char a: " << os7 << endl;

   os7 = nullCharStr;
   cout << "ossimString assigned null string: " << os7 << endl;

   os7 = abcCharStr;
   cout << "ossimString assigned abc char string: " << os7 << endl;

   os7 = s3;
   cout << "ossimString assigned std::string abc: " << os7 << endl;

   os7 = os5;
   cout << "ossimString assigned ossimString abc: " << os7 << endl;
}

void testRegularExpression()
{
   std::cout << "Testing regular expression" << std::endl;
   ossimString aString1("Garbage Hi There garbage");
   cout << aString1.match(aString1) << endl;

   ossimString aString2("ab123QQ59ba");
   cout << aString2.match("[^ab1-9]") << endl;

   ossimString aString3("That's OK for me. OK for---you?");
   cout << aString3.match("O(.*r)") << endl;

   ossimString aString4("That's OK for me. OK for---you?");
   cout << aString4.match("[A-Za-z' \\.]*") << endl;

   ossimString aString5(" kasdfj OK---- for ---- --  ------ me. OK for");
   cout << aString5.replaceAllThatMatch("--*[A-Z|a-z| ]*", "*PPPPP*") << endl;
}

int main()
{
   testString();
   testRegularExpression();
   
   return 0;
}
