Minutes from 96th OpenVDB TSC meeting, June 22nd, 2021, (EDT)

Attendees: *Nick* A., *Jeff* L., *Dan* B., *Andre* P.

Additional Attendees: JT Nelson (Blender), Richard Jones (DNeg),
Johannes Meng (Intel), Bruce Chernia (Intel)

Regrets: *Ken* M.

Agenda:

1) Confirm Quorum
2) Secretary
3) PyBind11
4) OpenPRs
5) VDB Visualize SOP
6) Bug report on VDB Clip SOP not supporting cameras with overscan.
7) Continuing discussion on VDB Visualize Tree SOP
8) JT looked at the transcript for the OpenVDB SIGGRAPH course, which looks
9) Next meeting


1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Nick Avramoussis.

3) PyBind11

Nick has sent an email outlining the proposed work. All agree with Dan that the
work can be incrementally completed. A feature/pybind11 branch exists for the
target of this work. Nick to post as a Github Issue. The feature branch is to
be kept in sync on subsequent releases of OpenVDB.

4) Open PRs

Deprecating StringGrids: All approve but should wait for Kens approval too.

TBB 2021: Nick, incomplete CI. Majority agree that this should not hold up this
work. Jeff, already downstreamed some of it into Houdini. Nick to merge. We
can release a new (minor) version of VDB with this support. This needs approval
from Ken and we should discussing the versioning required.

EXR 3 (no PR, related to a proposed TBB release): How we bump VDB with the TBB
2021 changes is sort of related to how we would release a new version with
EXR 3 support. All agree that the path of least resistance is to make EXR
support in the command line tool optional, then add support for EXR 3. There's
still a question about the VFX platform's 2022 versioning if we don't support
it before EOY.

hsvtorgb: AX PR adding color conversion methods. Rich, tested against VEX's
implementation which seems to clamp inputs going from hsv to rgb. Jeff, hue is
most likely wrapped and saturation is clamped. Nick to make these changes.

Counting Tools: Dan, ran into some issues with g++ AX builds exceeding memory
limits. Fixed by forcing the CI to build on one thread. PR needs approval.

CMake variable for Houdini DSOs: Dan, needs approval. There were issues with
proposed alternatives (building individual targets with makefiles) so Nick
agrees this proposal is fine. One outstanding point was the fact that there
are two CMake variables which are attempting to achieve the same thing. The
first is documented at the top of the Houdini CMakeLists.txt file and turns
off nodes. Dan's new system turns nodes on. Ideally we would have a single
variable which supported both. Nick, a regex string would be good.
Introducing this new system is not ideal as it stands but can be improved
in the future.

Grain size dynamic node manager: Still no clear path forward here.

5) VDB Visualize SOP

Dan has parallelized some of the geometry construction from the VDB visualize
SOP. Points from voxels is now much faster. Sold + wireframe generation is not
parallelized. As part of this, Dan has removed lots of old compile time logic
specific to SESI/DWA. Dan, also trying to add slicing support, a common feature
done as a post processes to visualize a slice of a VDB. Jeff, this can be a
pain due to relative bounds moving or absolute index coordinates changing over
a frame range. Nick, solves this by clipping the input geometry though this
isn't the exact same solution as it needs a bounds to define the slice. Dan to
experiment with some solutions.

6) Bug report on VDB Clip SOP not supporting cameras with overscan.

Dan gets a bug report in VDB Clip SOP when a user sets the window size to 1.5
from the camera that you feed in, the SOP doesn't take into account the
overscan when you do that. It is implemented differently with different SOPs,
e.g. the SOP Occlusion Mask. Dan thinks that it is good to clean up the logic
across the different SOPs.

However, the current SOP is not in the OpenVDB repository and is still owned
by SideFX. Dan asks if this can be open-sourced. Jeff says that he should get
the code into the open source repository.

7) Continuing discussion on VDB Visualize Tree SOP

Andre asks Dan: when he tries to slice the VDB, then will it always be axis
aligned? Dan says yes. His plan is to do the slice by plane: x-axis, y-axis,
and z-axis and have a relative 0 to 1 offset to where it lies in the bounding
box, similar to what the volume slice does. Instead of sampling the volume, he
wants to 'snap' the voxel values to the plane, so that as you move from one
voxel to the next, it will jump to the next slice. By doing that, you can also
show all of the leaf nodes and internal node wire-frame. The main idea being
visualizing everything that intersects the plane. Jeff thinks this is a good
idea because the Visualize Tree SOP is about exact voxel-values representation.
Jeff suggests making a visualization based on solid boxes with color instead of
points and to be careful with GL_LIT attribute and to set it to equal 0. Jeff
is excited that this makes debugging a VDB easier.

JT thinks that this may be a good project for an ASWF program where they have
people do Google summer-of-code projects. Dan thinks that the parallelization
can be tricky with parallelizing across topology.

Andre asks for reference on how to do parallelization for geometry creation
using HDK. Jeff suggests appendPointBlock. You can do the same thing with
primitives. Dan says that the best example is the SOP_CopyPacked example in
the HDK sample.

8) JT looked at the transcript for the OpenVDB SIGGRAPH course, which looks
mangled. He asks if it is useful to have somebody to do a better transcription
on his end.

Jeff says that SIGGRAPH should be responsible. Dan says that they have SIGGRAPH
volunteers.

9) Next meeting

Next meeting is June 29th, 2021. 12pm-1pm EST (GMT-5).

