###############################################################################
# OpenVAS Vulnerability Test
# $Id: webmedia_explorer_xss.nasl 7876 2010-06-01 11:02:32Z mime $
#
# Webmedia Explorer Multiple Cross Site Scripting Vulnerabilities
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100225);
 script_tag(name:"cvss_base", value:"4.3");
 script_cve_id("CVE-2009-2107");
 script_bugtraq_id(35368);
 script_version ("1.0");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Webmedia Explorer Multiple Cross Site Scripting Vulnerabilities");
 desc = "

 Overview:
  Webmedia Explorer is prone to multiple cross-site scripting
  vulnerabilities because it fails to sufficiently sanitize
  user-supplied data.

  An attacker may leverage these issues to execute arbitrary script
  code in the browser of an unsuspecting user in the context of the
  affected site. This may allow the attacker to steal cookie-based
  authentication credentials and to launch other attacks.

  Webmedia Explorer 5.0.9 and 5.10.0 are vulnerable; other versions
  may also be affected. 

 See also:
  http://www.securityfocus.com/bid/35368

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Webmedia Explore is prone to multiple XSS");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("webmedia_explorer_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/WebmediaExplorer")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

dir  = matches[2];

  if(!isnull(dir)) {
      url = string(dir, "/index.php?search=%22%20onmouseover=alert(document.cookie)%20---");
      req = http_get(item:url, port:port);
      buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if( buf == NULL )exit(0);

      if(egrep(pattern:"<a href=.*onmouseover=alert\(document.cookie\) ---", string: buf))
        {    
   	   security_warning(port:port);
           exit(0);
        } 
  }   

exit(0);
