# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-677-2 (fixed)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63074);
 script_cve_id("CVE-2008-2237", "CVE-2008-2238", "CVE-2008-4937");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Ubuntu USN-677-2 (OpenOffice)";
 script_name(name);

 desc = "The remote host is missing an update to OpenOffice
announced via advisory USN-677-2.

Original advisory details:

 Multiple memory overflow flaws were discovered in OpenOffice.org's handling of
 WMF and EMF files. If a user were tricked into opening a specially crafted
 document, a remote attacker might be able to execute arbitrary code with user
 privileges. (CVE-2008-2237, CVE-2008-2238)
 
 Dmitry E. Oboukhov discovered that senddoc, as included in OpenOffice.org,
 created temporary files in an insecure way. Local users could exploit a race
 condition to create or overwrite files with the privileges of the user invoking
 the program. This issue only affected Ubuntu 8.04 LTS. (CVE-2008-4937)

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=USN-677-2

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-677-2 (OpenOffice)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"openoffice.org-help-br", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-cs", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-da", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-de", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-dz", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-en-gb", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-en-us", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-es", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-et", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-eu", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-fr", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-gl", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-hi-in", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-hu", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-it", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-ja", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-km", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-ko", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-nl", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-pl", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-pt-br", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-pt", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-ru", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-sl", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-sv", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-zh-cn", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-help-zh-tw", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-af", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ar", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-as-in", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-be-by", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-bg", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-bn", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-br", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-bs", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ca", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-common", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-cs", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-cy", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-da", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-de", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-dz", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-el", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-en-gb", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-en-za", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-eo", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-es", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-et", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-eu", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-fa", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-fi", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-fr", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ga", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-gl", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-gu-in", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-he", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-hi-in", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-hr", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-hu", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-it", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ja", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ka", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-km", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-kn", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ko", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ku", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-lo", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-lt", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-lv", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-mk", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ml-in", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-mr-in", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-nb", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ne", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-nl", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-nn", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-nr", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ns", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-or-in", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-pa-in", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-pl", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-pt-br", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-pt", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ro", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ru", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-rw", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-sk", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-sl", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-sr", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ss", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-st", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-sv", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-sw", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ta-in", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-te-in", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-tg", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-th", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ti-er", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-tn", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-tr", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ts", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-uk", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ur-in", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-uz", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ve", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-vi", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-xh", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-zh-cn", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-zh-tw", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-zu", ver:"2.4.1-1ubuntu2.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
