###############################################################################
# OpenVAS Vulnerability Test
# $Id: sympa_30727.nasl 8291 2010-07-05 13:13:29Z mime $
#
# Sympa 'sympa.pl' Insecure Temporary File Creation Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100299);
 script_bugtraq_id(30727);
 script_cve_id("CVE-2008-4476");
 script_version ("1.0-$Revision: 8291 $");
 script_tag(name:"cvss_base", value:"6.9");
 script_tag(name:"risk_factor", value:"High");

 script_name("Sympa 'sympa.pl' Insecure Temporary File Creation Vulnerability");

desc = "Overview:
Sympa creates temporary files in an insecure manner.

An attacker with local access could potentially exploit this issue to
perform symbolic-link attacks, overwriting arbitrary files in the
context of the affected application.

Successfully mounting a symlink attack may allow the attacker to
delete or corrupt sensitive files, which may result in a denial of
service. Other attacks may also be possible.

Sympa 5.4.3 is vulnerable; other versions may also be affected.

Solution:
Updates are available. Please see the references for more information.

References:
http://www.securityfocus.com/bid/30727
http://www.sympa.org/
http://www.sympa.org/distribution/
http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=494969

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Sympa version is 5.4.3");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("sympa_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/sympa")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "5.4.3")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
