###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tor_privilege_escalation_lin.nasl 625 2008-12-17 12:10:29Z dec $
#
# TOR Privilege Escalation Vulnerability (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright (c) SecPod http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900424);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-5397", "CVE-2008-5398");
  script_bugtraq_id(32648);
  script_name("TOR Privilege Escalation Vulnerability (Linux)");
  desc = "

  Overview: This host is installed with TOR and is prone to Privilege
  Escalation vulnerability.
  
  Vulnerability Insight:
  The flaws are due to,
  - an application does not properly drop privileges to the primary groups
    of the user specified by the User Parameter.
  - a ClientDNSRejectInternalAddresses configuration option is not always
    enforced which weaknesses the application security.
  
  Impact:
  Successful exploitation will let the attacker gain privileges and escalate
  the privileges in malicious ways.
  
  Affected Software/OS:
  Tor version 0.2.0.31 or prior.
  
  Fix:
  Upgrade to the latest version 0.2.0.32
  http://www.torproject.org/download.html.en
  
  References:
  http://www.torproject.org
  http://secunia.com/advisories/33025
  
  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Tor");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Privilege escalation");
  script_dependencies("secpod_tor_detect_lin.nasl");
  script_require_keys("ssh/login/uname");
  exit(0);
}


include("version_func.inc");

ver = get_kb_item("Tor/Linux/Ver");
if(ver != NULL)
{
  # Grep for version 0.2.0.31 or prior
  if(version_is_less_equal(version:ver, test_version:"0.2.0.31")){
    security_warning(0);
  }
}
