###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_php_tsrm_win32_dos_vuln_win.nasl 4930 2009-09-29 11:00:29Z sep $
#
# PHP 'tsrm_win32.c' Denial Of Service Vulnerability (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900872);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3294");
  script_bugtraq_id(36449);
  script_name("PHP 'tsrm_win32.c' Denial Of Service Vulnerability (Win)");
  desc = "
  Overview: This host is running PHP and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  An error occurs in popem 'API' function in TSRM/tsrm_win32.c, when running on
  certain Windows operating systems. It can be caused via a crafted 'e' or 'er'
  string in the second argument (aka mode), possibly related to the '_fdopen'
  function in the Microsoft C runtime library.

  Impact:
  Successful exploitation will let the attackers to cause Denial of Service in
  the victim's system.

  Impact Level: Application

  Affected Software/OS:
  PHP version prior to 5.2.11 on Windows.

  Fix: Upgrade to version 5.2.11 or later
  http://www.php.net/downloads.php

  References:
  http://en.securitylab.ru/nvd/383831.php
  http://downloads.securityfocus.com/vulnerabilities/exploits/31064.php

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

phpPort = get_http_port(default:80);
if(!phpPort){
  phpPort = 80;
}

if(!get_port_state(phpPort)){
  exit(0);
}

banner = get_http_banner(port:phpPort);
if("PHP" >< banner && ("Win32" >< banner))
{
  phpVer = ereg_replace(pattern:".*PHP/([.0-9]*).*", string:banner, replace:"\1");
  if(!isnull(phpVer))
  {
    # Check for PHP version 5.2.11
    if(version_is_less(version:phpVer, test_version:"5.2.11")){
      security_warning(phpPort);
    }
  }
}
