###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ntp_bof_vuln.nasl 1701 2009-04-23 15:15:28 apr $
#
# NTP Stack Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900623);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-0159");
  script_bugtraq_id(34481);
  script_name("NTP Stack Buffer Overflow Vulnerability");
  desc = "

  Overview:
  This host has NTP installed and is prone to stack buffer overflow
  vulnerabilities.

  Vulnerability Insight:
  The flaw is caused due to a boundary error within the cookedprint()
  function in ntpq/ntpq.c while processing malicious response from
  a specially crafted remote time server.

  Impact:
  Successful exploitation will allow attackers to execute arbitrary
  code or to cause the application to crash.

  Impact Level: Application.

  Affected Software/OS:
  NTP versions prior to 4.2.4p7-RC2 on Linux.

  Fix:
  Upgrade to NTP version 4.2.4p7-RC2
  http://www.ntp.org/downloads.html

  References:
  http://secunia.com/advisories/34608
  http://xforce.iss.net/xforce/xfdb/49838
  http://www.vupen.com/english/advisories/2009/0999

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of NTP)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("gb_ntp_detect_lin.nasl");
  script_require_keys("NTP/Linux/Ver");
  exit(0);
}


include("version_func.inc");

ntpPort = 123;
if(!get_udp_port_state(ntpPort)){
  exit(0);
}

ntpVer = get_kb_item("NTP/Linux/Ver");
if(!ntpVer){
  exit(0);
}

if(version_is_less(version:ntpVer, test_version:"4.2.4.p7.RC2")){
  security_warning(port:ntpPort, proto:"udp");
}
