##############################################################################
#
#  Microsoft Windows 'UnhookWindowsHookEx' Local DoS Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/17
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0477
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900178);
  script_cve_id("CVE-2008-5044");
 script_bugtraq_id(32206);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_tag(name:"cvss_base", value:"5.9");
  script_tag(name:"risk_factor", value:"High");
  script_category(ACT_GATHER_INFO);
  script_family("Denial of Service");
  script_name("Microsoft Windows 'UnhookWindowsHookEx' Local DoS Vulnerability");
  script_summary("Check for vulnerable version of Windows Server 2003");
  desc = "
  Overview: This Microsoft Windows host is prone to denial of service
  vulnerability.

  The flaw is caused due to error in 'UnhookWindowsHookEx' function. This can
  be exploited to cause system hang.

  Impact:
  Attackers may exploit this issue to deny service to legitimate users.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows Server 2003 Service Pack 2 and prior.

  Fix: No solution/patch is available as on 17th November, 2008.

  References:
  http://killprog.com/whk.zip
  http://www.securityfocus.com/archive/1/498165

  CVSS Score:
    CVSS Base Score     : 5.9 (AV:L/AC:M/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 5.3
  Risk factor : High";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2003:3) <= 0){
  exit(0);
}
security_warning(0);
