###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_visual_prdts_detect.nasl 3688 2009-07-31 12:12:44Z jul $
#
# Microsoft Visual Product(s) Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900808);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Microsoft Visual Products Version Detection");
  desc ="

  Overview : This script finds the installed product version of Microsoft Visual
  Product(s) and sets the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set KB for the version of Visual Product(s)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Check for Product Existence
if(!registry_key_exists(key:"SOFTWARE\Microsoft\VisualStudio")){
  exit(0);
}

visual_key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:visual_key))
{
  visualName = registry_get_sz(key:visual_key + item, item:"DisplayName");
  # Set the KB item for Microsoft Visual Studio
  if(visualName =~ "Microsoft Visual Studio [0-9]+")
  {
    studioVer = registry_get_sz(key:visual_key + item, item:"DisplayVersion");
    if(studioVer != NULL){
      set_kb_item(name:"Microsoft/VisualStudio/Ver", value:studioVer);
      security_note(data:visualName + " was detected on the host");
    }
  }

  # Set the KB item for Microsoft Visual Studio .Net
  if(visualName =~ "Visual Studio \.NET [A-Za-z0-9]+")
  {
    netVer = registry_get_sz(key:visual_key + item, item:"DisplayVersion");
    if(netVer != NULL){
      set_kb_item(name:"Microsoft/VisualStudio.Net/Ver", value:netVer);
      security_note(data:"Microsoft " + visualName + " was detected on the host");
    }
  }
}
