##############################################################################
#
#  Microsoft Internet Explorer Denial of Service Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/24
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0257
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900131);
 script_cve_id("CVE-2008-4127");
 script_bugtraq_id(31215);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.1 ");
 script_tag(name:"cvss_base", value:"7.1");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name("Microsoft Internet Explorer Denial of Service Vulnerability");
 script_summary("Check for the version of Microsoft Internet Explorer");
 desc = "
 Overview : The host has Microsoft Internet Explorer installed, which is prone
 to denial of service vulnerability.

 Vulnerability Insight :
        Due to errors while handling PNG files, CDwnTaskExec::ThreadExec enters
        into an infinite loop while loading images which causes the browser to
        crash. This can be exploited by enticing victim to visit a malicious 
        web page embedded with rouge PNG files.

        Impact : Successful exploitation will cause the application to stop
        responding and denying the service to legitimate users.

 Impact Level : Application

 Affected Software/OS :
        Microsoft Internet Explorer 7.x and 8 Beta on Windows
 
 Fix : No solution/patch is available as on 24th September, 2008. Information
 regarding this issue will be updated once the solution details are available.

 References :
 http://www.secniche.org/ie_mal_png_dos.html
 http://www.securityfocus.com/archive/1/496483

 CVSS Score :
        CVSS Base Score     : 7.1 (AV:N/AC:M/Au:NR/C:N/I:N/A:C)
        CVSS Temporal Score : 6.4
 Risk factor : Medium";

 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");

 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 iExpVer = registry_get_sz(key:"SOFTWARE\Microsoft\Internet Explorer" ,
                           item:"Version");
 if(!iExpVer){
	iExpVer = registry_get_sz(item:"IE",
        	  key:"SOFTWARE\Microsoft\Internet Explorer\Version Vector");
	if(!iExpVer){
        	exit(0);
	}
 }

 # Grep for IE 8 beta version <= 8.0.60001.18241
 if(ereg(pattern:"^(7\..*|8\.0\.(([0-5]?[0-9]?[0-9]?[0-9]|6000)\..*|6001" +
              "\.(0?[0-9]?[0-9]?[0-9]?[0-9]|1[0-7][0-9][0-9][0-9]|18[01]" +
              "[0-9][0-9]|182([0-3][0-9]|4[01]))))($|[^.0-9])", string:iExpVer)){
        security_warning(0);
 }
