###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_isc_dhcp_client_bof_vuln.nasl 3518 2009-07-22 15:05:27Z jul $
#
# ISC DHCP Client Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900694);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0692");
  script_bugtraq_id(35668);
  script_name("ISC DHCP Client Buffer Overflow Vulnerability");
  desc = "

  Overview: This host has installed ISC DHCP Client and is prone to Buffer
  overflow Vulnerability.

  Vulnerability Insight:
  The flaw is due to a boundary error within the 'script_write_params()'
  function in 'client/dhclient.c' which can be exploited to cause a stack-based
  buffer overflow by sending an overly long subnet-mask option.

  Impact:
  Successful exploitation allows attackers to run arbitrary code, corrupt memory,
  and can cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  ISC DHCP dhclient 4.1 before 4.1.0p1
  ISC DHCP dhclient 4.0 before 4.0.1p1
  ISC DHCP dhclient 3.1 before 3.1.2p1
  ISC DHCP dhclient all versions in 3.0
  and 2.0 series.

  Fix: Upgrade to version 4.1.0p1, 4.0.1p1, or 3.1.2p1 or later
  For updates refer, https://www.isc.org/downloadables/

  References:
  https://www.isc.org/node/468
  http://secunia.com/advisories/35785
  http://www.kb.cert.org/vuls/id/410676
  http://www.vupen.com/english/advisories/2009/1891

  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Checks for the version of ISC DHCP Client");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_isc_dhcp_client_detect.nasl");
  script_require_keys("ISC/DHCP-Client/Ver");
  exit(0);
}


include("version_func.inc");

dhcpVer = get_kb_item("ISC/DHCP-Client/Ver");
if(!dhcpVer){
  exit(0);
}

if(dhcpVer =~ "^4\.1")
{
  if(version_is_less(version:dhcpVer, test_version:"4.1.0.p1")){
    security_hole(0);
  }
}

else if(dhcpVer =~ "^4\.0")
{
  if(version_is_less(version:dhcpVer, test_version:"4.0.1.p1")){
    security_hole(0);
  }
}

else if(dhcpVer =~ "^3\.1")
{
  if(version_is_less(version:dhcpVer, test_version:"3.1.2.p1")){
    security_hole(0);
  }
}

else if((dhcpVer =~ "^3\.0") || (dhcpVer =~ "^2\.0")){
  security_hole(0);
}
