###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_imagemagick_bof_vuln_lin.nasl 2507 2009-05-29 09:36:22Z may $
#
# ImageMagick Buffer Overflow Vulnerability (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900565);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1882");
 script_bugtraq_id(35111);
  script_name("ImageMagick Buffer Overflow Vulnerability (Linux)");
  desc = "

  Overview: The host is installed with ImageMagick and is prone to Buffer
  Overflow Vulnerability.

  Vulnerability Insight:
  The flaw occurs due to an integer overflow error within the 'XMakeImage()'
  function in magick/xwindow.c file while processing malformed TIFF files.

  Impact:
  Attackers can exploit this issue by executing arbitrary code via a crafted
  TIFF files in the context of an affected application.

  Impact Level: Application

  Affected Software/OS:
  ImageMagick version prior to 6.5.2-9 on Linux.

  Fix: Upgrade to ImageMagick version 6.5.2-9 or later.
  http://www.imagemagick.org/script/download.php

  References:
  http://secunia.com/advisories/35216/

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of ImageMagick");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_imagemagick_detect_lin.nasl");
  script_require_keys("ImageMagick/Lin/Ver");
  exit(0);
}


include("version_func.inc");

imageVer = get_kb_item("ImageMagick/Lin/Ver");
if(!imageVer){
  exit(0);
}

if(version_is_less(version:imageVer, test_version:"6.5.2.9")){
  security_warning(0);
}
