##############################################################################
#
#  Hummingbird Deployment Wizard ActiveX Control Multiple Security Vulnerabilities
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/21
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0367
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900161);
  script_cve_id("CVE-2008-4728");
 script_bugtraq_id(31799);
  script_copyright("Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_category(ACT_GATHER_INFO);
  script_family("Denial of Service");
  script_name("Hummingbird Deployment Wizard ActiveX Control Multiple Security Vulnerabilities");
  script_summary("Check for vulnerable version of Deployment Wizard ActiveX Control");
  desc = "
  Overview : This host is installed with Deployment Wizard ActiveX Control and
  is prone to multiple security vulnerabilities. 

  The multiple flaws are due to error in 'SetRegistryValueAsString()',
  'Run()' and 'PerformUpdateAsync()' methods in DeployRun.DeploymentSetup.1
  (DeployRun.dll) ActiveX control.

  Impact :
  Successful exploitation allows execution of arbitrary code.

  Impact Level : Application

  Affected Software/OS:
  Hummingbird Deployment Wizard version 10.0.0.44 and prior on Windows (all)

  Fix : Set the kill-bit for the affected ActiveX control.
  No patch is available as on 21th October, 2008.

  References :
  http://secunia.com/advisories/32337
  http://www.frsirt.com/english/advisories/2008/2857

  CVSS Score :
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor : High";

  script_description(desc);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}

include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

wizPath = registry_get_sz(key:"SOFTWARE\Hummingbird\Deployment Wizard",
                          item:"HomeDir");
if(!wizPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*",replace:"\1$",string:wizPath);
file = ereg_replace(pattern:"[A-Z]:(.*)",replace:"\1",string:wizPath + 
                    "DeployPkgShell.exe");

soc = open_sock_tcp(port);
if(!soc){
  exit(0);
}

r = smb_session_request(soc:soc, remote:name);
if(!r){
  close(soc);
  exit(0);
}

prot = smb_neg_prot(soc:soc);
if(!prot){
  close(soc);
  exit(0);
}

r = smb_session_setup(soc:soc, login:login, password:pass, domain:domain,
                      prot:prot);
if(!r){
  close(soc);
  exit(0);
}

uid = session_extract_uid(reply:r);
if(!uid){
  close(soc);
  exit(0);
}

r = smb_tconx(soc:soc, name:name, uid:uid, share:share);
if(!r){
  close(soc);
  exit(0);
}

tid = tconx_extract_tid(reply:r);
if(!tid){
  close(soc);
  exit(0);
}

fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
if(!fid){
  close(soc);
  exit(0);
}

wizVer = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, offset:1735500);
close(soc);

if(wizVer)
{
  # Grep for version < 10.0.0.44
  if(ereg(pattern:"^[0-9](\..*)|10(\.0(\.0(\.[0-3]?[0-9]|\.4[0-4])?)?)($|[^.0-9])",
          string:wizVer)){
    security_hole(0);
  }
}
