###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_firefox_gif_dos_vuln_nov09_win.nasl 5819 2009-11-19 10:48:33Z nov $
#
# Mozilla Firefox 'GIF' File DoS Vulnerability - Nov09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900894);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-3978");
  script_name("Mozilla Firefox 'GIF' File DoS Vulnerability - Nov09 (Win)");
  desc = "
  Overview: The host is installed with Firefox browser and is prone to Denial
  of Service vulnerabilities.

  Vulnerability Insight:
  A NULL pointer dereference error in 'nsGIFDecoder2::GifWrite' function in
  'decoders/gif/nsGIFDecoder2.cpp' in libpr0n, which can be exploited to cause
  application crash via an animated 'GIF' file with a large image size.

  Impact:
  Successful exploitation could allows remote attacker to cause a vulnerable
  application to crash.

  Impact Level: Application

  Affected Software/OS:
  Mozilla Firefox version prior to 3.5.5 on Windows.

  Fix: Upgrade to Firefox version 3.5.5 or later,
  http://www.mozilla.com/en-US/firefox/all.html

  References:
  https://bugzilla.mozilla.org/show_bug.cgi?id=525326
  https://wiki.mozilla.org/Releases/Firefox_3.5.5/Test_Plan
  http://hg.mozilla.org/releases/mozilla-1.9.1/rev/edf189567edc

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Win/Ver");
if(!ffVer){
  exit(0);
}

# Grep for Firefox version < 3.5.5
if(version_is_less(version:ffVer, test_version:"3.5.5")){
  security_warning(0);
}
