###############################################################################
# OpenVAS Vulnerability Test
# $Id: ping_host.nasl 7554 2010-05-06 11:19:12Z mime $
#
# Ping Host 
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100315);
 script_version ("1.0-$Revision: 7554 $");

 script_name("Ping Host");

 desc = "This plugin try to determine if the remote host is up.

Risk factor : None";

 script_tag(name:"risk_factor", value:"None");
 script_description(desc);
 script_summary("Ping the remote host");
 script_category(ACT_SCANNER);
 script_family("Port scanners");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");

 script_add_preference(name:"Report about unrechable Hosts", type:"checkbox", value:"no");
 script_add_preference(name:"Mark unrechable Hosts as dead (not scanning)", type:"checkbox", value:"no");

 exit(0);
}

include("misc_func.inc");

function IP_IS_IPV6(ip) {

 if(":" >< ip) {
   return TRUE;
 }

 return FALSE;

}

report_dead = script_get_preference("Report about unrechable Hosts");
mark_dead   = script_get_preference("Mark unrechable Hosts as dead (not scanning)");

set_kb_item(name: "/tmp/start_time", value: unixtime());
if(islocalhost())exit(0);
if(IP_IS_IPV6(ip:get_host_ip())) {
  if(!defined_func("forge_icmp_v6_packet")) {
    if("yes" >< report_dead || "yes" >< mark_dead) {
      log_message(data: "ping_host.nasl not launched because target is IPv6 and the installed version of openvas-libraries does not support IPv6. Update to newer openvas-libraries to get IPv6 support.");
    }
   exit(0);
  }
}  

if("no" >< mark_dead && "no" >< report_dead)exit(0);

# Try ICMP (Ping) first
if(IP_IS_IPV6(ip:get_host_ip())) {
  # ICMPv6
  IP6_v = 0x60;
  IP6_P = 0x3a;#ICMPv6
  IP6_HLIM = 0x40;
  ICMP_ID = rand() % 65536;

  myhost = this_host();

  ip6_packet = forge_ipv6_packet(ip6_v: IP6_v,
                                 ip6_p: IP6_P,
                                 ip6_plen: 20,
                                 ip6_hlim: IP6_HLIM,
                                 ip6_src: myhost,
                                 ip6_dst: get_host_ip());
  d = rand_str(length: 56);
  icmp = forge_icmp_v6_packet(ip6: ip6_packet, icmp_type:128, icmp_code:0, icmp_seq:0,
                              icmp_id: ICMP_ID, icmp_cksum:-1, data: d);
  
  filter = "icmp6 and dst host " + myhost + " and src host " + get_host_ip()  + " and ip6[40] = 129";
  
  ret = NULL;
  attempt = 2;

  while (!ret && attempt--) {
    ret = send_v6packet(icmp, pcap_active: TRUE, pcap_filter: filter);
    if(ret) { 
      set_kb_item(name: "/tmp/ping/ICMP", value: 1);
      exit(0);
    }
  }

} else {  
  # ICMPv4
  ICMP_ECHO_REQUEST = 8;
  IP_ID = 0xBABA;
  ICMP_ID = rand() % 65536;

  data =
  raw_string(0x0c,0xf5,0xf3,0x4a,0x88,0x39,0x08,0x00,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,
  	     0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,
	     0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,
  	     0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37);

  ip_packet =
          forge_ip_packet(ip_tos : 6,
                          ip_id  : IP_ID,
                          ip_off : IP_DF,
                          ip_p   : IPPROTO_ICMP,
                          ip_src : this_host());

  icmp_packet =
         forge_icmp_packet(icmp_type : ICMP_ECHO_REQUEST,
                           icmp_code : 123,
                           icmp_seq  : 256,
                           icmp_id   : ICMP_ID,
	  	           data      : data,
                           ip        : ip_packet);
  attempt = 2;
  ret = NULL;

  filter = "icmp and dst host " + this_host() + " and src host " + get_host_ip() + " and icmp[0] = 0 " + " and icmp[4:2] = " + ICMP_ID;

  while (!ret && attempt--) {
   ret = send_packet(icmp_packet, pcap_active: TRUE, pcap_filter: filter, pcap_timeout: 3);
   if(ret) {
    set_kb_item(name: "/tmp/ping/ICMP", value: 1);
    exit(0);
   }
  }
}

# ICMP fails. Try TCP SYN 
if(tcp_ping()) {
  set_kb_item(name: "/tmp/ping/TCP", value: 1);
  exit(0);
}  

# Host seems to be dead.

if("yes" >< report_dead) {
  data = string("The remote host ", get_host_ip(), " was considered as dead.\n");
  log_message(data:data, port:0);
}

if("yes" >< mark_dead) {
  set_kb_item(name:"Host/ping_failed", value: 1);
}  

exit(0);

