#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
# Ref: PhpGroupWare Team
# This script is released under the GNU GPLv2


if(description)
{
 script_id(14295);
 script_bugtraq_id(9387);
 script_version ("$Revision: 8287 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_xref(name:"OSVDB", value:"6860");
 script_cve_id("CVE-2004-0016");
 name = "PhpGroupWare calendar server side script execution";

 script_name(name);
 
 desc = "
The remote host is running a version of PhpGroupware which is vulnerable
to a remote attack.

PhpGroupWare is a multi-user groupware suite written in PHP.

It has been reported that this version may be prone to a vulnerability that 
may allow remote attackers to execute malicious scripts on a vulnerable system. 
The flaw allows remote attackers to upload server side scripts which can then 
be executed on the server.

Solution : Update to version 0.9.14.007 or newer

See also: http://www.phpgroupware.org/

Risk factor : Medium";

 script_description(desc);
 
 summary = "Checks for PhpGroupWare version";
 
 script_summary(summary);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright("This script is Copyright (C) 2004 David Maciejak");
 family = "Web application abuses";
 script_family(family);
 script_dependencie("phpgroupware_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_http_port(default:80);

kb = get_kb_item("www/" + port + "/phpGroupWare");
if (! kb ) exit(0);
matches = eregmatch(pattern:"(.*) under (.*)", string:kb);

if ( ereg(pattern:"^0\.([0-8]\.|9\.([0-9]\.|1[0-3]\.|14\.0*[0-6]([^0-9]|$)))", string:matches[1]) )
 			security_warning(port);
