# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:114 (ipsec-tools)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64025);
 script_cve_id("CVE-2009-1632");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Mandrake Security Advisory MDVSA-2009:114 (ipsec-tools)";
 script_name(name);

 desc = "The remote host is missing an update to ipsec-tools
announced via advisory MDVSA-2009:114.

Multiple memory leaks in Ipsec-tools before 0.7.2 allow remote
attackers to cause a denial of service (memory consumption) via vectors
involving (1) signature verification during user authentication with
X.509 certificates, related to the eay_check_x509sign function in
src/racoon/crypto_openssl.c; and (2) the NAT-Traversal (aka NAT-T)
keepalive implementation, related to src/racoon/nattraversal.c
(CVE-2009-1632).

The updated packages have been patched to prevent this.

Affected: Corporate 4.0, Multi Network Firewall 2.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:114

Risk factor : High";

 script_description(desc);

 summary = "Mandrake Security Advisory MDVSA-2009:114 (ipsec-tools)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Mandrake Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ipsec-tools", rpm:"ipsec-tools~0.6.5~2.4.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libipsec0", rpm:"libipsec0~0.6.5~2.4.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libipsec0-devel", rpm:"libipsec0-devel~0.6.5~2.4.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64ipsec0", rpm:"lib64ipsec0~0.6.5~2.4.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64ipsec0-devel", rpm:"lib64ipsec0-devel~0.6.5~2.4.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ipsec-tools", rpm:"ipsec-tools~0.2.5~0.7.M20mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libipsec-tools0", rpm:"libipsec-tools0~0.2.5~0.7.M20mdk", rls:"MNDK_2.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
